/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.formatter;

import com.github.mikephil.charting.components.AxisBase;
import com.github.mikephil.charting.data.Entry;
import com.github.mikephil.charting.formatter.IAxisValueFormatter;
import com.github.mikephil.charting.formatter.IValueFormatter;
import com.github.mikephil.charting.utils.ViewPortHandler;
import java.text.DecimalFormat;

public class LargeValueFormatter
implements IValueFormatter,
IAxisValueFormatter {
    private DecimalFormat mFormat;
    private int mMaxLength = 5;
    private String[] mSuffix = new String[]{"", "k", "m", "b", "t"};
    private String mText = "";

    public LargeValueFormatter() {
        this.mFormat = new DecimalFormat("###E00");
    }

    public LargeValueFormatter(String string2) {
        this();
        this.mText = string2;
    }

    private String makePretty(double d) {
        String string2 = this.mFormat.format(d);
        int n = Character.getNumericValue(string2.charAt(string2.length() - 1));
        int n2 = Character.getNumericValue(string2.charAt(string2.length() - 2));
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(n2);
        stringBuilder.append("");
        stringBuilder.append(n);
        n = Integer.valueOf(stringBuilder.toString());
        string2 = string2.replaceAll("E[0-9][0-9]", this.mSuffix[n / 3]);
        while (string2.length() > this.mMaxLength || string2.matches("[0-9]+\\.[a-z]")) {
            stringBuilder = new StringBuilder();
            stringBuilder.append(string2.substring(0, string2.length() - 2));
            stringBuilder.append(string2.substring(string2.length() - 1));
            string2 = stringBuilder.toString();
        }
        return string2;
    }

    public int getDecimalDigits() {
        return 0;
    }

    @Override
    public String getFormattedValue(float f, AxisBase object) {
        object = new StringBuilder();
        ((StringBuilder)object).append(this.makePretty(f));
        ((StringBuilder)object).append(this.mText);
        return ((StringBuilder)object).toString();
    }

    @Override
    public String getFormattedValue(float f, Entry object, int n, ViewPortHandler viewPortHandler) {
        object = new StringBuilder();
        ((StringBuilder)object).append(this.makePretty(f));
        ((StringBuilder)object).append(this.mText);
        return ((StringBuilder)object).toString();
    }

    public void setAppendix(String string2) {
        this.mText = string2;
    }

    public void setMaxLength(int n) {
        this.mMaxLength = n;
    }

    public void setSuffix(String[] stringArray) {
        this.mSuffix = stringArray;
    }
}

