/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.listener;

import android.graphics.Matrix;
import android.util.Log;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.animation.AnimationUtils;
import com.github.mikephil.charting.charts.BarLineChartBase;
import com.github.mikephil.charting.charts.HorizontalBarChart;
import com.github.mikephil.charting.data.BarLineScatterCandleBubbleData;
import com.github.mikephil.charting.data.Entry;
import com.github.mikephil.charting.highlight.Highlight;
import com.github.mikephil.charting.interfaces.datasets.IBarLineScatterCandleBubbleDataSet;
import com.github.mikephil.charting.interfaces.datasets.IDataSet;
import com.github.mikephil.charting.listener.ChartTouchListener;
import com.github.mikephil.charting.listener.OnChartGestureListener;
import com.github.mikephil.charting.utils.MPPointF;
import com.github.mikephil.charting.utils.Utils;
import com.github.mikephil.charting.utils.ViewPortHandler;

public class BarLineChartTouchListener
extends ChartTouchListener<BarLineChartBase<? extends BarLineScatterCandleBubbleData<? extends IBarLineScatterCandleBubbleDataSet<? extends Entry>>>> {
    private IDataSet mClosestDataSetToTouch;
    private MPPointF mDecelerationCurrentPoint;
    private long mDecelerationLastTime = 0L;
    private MPPointF mDecelerationVelocity;
    private float mDragTriggerDist;
    private Matrix mMatrix = new Matrix();
    private float mMinScalePointerDistance;
    private float mSavedDist = 1.0f;
    private Matrix mSavedMatrix = new Matrix();
    private float mSavedXDist = 1.0f;
    private float mSavedYDist = 1.0f;
    private MPPointF mTouchPointCenter;
    private MPPointF mTouchStartPoint = MPPointF.getInstance(0.0f, 0.0f);
    private VelocityTracker mVelocityTracker;

    public BarLineChartTouchListener(BarLineChartBase<? extends BarLineScatterCandleBubbleData<? extends IBarLineScatterCandleBubbleDataSet<? extends Entry>>> barLineChartBase, Matrix matrix, float f) {
        super(barLineChartBase);
        this.mTouchPointCenter = MPPointF.getInstance(0.0f, 0.0f);
        this.mDecelerationCurrentPoint = MPPointF.getInstance(0.0f, 0.0f);
        this.mDecelerationVelocity = MPPointF.getInstance(0.0f, 0.0f);
        this.mMatrix = matrix;
        this.mDragTriggerDist = Utils.convertDpToPixel(f);
        this.mMinScalePointerDistance = Utils.convertDpToPixel(3.5f);
    }

    private static float getXDist(MotionEvent motionEvent) {
        return Math.abs(motionEvent.getX(0) - motionEvent.getX(1));
    }

    private static float getYDist(MotionEvent motionEvent) {
        return Math.abs(motionEvent.getY(0) - motionEvent.getY(1));
    }

    private boolean inverted() {
        boolean bl = this.mClosestDataSetToTouch == null && ((BarLineChartBase)this.mChart).isAnyAxisInverted() || this.mClosestDataSetToTouch != null && ((BarLineChartBase)this.mChart).isInverted(this.mClosestDataSetToTouch.getAxisDependency());
        return bl;
    }

    private static void midPoint(MPPointF mPPointF, MotionEvent motionEvent) {
        float f = motionEvent.getX(0);
        float f2 = motionEvent.getX(1);
        float f3 = motionEvent.getY(0);
        float f4 = motionEvent.getY(1);
        mPPointF.x = (f + f2) / 2.0f;
        mPPointF.y = (f3 + f4) / 2.0f;
    }

    private void performDrag(MotionEvent motionEvent, float f, float f2) {
        this.mLastGesture = ChartTouchListener.ChartGesture.DRAG;
        this.mMatrix.set(this.mSavedMatrix);
        OnChartGestureListener onChartGestureListener = ((BarLineChartBase)this.mChart).getOnChartGestureListener();
        float f3 = f;
        float f4 = f2;
        if (this.inverted()) {
            if (this.mChart instanceof HorizontalBarChart) {
                f3 = -f;
                f4 = f2;
            } else {
                f4 = -f2;
                f3 = f;
            }
        }
        this.mMatrix.postTranslate(f3, f4);
        if (onChartGestureListener != null) {
            onChartGestureListener.onChartTranslate(motionEvent, f3, f4);
        }
    }

    private void performHighlightDrag(MotionEvent object) {
        if ((object = ((BarLineChartBase)this.mChart).getHighlightByTouchPoint(object.getX(), object.getY())) != null && !((Highlight)object).equalTo(this.mLastHighlighted)) {
            this.mLastHighlighted = object;
            ((BarLineChartBase)this.mChart).highlightValue((Highlight)object, true);
        }
    }

    private void performZoom(MotionEvent motionEvent) {
        if (motionEvent.getPointerCount() >= 2) {
            OnChartGestureListener onChartGestureListener = ((BarLineChartBase)this.mChart).getOnChartGestureListener();
            float f = BarLineChartTouchListener.spacing(motionEvent);
            if (f > this.mMinScalePointerDistance) {
                MPPointF mPPointF = this.getTrans(this.mTouchPointCenter.x, this.mTouchPointCenter.y);
                ViewPortHandler viewPortHandler = ((BarLineChartBase)this.mChart).getViewPortHandler();
                int n = this.mTouchMode;
                boolean bl = true;
                boolean bl2 = true;
                boolean bl3 = true;
                float f2 = 1.0f;
                if (n == 4) {
                    this.mLastGesture = ChartTouchListener.ChartGesture.PINCH_ZOOM;
                    if (!((f /= this.mSavedDist) < 1.0f)) {
                        bl3 = false;
                    }
                    boolean bl4 = bl3 ? viewPortHandler.canZoomOutMoreX() : viewPortHandler.canZoomInMoreX();
                    boolean bl5 = bl3 ? viewPortHandler.canZoomOutMoreY() : viewPortHandler.canZoomInMoreY();
                    float f3 = ((BarLineChartBase)this.mChart).isScaleXEnabled() ? f : 1.0f;
                    if (((BarLineChartBase)this.mChart).isScaleYEnabled()) {
                        f2 = f;
                    }
                    if (bl5 || bl4) {
                        this.mMatrix.set(this.mSavedMatrix);
                        this.mMatrix.postScale(f3, f2, mPPointF.x, mPPointF.y);
                        if (onChartGestureListener != null) {
                            onChartGestureListener.onChartScale(motionEvent, f3, f2);
                        }
                    }
                } else if (this.mTouchMode == 2 && ((BarLineChartBase)this.mChart).isScaleXEnabled()) {
                    this.mLastGesture = ChartTouchListener.ChartGesture.X_ZOOM;
                    f = BarLineChartTouchListener.getXDist(motionEvent) / this.mSavedXDist;
                    bl3 = f < 1.0f ? bl : false;
                    boolean bl6 = bl3 ? viewPortHandler.canZoomOutMoreX() : viewPortHandler.canZoomInMoreX();
                    if (bl6) {
                        this.mMatrix.set(this.mSavedMatrix);
                        this.mMatrix.postScale(f, 1.0f, mPPointF.x, mPPointF.y);
                        if (onChartGestureListener != null) {
                            onChartGestureListener.onChartScale(motionEvent, f, 1.0f);
                        }
                    }
                } else if (this.mTouchMode == 3 && ((BarLineChartBase)this.mChart).isScaleYEnabled()) {
                    this.mLastGesture = ChartTouchListener.ChartGesture.Y_ZOOM;
                    f = BarLineChartTouchListener.getYDist(motionEvent) / this.mSavedYDist;
                    bl3 = f < 1.0f ? bl2 : false;
                    boolean bl7 = bl3 ? viewPortHandler.canZoomOutMoreY() : viewPortHandler.canZoomInMoreY();
                    if (bl7) {
                        this.mMatrix.set(this.mSavedMatrix);
                        this.mMatrix.postScale(1.0f, f, mPPointF.x, mPPointF.y);
                        if (onChartGestureListener != null) {
                            onChartGestureListener.onChartScale(motionEvent, 1.0f, f);
                        }
                    }
                }
                MPPointF.recycleInstance(mPPointF);
            }
        }
    }

    private void saveTouchStart(MotionEvent motionEvent) {
        this.mSavedMatrix.set(this.mMatrix);
        this.mTouchStartPoint.x = motionEvent.getX();
        this.mTouchStartPoint.y = motionEvent.getY();
        this.mClosestDataSetToTouch = ((BarLineChartBase)this.mChart).getDataSetByTouchPoint(motionEvent.getX(), motionEvent.getY());
    }

    private static float spacing(MotionEvent motionEvent) {
        float f = motionEvent.getX(0) - motionEvent.getX(1);
        float f2 = motionEvent.getY(0) - motionEvent.getY(1);
        return (float)Math.sqrt(f * f + f2 * f2);
    }

    public void computeScroll() {
        float f = this.mDecelerationVelocity.x;
        float f2 = 0.0f;
        if (f == 0.0f && this.mDecelerationVelocity.y == 0.0f) {
            return;
        }
        long l = AnimationUtils.currentAnimationTimeMillis();
        MPPointF mPPointF = this.mDecelerationVelocity;
        mPPointF.x *= ((BarLineChartBase)this.mChart).getDragDecelerationFrictionCoef();
        mPPointF = this.mDecelerationVelocity;
        mPPointF.y *= ((BarLineChartBase)this.mChart).getDragDecelerationFrictionCoef();
        f = (float)(l - this.mDecelerationLastTime) / 1000.0f;
        float f3 = this.mDecelerationVelocity.x;
        float f4 = this.mDecelerationVelocity.y;
        mPPointF = this.mDecelerationCurrentPoint;
        mPPointF.x += f3 * f;
        mPPointF = this.mDecelerationCurrentPoint;
        mPPointF.y += f4 * f;
        mPPointF = MotionEvent.obtain((long)l, (long)l, (int)2, (float)this.mDecelerationCurrentPoint.x, (float)this.mDecelerationCurrentPoint.y, (int)0);
        f = ((BarLineChartBase)this.mChart).isDragXEnabled() ? this.mDecelerationCurrentPoint.x - this.mTouchStartPoint.x : 0.0f;
        if (((BarLineChartBase)this.mChart).isDragYEnabled()) {
            f2 = this.mDecelerationCurrentPoint.y - this.mTouchStartPoint.y;
        }
        this.performDrag((MotionEvent)mPPointF, f, f2);
        mPPointF.recycle();
        this.mMatrix = ((BarLineChartBase)this.mChart).getViewPortHandler().refresh(this.mMatrix, (View)this.mChart, false);
        this.mDecelerationLastTime = l;
        if (!((double)Math.abs(this.mDecelerationVelocity.x) >= 0.01) && !((double)Math.abs(this.mDecelerationVelocity.y) >= 0.01)) {
            ((BarLineChartBase)this.mChart).calculateOffsets();
            ((BarLineChartBase)this.mChart).postInvalidate();
            this.stopDeceleration();
        } else {
            Utils.postInvalidateOnAnimation((View)this.mChart);
        }
    }

    public Matrix getMatrix() {
        return this.mMatrix;
    }

    public MPPointF getTrans(float f, float f2) {
        ViewPortHandler viewPortHandler = ((BarLineChartBase)this.mChart).getViewPortHandler();
        float f3 = viewPortHandler.offsetLeft();
        f2 = this.inverted() ? -(f2 - viewPortHandler.offsetTop()) : -((float)((BarLineChartBase)this.mChart).getMeasuredHeight() - f2 - viewPortHandler.offsetBottom());
        return MPPointF.getInstance(f - f3, f2);
    }

    public boolean onDoubleTap(MotionEvent motionEvent) {
        this.mLastGesture = ChartTouchListener.ChartGesture.DOUBLE_TAP;
        OnChartGestureListener onChartGestureListener = ((BarLineChartBase)this.mChart).getOnChartGestureListener();
        if (onChartGestureListener != null) {
            onChartGestureListener.onChartDoubleTapped(motionEvent);
        }
        if (((BarLineChartBase)this.mChart).isDoubleTapToZoomEnabled() && ((BarLineScatterCandleBubbleData)((BarLineChartBase)this.mChart).getData()).getEntryCount() > 0) {
            MPPointF mPPointF = this.getTrans(motionEvent.getX(), motionEvent.getY());
            boolean bl = ((BarLineChartBase)this.mChart).isScaleXEnabled();
            float f = 1.4f;
            float f2 = bl ? 1.4f : 1.0f;
            if (!((BarLineChartBase)this.mChart).isScaleYEnabled()) {
                f = 1.0f;
            }
            ((BarLineChartBase)this.mChart).zoom(f2, f, mPPointF.x, mPPointF.y);
            if (((BarLineChartBase)this.mChart).isLogEnabled()) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Double-Tap, Zooming In, x: ");
                stringBuilder.append(mPPointF.x);
                stringBuilder.append(", y: ");
                stringBuilder.append(mPPointF.y);
                Log.i((String)"BarlineChartTouch", (String)stringBuilder.toString());
            }
            if (onChartGestureListener != null) {
                onChartGestureListener.onChartScale(motionEvent, f2, f);
            }
            MPPointF.recycleInstance(mPPointF);
        }
        return super.onDoubleTap(motionEvent);
    }

    public boolean onFling(MotionEvent motionEvent, MotionEvent motionEvent2, float f, float f2) {
        this.mLastGesture = ChartTouchListener.ChartGesture.FLING;
        OnChartGestureListener onChartGestureListener = ((BarLineChartBase)this.mChart).getOnChartGestureListener();
        if (onChartGestureListener != null) {
            onChartGestureListener.onChartFling(motionEvent, motionEvent2, f, f2);
        }
        return super.onFling(motionEvent, motionEvent2, f, f2);
    }

    public void onLongPress(MotionEvent motionEvent) {
        this.mLastGesture = ChartTouchListener.ChartGesture.LONG_PRESS;
        OnChartGestureListener onChartGestureListener = ((BarLineChartBase)this.mChart).getOnChartGestureListener();
        if (onChartGestureListener != null) {
            onChartGestureListener.onChartLongPressed(motionEvent);
        }
    }

    public boolean onSingleTapUp(MotionEvent motionEvent) {
        this.mLastGesture = ChartTouchListener.ChartGesture.SINGLE_TAP;
        OnChartGestureListener onChartGestureListener = ((BarLineChartBase)this.mChart).getOnChartGestureListener();
        if (onChartGestureListener != null) {
            onChartGestureListener.onChartSingleTapped(motionEvent);
        }
        if (!((BarLineChartBase)this.mChart).isHighlightPerTapEnabled()) {
            return false;
        }
        this.performHighlight(((BarLineChartBase)this.mChart).getHighlightByTouchPoint(motionEvent.getX(), motionEvent.getY()), motionEvent);
        return super.onSingleTapUp(motionEvent);
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean onTouch(View view, MotionEvent motionEvent) {
        block33: {
            block29: {
                int n;
                block30: {
                    block35: {
                        block38: {
                            block37: {
                                block36: {
                                    int n2;
                                    block34: {
                                        block31: {
                                            block32: {
                                                if (this.mVelocityTracker == null) {
                                                    this.mVelocityTracker = VelocityTracker.obtain();
                                                }
                                                this.mVelocityTracker.addMovement(motionEvent);
                                                n2 = motionEvent.getActionMasked();
                                                n = 3;
                                                if (n2 == 3 && (view = this.mVelocityTracker) != null) {
                                                    view.recycle();
                                                    this.mVelocityTracker = null;
                                                }
                                                if (this.mTouchMode == 0) {
                                                    this.mGestureDetector.onTouchEvent(motionEvent);
                                                }
                                                if (!(((BarLineChartBase)this.mChart).isDragEnabled() || ((BarLineChartBase)this.mChart).isScaleXEnabled() || ((BarLineChartBase)this.mChart).isScaleYEnabled())) {
                                                    return true;
                                                }
                                                int n3 = motionEvent.getAction() & 0xFF;
                                                if (n3 == 0) break block29;
                                                n2 = 0;
                                                if (n3 == 1) break block30;
                                                if (n3 == 2) break block31;
                                                if (n3 == 3) break block32;
                                                if (n3 != 5) {
                                                    if (n3 == 6) {
                                                        Utils.velocityTrackerPointerUpCleanUpIfNecessary(motionEvent, this.mVelocityTracker);
                                                        this.mTouchMode = 5;
                                                    }
                                                    break block33;
                                                } else if (motionEvent.getPointerCount() >= 2) {
                                                    float f;
                                                    ((BarLineChartBase)this.mChart).disableScroll();
                                                    this.saveTouchStart(motionEvent);
                                                    this.mSavedXDist = BarLineChartTouchListener.getXDist(motionEvent);
                                                    this.mSavedYDist = BarLineChartTouchListener.getYDist(motionEvent);
                                                    this.mSavedDist = f = BarLineChartTouchListener.spacing(motionEvent);
                                                    if (f > 10.0f) {
                                                        if (((BarLineChartBase)this.mChart).isPinchZoomEnabled()) {
                                                            this.mTouchMode = 4;
                                                        } else if (((BarLineChartBase)this.mChart).isScaleXEnabled() != ((BarLineChartBase)this.mChart).isScaleYEnabled()) {
                                                            if (((BarLineChartBase)this.mChart).isScaleXEnabled()) {
                                                                n = 2;
                                                            }
                                                            this.mTouchMode = n;
                                                        } else {
                                                            if (this.mSavedXDist > this.mSavedYDist) {
                                                                n = 2;
                                                            }
                                                            this.mTouchMode = n;
                                                        }
                                                    }
                                                    BarLineChartTouchListener.midPoint(this.mTouchPointCenter, motionEvent);
                                                }
                                                break block33;
                                            }
                                            this.mTouchMode = 0;
                                            this.endAction(motionEvent);
                                            break block33;
                                        }
                                        if (this.mTouchMode != 1) break block34;
                                        ((BarLineChartBase)this.mChart).disableScroll();
                                        boolean bl = ((BarLineChartBase)this.mChart).isDragXEnabled();
                                        float f = 0.0f;
                                        float f2 = bl ? motionEvent.getX() - this.mTouchStartPoint.x : 0.0f;
                                        if (((BarLineChartBase)this.mChart).isDragYEnabled()) {
                                            f = motionEvent.getY() - this.mTouchStartPoint.y;
                                        }
                                        this.performDrag(motionEvent, f2, f);
                                        break block33;
                                    }
                                    if (this.mTouchMode == 2 || this.mTouchMode == 3 || this.mTouchMode == 4) break block35;
                                    if (this.mTouchMode != 0 || !(Math.abs(BarLineChartTouchListener.distance(motionEvent.getX(), this.mTouchStartPoint.x, motionEvent.getY(), this.mTouchStartPoint.y)) > this.mDragTriggerDist) || !((BarLineChartBase)this.mChart).isDragEnabled()) break block33;
                                    if (!((BarLineChartBase)this.mChart).isFullyZoomedOut()) break block36;
                                    n = n2;
                                    if (((BarLineChartBase)this.mChart).hasNoDragOffset()) break block37;
                                }
                                n = 1;
                            }
                            if (n == 0) break block38;
                            float f = Math.abs(motionEvent.getX() - this.mTouchStartPoint.x);
                            float f3 = Math.abs(motionEvent.getY() - this.mTouchStartPoint.y);
                            if ((((BarLineChartBase)this.mChart).isDragXEnabled() || f3 >= f) && (((BarLineChartBase)this.mChart).isDragYEnabled() || f3 <= f)) {
                                this.mLastGesture = ChartTouchListener.ChartGesture.DRAG;
                                this.mTouchMode = 1;
                            }
                            break block33;
                        }
                        if (((BarLineChartBase)this.mChart).isHighlightPerDragEnabled()) {
                            this.mLastGesture = ChartTouchListener.ChartGesture.DRAG;
                            if (((BarLineChartBase)this.mChart).isHighlightPerDragEnabled()) {
                                this.performHighlightDrag(motionEvent);
                            }
                        }
                        break block33;
                    }
                    ((BarLineChartBase)this.mChart).disableScroll();
                    if (((BarLineChartBase)this.mChart).isScaleXEnabled() || ((BarLineChartBase)this.mChart).isScaleYEnabled()) {
                        this.performZoom(motionEvent);
                    }
                    break block33;
                }
                view = this.mVelocityTracker;
                n = motionEvent.getPointerId(0);
                view.computeCurrentVelocity(1000, (float)Utils.getMaximumFlingVelocity());
                float f = view.getYVelocity(n);
                float f4 = view.getXVelocity(n);
                if ((Math.abs(f4) > (float)Utils.getMinimumFlingVelocity() || Math.abs(f) > (float)Utils.getMinimumFlingVelocity()) && this.mTouchMode == 1 && ((BarLineChartBase)this.mChart).isDragDecelerationEnabled()) {
                    this.stopDeceleration();
                    this.mDecelerationLastTime = AnimationUtils.currentAnimationTimeMillis();
                    this.mDecelerationCurrentPoint.x = motionEvent.getX();
                    this.mDecelerationCurrentPoint.y = motionEvent.getY();
                    this.mDecelerationVelocity.x = f4;
                    this.mDecelerationVelocity.y = f;
                    Utils.postInvalidateOnAnimation((View)this.mChart);
                }
                if (this.mTouchMode == 2 || this.mTouchMode == 3 || this.mTouchMode == 4 || this.mTouchMode == 5) {
                    ((BarLineChartBase)this.mChart).calculateOffsets();
                    ((BarLineChartBase)this.mChart).postInvalidate();
                }
                this.mTouchMode = 0;
                ((BarLineChartBase)this.mChart).enableScroll();
                view = this.mVelocityTracker;
                if (view != null) {
                    view.recycle();
                    this.mVelocityTracker = null;
                }
                this.endAction(motionEvent);
                break block33;
            }
            this.startAction(motionEvent);
            this.stopDeceleration();
            this.saveTouchStart(motionEvent);
        }
        this.mMatrix = ((BarLineChartBase)this.mChart).getViewPortHandler().refresh(this.mMatrix, (View)this.mChart, true);
        return true;
    }

    public void setDragTriggerDist(float f) {
        this.mDragTriggerDist = Utils.convertDpToPixel(f);
    }

    public void stopDeceleration() {
        this.mDecelerationVelocity.x = 0.0f;
        this.mDecelerationVelocity.y = 0.0f;
    }
}

