/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.renderer;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import com.github.mikephil.charting.animation.ChartAnimator;
import com.github.mikephil.charting.data.CandleData;
import com.github.mikephil.charting.data.CandleEntry;
import com.github.mikephil.charting.data.Entry;
import com.github.mikephil.charting.highlight.Highlight;
import com.github.mikephil.charting.interfaces.dataprovider.CandleDataProvider;
import com.github.mikephil.charting.interfaces.datasets.ICandleDataSet;
import com.github.mikephil.charting.renderer.LineScatterCandleRadarRenderer;
import com.github.mikephil.charting.utils.MPPointD;
import com.github.mikephil.charting.utils.MPPointF;
import com.github.mikephil.charting.utils.Transformer;
import com.github.mikephil.charting.utils.Utils;
import com.github.mikephil.charting.utils.ViewPortHandler;
import java.util.List;

public class CandleStickChartRenderer
extends LineScatterCandleRadarRenderer {
    private float[] mBodyBuffers;
    protected CandleDataProvider mChart;
    private float[] mCloseBuffers;
    private float[] mOpenBuffers;
    private float[] mRangeBuffers;
    private float[] mShadowBuffers = new float[8];

    public CandleStickChartRenderer(CandleDataProvider candleDataProvider, ChartAnimator chartAnimator, ViewPortHandler viewPortHandler) {
        super(chartAnimator, viewPortHandler);
        this.mBodyBuffers = new float[4];
        this.mRangeBuffers = new float[4];
        this.mOpenBuffers = new float[4];
        this.mCloseBuffers = new float[4];
        this.mChart = candleDataProvider;
    }

    @Override
    public void drawData(Canvas canvas) {
        for (ICandleDataSet iCandleDataSet : this.mChart.getCandleData().getDataSets()) {
            if (!iCandleDataSet.isVisible()) continue;
            this.drawDataSet(canvas, iCandleDataSet);
        }
    }

    protected void drawDataSet(Canvas canvas, ICandleDataSet iCandleDataSet) {
        Transformer transformer = this.mChart.getTransformer(iCandleDataSet.getAxisDependency());
        float f = this.mAnimator.getPhaseY();
        float f2 = iCandleDataSet.getBarSpace();
        boolean bl = iCandleDataSet.getShowCandleBar();
        this.mXBounds.set(this.mChart, iCandleDataSet);
        this.mRenderPaint.setStrokeWidth(iCandleDataSet.getShadowWidth());
        for (int i = this.mXBounds.min; i <= this.mXBounds.range + this.mXBounds.min; ++i) {
            int n;
            Object object = (CandleEntry)iCandleDataSet.getEntryForIndex(i);
            if (object == null) continue;
            float f3 = ((Entry)object).getX();
            float f4 = ((CandleEntry)object).getOpen();
            float f5 = ((CandleEntry)object).getClose();
            float f6 = ((CandleEntry)object).getHigh();
            float f7 = ((CandleEntry)object).getLow();
            if (bl) {
                object = this.mShadowBuffers;
                object[0] = f3;
                object[2] = f3;
                object[4] = f3;
                object[6] = f3;
                float f8 = f4 == f5 ? 0 : (f4 > f5 ? 1 : -1);
                if (f8 > 0) {
                    object[1] = f6 * f;
                    object[3] = f4 * f;
                    object[5] = f7 * f;
                    object[7] = f5 * f;
                } else if (f4 < f5) {
                    object[1] = f6 * f;
                    object[3] = f5 * f;
                    object[5] = f7 * f;
                    object[7] = f4 * f;
                } else {
                    object[1] = f6 * f;
                    object[3] = f4 * f;
                    object[5] = f7 * f;
                    object[7] = object[3];
                }
                transformer.pointValuesToPixel((float[])object);
                if (iCandleDataSet.getShadowColorSameAsCandle()) {
                    if (f8 > 0) {
                        object = this.mRenderPaint;
                        n = iCandleDataSet.getDecreasingColor() == 0x112233 ? iCandleDataSet.getColor(i) : iCandleDataSet.getDecreasingColor();
                        object.setColor(n);
                    } else if (f4 < f5) {
                        object = this.mRenderPaint;
                        n = iCandleDataSet.getIncreasingColor() == 0x112233 ? iCandleDataSet.getColor(i) : iCandleDataSet.getIncreasingColor();
                        object.setColor(n);
                    } else {
                        object = this.mRenderPaint;
                        n = iCandleDataSet.getNeutralColor() == 0x112233 ? iCandleDataSet.getColor(i) : iCandleDataSet.getNeutralColor();
                        object.setColor(n);
                    }
                } else {
                    object = this.mRenderPaint;
                    n = iCandleDataSet.getShadowColor() == 0x112233 ? iCandleDataSet.getColor(i) : iCandleDataSet.getShadowColor();
                    object.setColor(n);
                }
                this.mRenderPaint.setStyle(Paint.Style.STROKE);
                canvas.drawLines(this.mShadowBuffers, this.mRenderPaint);
                object = this.mBodyBuffers;
                object[0] = f3 - 0.5f + f2;
                object[1] = f5 * f;
                object[2] = f3 + 0.5f - f2;
                object[3] = f4 * f;
                transformer.pointValuesToPixel((float[])object);
                if (f8 > 0) {
                    if (iCandleDataSet.getDecreasingColor() == 0x112233) {
                        this.mRenderPaint.setColor(iCandleDataSet.getColor(i));
                    } else {
                        this.mRenderPaint.setColor(iCandleDataSet.getDecreasingColor());
                    }
                    this.mRenderPaint.setStyle(iCandleDataSet.getDecreasingPaintStyle());
                    object = this.mBodyBuffers;
                    canvas.drawRect((float)object[0], (float)object[3], (float)object[2], (float)object[1], this.mRenderPaint);
                    continue;
                }
                if (f4 < f5) {
                    if (iCandleDataSet.getIncreasingColor() == 0x112233) {
                        this.mRenderPaint.setColor(iCandleDataSet.getColor(i));
                    } else {
                        this.mRenderPaint.setColor(iCandleDataSet.getIncreasingColor());
                    }
                    this.mRenderPaint.setStyle(iCandleDataSet.getIncreasingPaintStyle());
                    object = this.mBodyBuffers;
                    canvas.drawRect((float)object[0], (float)object[1], (float)object[2], (float)object[3], this.mRenderPaint);
                    continue;
                }
                if (iCandleDataSet.getNeutralColor() == 0x112233) {
                    this.mRenderPaint.setColor(iCandleDataSet.getColor(i));
                } else {
                    this.mRenderPaint.setColor(iCandleDataSet.getNeutralColor());
                }
                object = this.mBodyBuffers;
                canvas.drawLine((float)object[0], (float)object[1], (float)object[2], (float)object[3], this.mRenderPaint);
                continue;
            }
            object = this.mRangeBuffers;
            object[0] = f3;
            object[1] = f6 * f;
            object[2] = f3;
            object[3] = f7 * f;
            float[] fArray = this.mOpenBuffers;
            fArray[0] = f3 - 0.5f + f2;
            fArray[1] = f7 = f4 * f;
            fArray[2] = f3;
            fArray[3] = f7;
            fArray = this.mCloseBuffers;
            fArray[0] = 0.5f + f3 - f2;
            fArray[1] = f7 = f5 * f;
            fArray[2] = f3;
            fArray[3] = f7;
            transformer.pointValuesToPixel((float[])object);
            transformer.pointValuesToPixel(this.mOpenBuffers);
            transformer.pointValuesToPixel(this.mCloseBuffers);
            n = f4 > f5 ? (iCandleDataSet.getDecreasingColor() == 0x112233 ? iCandleDataSet.getColor(i) : iCandleDataSet.getDecreasingColor()) : (f4 < f5 ? (iCandleDataSet.getIncreasingColor() == 0x112233 ? iCandleDataSet.getColor(i) : iCandleDataSet.getIncreasingColor()) : (iCandleDataSet.getNeutralColor() == 0x112233 ? iCandleDataSet.getColor(i) : iCandleDataSet.getNeutralColor()));
            this.mRenderPaint.setColor(n);
            object = this.mRangeBuffers;
            canvas.drawLine((float)object[0], (float)object[1], (float)object[2], (float)object[3], this.mRenderPaint);
            object = this.mOpenBuffers;
            canvas.drawLine((float)object[0], (float)object[1], (float)object[2], (float)object[3], this.mRenderPaint);
            object = this.mCloseBuffers;
            canvas.drawLine((float)object[0], (float)object[1], (float)object[2], (float)object[3], this.mRenderPaint);
        }
    }

    @Override
    public void drawExtras(Canvas canvas) {
    }

    @Override
    public void drawHighlighted(Canvas canvas, Highlight[] highlightArray) {
        CandleData candleData = this.mChart.getCandleData();
        for (Highlight highlight : highlightArray) {
            Object object;
            ICandleDataSet iCandleDataSet = (ICandleDataSet)candleData.getDataSetByIndex(highlight.getDataSetIndex());
            if (iCandleDataSet == null || !iCandleDataSet.isHighlightEnabled() || !this.isInBoundsX((Entry)(object = (CandleEntry)iCandleDataSet.getEntryForXValue(highlight.getX(), highlight.getY())), iCandleDataSet)) continue;
            float f = (((CandleEntry)object).getLow() * this.mAnimator.getPhaseY() + ((CandleEntry)object).getHigh() * this.mAnimator.getPhaseY()) / 2.0f;
            object = this.mChart.getTransformer(iCandleDataSet.getAxisDependency()).getPixelForValues(((Entry)object).getX(), f);
            highlight.setDraw((float)((MPPointD)object).x, (float)((MPPointD)object).y);
            this.drawHighlightLines(canvas, (float)((MPPointD)object).x, (float)((MPPointD)object).y, iCandleDataSet);
        }
    }

    @Override
    public void drawValues(Canvas canvas) {
        if (this.isDrawingValuesAllowed(this.mChart)) {
            List list = this.mChart.getCandleData().getDataSets();
            for (int i = 0; i < list.size(); ++i) {
                ICandleDataSet iCandleDataSet = (ICandleDataSet)list.get(i);
                if (!this.shouldDrawValues(iCandleDataSet) || iCandleDataSet.getEntryCount() < 1) continue;
                this.applyValueTextStyle(iCandleDataSet);
                Object object = this.mChart.getTransformer(iCandleDataSet.getAxisDependency());
                this.mXBounds.set(this.mChart, iCandleDataSet);
                float[] fArray = ((Transformer)object).generateTransformedValuesCandle(iCandleDataSet, this.mAnimator.getPhaseX(), this.mAnimator.getPhaseY(), this.mXBounds.min, this.mXBounds.max);
                float f = Utils.convertDpToPixel(5.0f);
                object = MPPointF.getInstance(iCandleDataSet.getIconsOffset());
                ((MPPointF)object).x = Utils.convertDpToPixel(((MPPointF)object).x);
                ((MPPointF)object).y = Utils.convertDpToPixel(((MPPointF)object).y);
                for (int j = 0; j < fArray.length; j += 2) {
                    float f2 = fArray[j];
                    float f3 = fArray[j + 1];
                    if (!this.mViewPortHandler.isInBoundsRight(f2)) break;
                    if (!this.mViewPortHandler.isInBoundsLeft(f2) || !this.mViewPortHandler.isInBoundsY(f3)) continue;
                    int n = j / 2;
                    CandleEntry candleEntry = (CandleEntry)iCandleDataSet.getEntryForIndex(this.mXBounds.min + n);
                    if (iCandleDataSet.isDrawValuesEnabled()) {
                        this.drawValue(canvas, iCandleDataSet.getValueFormatter(), candleEntry.getHigh(), candleEntry, i, f2, f3 - f, iCandleDataSet.getValueTextColor(n));
                    }
                    Object object2 = object;
                    if (candleEntry.getIcon() == null || !iCandleDataSet.isDrawIconsEnabled()) continue;
                    candleEntry = candleEntry.getIcon();
                    Utils.drawImage(canvas, (Drawable)candleEntry, (int)(f2 + ((MPPointF)object2).x), (int)(f3 + ((MPPointF)object2).y), candleEntry.getIntrinsicWidth(), candleEntry.getIntrinsicHeight());
                }
                MPPointF.recycleInstance((MPPointF)object);
            }
        }
    }

    @Override
    public void initBuffers() {
    }
}

