/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.renderer;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.graphics.Typeface;
import com.github.mikephil.charting.components.Legend;
import com.github.mikephil.charting.components.LegendEntry;
import com.github.mikephil.charting.data.ChartData;
import com.github.mikephil.charting.data.PieEntry;
import com.github.mikephil.charting.interfaces.datasets.IBarDataSet;
import com.github.mikephil.charting.interfaces.datasets.ICandleDataSet;
import com.github.mikephil.charting.interfaces.datasets.IPieDataSet;
import com.github.mikephil.charting.renderer.Renderer;
import com.github.mikephil.charting.utils.FSize;
import com.github.mikephil.charting.utils.Utils;
import com.github.mikephil.charting.utils.ViewPortHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class LegendRenderer
extends Renderer {
    protected List<LegendEntry> computedEntries = new ArrayList<LegendEntry>(16);
    protected Paint.FontMetrics legendFontMetrics = new Paint.FontMetrics();
    protected Legend mLegend;
    protected Paint mLegendFormPaint;
    protected Paint mLegendLabelPaint;
    private Path mLineFormPath = new Path();

    public LegendRenderer(ViewPortHandler viewPortHandler, Legend legend) {
        super(viewPortHandler);
        this.mLegend = legend;
        viewPortHandler = new Paint(1);
        this.mLegendLabelPaint = viewPortHandler;
        viewPortHandler.setTextSize(Utils.convertDpToPixel(9.0f));
        this.mLegendLabelPaint.setTextAlign(Paint.Align.LEFT);
        viewPortHandler = new Paint(1);
        this.mLegendFormPaint = viewPortHandler;
        viewPortHandler.setStyle(Paint.Style.FILL);
    }

    public void computeLegend(ChartData<?> typeface) {
        Object object = typeface;
        if (!this.mLegend.isLegendCustom()) {
            this.computedEntries.clear();
            for (int i = 0; i < typeface.getDataSetCount(); ++i) {
                int n;
                IBarDataSet iBarDataSet;
                Object t = ((ChartData)object).getDataSetByIndex(i);
                if (t == null) continue;
                List<Integer> list = t.getColors();
                int n2 = t.getEntryCount();
                if (t instanceof IBarDataSet && (iBarDataSet = (IBarDataSet)t).isStacked()) {
                    String[] stringArray = iBarDataSet.getStackLabels();
                    n2 = Math.min(list.size(), iBarDataSet.getStackSize());
                    for (n = 0; n < n2; ++n) {
                        int n3;
                        String string2 = stringArray.length > 0 ? ((n3 = n % n2) < stringArray.length ? stringArray[n3] : null) : null;
                        this.computedEntries.add(new LegendEntry(string2, t.getForm(), t.getFormSize(), t.getFormLineWidth(), t.getFormLineDashEffect(), list.get(n)));
                    }
                    if (iBarDataSet.getLabel() == null) continue;
                    this.computedEntries.add(new LegendEntry(t.getLabel(), Legend.LegendForm.NONE, Float.NaN, Float.NaN, null, 0x112233));
                    continue;
                }
                if (t instanceof IPieDataSet) {
                    object = (IPieDataSet)t;
                    for (n = 0; n < list.size() && n < n2; ++n) {
                        this.computedEntries.add(new LegendEntry(((PieEntry)object.getEntryForIndex(n)).getLabel(), t.getForm(), t.getFormSize(), t.getFormLineWidth(), t.getFormLineDashEffect(), list.get(n)));
                    }
                    if (object.getLabel() != null) {
                        this.computedEntries.add(new LegendEntry(t.getLabel(), Legend.LegendForm.NONE, Float.NaN, Float.NaN, null, 0x112233));
                    }
                } else if (t instanceof ICandleDataSet && (object = (ICandleDataSet)t).getDecreasingColor() != 0x112233) {
                    n = object.getDecreasingColor();
                    n2 = object.getIncreasingColor();
                    this.computedEntries.add(new LegendEntry(null, t.getForm(), t.getFormSize(), t.getFormLineWidth(), t.getFormLineDashEffect(), n));
                    this.computedEntries.add(new LegendEntry(t.getLabel(), t.getForm(), t.getFormSize(), t.getFormLineWidth(), t.getFormLineDashEffect(), n2));
                } else {
                    for (n = 0; n < list.size() && n < n2; ++n) {
                        object = n < list.size() - 1 && n < n2 - 1 ? null : typeface.getDataSetByIndex(i).getLabel();
                        this.computedEntries.add(new LegendEntry((String)object, t.getForm(), t.getFormSize(), t.getFormLineWidth(), t.getFormLineDashEffect(), list.get(n)));
                    }
                }
                object = typeface;
            }
            if (this.mLegend.getExtraEntries() != null) {
                Collections.addAll(this.computedEntries, this.mLegend.getExtraEntries());
            }
            this.mLegend.setEntries(this.computedEntries);
        }
        if ((typeface = this.mLegend.getTypeface()) != null) {
            this.mLegendLabelPaint.setTypeface(typeface);
        }
        this.mLegendLabelPaint.setTextSize(this.mLegend.getTextSize());
        this.mLegendLabelPaint.setColor(this.mLegend.getTextColor());
        this.mLegend.calculateDimensions(this.mLegendLabelPaint, this.mViewPortHandler);
    }

    protected void drawForm(Canvas canvas, float f, float f2, LegendEntry legendEntry, Legend legend) {
        if (legendEntry.formColor != 1122868 && legendEntry.formColor != 0x112233 && legendEntry.formColor != 0) {
            Legend.LegendForm legendForm;
            int n = canvas.save();
            Legend.LegendForm legendForm2 = legendForm = legendEntry.form;
            if (legendForm == Legend.LegendForm.DEFAULT) {
                legendForm2 = legend.getForm();
            }
            this.mLegendFormPaint.setColor(legendEntry.formColor);
            float f3 = Float.isNaN(legendEntry.formSize) ? legend.getFormSize() : legendEntry.formSize;
            float f4 = Utils.convertDpToPixel(f3);
            f3 = f4 / 2.0f;
            int n2 = 1.$SwitchMap$com$github$mikephil$charting$components$Legend$LegendForm[legendForm2.ordinal()];
            if (n2 != 3 && n2 != 4) {
                if (n2 != 5) {
                    if (n2 == 6) {
                        f3 = Float.isNaN(legendEntry.formLineWidth) ? legend.getFormLineWidth() : legendEntry.formLineWidth;
                        f3 = Utils.convertDpToPixel(f3);
                        legendEntry = legendEntry.formLineDashEffect == null ? legend.getFormLineDashEffect() : legendEntry.formLineDashEffect;
                        this.mLegendFormPaint.setStyle(Paint.Style.STROKE);
                        this.mLegendFormPaint.setStrokeWidth(f3);
                        this.mLegendFormPaint.setPathEffect((PathEffect)legendEntry);
                        this.mLineFormPath.reset();
                        this.mLineFormPath.moveTo(f, f2);
                        this.mLineFormPath.lineTo(f + f4, f2);
                        canvas.drawPath(this.mLineFormPath, this.mLegendFormPaint);
                    }
                } else {
                    this.mLegendFormPaint.setStyle(Paint.Style.FILL);
                    canvas.drawRect(f, f2 - f3, f + f4, f2 + f3, this.mLegendFormPaint);
                }
            } else {
                this.mLegendFormPaint.setStyle(Paint.Style.FILL);
                canvas.drawCircle(f + f3, f2, f3, this.mLegendFormPaint);
            }
            canvas.restoreToCount(n);
        }
    }

    protected void drawLabel(Canvas canvas, float f, float f2, String string2) {
        canvas.drawText(string2, f, f2, this.mLegendLabelPaint);
    }

    public Paint getFormPaint() {
        return this.mLegendFormPaint;
    }

    public Paint getLabelPaint() {
        return this.mLegendLabelPaint;
    }

    public void renderLegend(Canvas canvas) {
        float f;
        float f2;
        if (!this.mLegend.isEnabled()) {
            return;
        }
        Object object = this.mLegend.getTypeface();
        if (object != null) {
            this.mLegendLabelPaint.setTypeface((Typeface)object);
        }
        this.mLegendLabelPaint.setTextSize(this.mLegend.getTextSize());
        this.mLegendLabelPaint.setColor(this.mLegend.getTextColor());
        float f3 = Utils.getLineHeight(this.mLegendLabelPaint, this.legendFontMetrics);
        float f4 = Utils.getLineSpacing(this.mLegendLabelPaint, this.legendFontMetrics) + Utils.convertDpToPixel(this.mLegend.getYEntrySpace());
        float f5 = f3 - (float)Utils.calcTextHeight(this.mLegendLabelPaint, "ABC") / 2.0f;
        LegendEntry[] legendEntryArray = this.mLegend.getEntries();
        float f6 = Utils.convertDpToPixel(this.mLegend.getFormToTextSpace());
        float f7 = Utils.convertDpToPixel(this.mLegend.getXEntrySpace());
        object = this.mLegend.getOrientation();
        Legend.LegendHorizontalAlignment legendHorizontalAlignment = this.mLegend.getHorizontalAlignment();
        Object object2 = this.mLegend.getVerticalAlignment();
        Legend.LegendDirection legendDirection = this.mLegend.getDirection();
        float f8 = Utils.convertDpToPixel(this.mLegend.getFormSize());
        float f9 = Utils.convertDpToPixel(this.mLegend.getStackSpace());
        float f10 = this.mLegend.getYOffset();
        float f11 = this.mLegend.getXOffset();
        int n = 1.$SwitchMap$com$github$mikephil$charting$components$Legend$LegendHorizontalAlignment[legendHorizontalAlignment.ordinal()];
        if (n != 1) {
            if (n != 2) {
                if (n != 3) {
                    f11 = 0.0f;
                } else {
                    f2 = object == Legend.LegendOrientation.VERTICAL ? this.mViewPortHandler.getChartWidth() / 2.0f : this.mViewPortHandler.contentLeft() + this.mViewPortHandler.contentWidth() / 2.0f;
                    f = legendDirection == Legend.LegendDirection.LEFT_TO_RIGHT ? f11 : -f11;
                    f2 += f;
                    if (object == Legend.LegendOrientation.VERTICAL) {
                        double d = f2;
                        double d2 = legendDirection == Legend.LegendDirection.LEFT_TO_RIGHT ? (double)(-this.mLegend.mNeededWidth) / 2.0 + (double)f11 : (double)this.mLegend.mNeededWidth / 2.0 - (double)f11;
                        f11 = (float)(d + d2);
                    } else {
                        f11 = f2;
                    }
                }
            } else {
                f2 = object == Legend.LegendOrientation.VERTICAL ? this.mViewPortHandler.getChartWidth() : this.mViewPortHandler.contentRight();
                f2 -= f11;
                f11 = f2;
                if (legendDirection == Legend.LegendDirection.LEFT_TO_RIGHT) {
                    f11 = f2 - this.mLegend.mNeededWidth;
                }
            }
        } else {
            if (object != Legend.LegendOrientation.VERTICAL) {
                f11 += this.mViewPortHandler.contentLeft();
            }
            if (legendDirection == Legend.LegendDirection.RIGHT_TO_LEFT) {
                f11 = this.mLegend.mNeededWidth + f11;
            }
        }
        n = 1.$SwitchMap$com$github$mikephil$charting$components$Legend$LegendOrientation[((Enum)object).ordinal()];
        if (n != 1) {
            if (n == 2) {
                n = 1.$SwitchMap$com$github$mikephil$charting$components$Legend$LegendVerticalAlignment[object2.ordinal()];
                if (n != 1) {
                    if (n != 2) {
                        f2 = n != 3 ? 0.0f : this.mViewPortHandler.getChartHeight() / 2.0f - this.mLegend.mNeededHeight / 2.0f + this.mLegend.getYOffset();
                    } else {
                        f2 = legendHorizontalAlignment == Legend.LegendHorizontalAlignment.CENTER ? this.mViewPortHandler.getChartHeight() : this.mViewPortHandler.contentBottom();
                        f2 -= this.mLegend.mNeededHeight + f10;
                    }
                } else {
                    f2 = legendHorizontalAlignment == Legend.LegendHorizontalAlignment.CENTER ? 0.0f : this.mViewPortHandler.contentTop();
                    f2 += f10;
                }
                f7 = f2;
                boolean bl = false;
                float f12 = 0.0f;
                f2 = f9;
                f = f5;
                f9 = f7;
                object = legendDirection;
                for (n = 0; n < legendEntryArray.length; ++n) {
                    LegendEntry legendEntry = legendEntryArray[n];
                    boolean bl2 = legendEntry.form != Legend.LegendForm.NONE;
                    f5 = Float.isNaN(legendEntry.formSize) ? f8 : Utils.convertDpToPixel(legendEntry.formSize);
                    if (bl2) {
                        f7 = object == Legend.LegendDirection.LEFT_TO_RIGHT ? f11 + f12 : f11 - (f5 - f12);
                        f10 = f7;
                        this.drawForm(canvas, f10, f9 + f, legendEntry, this.mLegend);
                        f7 = f10;
                        if (object == Legend.LegendDirection.LEFT_TO_RIGHT) {
                            f7 = f10 + f5;
                        }
                    } else {
                        f7 = f11;
                    }
                    f10 = f2;
                    if (legendEntry.label != null) {
                        if (bl2 && !bl) {
                            f2 = object == Legend.LegendDirection.LEFT_TO_RIGHT ? f6 : -f6;
                            f2 = f7 + f2;
                        } else {
                            f2 = f7;
                            if (bl) {
                                f2 = f11;
                            }
                        }
                        f7 = f2;
                        if (object == Legend.LegendDirection.RIGHT_TO_LEFT) {
                            f7 = f2 - (float)Utils.calcTextWidth(this.mLegendLabelPaint, legendEntry.label);
                        }
                        if (!bl) {
                            this.drawLabel(canvas, f7, f9 + f3, legendEntry.label);
                        } else {
                            this.drawLabel(canvas, f7, (f9 += f3 + f4) + f3, legendEntry.label);
                        }
                        f9 += f3 + f4;
                        f7 = 0.0f;
                    } else {
                        f7 = f12 + (f5 + f10);
                        bl = true;
                    }
                    f2 = f10;
                    f12 = f7;
                }
            }
        } else {
            object = this.mLegend.getCalculatedLineSizes();
            List<FSize> list = this.mLegend.getCalculatedLabelSizes();
            List<Boolean> list2 = this.mLegend.getCalculatedLabelBreakPoints();
            n = 1.$SwitchMap$com$github$mikephil$charting$components$Legend$LegendVerticalAlignment[object2.ordinal()];
            f2 = f10;
            if (n != 1) {
                f2 = n != 2 ? (n != 3 ? 0.0f : f10 + (this.mViewPortHandler.getChartHeight() - this.mLegend.mNeededHeight) / 2.0f) : this.mViewPortHandler.getChartHeight() - f10 - this.mLegend.mNeededHeight;
            }
            int n2 = legendEntryArray.length;
            f10 = f11;
            int n3 = 0;
            f = f9;
            f9 = f11;
            for (n = 0; n < n2; ++n) {
                object2 = legendEntryArray[n];
                boolean bl = ((LegendEntry)object2).form != Legend.LegendForm.NONE;
                float f13 = Float.isNaN(((LegendEntry)object2).formSize) ? f8 : Utils.convertDpToPixel(((LegendEntry)object2).formSize);
                if (n < list2.size() && list2.get(n).booleanValue()) {
                    f2 += f3 + f4;
                    f11 = f9;
                } else {
                    f11 = f10;
                }
                if (f11 == f9 && legendHorizontalAlignment == Legend.LegendHorizontalAlignment.CENTER && n3 < object.size()) {
                    f10 = legendDirection == Legend.LegendDirection.RIGHT_TO_LEFT ? ((FSize)object.get((int)n3)).width : -((FSize)object.get((int)n3)).width;
                    f11 += f10 / 2.0f;
                    ++n3;
                }
                boolean bl3 = ((LegendEntry)object2).label == null;
                if (bl) {
                    f10 = f11;
                    if (legendDirection == Legend.LegendDirection.RIGHT_TO_LEFT) {
                        f10 = f11 - f13;
                    }
                    this.drawForm(canvas, f10, f2 + f5, (LegendEntry)object2, this.mLegend);
                    f11 = legendDirection == Legend.LegendDirection.LEFT_TO_RIGHT ? f10 + f13 : f10;
                }
                if (!bl3) {
                    f10 = f11;
                    if (bl) {
                        f10 = legendDirection == Legend.LegendDirection.RIGHT_TO_LEFT ? -f6 : f6;
                        f10 = f11 + f10;
                    }
                    f11 = f10;
                    if (legendDirection == Legend.LegendDirection.RIGHT_TO_LEFT) {
                        f11 = f10 - list.get((int)n).width;
                    }
                    this.drawLabel(canvas, f11, f2 + f3, ((LegendEntry)object2).label);
                    f10 = f11;
                    if (legendDirection == Legend.LegendDirection.LEFT_TO_RIGHT) {
                        f10 = f11 + list.get((int)n).width;
                    }
                    f11 = legendDirection == Legend.LegendDirection.RIGHT_TO_LEFT ? -f7 : f7;
                    f11 = f10 + f11;
                } else {
                    f10 = legendDirection == Legend.LegendDirection.RIGHT_TO_LEFT ? -f : f;
                    f11 += f10;
                }
                f10 = f11;
            }
        }
    }
}

