/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.renderer;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.text.Layout;
import android.text.StaticLayout;
import android.text.TextPaint;
import com.github.mikephil.charting.animation.ChartAnimator;
import com.github.mikephil.charting.charts.PieChart;
import com.github.mikephil.charting.data.BaseEntry;
import com.github.mikephil.charting.data.PieData;
import com.github.mikephil.charting.data.PieDataSet;
import com.github.mikephil.charting.data.PieEntry;
import com.github.mikephil.charting.formatter.IValueFormatter;
import com.github.mikephil.charting.highlight.Highlight;
import com.github.mikephil.charting.interfaces.datasets.IDataSet;
import com.github.mikephil.charting.interfaces.datasets.IPieDataSet;
import com.github.mikephil.charting.renderer.DataRenderer;
import com.github.mikephil.charting.utils.MPPointF;
import com.github.mikephil.charting.utils.Utils;
import com.github.mikephil.charting.utils.ViewPortHandler;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;

public class PieChartRenderer
extends DataRenderer {
    protected Canvas mBitmapCanvas;
    private RectF mCenterTextLastBounds = new RectF();
    private CharSequence mCenterTextLastValue;
    private StaticLayout mCenterTextLayout;
    private TextPaint mCenterTextPaint;
    protected PieChart mChart;
    protected WeakReference<Bitmap> mDrawBitmap;
    protected Path mDrawCenterTextPathBuffer;
    protected RectF mDrawHighlightedRectF;
    private Paint mEntryLabelsPaint;
    private Path mHoleCirclePath;
    protected Paint mHolePaint;
    private RectF mInnerRectBuffer;
    private Path mPathBuffer;
    private RectF[] mRectBuffer = new RectF[]{new RectF(), new RectF(), new RectF()};
    protected Paint mTransparentCirclePaint;
    protected Paint mValueLinePaint;

    public PieChartRenderer(PieChart pieChart, ChartAnimator chartAnimator, ViewPortHandler viewPortHandler) {
        super(chartAnimator, viewPortHandler);
        this.mPathBuffer = new Path();
        this.mInnerRectBuffer = new RectF();
        this.mHoleCirclePath = new Path();
        this.mDrawCenterTextPathBuffer = new Path();
        this.mDrawHighlightedRectF = new RectF();
        this.mChart = pieChart;
        pieChart = new Paint(1);
        this.mHolePaint = pieChart;
        pieChart.setColor(-1);
        this.mHolePaint.setStyle(Paint.Style.FILL);
        pieChart = new Paint(1);
        this.mTransparentCirclePaint = pieChart;
        pieChart.setColor(-1);
        this.mTransparentCirclePaint.setStyle(Paint.Style.FILL);
        this.mTransparentCirclePaint.setAlpha(105);
        pieChart = new TextPaint(1);
        this.mCenterTextPaint = pieChart;
        pieChart.setColor(-16777216);
        this.mCenterTextPaint.setTextSize(Utils.convertDpToPixel(12.0f));
        this.mValuePaint.setTextSize(Utils.convertDpToPixel(13.0f));
        this.mValuePaint.setColor(-1);
        this.mValuePaint.setTextAlign(Paint.Align.CENTER);
        pieChart = new Paint(1);
        this.mEntryLabelsPaint = pieChart;
        pieChart.setColor(-1);
        this.mEntryLabelsPaint.setTextAlign(Paint.Align.CENTER);
        this.mEntryLabelsPaint.setTextSize(Utils.convertDpToPixel(13.0f));
        pieChart = new Paint(1);
        this.mValueLinePaint = pieChart;
        pieChart.setStyle(Paint.Style.STROKE);
    }

    protected float calculateMinimumRadiusForSpacedSlice(MPPointF mPPointF, float f, float f2, float f3, float f4, float f5, float f6) {
        float f7 = f6 / 2.0f;
        float f8 = mPPointF.x;
        double d = (f5 + f6) * ((float)Math.PI / 180);
        float f9 = f8 + (float)Math.cos(d) * f;
        f6 = mPPointF.y + (float)Math.sin(d) * f;
        f8 = mPPointF.x;
        d = (f5 + f7) * ((float)Math.PI / 180);
        f5 = (float)Math.cos(d);
        f7 = mPPointF.y;
        float f10 = (float)Math.sin(d);
        return (float)((double)(f - (float)(Math.sqrt(Math.pow(f9 - f3, 2.0) + Math.pow(f6 - f4, 2.0)) / 2.0 * Math.tan((180.0 - (double)f2) / 2.0 * (Math.PI / 180)))) - Math.sqrt(Math.pow(f8 + f5 * f - (f9 + f3) / 2.0f, 2.0) + Math.pow(f7 + f10 * f - (f6 + f4) / 2.0f, 2.0)));
    }

    protected void drawCenterText(Canvas canvas) {
        CharSequence charSequence = this.mChart.getCenterText();
        if (this.mChart.isDrawCenterTextEnabled() && charSequence != null) {
            MPPointF mPPointF = this.mChart.getCenterCircleBox();
            MPPointF mPPointF2 = this.mChart.getCenterTextOffset();
            float f = mPPointF.x + mPPointF2.x;
            float f2 = mPPointF.y + mPPointF2.y;
            float f3 = this.mChart.isDrawHoleEnabled() && !this.mChart.isDrawSlicesUnderHoleEnabled() ? this.mChart.getRadius() * (this.mChart.getHoleRadius() / 100.0f) : this.mChart.getRadius();
            RectF rectF = this.mRectBuffer[0];
            rectF.left = f - f3;
            rectF.top = f2 - f3;
            rectF.right = f + f3;
            rectF.bottom = f2 + f3;
            RectF rectF2 = this.mRectBuffer[1];
            rectF2.set(rectF);
            f3 = this.mChart.getCenterTextRadiusPercent() / 100.0f;
            if ((double)f3 > 0.0) {
                rectF2.inset((rectF2.width() - rectF2.width() * f3) / 2.0f, (rectF2.height() - rectF2.height() * f3) / 2.0f);
            }
            if (!charSequence.equals(this.mCenterTextLastValue) || !rectF2.equals((Object)this.mCenterTextLastBounds)) {
                this.mCenterTextLastBounds.set(rectF2);
                this.mCenterTextLastValue = charSequence;
                f3 = this.mCenterTextLastBounds.width();
                this.mCenterTextLayout = new StaticLayout(charSequence, 0, charSequence.length(), this.mCenterTextPaint, (int)Math.max(Math.ceil(f3), 1.0), Layout.Alignment.ALIGN_CENTER, 1.0f, 0.0f, false);
            }
            f3 = this.mCenterTextLayout.getHeight();
            canvas.save();
            if (Build.VERSION.SDK_INT >= 18) {
                charSequence = this.mDrawCenterTextPathBuffer;
                charSequence.reset();
                charSequence.addOval(rectF, Path.Direction.CW);
                canvas.clipPath((Path)charSequence);
            }
            canvas.translate(rectF2.left, rectF2.top + (rectF2.height() - f3) / 2.0f);
            this.mCenterTextLayout.draw(canvas);
            canvas.restore();
            MPPointF.recycleInstance(mPPointF);
            MPPointF.recycleInstance(mPPointF2);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void drawData(Canvas canvas) {
        block5: {
            void var5_7;
            block4: {
                int n;
                int n2;
                block3: {
                    n2 = (int)this.mViewPortHandler.getChartWidth();
                    n = (int)this.mViewPortHandler.getChartHeight();
                    Object object2 = this.mDrawBitmap;
                    object2 = object2 == null ? null : (Bitmap)((Reference)object2).get();
                    if (object2 == null || object2.getWidth() != n2) break block3;
                    Bitmap object3 = object2;
                    if (object2.getHeight() == n) break block4;
                }
                if (n2 <= 0 || n <= 0) break block5;
                Bitmap bitmap = Bitmap.createBitmap((int)n2, (int)n, (Bitmap.Config)Bitmap.Config.ARGB_4444);
                this.mDrawBitmap = new WeakReference<Bitmap>(bitmap);
                this.mBitmapCanvas = new Canvas(bitmap);
            }
            var5_7.eraseColor(0);
            for (IPieDataSet iPieDataSet : ((PieData)this.mChart.getData()).getDataSets()) {
                if (!iPieDataSet.isVisible() || iPieDataSet.getEntryCount() <= 0) continue;
                this.drawDataSet(canvas, iPieDataSet);
            }
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    protected void drawDataSet(Canvas var1_1, IPieDataSet var2_2) {
        var3_3 = this;
        var4_4 = var2_2;
        var5_5 = var3_3.mChart.getRotationAngle();
        var6_6 = var3_3.mAnimator.getPhaseX();
        var7_7 = var3_3.mAnimator.getPhaseY();
        var8_8 = var3_3.mChart.getCircleBox();
        var9_9 = var2_2.getEntryCount();
        var10_10 = var3_3.mChart.getDrawAngles();
        var1_1 /* !! */  = var3_3.mChart.getCenterCircleBox();
        var11_11 = var3_3.mChart.getRadius();
        var12_12 = var3_3.mChart.isDrawHoleEnabled() != false && var3_3.mChart.isDrawSlicesUnderHoleEnabled() == false;
        var13_13 = var12_12 != false ? var3_3.mChart.getHoleRadius() / 100.0f * var11_11 : 0.0f;
        var14_14 = (var11_11 - var3_3.mChart.getHoleRadius() * var11_11 / 100.0f) / 2.0f;
        var15_15 /* !! */  = new RectF();
        var16_16 = var12_12 != false && var3_3.mChart.isDrawRoundedSlicesEnabled() != false;
        var18_18 = 0;
        for (var17_17 = 0; var17_17 < var9_9; ++var17_17) {
            var19_19 = var18_18;
            if (Math.abs(((PieEntry)var4_4.getEntryForIndex(var17_17)).getY()) > Utils.FLOAT_EPSILON) {
                var19_19 = var18_18 + 1;
            }
            var18_18 = var19_19;
        }
        var20_20 = var18_18 <= 1 ? 0.0f : var3_3.getSliceSpace(var4_4);
        var19_19 = 0;
        var21_21 = 0.0f;
        var17_17 = var9_9;
        while (true) {
            block22: {
                block23: {
                    var4_4 = var2_2;
                    if (var19_19 >= var17_17) break;
                    var22_22 = var10_10[var19_19];
                    if (!(Math.abs(var4_4.getEntryForIndex(var19_19).getY()) > Utils.FLOAT_EPSILON)) {
                        while (true) {
                            var23_23 = var21_21 + var22_22 * var6_6;
                            var4_4 = var1_1 /* !! */ ;
                            var1_1 /* !! */  = var15_15 /* !! */ ;
                            var15_15 /* !! */  = var4_4;
                            break block22;
                            break;
                        }
                    }
                    if (var2_2.isHighlightEnabled() && var3_3.mChart.needsHighlight(var19_19) && !var16_16) ** continue;
                    var9_9 = var20_20 > 0.0f && var22_22 <= 180.0f ? 1 : 0;
                    var3_3.mRenderPaint.setColor(var4_4.getColor(var19_19));
                    var23_23 = var18_18 == 1 ? 0.0f : var20_20 / (var11_11 * 0.017453292f);
                    var24_24 = var5_5 + (var21_21 + var23_23 / 2.0f) * var7_7;
                    var23_23 = var25_25 = (var22_22 - var23_23) * var7_7;
                    if (var25_25 < 0.0f) {
                        var23_23 = 0.0f;
                    }
                    var3_3.mPathBuffer.reset();
                    if (var16_16) {
                        var26_26 = var1_1 /* !! */ .x;
                        var25_25 = var11_11 - var14_14;
                        var27_27 = var24_24 * 0.017453292f;
                        var26_26 += (float)Math.cos(var27_27) * var25_25;
                        var25_25 = var1_1 /* !! */ .y + var25_25 * (float)Math.sin(var27_27);
                        var15_15 /* !! */ .set(var26_26 - var14_14, var25_25 - var14_14, var26_26 + var14_14, var25_25 + var14_14);
                    }
                    var25_25 = var1_1 /* !! */ .x;
                    var27_27 = var24_24 * 0.017453292f;
                    var29_28 = var25_25 + (float)Math.cos(var27_27) * var11_11;
                    var26_26 = var1_1 /* !! */ .y + (float)Math.sin(var27_27) * var11_11;
                    cfr_temp_0 = var23_23 - 360.0f;
                    var30_29 = cfr_temp_0 == 0.0f ? 0 : (cfr_temp_0 > 0.0f ? 1 : -1);
                    if (var30_29 >= 0 && var23_23 % 360.0f <= Utils.FLOAT_EPSILON) {
                        var3_3.mPathBuffer.addCircle(var1_1 /* !! */ .x, var1_1 /* !! */ .y, var11_11, Path.Direction.CW);
                    } else {
                        if (var16_16) {
                            var3_3.mPathBuffer.arcTo(var15_15 /* !! */ , var24_24 + 180.0f, -180.0f);
                        }
                        var3_3.mPathBuffer.arcTo(var8_8, var24_24, var23_23);
                    }
                    var3_3.mInnerRectBuffer.set(var1_1 /* !! */ .x - var13_13, var1_1 /* !! */ .y - var13_13, var1_1 /* !! */ .x + var13_13, var1_1 /* !! */ .y + var13_13);
                    if (!var12_12 || !(var13_13 > 0.0f) && var9_9 == 0) break block23;
                    if (var9_9 != 0) {
                        var25_25 = var24_24 = this.calculateMinimumRadiusForSpacedSlice((MPPointF)var1_1 /* !! */ , var11_11, var22_22 * var7_7, var29_28, var26_26, var24_24, var23_23);
                        if (var24_24 < 0.0f) {
                            var25_25 = -var24_24;
                        }
                        var25_25 = Math.max(var13_13, var25_25);
                    } else {
                        var25_25 = var13_13;
                    }
                    var24_24 = var25_25;
                    var25_25 = var18_18 != 1 && var24_24 != 0.0f ? var20_20 / (var24_24 * 0.017453292f) : 0.0f;
                    var29_28 = var25_25 / 2.0f;
                    var25_25 = var26_26 = (var22_22 - var25_25) * var7_7;
                    if (var26_26 < 0.0f) {
                        var25_25 = 0.0f;
                    }
                    var26_26 = var5_5 + (var21_21 + var29_28) * var7_7 + var25_25;
                    if (var30_29 >= 0 && var23_23 % 360.0f <= Utils.FLOAT_EPSILON) {
                        this.mPathBuffer.addCircle(var1_1 /* !! */ .x, var1_1 /* !! */ .y, var24_24, Path.Direction.CCW);
                    } else {
                        var3_3 = this;
                        if (var16_16) {
                            var24_24 = var1_1 /* !! */ .x;
                            var23_23 = var11_11 - var14_14;
                            var27_27 = var26_26 * 0.017453292f;
                            var24_24 += (float)Math.cos(var27_27) * var23_23;
                            var23_23 = var1_1 /* !! */ .y + var23_23 * (float)Math.sin(var27_27);
                            var4_4 = var15_15 /* !! */ ;
                            var4_4.set(var24_24 - var14_14, var23_23 - var14_14, var24_24 + var14_14, var23_23 + var14_14);
                            var3_3.mPathBuffer.arcTo((RectF)var4_4, var26_26, 180.0f);
                        } else {
                            var4_4 = var3_3.mPathBuffer;
                            var23_23 = var1_1 /* !! */ .x;
                            var27_27 = var26_26 * 0.017453292f;
                            var4_4.lineTo(var23_23 + (float)Math.cos(var27_27) * var24_24, var1_1 /* !! */ .y + var24_24 * (float)Math.sin(var27_27));
                        }
                        var3_3.mPathBuffer.arcTo(var3_3.mInnerRectBuffer, var26_26, -var25_25);
                    }
                    var31_30 = this;
                    var32_31 = var1_1 /* !! */ ;
                    var1_1 /* !! */  = var15_15 /* !! */ ;
                    ** GOTO lbl-1000
                }
                var4_4 = var1_1 /* !! */ ;
                var1_1 /* !! */  = var15_15 /* !! */ ;
                var31_30 = var3_3;
                var32_31 = var4_4;
                if (var23_23 % 360.0f > Utils.FLOAT_EPSILON) {
                    if (var9_9 != 0) {
                        var25_25 = var23_23 / 2.0f;
                        var1_1 /* !! */  = var15_15 /* !! */ ;
                        var23_23 = this.calculateMinimumRadiusForSpacedSlice((MPPointF)var4_4, var11_11, var22_22 * var7_7, var29_28, var26_26, var24_24, var23_23);
                        var26_26 = var4_4.x;
                        var27_27 = (var24_24 + var25_25) * 0.017453292f;
                        var25_25 = (float)Math.cos(var27_27);
                        var29_28 = var4_4.y;
                        var24_24 = (float)Math.sin(var27_27);
                        var3_3.mPathBuffer.lineTo(var26_26 + var25_25 * var23_23, var29_28 + var23_23 * var24_24);
                        var15_15 /* !! */  = var4_4;
                    } else {
                        var1_1 /* !! */  = var15_15 /* !! */ ;
                        var3_3.mPathBuffer.lineTo(var4_4.x, var4_4.y);
                        var15_15 /* !! */  = var4_4;
                    }
                } else lbl-1000:
                // 2 sources

                {
                    var15_15 /* !! */  = var32_31;
                    var3_3 = var31_30;
                }
                var3_3.mPathBuffer.close();
                var3_3.mBitmapCanvas.drawPath(var3_3.mPathBuffer, var3_3.mRenderPaint);
                var23_23 = var21_21 + var22_22 * var6_6;
            }
            ++var19_19;
            var4_4 = var1_1 /* !! */ ;
            var1_1 /* !! */  = var15_15 /* !! */ ;
            var15_15 /* !! */  = var4_4;
            var21_21 = var23_23;
        }
        MPPointF.recycleInstance((MPPointF)var1_1 /* !! */ );
    }

    protected void drawEntryLabel(Canvas canvas, String string2, float f, float f2) {
        canvas.drawText(string2, f, f2, this.mEntryLabelsPaint);
    }

    @Override
    public void drawExtras(Canvas canvas) {
        this.drawHole(canvas);
        canvas.drawBitmap((Bitmap)this.mDrawBitmap.get(), 0.0f, 0.0f, null);
        this.drawCenterText(canvas);
    }

    @Override
    public void drawHighlighted(Canvas object, Highlight[] highlightArray) {
        Object object2;
        boolean bl = this.mChart.isDrawHoleEnabled() && !this.mChart.isDrawSlicesUnderHoleEnabled();
        if (bl && this.mChart.isDrawRoundedSlicesEnabled()) {
            return;
        }
        float f = this.mAnimator.getPhaseX();
        float f2 = this.mAnimator.getPhaseY();
        float f3 = this.mChart.getRotationAngle();
        object = this.mChart.getDrawAngles();
        float[] fArray = this.mChart.getAbsoluteAngles();
        MPPointF mPPointF = this.mChart.getCenterCircleBox();
        float f4 = this.mChart.getRadius();
        float f5 = bl ? this.mChart.getHoleRadius() / 100.0f * f4 : 0.0f;
        RectF rectF = this.mDrawHighlightedRectF;
        rectF.set(0.0f, 0.0f, 0.0f, 0.0f);
        for (int i = 0; i < ((Highlight[])(object2 = highlightArray)).length; ++i) {
            double d;
            int n;
            int n2;
            IDataSet iDataSet;
            int n3 = (int)object2[i].getX();
            if (n3 >= ((Canvas)object).length || (iDataSet = ((PieData)this.mChart.getData()).getDataSetByIndex(object2[i].getDataSetIndex())) == null || !iDataSet.isHighlightEnabled()) continue;
            int n4 = iDataSet.getEntryCount();
            int n5 = 0;
            for (n2 = 0; n2 < n4; ++n2) {
                n = n5;
                if (Math.abs(((PieEntry)iDataSet.getEntryForIndex(n2)).getY()) > Utils.FLOAT_EPSILON) {
                    n = n5 + 1;
                }
                n5 = n;
            }
            float f6 = n3 == 0 ? 0.0f : fArray[n3 - 1] * f;
            float f7 = n5 <= 1 ? 0.0f : iDataSet.getSliceSpace();
            Canvas canvas = object[n3];
            float f8 = iDataSet.getSelectionShift();
            float f9 = f4 + f8;
            rectF.set(this.mChart.getCircleBox());
            f8 = -f8;
            rectF.inset(f8, f8);
            n = f7 > 0.0f && canvas <= 180.0f ? 1 : 0;
            Integer n6 = iDataSet.getHighlightColor();
            object2 = n6;
            if (n6 == null) {
                object2 = iDataSet.getColor(n3);
            }
            this.mRenderPaint.setColor(((Integer)object2).intValue());
            float f10 = n5 == 1 ? 0.0f : f7 / (f4 * ((float)Math.PI / 180));
            f8 = n5 == 1 ? 0.0f : f7 / (f9 * ((float)Math.PI / 180));
            float f11 = f3 + (f10 / 2.0f + f6) * f2;
            f10 = (float)((canvas - f10) * f2);
            if (f10 < 0.0f) {
                f10 = 0.0f;
            }
            float f12 = (f8 / 2.0f + f6) * f2 + f3;
            Object object3 = (canvas - f8) * f2;
            f8 = (float)object3;
            if (object3 < 0.0f) {
                f8 = 0.0f;
            }
            this.mPathBuffer.reset();
            float f13 = f10 - 360.0f;
            n2 = f13 == 0.0f ? 0 : (f13 > 0.0f ? 1 : -1);
            if (n2 >= 0 && f10 % 360.0f <= Utils.FLOAT_EPSILON) {
                this.mPathBuffer.addCircle(mPPointF.x, mPPointF.y, f9, Path.Direction.CW);
            } else {
                object2 = this.mPathBuffer;
                object3 = mPPointF.x;
                d = f12 * ((float)Math.PI / 180);
                object2.moveTo((float)(object3 + (float)Math.cos(d) * f9), mPPointF.y + f9 * (float)Math.sin(d));
                this.mPathBuffer.arcTo(rectF, f12, f8);
            }
            if (n != 0) {
                f8 = mPPointF.x;
                d = f11 * ((float)Math.PI / 180);
                f8 = this.calculateMinimumRadiusForSpacedSlice(mPPointF, f4, (float)(canvas * f2), (float)Math.cos(d) * f4 + f8, mPPointF.y + (float)Math.sin(d) * f4, f11, f10);
            } else {
                f8 = 0.0f;
            }
            object2 = mPPointF;
            object3 = f5;
            this.mInnerRectBuffer.set(((MPPointF)object2).x - object3, ((MPPointF)object2).y - object3, ((MPPointF)object2).x + object3, ((MPPointF)object2).y + object3);
            if (bl && (object3 > 0.0f || n != 0)) {
                if (n != 0) {
                    f11 = f8;
                    if (f8 < 0.0f) {
                        f11 = -f8;
                    }
                    f8 = Math.max((float)object3, f11);
                } else {
                    f8 = (float)object3;
                }
                f7 = n5 != 1 && f8 != 0.0f ? (f7 /= f8 * ((float)Math.PI / 180)) : 0.0f;
                f11 = f7 / 2.0f;
                object3 = (canvas - f7) * f2;
                f7 = (float)object3;
                if (object3 < 0.0f) {
                    f7 = 0.0f;
                }
                f6 = (f6 + f11) * f2 + f3 + f7;
                if (n2 >= 0 && f10 % 360.0f <= Utils.FLOAT_EPSILON) {
                    this.mPathBuffer.addCircle(((MPPointF)object2).x, ((MPPointF)object2).y, f8, Path.Direction.CCW);
                } else {
                    n6 = this.mPathBuffer;
                    f10 = ((MPPointF)object2).x;
                    d = f6 * ((float)Math.PI / 180);
                    n6.lineTo(f10 + (float)Math.cos(d) * f8, ((MPPointF)object2).y + f8 * (float)Math.sin(d));
                    this.mPathBuffer.arcTo(this.mInnerRectBuffer, f6, -f7);
                }
            } else if (f10 % 360.0f > Utils.FLOAT_EPSILON) {
                if (n != 0) {
                    f7 = f10 / 2.0f;
                    f6 = ((MPPointF)object2).x;
                    d = (f11 + f7) * ((float)Math.PI / 180);
                    f7 = (float)Math.cos(d);
                    object3 = ((MPPointF)object2).y;
                    f10 = (float)Math.sin(d);
                    this.mPathBuffer.lineTo(f6 + f7 * f8, (float)(object3 + f8 * f10));
                } else {
                    this.mPathBuffer.lineTo(((MPPointF)object2).x, ((MPPointF)object2).y);
                }
            }
            this.mPathBuffer.close();
            this.mBitmapCanvas.drawPath(this.mPathBuffer, this.mRenderPaint);
        }
        MPPointF.recycleInstance(mPPointF);
    }

    protected void drawHole(Canvas object) {
        if (this.mChart.isDrawHoleEnabled() && this.mBitmapCanvas != null) {
            float f = this.mChart.getRadius();
            float f2 = this.mChart.getHoleRadius() / 100.0f * f;
            object = this.mChart.getCenterCircleBox();
            if (Color.alpha((int)this.mHolePaint.getColor()) > 0) {
                this.mBitmapCanvas.drawCircle(object.x, object.y, f2, this.mHolePaint);
            }
            if (Color.alpha((int)this.mTransparentCirclePaint.getColor()) > 0 && this.mChart.getTransparentCircleRadius() > this.mChart.getHoleRadius()) {
                int n = this.mTransparentCirclePaint.getAlpha();
                float f3 = this.mChart.getTransparentCircleRadius() / 100.0f;
                this.mTransparentCirclePaint.setAlpha((int)((float)n * this.mAnimator.getPhaseX() * this.mAnimator.getPhaseY()));
                this.mHoleCirclePath.reset();
                this.mHoleCirclePath.addCircle(object.x, object.y, f * f3, Path.Direction.CW);
                this.mHoleCirclePath.addCircle(object.x, object.y, f2, Path.Direction.CCW);
                this.mBitmapCanvas.drawPath(this.mHoleCirclePath, this.mTransparentCirclePaint);
                this.mTransparentCirclePaint.setAlpha(n);
            }
            MPPointF.recycleInstance((MPPointF)object);
        }
    }

    protected void drawRoundedSlices(Canvas object) {
        if (!this.mChart.isDrawRoundedSlicesEnabled()) {
            return;
        }
        IPieDataSet iPieDataSet = ((PieData)this.mChart.getData()).getDataSet();
        if (!iPieDataSet.isVisible()) {
            return;
        }
        float f = this.mAnimator.getPhaseX();
        float f2 = this.mAnimator.getPhaseY();
        MPPointF mPPointF = this.mChart.getCenterCircleBox();
        float f3 = this.mChart.getRadius();
        float f4 = (f3 - this.mChart.getHoleRadius() * f3 / 100.0f) / 2.0f;
        object = this.mChart.getDrawAngles();
        float f5 = this.mChart.getRotationAngle();
        for (int i = 0; i < iPieDataSet.getEntryCount(); ++i) {
            Canvas canvas = object[i];
            if (Math.abs(((BaseEntry)iPieDataSet.getEntryForIndex(i)).getY()) > Utils.FLOAT_EPSILON) {
                double d = f3 - f4;
                double d2 = (f5 + canvas) * f2;
                double d3 = Math.cos(Math.toRadians(d2));
                float f6 = (float)((double)mPPointF.x + d3 * d);
                float f7 = (float)(d * Math.sin(Math.toRadians(d2)) + (double)mPPointF.y);
                this.mRenderPaint.setColor(iPieDataSet.getColor(i));
                this.mBitmapCanvas.drawCircle(f6, f7, f4, this.mRenderPaint);
            }
            f5 += canvas * f;
        }
        MPPointF.recycleInstance(mPPointF);
    }

    @Override
    public void drawValues(Canvas canvas) {
        float f;
        Object object = this.mChart.getCenterCircleBox();
        float f2 = this.mChart.getRadius();
        float f3 = this.mChart.getRotationAngle();
        Object object2 = this.mChart.getDrawAngles();
        Object object3 = this.mChart.getAbsoluteAngles();
        float f4 = this.mAnimator.getPhaseX();
        float f5 = this.mAnimator.getPhaseY();
        float f6 = (f2 - this.mChart.getHoleRadius() * f2 / 100.0f) / 2.0f;
        float f7 = this.mChart.getHoleRadius() / 100.0f;
        float f8 = f2 / 10.0f * 3.6f;
        float f9 = f3;
        if (this.mChart.isDrawHoleEnabled()) {
            f = (f2 - f2 * f7) / 2.0f;
            f9 = f3;
            f8 = f;
            if (!this.mChart.isDrawSlicesUnderHoleEnabled()) {
                f9 = f3;
                f8 = f;
                if (this.mChart.isDrawRoundedSlicesEnabled()) {
                    f9 = (float)((double)f3 + (double)(f6 * 360.0f) / ((double)f2 * (Math.PI * 2)));
                    f8 = f;
                }
            }
        }
        float f10 = f2 - f8;
        PieData pieData = (PieData)this.mChart.getData();
        Object object4 = pieData.getDataSets();
        float f11 = pieData.getYValueSum();
        boolean bl = this.mChart.isDrawEntryLabelsEnabled();
        canvas.save();
        float f12 = Utils.convertDpToPixel(5.0f);
        int n = 0;
        f8 = f4;
        for (int i = 0; i < object4.size(); ++i) {
            Object object5;
            block34: {
                boolean bl2;
                IPieDataSet iPieDataSet;
                block33: {
                    iPieDataSet = object4.get(i);
                    bl2 = iPieDataSet.isDrawValuesEnabled();
                    if (bl2 || bl) break block33;
                    object5 = object4;
                    f4 = f2;
                    object4 = object;
                    object = object5;
                    f2 = f8;
                    f8 = f4;
                    break block34;
                }
                PieDataSet.ValuePosition valuePosition = iPieDataSet.getXValuePosition();
                PieDataSet.ValuePosition valuePosition2 = iPieDataSet.getYValuePosition();
                this.applyValueTextStyle(iPieDataSet);
                float f13 = (float)Utils.calcTextHeight(this.mValuePaint, "Q") + Utils.convertDpToPixel(4.0f);
                IValueFormatter iValueFormatter = iPieDataSet.getValueFormatter();
                int n2 = iPieDataSet.getEntryCount();
                boolean bl3 = iPieDataSet.isUseValueColorForLineEnabled();
                int n3 = iPieDataSet.getValueLineColor();
                object5 = this.mValueLinePaint;
                f4 = iPieDataSet.getValueLineWidth();
                object5.setStrokeWidth(Utils.convertDpToPixel(f4));
                float f14 = this.getSliceSpace(iPieDataSet);
                Object object6 = MPPointF.getInstance(iPieDataSet.getIconsOffset());
                ((MPPointF)object6).x = Utils.convertDpToPixel(((MPPointF)object6).x);
                ((MPPointF)object6).y = Utils.convertDpToPixel(((MPPointF)object6).y);
                int n4 = 0;
                int n5 = n;
                object5 = object3;
                float[] fArray = object2;
                object3 = object;
                n = i;
                object2 = object6;
                for (i = n4; i < n2; ++i) {
                    float f15;
                    float f16;
                    float f17;
                    PieEntry pieEntry;
                    block36: {
                        boolean bl4;
                        boolean bl5;
                        block35: {
                            pieEntry = (PieEntry)iPieDataSet.getEntryForIndex(i);
                            f4 = n5 == 0 ? 0.0f : (float)(object5[n5 - 1] * f8);
                            f6 = f9 + (f4 + (fArray[n5] - f14 / (f10 * ((float)Math.PI / 180)) / 2.0f) / 2.0f) * f5;
                            f4 = this.mChart.isUsePercentValuesEnabled() ? pieEntry.getY() / f11 * 100.0f : pieEntry.getY();
                            object6 = pieEntry.getLabel();
                            double d = f6 * ((float)Math.PI / 180);
                            f17 = (float)Math.cos(d);
                            f16 = (float)Math.sin(d);
                            int n6 = bl && valuePosition == PieDataSet.ValuePosition.OUTSIDE_SLICE ? 1 : 0;
                            boolean bl6 = bl2 && valuePosition2 == PieDataSet.ValuePosition.OUTSIDE_SLICE;
                            bl5 = bl && valuePosition == PieDataSet.ValuePosition.INSIDE_SLICE;
                            bl4 = bl2 && valuePosition2 == PieDataSet.ValuePosition.INSIDE_SLICE;
                            if (n6 != 0 || bl6) {
                                float f18 = iPieDataSet.getValueLinePart1Length();
                                f = iPieDataSet.getValueLinePart2Length();
                                f15 = iPieDataSet.getValueLinePart1OffsetPercentage() / 100.0f;
                                if (this.mChart.isDrawHoleEnabled()) {
                                    f3 = f2 * f7;
                                    f3 = (f2 - f3) * f15 + f3;
                                } else {
                                    f3 = f2 * f15;
                                }
                                f = iPieDataSet.isValueLineVariableLength() ? f * f10 * (float)Math.abs(Math.sin(d)) : (f *= f10);
                                f15 = object3.x;
                                float f19 = object3.y;
                                float f20 = (f18 + 1.0f) * f10;
                                f18 = f20 * f17 + object3.x;
                                f20 = f20 * f16 + object3.y;
                                d = (double)f6 % 360.0;
                                if (d >= 90.0 && d <= 270.0) {
                                    f6 = f18 - f;
                                    this.mValuePaint.setTextAlign(Paint.Align.RIGHT);
                                    if (n6 != 0) {
                                        this.mEntryLabelsPaint.setTextAlign(Paint.Align.RIGHT);
                                    }
                                    f = f6;
                                    f6 -= f12;
                                } else {
                                    f = f18 + f;
                                    this.mValuePaint.setTextAlign(Paint.Align.LEFT);
                                    if (n6 != 0) {
                                        this.mEntryLabelsPaint.setTextAlign(Paint.Align.LEFT);
                                    }
                                    f6 = f + f12;
                                }
                                n4 = bl3 ? iPieDataSet.getColor(i) : (n3 != 0x112233 ? n3 : 0x112233);
                                if (n4 != 0x112233) {
                                    this.mValueLinePaint.setColor(n4);
                                    canvas.drawLine(f3 * f17 + f15, f3 * f16 + f19, f18, f20, this.mValueLinePaint);
                                    canvas.drawLine(f18, f20, f, f20, this.mValueLinePaint);
                                }
                                object = object6;
                                n4 = i;
                                if (n6 != 0 && bl6) {
                                    n6 = iPieDataSet.getValueTextColor(n4);
                                    this.drawValue(canvas, iValueFormatter, f4, pieEntry, 0, f6, f20, n6);
                                    if (n4 < pieData.getEntryCount() && object != null) {
                                        this.drawEntryLabel(canvas, (String)object, f6, f20 + f13);
                                    }
                                } else if (n6 != 0) {
                                    if (n4 < pieData.getEntryCount() && object != null) {
                                        this.drawEntryLabel(canvas, (String)object, f6, f20 + f13 / 2.0f);
                                    }
                                } else if (bl6) {
                                    this.drawValue(canvas, iValueFormatter, f4, pieEntry, 0, f6, f20 + f13 / 2.0f, iPieDataSet.getValueTextColor(n4));
                                }
                            }
                            object = object3;
                            if (bl5) break block35;
                            object3 = object;
                            if (!bl4) break block36;
                        }
                        f3 = f10 * f17 + ((MPPointF)object).x;
                        f = f10 * f16 + ((MPPointF)object).y;
                        this.mValuePaint.setTextAlign(Paint.Align.CENTER);
                        if (bl5 && bl4) {
                            n4 = iPieDataSet.getValueTextColor(i);
                            this.drawValue(canvas, iValueFormatter, f4, pieEntry, 0, f3, f, n4);
                            object3 = object;
                            if (i < pieData.getEntryCount()) {
                                object3 = object;
                                if (object6 != null) {
                                    this.drawEntryLabel(canvas, (String)object6, f3, f + f13);
                                    object3 = object;
                                }
                            }
                        } else if (bl5) {
                            object3 = object;
                            if (i < pieData.getEntryCount()) {
                                object3 = object;
                                if (object6 != null) {
                                    this.drawEntryLabel(canvas, (String)object6, f3, f + f13 / 2.0f);
                                    object3 = object;
                                }
                            }
                        } else {
                            object3 = object;
                            if (bl4) {
                                this.drawValue(canvas, iValueFormatter, f4, pieEntry, 0, f3, f + f13 / 2.0f, iPieDataSet.getValueTextColor(i));
                                object3 = object;
                            }
                        }
                    }
                    if (pieEntry.getIcon() != null && iPieDataSet.isDrawIconsEnabled()) {
                        pieEntry = pieEntry.getIcon();
                        object6 = object2;
                        f = ((MPPointF)object6).y;
                        object = object3;
                        f6 = ((MPPointF)object).x;
                        f15 = ((MPPointF)object6).y;
                        f4 = ((MPPointF)object).y;
                        f3 = ((MPPointF)object6).x;
                        Utils.drawImage(canvas, (Drawable)pieEntry, (int)((f10 + f) * f17 + f6), (int)((f10 + f15) * f16 + f4 + f3), pieEntry.getIntrinsicWidth(), pieEntry.getIntrinsicHeight());
                    }
                    ++n5;
                }
                object = object4;
                object4 = object3;
                object3 = object5;
                f4 = f8;
                MPPointF.recycleInstance((MPPointF)object2);
                f8 = f2;
                f2 = f4;
                object2 = fArray;
                i = n;
                n = n5;
            }
            object5 = object4;
            f4 = f2;
            object4 = object;
            object = object5;
            f2 = f8;
            f8 = f4;
        }
        MPPointF.recycleInstance((MPPointF)object);
        canvas.restore();
    }

    public TextPaint getPaintCenterText() {
        return this.mCenterTextPaint;
    }

    public Paint getPaintEntryLabels() {
        return this.mEntryLabelsPaint;
    }

    public Paint getPaintHole() {
        return this.mHolePaint;
    }

    public Paint getPaintTransparentCircle() {
        return this.mTransparentCirclePaint;
    }

    protected float getSliceSpace(IPieDataSet iPieDataSet) {
        if (!iPieDataSet.isAutomaticallyDisableSliceSpacingEnabled()) {
            return iPieDataSet.getSliceSpace();
        }
        float f = iPieDataSet.getSliceSpace() / this.mViewPortHandler.getSmallestContentExtension() > iPieDataSet.getYMin() / ((PieData)this.mChart.getData()).getYValueSum() * 2.0f ? 0.0f : iPieDataSet.getSliceSpace();
        return f;
    }

    @Override
    public void initBuffers() {
    }

    public void releaseBitmap() {
        Object object = this.mBitmapCanvas;
        if (object != null) {
            object.setBitmap(null);
            this.mBitmapCanvas = null;
        }
        if ((object = this.mDrawBitmap) != null) {
            if ((object = (Bitmap)((Reference)object).get()) != null) {
                object.recycle();
            }
            this.mDrawBitmap.clear();
            this.mDrawBitmap = null;
        }
    }
}

