/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.renderer;

import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.drawable.Drawable;
import com.github.mikephil.charting.animation.ChartAnimator;
import com.github.mikephil.charting.charts.RadarChart;
import com.github.mikephil.charting.data.RadarData;
import com.github.mikephil.charting.data.RadarEntry;
import com.github.mikephil.charting.highlight.Highlight;
import com.github.mikephil.charting.interfaces.datasets.IRadarDataSet;
import com.github.mikephil.charting.renderer.LineRadarRenderer;
import com.github.mikephil.charting.utils.ColorTemplate;
import com.github.mikephil.charting.utils.MPPointF;
import com.github.mikephil.charting.utils.Utils;
import com.github.mikephil.charting.utils.ViewPortHandler;

public class RadarChartRenderer
extends LineRadarRenderer {
    protected RadarChart mChart;
    protected Path mDrawDataSetSurfacePathBuffer = new Path();
    protected Path mDrawHighlightCirclePathBuffer = new Path();
    protected Paint mHighlightCirclePaint;
    protected Paint mWebPaint;

    public RadarChartRenderer(RadarChart radarChart, ChartAnimator chartAnimator, ViewPortHandler viewPortHandler) {
        super(chartAnimator, viewPortHandler);
        this.mChart = radarChart;
        this.mHighlightPaint = new Paint(1);
        this.mHighlightPaint.setStyle(Paint.Style.STROKE);
        this.mHighlightPaint.setStrokeWidth(2.0f);
        this.mHighlightPaint.setColor(Color.rgb((int)255, (int)187, (int)115));
        radarChart = new Paint(1);
        this.mWebPaint = radarChart;
        radarChart.setStyle(Paint.Style.STROKE);
        this.mHighlightCirclePaint = new Paint(1);
    }

    @Override
    public void drawData(Canvas canvas) {
        RadarData radarData = (RadarData)this.mChart.getData();
        int n = ((IRadarDataSet)radarData.getMaxEntryCountSet()).getEntryCount();
        for (IRadarDataSet iRadarDataSet : radarData.getDataSets()) {
            if (!iRadarDataSet.isVisible()) continue;
            this.drawDataSet(canvas, iRadarDataSet, n);
        }
    }

    protected void drawDataSet(Canvas canvas, IRadarDataSet iRadarDataSet, int n) {
        float f = this.mAnimator.getPhaseX();
        float f2 = this.mAnimator.getPhaseY();
        float f3 = this.mChart.getSliceAngle();
        float f4 = this.mChart.getFactor();
        MPPointF mPPointF = this.mChart.getCenterOffsets();
        MPPointF mPPointF2 = MPPointF.getInstance(0.0f, 0.0f);
        Path path = this.mDrawDataSetSurfacePathBuffer;
        path.reset();
        boolean bl = false;
        for (int i = 0; i < iRadarDataSet.getEntryCount(); ++i) {
            this.mRenderPaint.setColor(iRadarDataSet.getColor(i));
            Utils.getPosition(mPPointF, (((RadarEntry)iRadarDataSet.getEntryForIndex(i)).getY() - this.mChart.getYChartMin()) * f4 * f2, (float)i * f3 * f + this.mChart.getRotationAngle(), mPPointF2);
            if (Float.isNaN(mPPointF2.x)) continue;
            if (!bl) {
                path.moveTo(mPPointF2.x, mPPointF2.y);
                bl = true;
                continue;
            }
            path.lineTo(mPPointF2.x, mPPointF2.y);
        }
        if (iRadarDataSet.getEntryCount() > n) {
            path.lineTo(mPPointF.x, mPPointF.y);
        }
        path.close();
        if (iRadarDataSet.isDrawFilledEnabled()) {
            Drawable drawable2 = iRadarDataSet.getFillDrawable();
            if (drawable2 != null) {
                this.drawFilledPath(canvas, path, drawable2);
            } else {
                this.drawFilledPath(canvas, path, iRadarDataSet.getFillColor(), iRadarDataSet.getFillAlpha());
            }
        }
        this.mRenderPaint.setStrokeWidth(iRadarDataSet.getLineWidth());
        this.mRenderPaint.setStyle(Paint.Style.STROKE);
        if (!iRadarDataSet.isDrawFilledEnabled() || iRadarDataSet.getFillAlpha() < 255) {
            canvas.drawPath(path, this.mRenderPaint);
        }
        MPPointF.recycleInstance(mPPointF);
        MPPointF.recycleInstance(mPPointF2);
    }

    @Override
    public void drawExtras(Canvas canvas) {
        this.drawWeb(canvas);
    }

    public void drawHighlightCircle(Canvas canvas, MPPointF mPPointF, float f, float f2, int n, int n2, float f3) {
        canvas.save();
        f2 = Utils.convertDpToPixel(f2);
        f = Utils.convertDpToPixel(f);
        if (n != 0x112233) {
            Path path = this.mDrawHighlightCirclePathBuffer;
            path.reset();
            path.addCircle(mPPointF.x, mPPointF.y, f2, Path.Direction.CW);
            if (f > 0.0f) {
                path.addCircle(mPPointF.x, mPPointF.y, f, Path.Direction.CCW);
            }
            this.mHighlightCirclePaint.setColor(n);
            this.mHighlightCirclePaint.setStyle(Paint.Style.FILL);
            canvas.drawPath(path, this.mHighlightCirclePaint);
        }
        if (n2 != 0x112233) {
            this.mHighlightCirclePaint.setColor(n2);
            this.mHighlightCirclePaint.setStyle(Paint.Style.STROKE);
            this.mHighlightCirclePaint.setStrokeWidth(Utils.convertDpToPixel(f3));
            canvas.drawCircle(mPPointF.x, mPPointF.y, f2, this.mHighlightCirclePaint);
        }
        canvas.restore();
    }

    @Override
    public void drawHighlighted(Canvas canvas, Highlight[] highlightArray) {
        float f = this.mChart.getSliceAngle();
        float f2 = this.mChart.getFactor();
        MPPointF mPPointF = this.mChart.getCenterOffsets();
        MPPointF mPPointF2 = MPPointF.getInstance(0.0f, 0.0f);
        RadarData radarData = (RadarData)this.mChart.getData();
        for (Highlight highlight : highlightArray) {
            int n;
            RadarEntry radarEntry;
            IRadarDataSet iRadarDataSet = (IRadarDataSet)radarData.getDataSetByIndex(highlight.getDataSetIndex());
            if (iRadarDataSet == null || !iRadarDataSet.isHighlightEnabled() || !this.isInBoundsX(radarEntry = (RadarEntry)iRadarDataSet.getEntryForIndex((int)highlight.getX()), iRadarDataSet)) continue;
            Utils.getPosition(mPPointF, (radarEntry.getY() - this.mChart.getYChartMin()) * f2 * this.mAnimator.getPhaseY(), highlight.getX() * f * this.mAnimator.getPhaseX() + this.mChart.getRotationAngle(), mPPointF2);
            highlight.setDraw(mPPointF2.x, mPPointF2.y);
            this.drawHighlightLines(canvas, mPPointF2.x, mPPointF2.y, iRadarDataSet);
            if (!iRadarDataSet.isDrawHighlightCircleEnabled() || Float.isNaN(mPPointF2.x) || Float.isNaN(mPPointF2.y)) continue;
            int n2 = n = iRadarDataSet.getHighlightCircleStrokeColor();
            if (n == 0x112233) {
                n2 = iRadarDataSet.getColor(0);
            }
            n = n2;
            if (iRadarDataSet.getHighlightCircleStrokeAlpha() < 255) {
                n = ColorTemplate.colorWithAlpha(n2, iRadarDataSet.getHighlightCircleStrokeAlpha());
            }
            this.drawHighlightCircle(canvas, mPPointF2, iRadarDataSet.getHighlightCircleInnerRadius(), iRadarDataSet.getHighlightCircleOuterRadius(), iRadarDataSet.getHighlightCircleFillColor(), n, iRadarDataSet.getHighlightCircleStrokeWidth());
        }
        MPPointF.recycleInstance(mPPointF);
        MPPointF.recycleInstance(mPPointF2);
    }

    @Override
    public void drawValues(Canvas canvas) {
        float f = this.mAnimator.getPhaseX();
        float f2 = this.mAnimator.getPhaseY();
        float f3 = this.mChart.getSliceAngle();
        float f4 = this.mChart.getFactor();
        MPPointF mPPointF = this.mChart.getCenterOffsets();
        MPPointF mPPointF2 = MPPointF.getInstance(0.0f, 0.0f);
        MPPointF mPPointF3 = MPPointF.getInstance(0.0f, 0.0f);
        float f5 = Utils.convertDpToPixel(5.0f);
        for (int i = 0; i < ((RadarData)this.mChart.getData()).getDataSetCount(); ++i) {
            IRadarDataSet iRadarDataSet = (IRadarDataSet)((RadarData)this.mChart.getData()).getDataSetByIndex(i);
            if (!this.shouldDrawValues(iRadarDataSet)) continue;
            this.applyValueTextStyle(iRadarDataSet);
            MPPointF mPPointF4 = MPPointF.getInstance(iRadarDataSet.getIconsOffset());
            mPPointF4.x = Utils.convertDpToPixel(mPPointF4.x);
            mPPointF4.y = Utils.convertDpToPixel(mPPointF4.y);
            for (int j = 0; j < iRadarDataSet.getEntryCount(); ++j) {
                RadarEntry radarEntry = (RadarEntry)iRadarDataSet.getEntryForIndex(j);
                float f6 = radarEntry.getY();
                float f7 = this.mChart.getYChartMin();
                float f8 = (float)j * f3 * f;
                Utils.getPosition(mPPointF, (f6 - f7) * f4 * f2, f8 + this.mChart.getRotationAngle(), mPPointF2);
                if (iRadarDataSet.isDrawValuesEnabled()) {
                    this.drawValue(canvas, iRadarDataSet.getValueFormatter(), radarEntry.getY(), radarEntry, i, mPPointF2.x, mPPointF2.y - f5, iRadarDataSet.getValueTextColor(j));
                }
                if (radarEntry.getIcon() == null || !iRadarDataSet.isDrawIconsEnabled()) continue;
                Drawable drawable2 = radarEntry.getIcon();
                Utils.getPosition(mPPointF, radarEntry.getY() * f4 * f2 + mPPointF4.y, f8 + this.mChart.getRotationAngle(), mPPointF3);
                mPPointF3.y += mPPointF4.x;
                Utils.drawImage(canvas, drawable2, (int)mPPointF3.x, (int)mPPointF3.y, drawable2.getIntrinsicWidth(), drawable2.getIntrinsicHeight());
            }
            MPPointF.recycleInstance(mPPointF4);
        }
        MPPointF.recycleInstance(mPPointF);
        MPPointF.recycleInstance(mPPointF2);
        MPPointF.recycleInstance(mPPointF3);
    }

    protected void drawWeb(Canvas canvas) {
        int n;
        float f = this.mChart.getSliceAngle();
        float f2 = this.mChart.getFactor();
        float f3 = this.mChart.getRotationAngle();
        MPPointF mPPointF = this.mChart.getCenterOffsets();
        this.mWebPaint.setStrokeWidth(this.mChart.getWebLineWidth());
        this.mWebPaint.setColor(this.mChart.getWebColor());
        this.mWebPaint.setAlpha(this.mChart.getWebAlpha());
        int n2 = this.mChart.getSkipWebLineCount();
        int n3 = ((IRadarDataSet)((RadarData)this.mChart.getData()).getMaxEntryCountSet()).getEntryCount();
        MPPointF mPPointF2 = MPPointF.getInstance(0.0f, 0.0f);
        for (n = 0; n < n3; n += n2 + 1) {
            Utils.getPosition(mPPointF, this.mChart.getYRange() * f2, (float)n * f + f3, mPPointF2);
            canvas.drawLine(mPPointF.x, mPPointF.y, mPPointF2.x, mPPointF2.y, this.mWebPaint);
        }
        MPPointF.recycleInstance(mPPointF2);
        this.mWebPaint.setStrokeWidth(this.mChart.getWebLineWidthInner());
        this.mWebPaint.setColor(this.mChart.getWebColorInner());
        this.mWebPaint.setAlpha(this.mChart.getWebAlpha());
        n3 = this.mChart.getYAxis().mEntryCount;
        MPPointF mPPointF3 = MPPointF.getInstance(0.0f, 0.0f);
        mPPointF2 = MPPointF.getInstance(0.0f, 0.0f);
        for (n = 0; n < n3; ++n) {
            n2 = 0;
            while (n2 < ((RadarData)this.mChart.getData()).getEntryCount()) {
                float f4 = (this.mChart.getYAxis().mEntries[n] - this.mChart.getYChartMin()) * f2;
                Utils.getPosition(mPPointF, f4, (float)n2 * f + f3, mPPointF3);
                Utils.getPosition(mPPointF, f4, (float)(++n2) * f + f3, mPPointF2);
                canvas.drawLine(mPPointF3.x, mPPointF3.y, mPPointF2.x, mPPointF2.y, this.mWebPaint);
            }
        }
        MPPointF.recycleInstance(mPPointF3);
        MPPointF.recycleInstance(mPPointF2);
    }

    public Paint getWebPaint() {
        return this.mWebPaint;
    }

    @Override
    public void initBuffers() {
    }
}

