/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.renderer;

import android.graphics.Canvas;
import android.util.Log;
import com.github.mikephil.charting.animation.ChartAnimator;
import com.github.mikephil.charting.data.BaseEntry;
import com.github.mikephil.charting.data.Entry;
import com.github.mikephil.charting.data.ScatterData;
import com.github.mikephil.charting.highlight.Highlight;
import com.github.mikephil.charting.interfaces.dataprovider.ScatterDataProvider;
import com.github.mikephil.charting.interfaces.datasets.IScatterDataSet;
import com.github.mikephil.charting.renderer.LineScatterCandleRadarRenderer;
import com.github.mikephil.charting.renderer.scatter.IShapeRenderer;
import com.github.mikephil.charting.utils.MPPointD;
import com.github.mikephil.charting.utils.MPPointF;
import com.github.mikephil.charting.utils.Transformer;
import com.github.mikephil.charting.utils.Utils;
import com.github.mikephil.charting.utils.ViewPortHandler;
import java.util.List;

public class ScatterChartRenderer
extends LineScatterCandleRadarRenderer {
    protected ScatterDataProvider mChart;
    float[] mPixelBuffer = new float[2];

    public ScatterChartRenderer(ScatterDataProvider scatterDataProvider, ChartAnimator chartAnimator, ViewPortHandler viewPortHandler) {
        super(chartAnimator, viewPortHandler);
        this.mChart = scatterDataProvider;
    }

    @Override
    public void drawData(Canvas canvas) {
        for (IScatterDataSet iScatterDataSet : this.mChart.getScatterData().getDataSets()) {
            if (!iScatterDataSet.isVisible()) continue;
            this.drawDataSet(canvas, iScatterDataSet);
        }
    }

    protected void drawDataSet(Canvas canvas, IScatterDataSet iScatterDataSet) {
        if (iScatterDataSet.getEntryCount() < 1) {
            return;
        }
        ViewPortHandler viewPortHandler = this.mViewPortHandler;
        Transformer transformer = this.mChart.getTransformer(iScatterDataSet.getAxisDependency());
        float f = this.mAnimator.getPhaseY();
        IShapeRenderer iShapeRenderer = iScatterDataSet.getShapeRenderer();
        if (iShapeRenderer == null) {
            Log.i((String)"MISSING", (String)"There's no IShapeRenderer specified for ScatterDataSet");
            return;
        }
        int n = (int)Math.min(Math.ceil((float)iScatterDataSet.getEntryCount() * this.mAnimator.getPhaseX()), (double)iScatterDataSet.getEntryCount());
        for (int i = 0; i < n; ++i) {
            Object object = iScatterDataSet.getEntryForIndex(i);
            this.mPixelBuffer[0] = ((Entry)object).getX();
            this.mPixelBuffer[1] = ((BaseEntry)object).getY() * f;
            transformer.pointValuesToPixel(this.mPixelBuffer);
            if (!viewPortHandler.isInBoundsRight(this.mPixelBuffer[0])) break;
            if (!viewPortHandler.isInBoundsLeft(this.mPixelBuffer[0]) || !viewPortHandler.isInBoundsY(this.mPixelBuffer[1])) continue;
            this.mRenderPaint.setColor(iScatterDataSet.getColor(i / 2));
            object = this.mViewPortHandler;
            float[] fArray = this.mPixelBuffer;
            iShapeRenderer.renderShape(canvas, iScatterDataSet, (ViewPortHandler)object, fArray[0], fArray[1], this.mRenderPaint);
        }
    }

    @Override
    public void drawExtras(Canvas canvas) {
    }

    @Override
    public void drawHighlighted(Canvas canvas, Highlight[] highlightArray) {
        ScatterData scatterData = this.mChart.getScatterData();
        for (Highlight highlight : highlightArray) {
            Object object;
            IScatterDataSet iScatterDataSet = (IScatterDataSet)scatterData.getDataSetByIndex(highlight.getDataSetIndex());
            if (iScatterDataSet == null || !iScatterDataSet.isHighlightEnabled() || !this.isInBoundsX((Entry)(object = iScatterDataSet.getEntryForXValue(highlight.getX(), highlight.getY())), iScatterDataSet)) continue;
            object = this.mChart.getTransformer(iScatterDataSet.getAxisDependency()).getPixelForValues(((Entry)object).getX(), ((BaseEntry)object).getY() * this.mAnimator.getPhaseY());
            highlight.setDraw((float)((MPPointD)object).x, (float)((MPPointD)object).y);
            this.drawHighlightLines(canvas, (float)((MPPointD)object).x, (float)((MPPointD)object).y, iScatterDataSet);
        }
    }

    @Override
    public void drawValues(Canvas canvas) {
        if (this.isDrawingValuesAllowed(this.mChart)) {
            List list = this.mChart.getScatterData().getDataSets();
            for (int i = 0; i < this.mChart.getScatterData().getDataSetCount(); ++i) {
                IScatterDataSet iScatterDataSet = (IScatterDataSet)list.get(i);
                if (!this.shouldDrawValues(iScatterDataSet) || iScatterDataSet.getEntryCount() < 1) continue;
                this.applyValueTextStyle(iScatterDataSet);
                this.mXBounds.set(this.mChart, iScatterDataSet);
                float[] fArray = this.mChart.getTransformer(iScatterDataSet.getAxisDependency()).generateTransformedValuesScatter(iScatterDataSet, this.mAnimator.getPhaseX(), this.mAnimator.getPhaseY(), this.mXBounds.min, this.mXBounds.max);
                float f = Utils.convertDpToPixel(iScatterDataSet.getScatterShapeSize());
                MPPointF mPPointF = MPPointF.getInstance(iScatterDataSet.getIconsOffset());
                mPPointF.x = Utils.convertDpToPixel(mPPointF.x);
                mPPointF.y = Utils.convertDpToPixel(mPPointF.y);
                for (int j = 0; j < fArray.length && this.mViewPortHandler.isInBoundsRight(fArray[j]); j += 2) {
                    int n;
                    Object object;
                    if (!this.mViewPortHandler.isInBoundsLeft(fArray[j]) || !((ViewPortHandler)(object = this.mViewPortHandler)).isInBoundsY(fArray[n = j + 1])) continue;
                    int n2 = j / 2;
                    Object object2 = iScatterDataSet.getEntryForIndex(this.mXBounds.min + n2);
                    if (iScatterDataSet.isDrawValuesEnabled()) {
                        this.drawValue(canvas, iScatterDataSet.getValueFormatter(), ((BaseEntry)object2).getY(), (Entry)object2, i, fArray[j], fArray[n] - f, iScatterDataSet.getValueTextColor(n2 + this.mXBounds.min));
                    }
                    object = mPPointF;
                    if (((BaseEntry)object2).getIcon() == null || !iScatterDataSet.isDrawIconsEnabled()) continue;
                    object2 = ((BaseEntry)object2).getIcon();
                    Utils.drawImage(canvas, object2, (int)(fArray[j] + ((MPPointF)object).x), (int)(fArray[n] + ((MPPointF)object).y), object2.getIntrinsicWidth(), object2.getIntrinsicHeight());
                }
                MPPointF.recycleInstance(mPPointF);
            }
        }
    }

    @Override
    public void initBuffers() {
    }
}

