/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.utils;

import android.graphics.Canvas;
import android.graphics.LinearGradient;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.drawable.Drawable;
import com.github.mikephil.charting.utils.Utils;

public class Fill {
    private int mAlpha = 255;
    private Integer mColor = null;
    protected Drawable mDrawable;
    private Integer mFinalColor = null;
    private int[] mGradientColors;
    private float[] mGradientPositions;
    private Type mType = Type.EMPTY;

    public Fill() {
    }

    public Fill(int n) {
        this.mType = Type.COLOR;
        this.mColor = n;
        this.calculateFinalColor();
    }

    public Fill(int n, int n2) {
        this.mType = Type.LINEAR_GRADIENT;
        this.mGradientColors = new int[]{n, n2};
    }

    public Fill(Drawable drawable2) {
        this.mType = Type.DRAWABLE;
        this.mDrawable = drawable2;
    }

    public Fill(int[] nArray) {
        this.mType = Type.LINEAR_GRADIENT;
        this.mGradientColors = nArray;
    }

    public Fill(int[] nArray, float[] fArray) {
        this.mType = Type.LINEAR_GRADIENT;
        this.mGradientColors = nArray;
        this.mGradientPositions = fArray;
    }

    private void calculateFinalColor() {
        Integer n = this.mColor;
        this.mFinalColor = n == null ? null : Integer.valueOf((int)Math.floor((double)(n >> 24) / 255.0 * ((double)this.mAlpha / 255.0) * 255.0) << 24 | this.mColor & 0xFFFFFF);
    }

    private void ensureClipPathSupported() {
        if (Utils.getSDKInt() >= 18) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Fill-drawables not (yet) supported below API level 18, this code was run on API level ");
        stringBuilder.append(Utils.getSDKInt());
        stringBuilder.append(".");
        throw new RuntimeException(stringBuilder.toString());
    }

    private boolean isClipPathSupported() {
        boolean bl = Utils.getSDKInt() >= 18;
        return bl;
    }

    public void fillPath(Canvas canvas, Path path, Paint paint, RectF rectF) {
        int n = 1.$SwitchMap$com$github$mikephil$charting$utils$Fill$Type[this.mType.ordinal()];
        if (n != 2) {
            if (n != 3) {
                if (n == 4) {
                    if (this.mDrawable == null) {
                        return;
                    }
                    this.ensureClipPathSupported();
                    int n2 = canvas.save();
                    canvas.clipPath(path);
                    path = this.mDrawable;
                    int n3 = 0;
                    n = rectF == null ? 0 : (int)rectF.left;
                    if (rectF != null) {
                        n3 = (int)rectF.top;
                    }
                    int n4 = rectF == null ? canvas.getWidth() : (int)rectF.right;
                    int n5 = rectF == null ? canvas.getHeight() : (int)rectF.bottom;
                    path.setBounds(n, n3, n4, n5);
                    this.mDrawable.draw(canvas);
                    canvas.restoreToCount(n2);
                }
            } else {
                if (this.mGradientColors == null) {
                    return;
                }
                paint.setShader((Shader)new LinearGradient(0.0f, 0.0f, (float)canvas.getWidth(), (float)canvas.getHeight(), this.mGradientColors, this.mGradientPositions, Shader.TileMode.MIRROR));
                canvas.drawPath(path, paint);
            }
        } else {
            if (this.mFinalColor == null) {
                return;
            }
            if (rectF != null && this.isClipPathSupported()) {
                n = canvas.save();
                canvas.clipPath(path);
                canvas.drawColor(this.mFinalColor.intValue());
                canvas.restoreToCount(n);
            } else {
                rectF = paint.getStyle();
                n = paint.getColor();
                paint.setStyle(Paint.Style.FILL);
                paint.setColor(this.mFinalColor.intValue());
                canvas.drawPath(path, paint);
                paint.setColor(n);
                paint.setStyle((Paint.Style)rectF);
            }
        }
    }

    public void fillRect(Canvas canvas, Paint paint, float f, float f2, float f3, float f4, Direction direction) {
        int n = 1.$SwitchMap$com$github$mikephil$charting$utils$Fill$Type[this.mType.ordinal()];
        if (n != 2) {
            if (n != 3) {
                if (n == 4) {
                    paint = this.mDrawable;
                    if (paint == null) {
                        return;
                    }
                    paint.setBounds((int)f, (int)f2, (int)f3, (int)f4);
                    this.mDrawable.draw(canvas);
                }
            } else {
                Direction direction2;
                float f5;
                if (this.mGradientColors == null) {
                    return;
                }
                if (direction == Direction.RIGHT) {
                    f5 = f3;
                } else {
                    direction2 = Direction.LEFT;
                    f5 = f;
                }
                float f6 = (int)f5;
                if (direction == Direction.UP) {
                    f5 = f4;
                } else {
                    direction2 = Direction.DOWN;
                    f5 = f2;
                }
                float f7 = (int)f5;
                f5 = direction != Direction.RIGHT && direction == Direction.LEFT ? f3 : f;
                float f8 = (int)f5;
                f5 = direction != Direction.UP && direction == Direction.DOWN ? f4 : f2;
                paint.setShader((Shader)new LinearGradient(f6, f7, f8, (float)((int)f5), this.mGradientColors, this.mGradientPositions, Shader.TileMode.MIRROR));
                canvas.drawRect(f, f2, f3, f4, paint);
            }
        } else {
            if (this.mFinalColor == null) {
                return;
            }
            if (this.isClipPathSupported()) {
                n = canvas.save();
                canvas.clipRect(f, f2, f3, f4);
                canvas.drawColor(this.mFinalColor.intValue());
                canvas.restoreToCount(n);
            } else {
                direction = paint.getStyle();
                n = paint.getColor();
                paint.setStyle(Paint.Style.FILL);
                paint.setColor(this.mFinalColor.intValue());
                canvas.drawRect(f, f2, f3, f4, paint);
                paint.setColor(n);
                paint.setStyle((Paint.Style)direction);
            }
        }
    }

    public int getAlpha() {
        return this.mAlpha;
    }

    public Integer getColor() {
        return this.mColor;
    }

    public int[] getGradientColors() {
        return this.mGradientColors;
    }

    public float[] getGradientPositions() {
        return this.mGradientPositions;
    }

    public Type getType() {
        return this.mType;
    }

    public void setAlpha(int n) {
        this.mAlpha = n;
        this.calculateFinalColor();
    }

    public void setColor(int n) {
        this.mColor = n;
        this.calculateFinalColor();
    }

    public void setGradientColors(int n, int n2) {
        this.mGradientColors = new int[]{n, n2};
    }

    public void setGradientColors(int[] nArray) {
        this.mGradientColors = nArray;
    }

    public void setGradientPositions(float[] fArray) {
        this.mGradientPositions = fArray;
    }

    public void setType(Type type) {
        this.mType = type;
    }

    public static final class Direction
    extends Enum<Direction> {
        private static final /* synthetic */ Direction[] $VALUES;
        public static final /* enum */ Direction DOWN;
        public static final /* enum */ Direction LEFT;
        public static final /* enum */ Direction RIGHT;
        public static final /* enum */ Direction UP;

        static {
            Direction direction;
            Direction direction2;
            Direction direction3;
            Direction direction4;
            DOWN = direction4 = new Direction();
            UP = direction3 = new Direction();
            RIGHT = direction2 = new Direction();
            LEFT = direction = new Direction();
            $VALUES = new Direction[]{direction4, direction3, direction2, direction};
        }

        public static Direction valueOf(String string2) {
            return Enum.valueOf(Direction.class, string2);
        }

        public static Direction[] values() {
            return (Direction[])$VALUES.clone();
        }
    }

    public static final class Type
    extends Enum<Type> {
        private static final /* synthetic */ Type[] $VALUES;
        public static final /* enum */ Type COLOR;
        public static final /* enum */ Type DRAWABLE;
        public static final /* enum */ Type EMPTY;
        public static final /* enum */ Type LINEAR_GRADIENT;

        static {
            Type type;
            Type type2;
            Type type3;
            Type type4;
            EMPTY = type4 = new Type();
            COLOR = type3 = new Type();
            LINEAR_GRADIENT = type2 = new Type();
            DRAWABLE = type = new Type();
            $VALUES = new Type[]{type4, type3, type2, type};
        }

        public static Type valueOf(String string2) {
            return Enum.valueOf(Type.class, string2);
        }

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }
    }
}

