/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjdev.libaums;

import android.content.Context;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbEndpoint;
import android.hardware.usb.UsbInterface;
import android.hardware.usb.UsbManager;
import android.util.Log;
import com.github.mjdev.libaums.driver.BlockDeviceDriver;
import com.github.mjdev.libaums.driver.BlockDeviceDriverFactory;
import com.github.mjdev.libaums.partition.Partition;
import com.github.mjdev.libaums.partition.PartitionTable;
import com.github.mjdev.libaums.partition.PartitionTableEntry;
import com.github.mjdev.libaums.partition.PartitionTableFactory;
import com.github.mjdev.libaums.usb.UsbCommunication;
import com.github.mjdev.libaums.usb.UsbCommunicationFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class UsbMassStorageDevice {
    private static final int INTERFACE_PROTOCOL = 80;
    private static final int INTERFACE_SUBCLASS = 6;
    private static final String TAG = "UsbMassStorageDevice";
    private BlockDeviceDriver blockDevice;
    private UsbDeviceConnection deviceConnection;
    private UsbEndpoint inEndpoint;
    private boolean inited = false;
    private UsbEndpoint outEndpoint;
    private PartitionTable partitionTable;
    private List<Partition> partitions = new ArrayList<Partition>();
    private UsbDevice usbDevice;
    private UsbInterface usbInterface;
    private UsbManager usbManager;

    private UsbMassStorageDevice(UsbManager usbManager, UsbDevice usbDevice, UsbInterface usbInterface, UsbEndpoint usbEndpoint, UsbEndpoint usbEndpoint2) {
        this.usbManager = usbManager;
        this.usbDevice = usbDevice;
        this.usbInterface = usbInterface;
        this.inEndpoint = usbEndpoint;
        this.outEndpoint = usbEndpoint2;
    }

    public static UsbMassStorageDevice[] getMassStorageDevices(Context object) {
        UsbManager usbManager = (UsbManager)object.getSystemService("usb");
        ArrayList<UsbMassStorageDevice> arrayList = new ArrayList<UsbMassStorageDevice>();
        for (UsbDevice usbDevice : usbManager.getDeviceList().values()) {
            object = TAG;
            CharSequence charSequence = new StringBuilder();
            charSequence.append("found usb device: ");
            charSequence.append(usbDevice);
            Log.i((String)object, (String)charSequence.toString());
            int n = usbDevice.getInterfaceCount();
            for (int i = 0; i < n; ++i) {
                UsbInterface usbInterface = usbDevice.getInterface(i);
                charSequence = TAG;
                object = new StringBuilder();
                ((StringBuilder)object).append("found usb interface: ");
                ((StringBuilder)object).append(usbInterface);
                Log.i((String)charSequence, (String)((StringBuilder)object).toString());
                if (usbInterface.getInterfaceClass() == 8 && usbInterface.getInterfaceSubclass() == 6 && usbInterface.getInterfaceProtocol() == 80) {
                    int n2 = usbInterface.getEndpointCount();
                    if (n2 != 2) {
                        Log.w((String)charSequence, (String)"inteface endpoint count != 2");
                    }
                    charSequence = null;
                    object = charSequence;
                    for (int j = 0; j < n2; ++j) {
                        UsbEndpoint usbEndpoint = usbInterface.getEndpoint(j);
                        Object object2 = TAG;
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append("found usb endpoint: ");
                        stringBuilder.append(usbEndpoint);
                        Log.i((String)object2, (String)stringBuilder.toString());
                        stringBuilder = charSequence;
                        object2 = object;
                        if (usbEndpoint.getType() == 2) {
                            if (usbEndpoint.getDirection() == 0) {
                                stringBuilder = charSequence;
                                object2 = usbEndpoint;
                            } else {
                                object2 = object;
                                stringBuilder = usbEndpoint;
                            }
                        }
                        charSequence = stringBuilder;
                        object = object2;
                    }
                    if (object != null && charSequence != null) {
                        arrayList.add(new UsbMassStorageDevice(usbManager, usbDevice, usbInterface, (UsbEndpoint)charSequence, (UsbEndpoint)object));
                        continue;
                    }
                    Log.e((String)TAG, (String)"Not all needed endpoints found!");
                    continue;
                }
                Log.i((String)charSequence, (String)"device interface not suitable!");
            }
        }
        return arrayList.toArray(new UsbMassStorageDevice[0]);
    }

    private void initPartitions() throws IOException {
        Iterator iterator2 = this.partitionTable.getPartitionTableEntries().iterator();
        while (iterator2.hasNext()) {
            Partition partition = Partition.createPartition((PartitionTableEntry)iterator2.next(), this.blockDevice);
            if (partition == null) continue;
            this.partitions.add(partition);
        }
    }

    private void setupDevice() throws IOException {
        Object object;
        Object object2 = TAG;
        Log.d((String)object2, (String)"setup device");
        this.deviceConnection = object = this.usbManager.openDevice(this.usbDevice);
        if (object != null) {
            if (object.claimInterface(this.usbInterface, true)) {
                object = UsbCommunicationFactory.createUsbCommunication(this.deviceConnection, this.outEndpoint, this.inEndpoint);
                byte[] byArray = new byte[1];
                this.deviceConnection.controlTransfer(161, 254, 0, this.usbInterface.getId(), byArray, 1, 5000);
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("MAX LUN ");
                stringBuilder.append(byArray[0]);
                Log.i((String)object2, (String)stringBuilder.toString());
                this.blockDevice = object2 = BlockDeviceDriverFactory.createBlockDevice((UsbCommunication)object);
                object2.init();
                this.partitionTable = PartitionTableFactory.createPartitionTable(this.blockDevice);
                this.initPartitions();
                return;
            }
            throw new IOException("could not claim interface!");
        }
        throw new IOException("deviceConnection is null!");
    }

    public void close() {
        String string2 = TAG;
        Log.d((String)string2, (String)"close device");
        UsbDeviceConnection usbDeviceConnection = this.deviceConnection;
        if (usbDeviceConnection == null) {
            return;
        }
        if (!usbDeviceConnection.releaseInterface(this.usbInterface)) {
            Log.e((String)string2, (String)"could not release interface!");
        }
        this.deviceConnection.close();
        this.inited = false;
    }

    public BlockDeviceDriver getBlockDevice() {
        return this.blockDevice;
    }

    public List<Partition> getPartitions() {
        return this.partitions;
    }

    public UsbDevice getUsbDevice() {
        return this.usbDevice;
    }

    public void init() throws IOException {
        if (this.usbManager.hasPermission(this.usbDevice)) {
            this.setupDevice();
            this.inited = true;
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Missing permission to access usb device: ");
        stringBuilder.append(this.usbDevice);
        throw new IllegalStateException(stringBuilder.toString());
    }
}

