/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjdev.libaums.driver.file;

import com.github.mjdev.libaums.driver.BlockDeviceDriver;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;

public class FileBlockDeviceDriver
implements BlockDeviceDriver {
    private int blockSize;
    private int byteOffset;
    private RandomAccessFile file;

    public FileBlockDeviceDriver(File file) throws FileNotFoundException {
        this(file, 512, 0);
    }

    public FileBlockDeviceDriver(File file, int n) throws FileNotFoundException {
        this(file, 512, n);
    }

    public FileBlockDeviceDriver(File file, int n, int n2) throws FileNotFoundException {
        this.file = new RandomAccessFile(file, "rw");
        this.blockSize = n;
        this.byteOffset = n2;
    }

    public FileBlockDeviceDriver(URL uRL) throws IOException {
        this(uRL, 512, 0);
    }

    public FileBlockDeviceDriver(URL uRL, int n) throws IOException {
        this(uRL, 512, n);
    }

    public FileBlockDeviceDriver(URL object, int n, int n2) throws IOException {
        this.byteOffset = n2;
        object = Channels.newChannel(((URL)object).openStream());
        File file = File.createTempFile("blockdevice", "bin");
        new FileOutputStream(file).getChannel().transferFrom((ReadableByteChannel)object, 0L, Long.MAX_VALUE);
        this.file = new RandomAccessFile(file, "rw");
        this.blockSize = n;
    }

    @Override
    public int getBlockSize() {
        return this.blockSize;
    }

    @Override
    public void init() throws IOException {
    }

    @Override
    public void read(long l, ByteBuffer byteBuffer) throws IOException {
        this.file.seek(l * (long)this.blockSize + (long)this.byteOffset);
        int n = this.file.read(byteBuffer.array(), byteBuffer.position(), byteBuffer.remaining());
        byteBuffer.position(byteBuffer.position() + n);
    }

    @Override
    public void write(long l, ByteBuffer byteBuffer) throws IOException {
        this.file.seek(l * (long)this.blockSize + (long)this.byteOffset);
        this.file.write(byteBuffer.array(), byteBuffer.position(), byteBuffer.remaining());
        byteBuffer.position(byteBuffer.limit());
    }
}

