/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjdev.libaums.fs;

import com.github.mjdev.libaums.driver.BlockDeviceDriver;
import com.github.mjdev.libaums.fs.FileSystem;
import com.github.mjdev.libaums.fs.FileSystemCreator;
import com.github.mjdev.libaums.fs.fat32.Fat32FileSystemCreator;
import com.github.mjdev.libaums.partition.PartitionTableEntry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TimeZone;

public class FileSystemFactory {
    private static List<FileSystemCreator> fileSystems = new ArrayList<FileSystemCreator>();
    private static TimeZone timeZone = TimeZone.getDefault();

    static {
        FileSystemFactory.registerFileSystem(new Fat32FileSystemCreator());
    }

    public static FileSystem createFileSystem(PartitionTableEntry partitionTableEntry, BlockDeviceDriver blockDeviceDriver) throws IOException, UnsupportedFileSystemException {
        Iterator<FileSystemCreator> iterator2 = fileSystems.iterator();
        while (iterator2.hasNext()) {
            FileSystem fileSystem = iterator2.next().read(partitionTableEntry, blockDeviceDriver);
            if (fileSystem == null) continue;
            return fileSystem;
        }
        throw new UnsupportedFileSystemException();
    }

    public static TimeZone getTimeZone() {
        return timeZone;
    }

    public static void registerFileSystem(FileSystemCreator fileSystemCreator) {
        synchronized (FileSystemFactory.class) {
            fileSystems.add(fileSystemCreator);
            return;
        }
    }

    public static void setTimeZone(TimeZone timeZone) {
        FileSystemFactory.timeZone = timeZone;
    }

    public static class UnsupportedFileSystemException
    extends IOException {
    }
}

