/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjdev.libaums.fs.fat32;

import android.util.Log;
import com.github.mjdev.libaums.driver.BlockDeviceDriver;
import com.github.mjdev.libaums.fs.fat32.FAT;
import com.github.mjdev.libaums.fs.fat32.Fat32BootSector;
import java.io.IOException;
import java.nio.ByteBuffer;

public class ClusterChain {
    private static final String TAG = "ClusterChain";
    private BlockDeviceDriver blockDevice;
    private Long[] chain;
    private long clusterSize;
    private long dataAreaOffset;
    private FAT fat;

    ClusterChain(long l, BlockDeviceDriver blockDeviceDriver, FAT fAT, Fat32BootSector fat32BootSector) throws IOException {
        String string2 = TAG;
        Log.d((String)string2, (String)"Init a cluster chain, reading from FAT");
        this.fat = fAT;
        this.blockDevice = blockDeviceDriver;
        this.chain = fAT.getChain(l);
        this.clusterSize = fat32BootSector.getBytesPerCluster();
        this.dataAreaOffset = fat32BootSector.getDataAreaOffset();
        Log.d((String)string2, (String)"Finished init of a cluster chain");
    }

    private long getFileSystemOffset(long l, int n) {
        return this.dataAreaOffset + (long)n + (l - 2L) * this.clusterSize;
    }

    int getClusters() {
        return this.chain.length;
    }

    long getLength() {
        return (long)this.chain.length * this.clusterSize;
    }

    void read(long l, ByteBuffer byteBuffer) throws IOException {
        int n = byteBuffer.remaining();
        long l2 = this.clusterSize;
        int n2 = (int)(l / l2);
        int n3 = n;
        int n4 = n2;
        if (l % l2 != 0L) {
            n4 = (int)(l % l2);
            n3 = Math.min(n, (int)(l2 - (long)n4));
            byteBuffer.limit(byteBuffer.position() + n3);
            this.blockDevice.read(this.getFileSystemOffset(this.chain[n2], n4), byteBuffer);
            n4 = n2 + 1;
            n3 = n - n3;
        }
        while (n3 > 0) {
            n = (int)Math.min(this.clusterSize, (long)n3);
            byteBuffer.limit(byteBuffer.position() + n);
            this.blockDevice.read(this.getFileSystemOffset(this.chain[n4], 0), byteBuffer);
            ++n4;
            n3 -= n;
        }
    }

    void setClusters(int n) throws IOException {
        int n2 = this.getClusters();
        if (n == n2) {
            return;
        }
        if (n > n2) {
            Log.d((String)TAG, (String)"grow chain");
            this.chain = this.fat.alloc(this.chain, n - n2);
        } else {
            Log.d((String)TAG, (String)"shrink chain");
            this.chain = this.fat.free(this.chain, n2 - n);
        }
    }

    void setLength(long l) throws IOException {
        long l2 = this.clusterSize;
        this.setClusters((int)((l + l2 - 1L) / l2));
    }

    void write(long l, ByteBuffer byteBuffer) throws IOException {
        int n = byteBuffer.remaining();
        long l2 = this.clusterSize;
        int n2 = (int)(l / l2);
        int n3 = n;
        int n4 = n2;
        if (l % l2 != 0L) {
            n4 = (int)(l % l2);
            n3 = Math.min(n, (int)(l2 - (long)n4));
            byteBuffer.limit(byteBuffer.position() + n3);
            this.blockDevice.write(this.getFileSystemOffset(this.chain[n2], n4), byteBuffer);
            n4 = n2 + 1;
            n3 = n - n3;
        }
        while (n3 > 0) {
            n = (int)Math.min(this.clusterSize, (long)n3);
            byteBuffer.limit(byteBuffer.position() + n);
            this.blockDevice.write(this.getFileSystemOffset(this.chain[n4], 0), byteBuffer);
            ++n4;
            n3 -= n;
        }
    }
}

