/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjdev.libaums.fs.fat32;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;

class Fat32BootSector {
    private static final int BYTES_PER_SECTOR_OFF = 11;
    private static final int FAT_COUNT_OFF = 16;
    private static final int FLAGS_OFF = 40;
    private static final int FS_INFO_SECTOR_OFF = 48;
    private static final int RESERVED_COUNT_OFF = 14;
    private static final int ROOT_DIR_CLUSTER_OFF = 44;
    private static final int SECTORS_PER_CLUSTER_OFF = 13;
    private static final int SECTORS_PER_FAT_OFF = 36;
    private static final int TOTAL_SECTORS_OFF = 32;
    private static final int VOLUME_LABEL_OFF = 48;
    private short bytesPerSector;
    private byte fatCount;
    private boolean fatMirrored;
    private short fsInfoStartSector;
    private short reservedSectors;
    private long rootDirStartCluster;
    private short sectorsPerCluster;
    private long sectorsPerFat;
    private long totalNumberOfSectors;
    private byte validFat;
    private String volumeLabel;

    private Fat32BootSector() {
    }

    static Fat32BootSector read(ByteBuffer byteBuffer) {
        Fat32BootSector fat32BootSector = new Fat32BootSector();
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        fat32BootSector.bytesPerSector = byteBuffer.getShort(11);
        fat32BootSector.sectorsPerCluster = (short)(byteBuffer.get(13) & 0xFF);
        fat32BootSector.reservedSectors = byteBuffer.getShort(14);
        fat32BootSector.fatCount = byteBuffer.get(16);
        fat32BootSector.totalNumberOfSectors = (long)byteBuffer.getInt(32) & 0xFFFFFFFFL;
        fat32BootSector.sectorsPerFat = (long)byteBuffer.getInt(36) & 0xFFFFFFFFL;
        fat32BootSector.rootDirStartCluster = (long)byteBuffer.getInt(44) & 0xFFFFFFFFL;
        fat32BootSector.fsInfoStartSector = byteBuffer.getShort(48);
        byte by = (byte)byteBuffer.getShort(40);
        boolean bl = (by & 0x80) == 0;
        fat32BootSector.fatMirrored = bl;
        fat32BootSector.validFat = (byte)(by & 7);
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < 11 && (by = byteBuffer.get(i + 48)) != 0; ++i) {
            stringBuilder.append((char)by);
        }
        fat32BootSector.volumeLabel = stringBuilder.toString();
        return fat32BootSector;
    }

    int getBytesPerCluster() {
        return this.sectorsPerCluster * this.bytesPerSector;
    }

    short getBytesPerSector() {
        return this.bytesPerSector;
    }

    long getDataAreaOffset() {
        return this.getFatOffset(0) + (long)this.getFatCount() * this.getSectorsPerFat() * (long)this.getBytesPerSector();
    }

    byte getFatCount() {
        return this.fatCount;
    }

    long getFatOffset(int n) {
        return (long)this.getBytesPerSector() * ((long)this.getReservedSectors() + (long)n * this.getSectorsPerFat());
    }

    short getFsInfoStartSector() {
        return this.fsInfoStartSector;
    }

    short getReservedSectors() {
        return this.reservedSectors;
    }

    long getRootDirStartCluster() {
        return this.rootDirStartCluster;
    }

    short getSectorsPerCluster() {
        return this.sectorsPerCluster;
    }

    long getSectorsPerFat() {
        return this.sectorsPerFat;
    }

    long getTotalNumberOfSectors() {
        return this.totalNumberOfSectors;
    }

    byte getValidFat() {
        return this.validFat;
    }

    String getVolumeLabel() {
        return this.volumeLabel;
    }

    boolean isFatMirrored() {
        return this.fatMirrored;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Fat32BootSector{bytesPerSector=");
        stringBuilder.append(this.bytesPerSector);
        stringBuilder.append(", sectorsPerCluster=");
        stringBuilder.append(this.sectorsPerCluster);
        stringBuilder.append(", reservedSectors=");
        stringBuilder.append(this.reservedSectors);
        stringBuilder.append(", fatCount=");
        stringBuilder.append(this.fatCount);
        stringBuilder.append(", totalNumberOfSectors=");
        stringBuilder.append(this.totalNumberOfSectors);
        stringBuilder.append(", sectorsPerFat=");
        stringBuilder.append(this.sectorsPerFat);
        stringBuilder.append(", rootDirStartCluster=");
        stringBuilder.append(this.rootDirStartCluster);
        stringBuilder.append(", fsInfoStartSector=");
        stringBuilder.append(this.fsInfoStartSector);
        stringBuilder.append(", fatMirrored=");
        stringBuilder.append(this.fatMirrored);
        stringBuilder.append(", validFat=");
        stringBuilder.append(this.validFat);
        stringBuilder.append(", volumeLabel='");
        stringBuilder.append(this.volumeLabel);
        stringBuilder.append('\'');
        stringBuilder.append('}');
        return stringBuilder.toString();
    }
}

