/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjdev.libaums.fs.fat32;

import com.github.mjdev.libaums.fs.FileSystemFactory;
import com.github.mjdev.libaums.fs.fat32.ShortName;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.util.Calendar;

class FatDirectoryEntry {
    private static final int ATTR_OFF = 11;
    private static final int CREATED_DATE_OFF = 16;
    private static final int CREATED_TIME_OFF = 14;
    static final int ENTRY_DELETED = 229;
    private static final int FILE_SIZE_OFF = 28;
    private static final int FLAG_ARCHIVE = 32;
    private static final int FLAG_DIRECTORY = 16;
    private static final int FLAG_HIDDEN = 2;
    private static final int FLAG_READONLY = 1;
    private static final int FLAG_SYSTEM = 4;
    private static final int FLAG_VOLUME_ID = 8;
    private static final int LAST_ACCESSED_DATE_OFF = 18;
    private static final int LAST_WRITE_DATE_OFF = 24;
    private static final int LAST_WRITE_TIME_OFF = 22;
    private static final int LSB_CLUSTER_OFF = 26;
    private static final int MSB_CLUSTER_OFF = 20;
    private static final int SHORTNAME_CASE_OFF = 12;
    static final int SIZE = 32;
    private ByteBuffer data;
    private ShortName shortName;

    private FatDirectoryEntry() {
    }

    private FatDirectoryEntry(ByteBuffer byteBuffer) {
        this.data = byteBuffer;
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        this.shortName = ShortName.parse(byteBuffer);
        byteBuffer.clear();
    }

    static FatDirectoryEntry createLfnPart(String object, int n, byte by, int n2, boolean bl) {
        FatDirectoryEntry fatDirectoryEntry = new FatDirectoryEntry();
        Object object2 = object;
        int n3 = n;
        if (bl) {
            int n4 = ((String)object).length() - n;
            object2 = object;
            n3 = n;
            if (n4 < 13) {
                object2 = new StringBuilder(13);
                ((StringBuilder)object2).append((CharSequence)object, n, ((String)object).length());
                ((StringBuilder)object2).append('\u0000');
                for (n = 0; n < 13 - n4; ++n) {
                    ((StringBuilder)object2).append('\uffff');
                }
                object2 = ((StringBuilder)object2).toString();
                n3 = 0;
            }
        }
        object = ByteBuffer.allocate(32);
        ((ByteBuffer)object).order(ByteOrder.LITTLE_ENDIAN);
        n = n2;
        if (bl) {
            n = n2 + 64;
        }
        ((ByteBuffer)object).put(0, (byte)n);
        ((ByteBuffer)object).putShort(1, (short)((String)object2).charAt(n3));
        ((ByteBuffer)object).putShort(3, (short)((String)object2).charAt(n3 + 1));
        ((ByteBuffer)object).putShort(5, (short)((String)object2).charAt(n3 + 2));
        ((ByteBuffer)object).putShort(7, (short)((String)object2).charAt(n3 + 3));
        ((ByteBuffer)object).putShort(9, (short)((String)object2).charAt(n3 + 4));
        ((ByteBuffer)object).put(11, (byte)15);
        ((ByteBuffer)object).put(12, (byte)0);
        ((ByteBuffer)object).put(13, by);
        ((ByteBuffer)object).putShort(14, (short)((String)object2).charAt(n3 + 5));
        ((ByteBuffer)object).putShort(16, (short)((String)object2).charAt(n3 + 6));
        ((ByteBuffer)object).putShort(18, (short)((String)object2).charAt(n3 + 7));
        ((ByteBuffer)object).putShort(20, (short)((String)object2).charAt(n3 + 8));
        ((ByteBuffer)object).putShort(22, (short)((String)object2).charAt(n3 + 9));
        ((ByteBuffer)object).putShort(24, (short)((String)object2).charAt(n3 + 10));
        ((ByteBuffer)object).putShort(26, (short)0);
        ((ByteBuffer)object).putShort(28, (short)((String)object2).charAt(n3 + 11));
        ((ByteBuffer)object).putShort(30, (short)((String)object2).charAt(n3 + 12));
        fatDirectoryEntry.data = object;
        return fatDirectoryEntry;
    }

    static FatDirectoryEntry createNew() {
        FatDirectoryEntry fatDirectoryEntry = new FatDirectoryEntry();
        fatDirectoryEntry.data = ByteBuffer.allocate(32);
        long l = System.currentTimeMillis();
        fatDirectoryEntry.setCreatedDateTime(l);
        fatDirectoryEntry.setLastAccessedDateTime(l);
        fatDirectoryEntry.setLastModifiedDateTime(l);
        return fatDirectoryEntry;
    }

    static FatDirectoryEntry createVolumeLabel(String string2) {
        FatDirectoryEntry fatDirectoryEntry = new FatDirectoryEntry();
        ByteBuffer byteBuffer = ByteBuffer.allocate(32);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        System.arraycopy(string2.getBytes(Charset.forName("ASCII")), 0, byteBuffer.array(), 0, string2.length());
        fatDirectoryEntry.data = byteBuffer;
        fatDirectoryEntry.setFlag(8);
        return fatDirectoryEntry;
    }

    private static long decodeDateTime(int n, int n2) {
        Calendar calendar = Calendar.getInstance(FileSystemFactory.getTimeZone());
        calendar.set(1, (n >> 9) + 1980);
        calendar.set(2, (n >> 5 & 0xF) - 1);
        calendar.set(5, n & 0x1F);
        calendar.set(11, n2 >> 11);
        calendar.set(12, n2 >> 5 & 0x3F);
        calendar.set(13, (n2 & 0x1F) * 2);
        return calendar.getTimeInMillis();
    }

    private static int encodeDate(long l) {
        Calendar calendar = Calendar.getInstance(FileSystemFactory.getTimeZone());
        calendar.setTimeInMillis(l);
        return (calendar.get(1) - 1980 << 9) + (calendar.get(2) + 1 << 5) + calendar.get(5);
    }

    private static int encodeTime(long l) {
        Calendar calendar = Calendar.getInstance(FileSystemFactory.getTimeZone());
        calendar.setTimeInMillis(l);
        return (calendar.get(11) << 11) + (calendar.get(12) << 5) + calendar.get(13) / 2;
    }

    private int getFlags() {
        return this.data.get(11);
    }

    private int getUnsignedInt16(int n) {
        byte by = this.data.get(n);
        return (this.data.get(n + 1) & 0xFF) << 8 | by & 0xFF;
    }

    private long getUnsignedInt32(int n) {
        return (long)(this.data.get(n) & 0xFF) | ((long)(this.data.get(n + 1) & 0xFF) << 8 | ((long)(this.data.get(n + 2) & 0xFF) << 16 | (long)(this.data.get(n + 3) & 0xFF) << 24));
    }

    private int getUnsignedInt8(int n) {
        return this.data.get(n) & 0xFF;
    }

    private boolean isFlagSet(int n) {
        boolean bl = (n & this.getFlags()) != 0;
        return bl;
    }

    static FatDirectoryEntry read(ByteBuffer byteBuffer) {
        byte[] byArray = new byte[32];
        if (byteBuffer.get(byteBuffer.position()) == 0) {
            return null;
        }
        byteBuffer.get(byArray);
        return new FatDirectoryEntry(ByteBuffer.wrap(byArray));
    }

    private void setFlag(int n) {
        int n2 = this.getFlags();
        this.data.put(11, (byte)(n | n2));
    }

    private void setUnsignedInt16(int n, int n2) {
        this.data.put(n, (byte)(n2 & 0xFF));
        this.data.put(n + 1, (byte)(n2 >>> 8 & 0xFF));
    }

    private void setUnsignedInt32(int n, long l) {
        this.data.put(n, (byte)(l & 0xFFL));
        this.data.put(n + 1, (byte)(l >>> 8 & 0xFFL));
        this.data.put(n + 2, (byte)(l >>> 16 & 0xFFL));
        this.data.put(n + 3, (byte)(l >>> 24 & 0xFFL));
    }

    void extractLfnPart(StringBuilder stringBuilder) {
        int n;
        char[] cArray = new char[]{(char)this.data.getShort(1), (char)this.data.getShort(3), (char)this.data.getShort(5), (char)this.data.getShort(7), (char)this.data.getShort(9), (char)this.data.getShort(14), (char)this.data.getShort(16), (char)this.data.getShort(18), (char)this.data.getShort(20), (char)this.data.getShort(22), (char)this.data.getShort(24), (char)this.data.getShort(28), (char)this.data.getShort(30)};
        for (n = 0; n < 13 && cArray[n] != '\u0000'; ++n) {
        }
        stringBuilder.append(cArray, 0, n);
    }

    long getCreatedDateTime() {
        return FatDirectoryEntry.decodeDateTime(this.getUnsignedInt16(16), this.getUnsignedInt16(14));
    }

    long getFileSize() {
        return this.getUnsignedInt32(28);
    }

    long getLastAccessedDateTime() {
        return FatDirectoryEntry.decodeDateTime(this.getUnsignedInt16(18), 0);
    }

    long getLastModifiedDateTime() {
        return FatDirectoryEntry.decodeDateTime(this.getUnsignedInt16(24), this.getUnsignedInt16(22));
    }

    ShortName getShortName() {
        if (this.data.get(0) == 0) {
            return null;
        }
        return this.shortName;
    }

    long getStartCluster() {
        int n = this.getUnsignedInt16(20);
        int n2 = this.getUnsignedInt16(26);
        long l = n;
        return (long)n2 | l << 16;
    }

    String getVolumeLabel() {
        byte by;
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < 11 && (by = this.data.get(i)) != 0; ++i) {
            stringBuilder.append((char)by);
        }
        return stringBuilder.toString();
    }

    boolean isArchive() {
        return this.isFlagSet(32);
    }

    boolean isDeleted() {
        boolean bl = false;
        if (this.getUnsignedInt8(0) == 229) {
            bl = true;
        }
        return bl;
    }

    boolean isDirectory() {
        boolean bl = (this.getFlags() & 0x18) == 16;
        return bl;
    }

    boolean isHidden() {
        return this.isFlagSet(2);
    }

    boolean isLfnEntry() {
        boolean bl = this.isHidden() && this.isVolume() && this.isReadOnly() && this.isSystem();
        return bl;
    }

    boolean isReadOnly() {
        return this.isFlagSet(1);
    }

    boolean isShortNameExtLowerCase() {
        boolean bl = (this.data.get(12) & 0x10) != 0;
        return bl;
    }

    boolean isShortNameLowerCase() {
        boolean bl = (this.data.get(12) & 8) != 0;
        return bl;
    }

    boolean isSystem() {
        return this.isFlagSet(4);
    }

    boolean isVolume() {
        return this.isFlagSet(8);
    }

    boolean isVolumeLabel() {
        boolean bl = this.isLfnEntry();
        boolean bl2 = false;
        if (bl) {
            return false;
        }
        if ((this.getFlags() & 0x18) == 8) {
            bl2 = true;
        }
        return bl2;
    }

    void serialize(ByteBuffer byteBuffer) {
        byteBuffer.put(this.data.array());
    }

    void setCreatedDateTime(long l) {
        this.setUnsignedInt16(16, FatDirectoryEntry.encodeDate(l));
        this.setUnsignedInt16(14, FatDirectoryEntry.encodeTime(l));
    }

    void setDirectory() {
        this.setFlag(16);
    }

    void setFileSize(long l) {
        this.setUnsignedInt32(28, l);
    }

    void setLastAccessedDateTime(long l) {
        this.setUnsignedInt16(18, FatDirectoryEntry.encodeDate(l));
    }

    void setLastModifiedDateTime(long l) {
        this.setUnsignedInt16(24, FatDirectoryEntry.encodeDate(l));
        this.setUnsignedInt16(22, FatDirectoryEntry.encodeTime(l));
    }

    void setShortName(ShortName shortName) {
        this.shortName = shortName;
        shortName.serialize(this.data);
        this.data.clear();
    }

    void setStartCluster(long l) {
        this.setUnsignedInt16(20, (int)(l >> 16 & 0xFFFFL));
        this.setUnsignedInt16(26, (int)(l & 0xFFFFL));
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[FatDirectoryEntry shortName=");
        stringBuilder.append(this.shortName.getString());
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

