/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjdev.libaums.fs.fat32;

import com.github.mjdev.libaums.driver.BlockDeviceDriver;
import com.github.mjdev.libaums.fs.AbstractUsbFile;
import com.github.mjdev.libaums.fs.UsbFile;
import com.github.mjdev.libaums.fs.fat32.ClusterChain;
import com.github.mjdev.libaums.fs.fat32.FAT;
import com.github.mjdev.libaums.fs.fat32.Fat32BootSector;
import com.github.mjdev.libaums.fs.fat32.FatDirectory;
import com.github.mjdev.libaums.fs.fat32.FatLfnDirectoryEntry;
import java.io.IOException;
import java.nio.ByteBuffer;

public class FatFile
extends AbstractUsbFile {
    private BlockDeviceDriver blockDevice;
    private Fat32BootSector bootSector;
    private ClusterChain chain;
    private FatLfnDirectoryEntry entry;
    private FAT fat;
    private FatDirectory parent;

    private FatFile(BlockDeviceDriver blockDeviceDriver, FAT fAT, Fat32BootSector fat32BootSector, FatLfnDirectoryEntry fatLfnDirectoryEntry, FatDirectory fatDirectory) {
        this.blockDevice = blockDeviceDriver;
        this.fat = fAT;
        this.bootSector = fat32BootSector;
        this.entry = fatLfnDirectoryEntry;
        this.parent = fatDirectory;
    }

    public static FatFile create(FatLfnDirectoryEntry fatLfnDirectoryEntry, BlockDeviceDriver blockDeviceDriver, FAT fAT, Fat32BootSector fat32BootSector, FatDirectory fatDirectory) throws IOException {
        return new FatFile(blockDeviceDriver, fAT, fat32BootSector, fatLfnDirectoryEntry, fatDirectory);
    }

    private void initChain() throws IOException {
        if (this.chain == null) {
            this.chain = new ClusterChain(this.entry.getStartCluster(), this.blockDevice, this.fat, this.bootSector);
        }
    }

    @Override
    public void close() throws IOException {
        this.flush();
    }

    @Override
    public UsbFile createDirectory(String string2) throws IOException {
        throw new UnsupportedOperationException("This is a file!");
    }

    @Override
    public UsbFile createFile(String string2) throws IOException {
        throw new UnsupportedOperationException("This is a file!");
    }

    @Override
    public long createdAt() {
        return this.entry.getActualEntry().getCreatedDateTime();
    }

    @Override
    public void delete() throws IOException {
        this.initChain();
        this.parent.removeEntry(this.entry);
        this.parent.write();
        this.chain.setLength(0L);
    }

    @Override
    public void flush() throws IOException {
        this.parent.write();
    }

    @Override
    public long getLength() {
        return this.entry.getFileSize();
    }

    @Override
    public String getName() {
        return this.entry.getName();
    }

    @Override
    public UsbFile getParent() {
        return this.parent;
    }

    @Override
    public boolean isDirectory() {
        return false;
    }

    @Override
    public boolean isRoot() {
        return false;
    }

    @Override
    public long lastAccessed() {
        return this.entry.getActualEntry().getLastAccessedDateTime();
    }

    @Override
    public long lastModified() {
        return this.entry.getActualEntry().getLastModifiedDateTime();
    }

    @Override
    public String[] list() {
        throw new UnsupportedOperationException("This is a file!");
    }

    @Override
    public UsbFile[] listFiles() throws IOException {
        throw new UnsupportedOperationException("This is a file!");
    }

    @Override
    public void moveTo(UsbFile usbFile) throws IOException {
        this.parent.move(this.entry, usbFile);
        this.parent = (FatDirectory)usbFile;
    }

    @Override
    public void read(long l, ByteBuffer byteBuffer) throws IOException {
        this.initChain();
        this.entry.setLastAccessedTimeToNow();
        this.chain.read(l, byteBuffer);
    }

    @Override
    public void setLength(long l) throws IOException {
        this.initChain();
        this.chain.setLength(l);
        this.entry.setFileSize(l);
    }

    @Override
    public void setName(String string2) throws IOException {
        this.parent.renameEntry(this.entry, string2);
    }

    @Override
    public void write(long l, ByteBuffer byteBuffer) throws IOException {
        this.initChain();
        long l2 = (long)byteBuffer.remaining() + l;
        if (l2 > this.getLength()) {
            this.setLength(l2);
        }
        this.entry.setLastModifiedTimeToNow();
        this.chain.write(l, byteBuffer);
    }
}

