/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjdev.libaums.fs.fat32;

import com.github.mjdev.libaums.fs.fat32.FatDirectoryEntry;
import com.github.mjdev.libaums.fs.fat32.ShortName;
import java.nio.ByteBuffer;
import java.util.List;

class FatLfnDirectoryEntry {
    private FatDirectoryEntry actualEntry;
    private String lfnName;

    private FatLfnDirectoryEntry() {
    }

    private FatLfnDirectoryEntry(FatDirectoryEntry fatDirectoryEntry, String string2) {
        this.actualEntry = fatDirectoryEntry;
        this.lfnName = string2;
    }

    static void copyDateTime(FatLfnDirectoryEntry object, FatLfnDirectoryEntry object2) {
        object2 = ((FatLfnDirectoryEntry)object).getActualEntry();
        object = ((FatLfnDirectoryEntry)object).getActualEntry();
        ((FatDirectoryEntry)object).setCreatedDateTime(((FatDirectoryEntry)object2).getCreatedDateTime());
        ((FatDirectoryEntry)object).setLastAccessedDateTime(((FatDirectoryEntry)object2).getLastAccessedDateTime());
        ((FatDirectoryEntry)object).setLastModifiedDateTime(((FatDirectoryEntry)object2).getLastModifiedDateTime());
    }

    static FatLfnDirectoryEntry createNew(String object, ShortName shortName) {
        FatLfnDirectoryEntry fatLfnDirectoryEntry = new FatLfnDirectoryEntry();
        fatLfnDirectoryEntry.lfnName = object;
        fatLfnDirectoryEntry.actualEntry = object = FatDirectoryEntry.createNew();
        ((FatDirectoryEntry)object).setShortName(shortName);
        return fatLfnDirectoryEntry;
    }

    static FatLfnDirectoryEntry read(FatDirectoryEntry fatDirectoryEntry, List<FatDirectoryEntry> list) {
        StringBuilder stringBuilder = new StringBuilder(list.size() * 13);
        if (list.size() > 0) {
            for (int i = list.size() - 1; i >= 0; --i) {
                list.get(i).extractLfnPart(stringBuilder);
            }
            return new FatLfnDirectoryEntry(fatDirectoryEntry, stringBuilder.toString());
        }
        return new FatLfnDirectoryEntry(fatDirectoryEntry, null);
    }

    FatDirectoryEntry getActualEntry() {
        return this.actualEntry;
    }

    int getEntryCount() {
        String string2 = this.lfnName;
        int n = 1;
        if (string2 != null) {
            int n2;
            int n3 = string2.length();
            n = n2 = 1 + n3 / 13;
            if (n3 % 13 != 0) {
                n = n2 + 1;
            }
        }
        return n;
    }

    long getFileSize() {
        return this.actualEntry.getFileSize();
    }

    String getName() {
        Object object;
        Object object2 = this.lfnName;
        if (object2 != null) {
            return object2;
        }
        String string2 = this.actualEntry.getShortName().getString();
        object2 = string2.split(".");
        if (((String[])object2).length == 2) {
            string2 = object2[0];
            object = object2[0];
        } else {
            object = "";
        }
        object2 = string2;
        if (this.actualEntry.isShortNameLowerCase()) {
            object2 = string2.toLowerCase();
        }
        string2 = object;
        if (this.actualEntry.isShortNameExtLowerCase()) {
            string2 = ((String)object).toLowerCase();
        }
        object = object2;
        if (!string2.isEmpty()) {
            object = new StringBuilder();
            ((StringBuilder)object).append((String)object2);
            ((StringBuilder)object).append(".");
            ((StringBuilder)object).append(string2);
            object = ((StringBuilder)object).toString();
        }
        return object;
    }

    long getStartCluster() {
        return this.actualEntry.getStartCluster();
    }

    boolean isDirectory() {
        return this.actualEntry.isDirectory();
    }

    void serialize(ByteBuffer byteBuffer) {
        if (this.lfnName != null) {
            byte by = this.actualEntry.getShortName().calculateCheckSum();
            int n = this.getEntryCount() - 2;
            FatDirectoryEntry.createLfnPart(this.lfnName, n * 13, by, n + 1, true).serialize(byteBuffer);
            while (true) {
                int n2 = n - 1;
                if (n <= 0) break;
                FatDirectoryEntry.createLfnPart(this.lfnName, n2 * 13, by, n2 + 1, false).serialize(byteBuffer);
                n = n2;
            }
        }
        this.actualEntry.serialize(byteBuffer);
    }

    void setDirectory() {
        this.actualEntry.setDirectory();
    }

    void setFileSize(long l) {
        this.actualEntry.setFileSize(l);
    }

    void setLastAccessedTimeToNow() {
        this.actualEntry.setLastAccessedDateTime(System.currentTimeMillis());
    }

    void setLastModifiedTimeToNow() {
        this.actualEntry.setLastModifiedDateTime(System.currentTimeMillis());
    }

    void setName(String string2, ShortName shortName) {
        this.lfnName = string2;
        this.actualEntry.setShortName(shortName);
    }

    void setStartCluster(long l) {
        this.actualEntry.setStartCluster(l);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[FatLfnDirectoryEntry getName()=");
        stringBuilder.append(this.getName());
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

