/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjdev.libaums.fs.fat32;

import android.util.Log;
import com.github.mjdev.libaums.driver.BlockDeviceDriver;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

class FsInfoStructure {
    private static int FREE_COUNT_OFF = 488;
    static int INVALID_VALUE = -1;
    private static int LEAD_SIGNATURE = 1096897106;
    private static int LEAD_SIGNATURE_OFF = 0;
    private static int NEXT_FREE_OFFSET = 492;
    private static int STRUCT_SIGNATURE = 1631679090;
    private static int STRUCT_SIGNATURE_OFF = 484;
    private static final String TAG = "FsInfoStructure";
    private static int TRAIL_SIGNATURE = -1437270016;
    private static int TRAIL_SIGNATURE_OFF = 508;
    private BlockDeviceDriver blockDevice;
    private ByteBuffer buffer;
    private int offset;

    private FsInfoStructure(BlockDeviceDriver blockDeviceDriver, int n) throws IOException {
        ByteBuffer byteBuffer;
        this.blockDevice = blockDeviceDriver;
        this.offset = n;
        this.buffer = byteBuffer = ByteBuffer.allocate(512);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        blockDeviceDriver.read(n, this.buffer);
        this.buffer.clear();
        if (this.buffer.getInt(LEAD_SIGNATURE_OFF) == LEAD_SIGNATURE && this.buffer.getInt(STRUCT_SIGNATURE_OFF) == STRUCT_SIGNATURE && this.buffer.getInt(TRAIL_SIGNATURE_OFF) == TRAIL_SIGNATURE) {
            return;
        }
        throw new IOException("invalid fs info structure!");
    }

    static FsInfoStructure read(BlockDeviceDriver blockDeviceDriver, int n) throws IOException {
        return new FsInfoStructure(blockDeviceDriver, n);
    }

    void decreaseClusterCount(long l) {
        long l2 = this.getFreeClusterCount();
        if (l2 != (long)INVALID_VALUE) {
            this.setFreeClusterCount(l2 - l);
        }
    }

    long getFreeClusterCount() {
        return this.buffer.getInt(FREE_COUNT_OFF);
    }

    long getLastAllocatedClusterHint() {
        return this.buffer.getInt(NEXT_FREE_OFFSET);
    }

    void setFreeClusterCount(long l) {
        this.buffer.putInt(FREE_COUNT_OFF, (int)l);
    }

    void setLastAllocatedClusterHint(long l) {
        this.buffer.putInt(NEXT_FREE_OFFSET, (int)l);
    }

    void write() throws IOException {
        Log.d((String)TAG, (String)"writing to device");
        this.blockDevice.write(this.offset, this.buffer);
        this.buffer.clear();
    }
}

