/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjdev.libaums.fs.fat32;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;

class ShortName {
    private static int SIZE = 11;
    private ByteBuffer data;

    ShortName(String string2, String string3) {
        byte[] byArray = new byte[SIZE];
        Arrays.fill(byArray, (byte)32);
        int n = Math.min(string2.length(), 8);
        System.arraycopy(string2.getBytes(Charset.forName("ASCII")), 0, byArray, 0, n);
        System.arraycopy(string3.getBytes(Charset.forName("ASCII")), 0, byArray, 8, string3.length());
        if (byArray[0] == 229) {
            byArray[0] = (byte)5;
        }
        this.data = ByteBuffer.wrap(byArray);
    }

    private ShortName(ByteBuffer byteBuffer) {
        this.data = byteBuffer;
    }

    static ShortName parse(ByteBuffer byteBuffer) {
        byte[] byArray = new byte[SIZE];
        byteBuffer.get(byArray);
        return new ShortName(ByteBuffer.wrap(byArray));
    }

    byte calculateCheckSum() {
        int n = 0;
        for (int i = 0; i < SIZE; ++i) {
            int n2 = n & true ? 128 : 0;
            n = this.data.get(i) + (n2 + ((n & 0xFF) >> 1));
        }
        return (byte)(n & 0xFF);
    }

    public boolean equals(Object object) {
        if (!(object instanceof ShortName)) {
            return false;
        }
        return Arrays.equals(this.data.array(), ((ShortName)object).data.array());
    }

    String getString() {
        int n;
        Object object = new char[8];
        Object object2 = new char[3];
        int n2 = 0;
        for (n = 0; n < 8; ++n) {
            object[n] = (char)(this.data.get(n) & 0xFF);
        }
        n = n2;
        if (this.data.get(0) == 5) {
            object[0] = (char)229;
            n = n2;
        }
        while (n < 3) {
            object2[n] = (char)(this.data.get(n + 8) & 0xFF);
            ++n;
        }
        object = new String((char[])object).trim();
        if (!((String)(object2 = (Object)new String((char[])object2).trim())).isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append((String)object);
            stringBuilder.append(".");
            stringBuilder.append((String)object2);
            object = stringBuilder.toString();
        }
        return object;
    }

    void serialize(ByteBuffer byteBuffer) {
        byteBuffer.put(this.data.array(), 0, SIZE);
    }

    public String toString() {
        return this.getString();
    }
}

