/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjdev.libaums.partition;

import com.github.mjdev.libaums.driver.BlockDeviceDriver;
import com.github.mjdev.libaums.partition.PartitionTable;
import com.github.mjdev.libaums.partition.fs.FileSystemPartitionTableCreator;
import com.github.mjdev.libaums.partition.mbr.MasterBootRecordCreator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class PartitionTableFactory {
    private static List<PartitionTableCreator> partitionTables = new ArrayList<PartitionTableCreator>();

    static {
        PartitionTableFactory.registerPartitionTable(new FileSystemPartitionTableCreator());
        PartitionTableFactory.registerPartitionTable(new MasterBootRecordCreator());
    }

    public static PartitionTable createPartitionTable(BlockDeviceDriver blockDeviceDriver) throws IOException {
        Iterator<PartitionTableCreator> iterator2 = partitionTables.iterator();
        while (iterator2.hasNext()) {
            PartitionTable partitionTable = iterator2.next().read(blockDeviceDriver);
            if (partitionTable == null) continue;
            return partitionTable;
        }
        throw new UnsupportedPartitionTableException();
    }

    public static void registerPartitionTable(PartitionTableCreator partitionTableCreator) {
        synchronized (PartitionTableFactory.class) {
            partitionTables.add(partitionTableCreator);
            return;
        }
    }

    public static interface PartitionTableCreator {
        public PartitionTable read(BlockDeviceDriver var1) throws IOException;
    }

    public static class UnsupportedPartitionTableException
    extends IOException {
    }
}

