/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjdev.libaums.usb;

import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbEndpoint;
import com.github.mjdev.libaums.usb.UsbCommunication;
import java.io.IOException;
import java.nio.ByteBuffer;

class HoneyCombMr1Communication
implements UsbCommunication {
    private UsbDeviceConnection deviceConnection;
    private UsbEndpoint inEndpoint;
    private UsbEndpoint outEndpoint;

    HoneyCombMr1Communication(UsbDeviceConnection usbDeviceConnection, UsbEndpoint usbEndpoint, UsbEndpoint usbEndpoint2) {
        this.deviceConnection = usbDeviceConnection;
        this.outEndpoint = usbEndpoint;
        this.inEndpoint = usbEndpoint2;
    }

    @Override
    public int bulkInTransfer(ByteBuffer byteBuffer) throws IOException {
        int n = byteBuffer.position();
        if (n == 0) {
            int n2 = this.deviceConnection.bulkTransfer(this.inEndpoint, byteBuffer.array(), byteBuffer.remaining(), 5000);
            if (n2 != -1) {
                byteBuffer.position(byteBuffer.position() + n2);
                return n2;
            }
            throw new IOException("Could read from to device, result == -1");
        }
        byte[] byArray = new byte[byteBuffer.remaining()];
        int n3 = this.deviceConnection.bulkTransfer(this.inEndpoint, byArray, byteBuffer.remaining(), 5000);
        if (n3 != -1) {
            System.arraycopy(byArray, 0, byteBuffer.array(), n, n3);
            byteBuffer.position(byteBuffer.position() + n3);
            return n3;
        }
        throw new IOException("Could not read from device, result == -1");
    }

    @Override
    public int bulkOutTransfer(ByteBuffer byteBuffer) throws IOException {
        int n = byteBuffer.position();
        if (n == 0) {
            n = this.deviceConnection.bulkTransfer(this.outEndpoint, byteBuffer.array(), byteBuffer.remaining(), 5000);
            if (n != -1) {
                byteBuffer.position(byteBuffer.position() + n);
                return n;
            }
            throw new IOException("Could not write to device, result == -1");
        }
        byte[] byArray = new byte[byteBuffer.remaining()];
        System.arraycopy(byteBuffer.array(), n, byArray, 0, byteBuffer.remaining());
        n = this.deviceConnection.bulkTransfer(this.outEndpoint, byArray, byteBuffer.remaining(), 5000);
        if (n != -1) {
            byteBuffer.position(byteBuffer.position() + n);
            return n;
        }
        throw new IOException("Could not write to device, result == -1");
    }
}

