/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjdev.libaums.usb;

import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbEndpoint;
import android.hardware.usb.UsbRequest;
import com.github.mjdev.libaums.usb.UsbCommunication;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;

class UsbRequestCommunication
implements UsbCommunication {
    private UsbDeviceConnection deviceConnection;
    private UsbRequest inRequest;
    private UsbRequest outRequest;
    private ByteBuffer workaroundBuffer = ByteBuffer.allocate(131072);

    UsbRequestCommunication(UsbDeviceConnection usbDeviceConnection, UsbEndpoint usbEndpoint, UsbEndpoint usbEndpoint2) {
        this.deviceConnection = usbDeviceConnection;
        UsbRequest usbRequest = new UsbRequest();
        usbRequest.initialize(usbDeviceConnection, usbEndpoint);
        this.outRequest = usbRequest;
        usbEndpoint = new UsbRequest();
        usbEndpoint.initialize(usbDeviceConnection, usbEndpoint2);
        this.inRequest = usbEndpoint;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int bulkInTransfer(ByteBuffer object) throws IOException {
        synchronized (this) {
            int n = ((Buffer)object).remaining();
            this.workaroundBuffer.clear();
            this.workaroundBuffer.limit(n);
            if (!this.inRequest.queue(this.workaroundBuffer, n)) {
                object = new IOException("Error queueing request.");
                throw object;
            }
            UsbRequest usbRequest = this.deviceConnection.requestWait();
            if (usbRequest == this.inRequest) {
                this.workaroundBuffer.flip();
                ((ByteBuffer)object).put(this.workaroundBuffer);
                return this.workaroundBuffer.limit();
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("requestWait failed! Request: ");
            stringBuilder.append(usbRequest);
            object = new IOException(stringBuilder.toString());
            throw object;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int bulkOutTransfer(ByteBuffer object) throws IOException {
        synchronized (this) {
            int n = ((Buffer)object).remaining();
            int n2 = ((Buffer)object).position();
            this.workaroundBuffer.clear();
            this.workaroundBuffer.put((ByteBuffer)object);
            if (!this.outRequest.queue(this.workaroundBuffer, n)) {
                object = new IOException("Error queueing request.");
                throw object;
            }
            UsbRequest usbRequest = this.deviceConnection.requestWait();
            if (usbRequest == this.outRequest) {
                ((ByteBuffer)object).position(n2 + this.workaroundBuffer.position());
                return this.workaroundBuffer.position();
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("requestWait failed! Request: ");
            stringBuilder.append(usbRequest);
            object = new IOException(stringBuilder.toString());
            throw object;
        }
    }
}

