/*
 * Decompiled with CFR 0.152.
 */
package com.gogolook.developmode;

import android.app.AlarmManager;
import android.app.AlertDialog;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.net.TrafficStats;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Environment;
import android.os.Handler;
import android.os.Message;
import android.os.Process;
import android.preference.PreferenceManager;
import android.telephony.TelephonyManager;
import android.util.Pair;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.ArrayAdapter;
import android.widget.EditText;
import android.widget.ListAdapter;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.gogolook.developmode.DevConfig;
import com.gogolook.developmode.DevShowLogsActivity;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Stack;
import java.util.Timer;
import java.util.TimerTask;

public class BasicDevelopMode {
    public static final String DEFAULT = "default";
    public static String DEVELOP_PASSWORD = "123#321#123";
    protected static final String SP_NAME = "share_pref";
    private static BasicDevelopMode sDevelopMode;
    protected Stack<Pair<Date, Long>> mByteCountStack = new Stack();
    protected Context mContext;
    protected DiagramView mDiagramView;
    protected boolean mIsEnable = false;
    protected boolean mIsInit = false;
    protected int mMaxNetworkTraffic = 800;
    protected Timer mNetworkTimer;
    protected SharedPreferences mSharedPreference;

    private DiagramView createMonitorView() {
        DiagramView diagramView = new DiagramView(this.mContext);
        WindowManager windowManager = (WindowManager)this.mContext.getSystemService("window");
        WindowManager.LayoutParams layoutParams = new WindowManager.LayoutParams();
        layoutParams.type = 2002;
        layoutParams.format = 1;
        layoutParams.flags = 40;
        layoutParams.gravity = 85;
        layoutParams.width = this.mContext.getResources().getDisplayMetrics().widthPixels / 2;
        layoutParams.height = this.mContext.getResources().getDisplayMetrics().heightPixels / 10;
        windowManager.addView((View)diagramView, (ViewGroup.LayoutParams)layoutParams);
        return diagramView;
    }

    private void exportData(final Context context, String string2) {
        new AsyncTask<String, Void, File>(){
            private ProgressDialog progressDialog;

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            protected File doInBackground(String ... object) {
                Object object2;
                object = Uri.parse((String)object[0]);
                Object object3 = context.getContentResolver().query((Uri)object, null, null, null, null);
                try {
                    object3 = object = context.getContentResolver().query((Uri)object, null, null, null, "date desc");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                object = object2 = "";
                if (object3 != null) {
                    int n;
                    String[] stringArray = object3.getColumnNames();
                    object = object2;
                    for (n = 0; n < stringArray.length; ++n) {
                        object2 = new StringBuilder();
                        ((StringBuilder)object2).append((String)object);
                        ((StringBuilder)object2).append(stringArray[n]);
                        ((StringBuilder)object2).append(",");
                        object = ((StringBuilder)object2).toString();
                    }
                    object2 = new StringBuilder();
                    ((StringBuilder)object2).append((String)object);
                    ((StringBuilder)object2).append("\n");
                    object = ((StringBuilder)object2).toString();
                    for (n = 0; n < object3.getCount() && n < 300; ++n) {
                        object3.moveToPosition(n);
                        for (int i = 0; i < object3.getColumnCount(); ++i) {
                            object2 = new StringBuilder();
                            ((StringBuilder)object2).append((String)object);
                            ((StringBuilder)object2).append(object3.getString(i));
                            ((StringBuilder)object2).append(",");
                            object = ((StringBuilder)object2).toString();
                        }
                        object2 = new StringBuilder();
                        ((StringBuilder)object2).append((String)object);
                        ((StringBuilder)object2).append("\n");
                        object = ((StringBuilder)object2).toString();
                    }
                    object3.close();
                }
                if (Environment.getExternalStorageState().equals("mounted")) {
                    object2 = context.getExternalCacheDir().getAbsolutePath();
                    object3 = new StringBuilder();
                    ((StringBuilder)object3).append("/db_");
                    ((StringBuilder)object3).append(Build.MODEL);
                    ((StringBuilder)object3).append("_");
                    ((StringBuilder)object3).append(Build.MANUFACTURER);
                    ((StringBuilder)object3).append(".csv");
                    object3 = new File((String)object2, ((StringBuilder)object3).toString());
                } else {
                    object2 = context.getCacheDir().getAbsolutePath();
                    object3 = new StringBuilder();
                    ((StringBuilder)object3).append("/db_");
                    ((StringBuilder)object3).append(Build.MODEL);
                    ((StringBuilder)object3).append("_");
                    ((StringBuilder)object3).append(Build.MANUFACTURER);
                    ((StringBuilder)object3).append(".csv");
                    object3 = new File((String)object2, ((StringBuilder)object3).toString());
                }
                if (((File)object3).exists()) {
                    ((File)object3).delete();
                }
                try {
                    ((File)object3).createNewFile();
                }
                catch (IOException iOException) {}
                try {
                    object2 = new FileOutputStream(((File)object3).getAbsolutePath());
                    ((FileOutputStream)object2).write(((String)object).getBytes());
                    ((FileOutputStream)object2).close();
                    return object3;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                return object3;
            }

            protected void onPostExecute(File file) {
                this.progressDialog.dismiss();
                Intent intent = new Intent("android.intent.action.SEND_MULTIPLE");
                intent.setType("plain/text");
                intent.putExtra("android.intent.extra.EMAIL", DevConfig.RECIEVERS);
                Serializable serializable = new StringBuilder();
                ((StringBuilder)serializable).append("[CallLog Report][");
                ((StringBuilder)serializable).append((Object)context.getApplicationInfo().loadLabel(context.getPackageManager()));
                ((StringBuilder)serializable).append("][");
                ((StringBuilder)serializable).append(Build.MODEL);
                ((StringBuilder)serializable).append(" - ");
                ((StringBuilder)serializable).append(Build.MANUFACTURER);
                ((StringBuilder)serializable).append("]");
                intent.putExtra("android.intent.extra.SUBJECT", ((StringBuilder)serializable).toString());
                intent.putExtra("android.intent.extra.TEXT", BasicDevelopMode.getReportString(BasicDevelopMode.this.mContext));
                serializable = new ArrayList();
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("file://");
                stringBuilder.append(file.getAbsolutePath());
                ((ArrayList)serializable).add(Uri.parse((String)stringBuilder.toString()));
                intent.putParcelableArrayListExtra("android.intent.extra.STREAM", (ArrayList)serializable);
                intent.setFlags(0x10000000);
                BasicDevelopMode.this.mContext.startActivity(intent);
            }

            protected void onPreExecute() {
                ProgressDialog progressDialog;
                this.progressDialog = progressDialog = new ProgressDialog(context);
                progressDialog.setMessage((CharSequence)"Exporting...");
                this.progressDialog.show();
            }
        }.execute((Object[])new String[]{string2});
    }

    public static BasicDevelopMode getInstance() {
        if (sDevelopMode == null) {
            sDevelopMode = new BasicDevelopMode();
        }
        return sDevelopMode;
    }

    private Pair<Date, Long> getMaxByteCount() {
        if (this.mByteCountStack.size() == 0) {
            return null;
        }
        ArrayList<Pair<Date, Long>> arrayList = new ArrayList<Pair<Date, Long>>();
        arrayList.addAll(this.mByteCountStack);
        Collections.sort(arrayList, new Comparator<Pair<Date, Long>>(){

            @Override
            public int compare(Pair<Date, Long> pair, Pair<Date, Long> pair2) {
                if ((Long)pair.second > (Long)pair2.second) {
                    return -1;
                }
                if ((Long)pair.second < (Long)pair2.second) {
                    return 1;
                }
                return 0;
            }
        });
        return (Pair)arrayList.get(0);
    }

    private Pair<Date, Long> getMinByteCount() {
        if (this.mByteCountStack.size() == 0) {
            return null;
        }
        ArrayList<Pair<Date, Long>> arrayList = new ArrayList<Pair<Date, Long>>();
        arrayList.addAll(this.mByteCountStack);
        Collections.sort(arrayList, new Comparator<Pair<Date, Long>>(){

            @Override
            public int compare(Pair<Date, Long> pair, Pair<Date, Long> pair2) {
                if ((Long)pair.second > (Long)pair2.second) {
                    return 1;
                }
                if ((Long)pair.second < (Long)pair2.second) {
                    return -1;
                }
                return 0;
            }
        });
        return (Pair)arrayList.get(0);
    }

    private static String getReportString(Context context) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Device: ");
        stringBuilder.append(Build.MODEL);
        stringBuilder.append("\nDisplay: ");
        stringBuilder.append(Build.DISPLAY);
        stringBuilder.append("\nVersion: ");
        stringBuilder.append(BasicDevelopMode.getVersionName(context));
        stringBuilder.append("\nAndroid API: ");
        stringBuilder.append(Build.VERSION.SDK_INT);
        return stringBuilder.toString();
    }

    private static String getVersionName(Context object) {
        try {
            object = object.getPackageManager().getPackageInfo((String)object.getPackageName(), (int)0).versionName;
            return object;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return "";
        }
    }

    public void applyCurrentLanguage() {
        this.checkIsInit();
        Object object = PreferenceManager.getDefaultSharedPreferences((Context)this.mContext).getString("develop_language_preference", DEFAULT);
        object = ((String)object).equals("ar") ? new Locale("ar") : (((String)object).equals("ja-rJP") ? new Locale("ja", "JP") : (((String)object).equals("ko-rKR") ? new Locale("ko", "KR") : (((String)object).equals("ru") ? new Locale("ru", "RU") : (((String)object).equals("zh-rCN") ? new Locale("zh", "CN") : (((String)object).equals("zh-rHK") ? new Locale("zh", "HK") : (((String)object).equals("zh-rTW") ? new Locale("zh", "TW") : (((String)object).equals("en-rUS") ? new Locale("en", "US") : (((String)object).equals("th") ? new Locale("th") : (((String)object).equals("in") ? new Locale("in") : (((String)object).equals("vi") ? new Locale("vi") : (((String)object).equals("fr") ? new Locale("fr") : (((String)object).equals("id") ? new Locale("id") : (((String)object).equals("it") ? new Locale("it") : (((String)object).equals("ms") ? new Locale("ms") : (((String)object).equals("pt") ? new Locale("pt") : (((String)object).equals("de") ? new Locale("de") : (((String)object).equals("es") ? new Locale("es") : (((String)object).equals("tr") ? new Locale("tr") : (((String)object).equals("pt-rBR") ? new Locale("pt", "BR") : (((String)object).equals("pt-rPT") ? new Locale("pt", "PT") : (((String)object).equals("sr") ? new Locale("sr") : Resources.getSystem().getConfiguration().locale)))))))))))))))))))));
        Locale.setDefault((Locale)object);
        Configuration configuration = new Configuration();
        configuration.locale = object;
        this.mContext.getResources().updateConfiguration(configuration, this.mContext.getResources().getDisplayMetrics());
    }

    public boolean checkEnableByEditText(EditText editText, Class<?> clazz) {
        this.checkIsInit();
        if (editText.getText().toString().equals(DEVELOP_PASSWORD) && !this.mIsEnable) {
            this.enable();
            this.restartApplication(clazz);
            return true;
        }
        if (editText.getText().toString().equals(DEVELOP_PASSWORD) && this.mIsEnable) {
            this.disable();
            this.restartApplication(clazz);
            return true;
        }
        return false;
    }

    public void checkIsInit() {
        if (this.mIsInit) {
            return;
        }
        throw new IllegalStateException();
    }

    public void disable() {
        this.checkIsInit();
        this.mIsEnable = false;
        this.mSharedPreference.edit().remove("DevelopMode").commit();
    }

    public void enable() {
        this.checkIsInit();
        this.mIsEnable = true;
        this.mSharedPreference.edit().putBoolean("DevelopMode", true).commit();
    }

    public String getCountry() {
        Object object;
        this.checkIsInit();
        if (this.isEnable() && !((String)(object = PreferenceManager.getDefaultSharedPreferences((Context)this.mContext).getString("develop_country_preference", DEFAULT))).equals(DEFAULT)) {
            return object;
        }
        object = (TelephonyManager)this.mContext.getSystemService("phone");
        object = object.getNetworkCountryIso().length() > 0 ? object.getNetworkCountryIso() : Locale.getDefault().getCountry();
        return ((String)object).toLowerCase();
    }

    public void init(Context object) {
        this.mContext = object;
        object = object.getSharedPreferences(SP_NAME, 0);
        this.mSharedPreference = object;
        this.mIsInit = true;
        this.mIsEnable = object.getBoolean("DevelopMode", false);
        if (!DevConfig.IS_RC) {
            Timer timer;
            this.mIsEnable = true;
            object = new Handler(){

                public void handleMessage(Message message) {
                    if (BasicDevelopMode.this.mDiagramView != null) {
                        BasicDevelopMode.this.mDiagramView.postInvalidate();
                    }
                    if (((BasicDevelopMode)BasicDevelopMode.this).getMaxByteCount().second != null && (Long)((BasicDevelopMode)BasicDevelopMode.this).getMaxByteCount().second / 1024L / 1024L > (long)BasicDevelopMode.this.mMaxNetworkTraffic) {
                        message = (NotificationManager)BasicDevelopMode.this.mContext.getSystemService("notification");
                        Intent intent = new Intent(BasicDevelopMode.this.mContext, DevShowLogsActivity.class);
                        intent.setFlags(0x10000000);
                        PendingIntent.getActivity((Context)BasicDevelopMode.this.mContext, (int)0, (Intent)intent, (int)0);
                        intent = new Notification();
                        intent.icon = 17301543;
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append("Warning! Network Traffic exceed ");
                        stringBuilder.append(BasicDevelopMode.this.mMaxNetworkTraffic);
                        stringBuilder.append(" mb !");
                        intent.tickerText = stringBuilder.toString();
                        intent.defaults = -1;
                        message.notify(22423, (Notification)intent);
                    }
                }
            };
            this.mNetworkTimer = timer = new Timer(true);
            timer.scheduleAtFixedRate(new TimerTask((Handler)object){
                final /* synthetic */ Handler val$handler;
                {
                    this.val$handler = handler;
                }

                @Override
                public void run() {
                    Date date = new Date();
                    long l = TrafficStats.getUidRxBytes((int)BasicDevelopMode.this.mContext.getApplicationInfo().uid);
                    if (BasicDevelopMode.this.mByteCountStack.size() > 100) {
                        BasicDevelopMode.this.mByteCountStack.remove(0);
                    }
                    BasicDevelopMode.this.mByteCountStack.push((Pair<Date, Long>)new Pair((Object)date, (Object)l));
                    this.val$handler.sendEmptyMessage(0);
                }
            }, 1000L, 5000L);
        }
    }

    public boolean isDefaultEnable() {
        if (DevConfig.IS_RC) {
            return false;
        }
        this.enable();
        return true;
    }

    public boolean isEnable() {
        this.checkIsInit();
        return this.mIsEnable;
    }

    public boolean isNetworkMonitoring() {
        boolean bl = this.mDiagramView != null;
        return bl;
    }

    public void recordContentProvider(final Context context) {
        this.checkIsInit();
        List<String> list = DevConfig.getSMSList();
        AlertDialog.Builder builder = new AlertDialog.Builder(context);
        final ArrayAdapter arrayAdapter = new ArrayAdapter(context, 17367058);
        for (int i = 0; i < list.size(); ++i) {
            arrayAdapter.add((Object)list.get(i));
        }
        builder.setAdapter((ListAdapter)arrayAdapter, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface object, int n) {
                object = (String)arrayAdapter.getItem(n);
                BasicDevelopMode.this.exportData(context, (String)object);
            }
        });
        builder.show();
    }

    public void restartApplication(Class<?> intent) {
        this.checkIsInit();
        intent = new Intent(this.mContext, intent);
        intent.addFlags(0x4000000);
        ((AlarmManager)this.mContext.getSystemService("alarm")).set(1, System.currentTimeMillis() + 2000L, PendingIntent.getActivity((Context)this.mContext, (int)0, (Intent)intent, (int)0));
        Process.killProcess((int)Process.myPid());
    }

    public void selectCountry(Context context) {
        this.selectCountry(context, null);
    }

    public void selectCountry(Context context, OnSettingCompleteListener onSettingCompleteListener) {
        this.checkIsInit();
        List<String> list = DevConfig.getCountries();
        AlertDialog.Builder builder = new AlertDialog.Builder(context);
        context = new ArrayAdapter(this.mContext, 17367058);
        for (int i = 0; i < list.size(); ++i) {
            context.add((Object)list.get(i));
        }
        builder.setAdapter((ListAdapter)context, new DialogInterface.OnClickListener((ArrayAdapter)context, onSettingCompleteListener){
            final /* synthetic */ ArrayAdapter val$arrayAdapter;
            final /* synthetic */ OnSettingCompleteListener val$onSettingCompleteListener;
            {
                this.val$arrayAdapter = arrayAdapter;
                this.val$onSettingCompleteListener = onSettingCompleteListener;
            }

            public void onClick(DialogInterface object, int n) {
                object = (String)this.val$arrayAdapter.getItem(n);
                PreferenceManager.getDefaultSharedPreferences((Context)BasicDevelopMode.this.mContext).edit().putString("develop_country_preference", (String)object).commit();
                object = this.val$onSettingCompleteListener;
                if (object != null) {
                    object.onComplete();
                }
            }
        });
        builder.show();
    }

    public void selectLanguage(Context context) {
        this.selectLanguage(context, null);
    }

    public void selectLanguage(final Context context, final OnSettingCompleteListener onSettingCompleteListener) {
        this.checkIsInit();
        List<String> list = DevConfig.getLanguages();
        AlertDialog.Builder builder = new AlertDialog.Builder(context);
        final ArrayAdapter arrayAdapter = new ArrayAdapter(context, 17367058);
        for (int i = 0; i < list.size(); ++i) {
            arrayAdapter.add((Object)list.get(i));
        }
        builder.setAdapter((ListAdapter)arrayAdapter, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface object, int n) {
                object = (String)arrayAdapter.getItem(n);
                PreferenceManager.getDefaultSharedPreferences((Context)context).edit().putString("develop_language_preference", (String)object).commit();
                BasicDevelopMode.this.applyCurrentLanguage();
                object = onSettingCompleteListener;
                if (object != null) {
                    object.onComplete();
                }
            }
        });
        builder.show();
    }

    public void startNetworkMonitor() {
        this.startNetworkMonitor(this.mMaxNetworkTraffic);
    }

    public void startNetworkMonitor(int n) {
        this.checkIsInit();
        this.mMaxNetworkTraffic = n;
        if (this.mDiagramView == null) {
            this.mDiagramView = this.createMonitorView();
        }
    }

    public void stopNetworkMonitor() {
        if (this.mDiagramView != null) {
            ((WindowManager)this.mContext.getSystemService("window")).removeView((View)this.mDiagramView);
            this.mDiagramView = null;
        }
    }

    private class DiagramView
    extends RelativeLayout {
        private TextView maxText;
        private TextView minText;
        private Paint paint;

        public DiagramView(Context context) {
            super(context);
            this.setBackgroundColor(-1442840576);
            BasicDevelopMode.this = new TextView(context);
            this.minText = BasicDevelopMode.this;
            BasicDevelopMode.this.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-2, -2));
            ((RelativeLayout.LayoutParams)this.minText.getLayoutParams()).addRule(12);
            ((RelativeLayout.LayoutParams)this.minText.getLayoutParams()).addRule(9);
            this.minText.setTextColor(-7829368);
            this.minText.setTextSize(7.0f);
            this.minText.setGravity(3);
            this.addView((View)this.minText);
            BasicDevelopMode.this = new TextView(context);
            this.maxText = BasicDevelopMode.this;
            BasicDevelopMode.this.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-2, -2));
            ((RelativeLayout.LayoutParams)this.maxText.getLayoutParams()).addRule(12);
            ((RelativeLayout.LayoutParams)this.maxText.getLayoutParams()).addRule(11);
            this.maxText.setTextColor(-7829368);
            this.maxText.setTextSize(7.0f);
            this.maxText.setGravity(5);
            this.addView((View)this.maxText);
            this.paint = new Paint();
        }

        public void onDraw(Canvas canvas) {
            super.onDraw(canvas);
            this.paint.reset();
            this.paint.setStyle(Paint.Style.FILL_AND_STROKE);
            this.paint.setColor(-1727987968);
            Pair pair = BasicDevelopMode.this.getMaxByteCount();
            Object object = BasicDevelopMode.this.getMinByteCount();
            if (pair != null && object != null && (Long)pair.second != 0L) {
                TextView textView = this.minText;
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("min\n");
                stringBuilder.append(String.valueOf((Long)((Pair)object).second / 1024L));
                stringBuilder.append(" bytes\n");
                stringBuilder.append(((Date)((Pair)object).first).toLocaleString().replace(" ", "\n"));
                textView.setText((CharSequence)stringBuilder.toString());
                stringBuilder = this.maxText;
                object = new StringBuilder();
                ((StringBuilder)object).append("max\n");
                ((StringBuilder)object).append(String.valueOf((Long)pair.second / 1024L));
                ((StringBuilder)object).append(" bytes\n");
                ((StringBuilder)object).append(((Date)pair.first).toLocaleString().replace(" ", "\n"));
                stringBuilder.setText(((StringBuilder)object).toString());
                for (int i = 0; i < BasicDevelopMode.this.mByteCountStack.size(); ++i) {
                    pair = (Pair)BasicDevelopMode.this.mByteCountStack.get(i);
                    int n = this.getWidth() / BasicDevelopMode.this.mByteCountStack.size() * i;
                    int n2 = this.getHeight();
                    int n3 = this.getWidth() / BasicDevelopMode.this.mByteCountStack.size();
                    int n4 = (int)((Long)pair.second / 1024L / 1024L / 10L);
                    if ((Long)pair.second / 1024L / 1024L > (long)BasicDevelopMode.this.mMaxNetworkTraffic) {
                        this.paint.setColor(-1711341568);
                    } else {
                        this.paint.setColor(-1727987968);
                    }
                    canvas.drawRect(new Rect(n, n2 - n4, n3 + n, n2), this.paint);
                }
            }
        }
    }

    public static interface OnSettingCompleteListener {
        public void onComplete();
    }
}

