/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.datatransport.cct;

import android.content.Context;
import android.content.pm.PackageManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.telephony.TelephonyManager;
import com.google.android.datatransport.Encoding;
import com.google.android.datatransport.cct.CCTDestination;
import com.google.android.datatransport.cct.CctTransportBackend$$ExternalSyntheticLambda0;
import com.google.android.datatransport.cct.CctTransportBackend$$ExternalSyntheticLambda1;
import com.google.android.datatransport.cct.internal.AndroidClientInfo;
import com.google.android.datatransport.cct.internal.BatchedLogRequest;
import com.google.android.datatransport.cct.internal.ClientInfo;
import com.google.android.datatransport.cct.internal.LogEvent;
import com.google.android.datatransport.cct.internal.LogRequest;
import com.google.android.datatransport.cct.internal.NetworkConnectionInfo;
import com.google.android.datatransport.cct.internal.QosTier;
import com.google.android.datatransport.runtime.EncodedPayload;
import com.google.android.datatransport.runtime.EventInternal;
import com.google.android.datatransport.runtime.backends.BackendRequest;
import com.google.android.datatransport.runtime.backends.BackendResponse;
import com.google.android.datatransport.runtime.backends.TransportBackend;
import com.google.android.datatransport.runtime.logging.Logging;
import com.google.android.datatransport.runtime.retries.Retries;
import com.google.android.datatransport.runtime.time.Clock;
import com.google.firebase.encoders.DataEncoder;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.zip.GZIPInputStream;

final class CctTransportBackend
implements TransportBackend {
    private static final String ACCEPT_ENCODING_HEADER_KEY = "Accept-Encoding";
    static final String API_KEY_HEADER_KEY = "X-Goog-Api-Key";
    private static final int CONNECTION_TIME_OUT = 30000;
    private static final String CONTENT_ENCODING_HEADER_KEY = "Content-Encoding";
    private static final String CONTENT_TYPE_HEADER_KEY = "Content-Type";
    private static final String GZIP_CONTENT_ENCODING = "gzip";
    private static final int INVALID_VERSION_CODE = -1;
    private static final String JSON_CONTENT_TYPE = "application/json";
    private static final String KEY_APPLICATION_BUILD = "application_build";
    private static final String KEY_COUNTRY = "country";
    private static final String KEY_DEVICE = "device";
    private static final String KEY_FINGERPRINT = "fingerprint";
    private static final String KEY_HARDWARE = "hardware";
    private static final String KEY_LOCALE = "locale";
    private static final String KEY_MANUFACTURER = "manufacturer";
    private static final String KEY_MCC_MNC = "mcc_mnc";
    static final String KEY_MOBILE_SUBTYPE = "mobile-subtype";
    private static final String KEY_MODEL = "model";
    static final String KEY_NETWORK_TYPE = "net-type";
    private static final String KEY_OS_BUILD = "os-uild";
    private static final String KEY_PRODUCT = "product";
    private static final String KEY_SDK_VERSION = "sdk-version";
    private static final String KEY_TIMEZONE_OFFSET = "tz-offset";
    private static final String LOG_TAG = "CctTransportBackend";
    private static final int READ_TIME_OUT = 40000;
    private final Context applicationContext;
    private final ConnectivityManager connectivityManager;
    private final DataEncoder dataEncoder = BatchedLogRequest.createDataEncoder();
    final URL endPoint;
    private final int readTimeout;
    private final Clock uptimeClock;
    private final Clock wallTimeClock;

    public static /* synthetic */ HttpResponse $r8$lambda$bLAzIpNF4NtapXlUpPVGhzxyNT8(CctTransportBackend cctTransportBackend, HttpRequest httpRequest) {
        return cctTransportBackend.doSend(httpRequest);
    }

    CctTransportBackend(Context context, Clock clock, Clock clock2) {
        this(context, clock, clock2, 40000);
    }

    CctTransportBackend(Context context, Clock clock, Clock clock2, int n) {
        this.applicationContext = context;
        this.connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        this.endPoint = CctTransportBackend.parseUrlOrThrow(CCTDestination.DEFAULT_END_POINT);
        this.uptimeClock = clock2;
        this.wallTimeClock = clock;
        this.readTimeout = n;
    }

    /*
     * Exception decompiling
     */
    private HttpResponse doSend(HttpRequest var1_1) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static int getNetSubtypeValue(NetworkInfo networkInfo) {
        if (networkInfo == null) {
            return NetworkConnectionInfo.MobileSubtype.UNKNOWN_MOBILE_SUBTYPE.getValue();
        }
        int n = networkInfo.getSubtype();
        if (n == -1) {
            return NetworkConnectionInfo.MobileSubtype.COMBINED.getValue();
        }
        if (NetworkConnectionInfo.MobileSubtype.forNumber(n) == null) {
            n = 0;
        }
        return n;
    }

    private static int getNetTypeValue(NetworkInfo networkInfo) {
        if (networkInfo == null) {
            return NetworkConnectionInfo.NetworkType.NONE.getValue();
        }
        return networkInfo.getType();
    }

    private static int getPackageVersionCode(Context context) {
        try {
            int n = context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).versionCode;
            return n;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            Logging.e(LOG_TAG, "Unable to find version code for package", nameNotFoundException);
            return -1;
        }
    }

    /*
     * WARNING - void declaration
     */
    private BatchedLogRequest getRequestBody(BackendRequest object3) {
        ArrayList<LogRequest> arrayList;
        Object object;
        HashMap hashMap = new HashMap();
        for (EventInternal eventInternal : ((BackendRequest)object3).getEvents()) {
            object = eventInternal.getTransportName();
            if (!hashMap.containsKey(object)) {
                arrayList = new ArrayList();
                arrayList.add((LogRequest)((Object)eventInternal));
                hashMap.put(object, arrayList);
                continue;
            }
            ((List)hashMap.get(object)).add(eventInternal);
        }
        arrayList = new ArrayList<LogRequest>();
        for (Map.Entry entry : hashMap.entrySet()) {
            Object object2 = (EventInternal)((List)entry.getValue()).get(0);
            object2 = LogRequest.builder().setQosTier(QosTier.DEFAULT).setRequestTimeMs(this.wallTimeClock.getTime()).setRequestUptimeMs(this.uptimeClock.getTime()).setClientInfo(ClientInfo.builder().setClientType(ClientInfo.ClientType.ANDROID_FIREBASE).setAndroidClientInfo(AndroidClientInfo.builder().setSdkVersion(((EventInternal)object2).getInteger(KEY_SDK_VERSION)).setModel(((EventInternal)object2).get(KEY_MODEL)).setHardware(((EventInternal)object2).get(KEY_HARDWARE)).setDevice(((EventInternal)object2).get(KEY_DEVICE)).setProduct(((EventInternal)object2).get(KEY_PRODUCT)).setOsBuild(((EventInternal)object2).get(KEY_OS_BUILD)).setManufacturer(((EventInternal)object2).get(KEY_MANUFACTURER)).setFingerprint(((EventInternal)object2).get(KEY_FINGERPRINT)).setCountry(((EventInternal)object2).get(KEY_COUNTRY)).setLocale(((EventInternal)object2).get(KEY_LOCALE)).setMccMnc(((EventInternal)object2).get(KEY_MCC_MNC)).setApplicationBuild(((EventInternal)object2).get(KEY_APPLICATION_BUILD)).build()).build());
            try {
                ((LogRequest.Builder)object2).setSource(Integer.parseInt((String)entry.getKey()));
            }
            catch (NumberFormatException numberFormatException) {
                ((LogRequest.Builder)object2).setSource((String)entry.getKey());
            }
            object = new ArrayList();
            for (EventInternal eventInternal : (List)entry.getValue()) {
                Encoding encoding;
                block12: {
                    void var1_10;
                    block11: {
                        EncodedPayload encodedPayload;
                        block10: {
                            encodedPayload = eventInternal.getEncodedPayload();
                            encoding = encodedPayload.getEncoding();
                            if (!encoding.equals(Encoding.of("proto"))) break block10;
                            LogEvent.Builder builder = LogEvent.protoBuilder(encodedPayload.getBytes());
                            break block11;
                        }
                        if (!encoding.equals(Encoding.of("json"))) break block12;
                        LogEvent.Builder builder = LogEvent.jsonBuilder(new String(encodedPayload.getBytes(), Charset.forName("UTF-8")));
                    }
                    var1_10.setEventTimeMs(eventInternal.getEventMillis()).setEventUptimeMs(eventInternal.getUptimeMillis()).setTimezoneOffsetSeconds(eventInternal.getLong(KEY_TIMEZONE_OFFSET)).setNetworkConnectionInfo(NetworkConnectionInfo.builder().setNetworkType(NetworkConnectionInfo.NetworkType.forNumber(eventInternal.getInteger(KEY_NETWORK_TYPE))).setMobileSubtype(NetworkConnectionInfo.MobileSubtype.forNumber(eventInternal.getInteger(KEY_MOBILE_SUBTYPE))).build());
                    if (eventInternal.getCode() != null) {
                        var1_10.setEventCode(eventInternal.getCode());
                    }
                    object.add(var1_10.build());
                    continue;
                }
                Logging.w(LOG_TAG, "Received event of unsupported encoding %s. Skipping...", encoding);
            }
            ((LogRequest.Builder)object2).setLogEvents((List<LogEvent>)object);
            arrayList.add(((LogRequest.Builder)object2).build());
        }
        return BatchedLogRequest.create(arrayList);
    }

    private static TelephonyManager getTelephonyManager(Context context) {
        return (TelephonyManager)context.getSystemService("phone");
    }

    static long getTzOffset() {
        Calendar.getInstance();
        return TimeZone.getDefault().getOffset(Calendar.getInstance().getTimeInMillis()) / 1000;
    }

    static /* synthetic */ HttpRequest lambda$send$0(HttpRequest httpRequest, HttpResponse httpResponse) {
        if (httpResponse.redirectUrl != null) {
            Logging.d(LOG_TAG, "Following redirect to: %s", (Object)httpResponse.redirectUrl);
            return httpRequest.withUrl(httpResponse.redirectUrl);
        }
        return null;
    }

    private static InputStream maybeUnGzip(InputStream inputStream, String string2) throws IOException {
        if (GZIP_CONTENT_ENCODING.equals(string2)) {
            return new GZIPInputStream(inputStream);
        }
        return inputStream;
    }

    private static URL parseUrlOrThrow(String string2) {
        try {
            URL uRL = new URL(string2);
            return uRL;
        }
        catch (MalformedURLException malformedURLException) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Invalid url: ");
            stringBuilder.append(string2);
            throw new IllegalArgumentException(stringBuilder.toString(), malformedURLException);
        }
    }

    @Override
    public EventInternal decorate(EventInternal eventInternal) {
        NetworkInfo networkInfo = this.connectivityManager.getActiveNetworkInfo();
        return eventInternal.toBuilder().addMetadata(KEY_SDK_VERSION, Build.VERSION.SDK_INT).addMetadata(KEY_MODEL, Build.MODEL).addMetadata(KEY_HARDWARE, Build.HARDWARE).addMetadata(KEY_DEVICE, Build.DEVICE).addMetadata(KEY_PRODUCT, Build.PRODUCT).addMetadata(KEY_OS_BUILD, Build.ID).addMetadata(KEY_MANUFACTURER, Build.MANUFACTURER).addMetadata(KEY_FINGERPRINT, Build.FINGERPRINT).addMetadata(KEY_TIMEZONE_OFFSET, CctTransportBackend.getTzOffset()).addMetadata(KEY_NETWORK_TYPE, CctTransportBackend.getNetTypeValue(networkInfo)).addMetadata(KEY_MOBILE_SUBTYPE, CctTransportBackend.getNetSubtypeValue(networkInfo)).addMetadata(KEY_COUNTRY, Locale.getDefault().getCountry()).addMetadata(KEY_LOCALE, Locale.getDefault().getLanguage()).addMetadata(KEY_MCC_MNC, CctTransportBackend.getTelephonyManager(this.applicationContext).getSimOperator()).addMetadata(KEY_APPLICATION_BUILD, Integer.toString(CctTransportBackend.getPackageVersionCode(this.applicationContext))).build();
    }

    @Override
    public BackendResponse send(BackendRequest object) {
        BatchedLogRequest batchedLogRequest = this.getRequestBody((BackendRequest)object);
        URL uRL = this.endPoint;
        Object object2 = ((BackendRequest)object).getExtras();
        Object object3 = null;
        Object var6_8 = null;
        Object object4 = uRL;
        if (object2 != null) {
            try {
                object2 = CCTDestination.fromByteArray(((BackendRequest)object).getExtras());
                object = var6_8;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return BackendResponse.fatalError();
            }
            if (((CCTDestination)object2).getAPIKey() != null) {
                object = ((CCTDestination)object2).getAPIKey();
            }
            object4 = uRL;
            object3 = object;
            if (((CCTDestination)object2).getEndPoint() != null) {
                object4 = CctTransportBackend.parseUrlOrThrow(((CCTDestination)object2).getEndPoint());
                object3 = object;
            }
        }
        try {
            object = new HttpRequest((URL)object4, batchedLogRequest, (String)object3);
            object4 = new CctTransportBackend$$ExternalSyntheticLambda0(this);
            object = (HttpResponse)Retries.retry(5, object, object4, CctTransportBackend$$ExternalSyntheticLambda1.INSTANCE);
            if (((HttpResponse)object).code == 200) {
                return BackendResponse.ok(((HttpResponse)object).nextRequestMillis);
            }
            if (((HttpResponse)object).code < 500 && ((HttpResponse)object).code != 404) {
                if (((HttpResponse)object).code == 400) {
                    return BackendResponse.invalidPayload();
                }
                return BackendResponse.fatalError();
            }
            object = BackendResponse.transientError();
            return object;
        }
        catch (IOException iOException) {
            Logging.e(LOG_TAG, "Could not make request to the backend", iOException);
            return BackendResponse.transientError();
        }
    }

    static final class HttpRequest {
        final String apiKey;
        final BatchedLogRequest requestBody;
        final URL url;

        HttpRequest(URL uRL, BatchedLogRequest batchedLogRequest, String string2) {
            this.url = uRL;
            this.requestBody = batchedLogRequest;
            this.apiKey = string2;
        }

        HttpRequest withUrl(URL uRL) {
            return new HttpRequest(uRL, this.requestBody, this.apiKey);
        }
    }

    static final class HttpResponse {
        final int code;
        final long nextRequestMillis;
        final URL redirectUrl;

        HttpResponse(int n, URL uRL, long l) {
            this.code = n;
            this.redirectUrl = uRL;
            this.nextRequestMillis = l;
        }
    }
}

