/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.datatransport.cct.internal;

import com.google.android.datatransport.cct.internal.AndroidClientInfo;
import com.google.android.datatransport.cct.internal.AutoValue_AndroidClientInfo;
import com.google.android.datatransport.cct.internal.AutoValue_BatchedLogRequest;
import com.google.android.datatransport.cct.internal.AutoValue_ClientInfo;
import com.google.android.datatransport.cct.internal.AutoValue_LogEvent;
import com.google.android.datatransport.cct.internal.AutoValue_LogRequest;
import com.google.android.datatransport.cct.internal.AutoValue_NetworkConnectionInfo;
import com.google.android.datatransport.cct.internal.BatchedLogRequest;
import com.google.android.datatransport.cct.internal.ClientInfo;
import com.google.android.datatransport.cct.internal.LogEvent;
import com.google.android.datatransport.cct.internal.LogRequest;
import com.google.android.datatransport.cct.internal.NetworkConnectionInfo;
import com.google.firebase.encoders.FieldDescriptor;
import com.google.firebase.encoders.ObjectEncoder;
import com.google.firebase.encoders.ObjectEncoderContext;
import com.google.firebase.encoders.config.Configurator;
import com.google.firebase.encoders.config.EncoderConfig;
import java.io.IOException;

public final class AutoBatchedLogRequestEncoder
implements Configurator {
    public static final int CODEGEN_VERSION = 2;
    public static final Configurator CONFIG = new AutoBatchedLogRequestEncoder();

    private AutoBatchedLogRequestEncoder() {
    }

    @Override
    public void configure(EncoderConfig<?> encoderConfig) {
        encoderConfig.registerEncoder(BatchedLogRequest.class, BatchedLogRequestEncoder.INSTANCE);
        encoderConfig.registerEncoder(AutoValue_BatchedLogRequest.class, BatchedLogRequestEncoder.INSTANCE);
        encoderConfig.registerEncoder(LogRequest.class, LogRequestEncoder.INSTANCE);
        encoderConfig.registerEncoder(AutoValue_LogRequest.class, LogRequestEncoder.INSTANCE);
        encoderConfig.registerEncoder(ClientInfo.class, ClientInfoEncoder.INSTANCE);
        encoderConfig.registerEncoder(AutoValue_ClientInfo.class, ClientInfoEncoder.INSTANCE);
        encoderConfig.registerEncoder(AndroidClientInfo.class, AndroidClientInfoEncoder.INSTANCE);
        encoderConfig.registerEncoder(AutoValue_AndroidClientInfo.class, AndroidClientInfoEncoder.INSTANCE);
        encoderConfig.registerEncoder(LogEvent.class, LogEventEncoder.INSTANCE);
        encoderConfig.registerEncoder(AutoValue_LogEvent.class, LogEventEncoder.INSTANCE);
        encoderConfig.registerEncoder(NetworkConnectionInfo.class, NetworkConnectionInfoEncoder.INSTANCE);
        encoderConfig.registerEncoder(AutoValue_NetworkConnectionInfo.class, NetworkConnectionInfoEncoder.INSTANCE);
    }

    private static final class AndroidClientInfoEncoder
    implements ObjectEncoder<AndroidClientInfo> {
        private static final FieldDescriptor APPLICATIONBUILD_DESCRIPTOR;
        private static final FieldDescriptor COUNTRY_DESCRIPTOR;
        private static final FieldDescriptor DEVICE_DESCRIPTOR;
        private static final FieldDescriptor FINGERPRINT_DESCRIPTOR;
        private static final FieldDescriptor HARDWARE_DESCRIPTOR;
        static final AndroidClientInfoEncoder INSTANCE;
        private static final FieldDescriptor LOCALE_DESCRIPTOR;
        private static final FieldDescriptor MANUFACTURER_DESCRIPTOR;
        private static final FieldDescriptor MCCMNC_DESCRIPTOR;
        private static final FieldDescriptor MODEL_DESCRIPTOR;
        private static final FieldDescriptor OSBUILD_DESCRIPTOR;
        private static final FieldDescriptor PRODUCT_DESCRIPTOR;
        private static final FieldDescriptor SDKVERSION_DESCRIPTOR;

        static {
            INSTANCE = new AndroidClientInfoEncoder();
            SDKVERSION_DESCRIPTOR = FieldDescriptor.of("sdkVersion");
            MODEL_DESCRIPTOR = FieldDescriptor.of("model");
            HARDWARE_DESCRIPTOR = FieldDescriptor.of("hardware");
            DEVICE_DESCRIPTOR = FieldDescriptor.of("device");
            PRODUCT_DESCRIPTOR = FieldDescriptor.of("product");
            OSBUILD_DESCRIPTOR = FieldDescriptor.of("osBuild");
            MANUFACTURER_DESCRIPTOR = FieldDescriptor.of("manufacturer");
            FINGERPRINT_DESCRIPTOR = FieldDescriptor.of("fingerprint");
            LOCALE_DESCRIPTOR = FieldDescriptor.of("locale");
            COUNTRY_DESCRIPTOR = FieldDescriptor.of("country");
            MCCMNC_DESCRIPTOR = FieldDescriptor.of("mccMnc");
            APPLICATIONBUILD_DESCRIPTOR = FieldDescriptor.of("applicationBuild");
        }

        private AndroidClientInfoEncoder() {
        }

        @Override
        public void encode(AndroidClientInfo androidClientInfo, ObjectEncoderContext objectEncoderContext) throws IOException {
            objectEncoderContext.add(SDKVERSION_DESCRIPTOR, (Object)androidClientInfo.getSdkVersion());
            objectEncoderContext.add(MODEL_DESCRIPTOR, (Object)androidClientInfo.getModel());
            objectEncoderContext.add(HARDWARE_DESCRIPTOR, (Object)androidClientInfo.getHardware());
            objectEncoderContext.add(DEVICE_DESCRIPTOR, (Object)androidClientInfo.getDevice());
            objectEncoderContext.add(PRODUCT_DESCRIPTOR, (Object)androidClientInfo.getProduct());
            objectEncoderContext.add(OSBUILD_DESCRIPTOR, (Object)androidClientInfo.getOsBuild());
            objectEncoderContext.add(MANUFACTURER_DESCRIPTOR, (Object)androidClientInfo.getManufacturer());
            objectEncoderContext.add(FINGERPRINT_DESCRIPTOR, (Object)androidClientInfo.getFingerprint());
            objectEncoderContext.add(LOCALE_DESCRIPTOR, (Object)androidClientInfo.getLocale());
            objectEncoderContext.add(COUNTRY_DESCRIPTOR, (Object)androidClientInfo.getCountry());
            objectEncoderContext.add(MCCMNC_DESCRIPTOR, (Object)androidClientInfo.getMccMnc());
            objectEncoderContext.add(APPLICATIONBUILD_DESCRIPTOR, (Object)androidClientInfo.getApplicationBuild());
        }
    }

    private static final class BatchedLogRequestEncoder
    implements ObjectEncoder<BatchedLogRequest> {
        static final BatchedLogRequestEncoder INSTANCE = new BatchedLogRequestEncoder();
        private static final FieldDescriptor LOGREQUEST_DESCRIPTOR = FieldDescriptor.of("logRequest");

        private BatchedLogRequestEncoder() {
        }

        @Override
        public void encode(BatchedLogRequest batchedLogRequest, ObjectEncoderContext objectEncoderContext) throws IOException {
            objectEncoderContext.add(LOGREQUEST_DESCRIPTOR, batchedLogRequest.getLogRequests());
        }
    }

    private static final class ClientInfoEncoder
    implements ObjectEncoder<ClientInfo> {
        private static final FieldDescriptor ANDROIDCLIENTINFO_DESCRIPTOR;
        private static final FieldDescriptor CLIENTTYPE_DESCRIPTOR;
        static final ClientInfoEncoder INSTANCE;

        static {
            INSTANCE = new ClientInfoEncoder();
            CLIENTTYPE_DESCRIPTOR = FieldDescriptor.of("clientType");
            ANDROIDCLIENTINFO_DESCRIPTOR = FieldDescriptor.of("androidClientInfo");
        }

        private ClientInfoEncoder() {
        }

        @Override
        public void encode(ClientInfo clientInfo, ObjectEncoderContext objectEncoderContext) throws IOException {
            objectEncoderContext.add(CLIENTTYPE_DESCRIPTOR, (Object)clientInfo.getClientType());
            objectEncoderContext.add(ANDROIDCLIENTINFO_DESCRIPTOR, (Object)clientInfo.getAndroidClientInfo());
        }
    }

    private static final class LogEventEncoder
    implements ObjectEncoder<LogEvent> {
        private static final FieldDescriptor EVENTCODE_DESCRIPTOR;
        private static final FieldDescriptor EVENTTIMEMS_DESCRIPTOR;
        private static final FieldDescriptor EVENTUPTIMEMS_DESCRIPTOR;
        static final LogEventEncoder INSTANCE;
        private static final FieldDescriptor NETWORKCONNECTIONINFO_DESCRIPTOR;
        private static final FieldDescriptor SOURCEEXTENSIONJSONPROTO3_DESCRIPTOR;
        private static final FieldDescriptor SOURCEEXTENSION_DESCRIPTOR;
        private static final FieldDescriptor TIMEZONEOFFSETSECONDS_DESCRIPTOR;

        static {
            INSTANCE = new LogEventEncoder();
            EVENTTIMEMS_DESCRIPTOR = FieldDescriptor.of("eventTimeMs");
            EVENTCODE_DESCRIPTOR = FieldDescriptor.of("eventCode");
            EVENTUPTIMEMS_DESCRIPTOR = FieldDescriptor.of("eventUptimeMs");
            SOURCEEXTENSION_DESCRIPTOR = FieldDescriptor.of("sourceExtension");
            SOURCEEXTENSIONJSONPROTO3_DESCRIPTOR = FieldDescriptor.of("sourceExtensionJsonProto3");
            TIMEZONEOFFSETSECONDS_DESCRIPTOR = FieldDescriptor.of("timezoneOffsetSeconds");
            NETWORKCONNECTIONINFO_DESCRIPTOR = FieldDescriptor.of("networkConnectionInfo");
        }

        private LogEventEncoder() {
        }

        @Override
        public void encode(LogEvent logEvent, ObjectEncoderContext objectEncoderContext) throws IOException {
            objectEncoderContext.add(EVENTTIMEMS_DESCRIPTOR, logEvent.getEventTimeMs());
            objectEncoderContext.add(EVENTCODE_DESCRIPTOR, (Object)logEvent.getEventCode());
            objectEncoderContext.add(EVENTUPTIMEMS_DESCRIPTOR, logEvent.getEventUptimeMs());
            objectEncoderContext.add(SOURCEEXTENSION_DESCRIPTOR, (Object)logEvent.getSourceExtension());
            objectEncoderContext.add(SOURCEEXTENSIONJSONPROTO3_DESCRIPTOR, (Object)logEvent.getSourceExtensionJsonProto3());
            objectEncoderContext.add(TIMEZONEOFFSETSECONDS_DESCRIPTOR, logEvent.getTimezoneOffsetSeconds());
            objectEncoderContext.add(NETWORKCONNECTIONINFO_DESCRIPTOR, (Object)logEvent.getNetworkConnectionInfo());
        }
    }

    private static final class LogRequestEncoder
    implements ObjectEncoder<LogRequest> {
        private static final FieldDescriptor CLIENTINFO_DESCRIPTOR;
        static final LogRequestEncoder INSTANCE;
        private static final FieldDescriptor LOGEVENT_DESCRIPTOR;
        private static final FieldDescriptor LOGSOURCENAME_DESCRIPTOR;
        private static final FieldDescriptor LOGSOURCE_DESCRIPTOR;
        private static final FieldDescriptor QOSTIER_DESCRIPTOR;
        private static final FieldDescriptor REQUESTTIMEMS_DESCRIPTOR;
        private static final FieldDescriptor REQUESTUPTIMEMS_DESCRIPTOR;

        static {
            INSTANCE = new LogRequestEncoder();
            REQUESTTIMEMS_DESCRIPTOR = FieldDescriptor.of("requestTimeMs");
            REQUESTUPTIMEMS_DESCRIPTOR = FieldDescriptor.of("requestUptimeMs");
            CLIENTINFO_DESCRIPTOR = FieldDescriptor.of("clientInfo");
            LOGSOURCE_DESCRIPTOR = FieldDescriptor.of("logSource");
            LOGSOURCENAME_DESCRIPTOR = FieldDescriptor.of("logSourceName");
            LOGEVENT_DESCRIPTOR = FieldDescriptor.of("logEvent");
            QOSTIER_DESCRIPTOR = FieldDescriptor.of("qosTier");
        }

        private LogRequestEncoder() {
        }

        @Override
        public void encode(LogRequest logRequest, ObjectEncoderContext objectEncoderContext) throws IOException {
            objectEncoderContext.add(REQUESTTIMEMS_DESCRIPTOR, logRequest.getRequestTimeMs());
            objectEncoderContext.add(REQUESTUPTIMEMS_DESCRIPTOR, logRequest.getRequestUptimeMs());
            objectEncoderContext.add(CLIENTINFO_DESCRIPTOR, (Object)logRequest.getClientInfo());
            objectEncoderContext.add(LOGSOURCE_DESCRIPTOR, (Object)logRequest.getLogSource());
            objectEncoderContext.add(LOGSOURCENAME_DESCRIPTOR, (Object)logRequest.getLogSourceName());
            objectEncoderContext.add(LOGEVENT_DESCRIPTOR, logRequest.getLogEvents());
            objectEncoderContext.add(QOSTIER_DESCRIPTOR, (Object)logRequest.getQosTier());
        }
    }

    private static final class NetworkConnectionInfoEncoder
    implements ObjectEncoder<NetworkConnectionInfo> {
        static final NetworkConnectionInfoEncoder INSTANCE = new NetworkConnectionInfoEncoder();
        private static final FieldDescriptor MOBILESUBTYPE_DESCRIPTOR;
        private static final FieldDescriptor NETWORKTYPE_DESCRIPTOR;

        static {
            NETWORKTYPE_DESCRIPTOR = FieldDescriptor.of("networkType");
            MOBILESUBTYPE_DESCRIPTOR = FieldDescriptor.of("mobileSubtype");
        }

        private NetworkConnectionInfoEncoder() {
        }

        @Override
        public void encode(NetworkConnectionInfo networkConnectionInfo, ObjectEncoderContext objectEncoderContext) throws IOException {
            objectEncoderContext.add(NETWORKTYPE_DESCRIPTOR, (Object)networkConnectionInfo.getNetworkType());
            objectEncoderContext.add(MOBILESUBTYPE_DESCRIPTOR, (Object)networkConnectionInfo.getMobileSubtype());
        }
    }
}

