/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.datatransport.runtime;

import android.util.Base64;
import com.google.android.datatransport.Priority;
import com.google.android.datatransport.runtime.AutoValue_TransportContext;

public abstract class TransportContext {
    public static Builder builder() {
        return new AutoValue_TransportContext.Builder().setPriority(Priority.DEFAULT);
    }

    public abstract String getBackendName();

    public abstract byte[] getExtras();

    public abstract Priority getPriority();

    public boolean shouldUploadClientHealthMetrics() {
        boolean bl = this.getExtras() != null;
        return bl;
    }

    public final String toString() {
        String string2 = this.getBackendName();
        Priority priority = this.getPriority();
        String string3 = this.getExtras() == null ? "" : Base64.encodeToString((byte[])this.getExtras(), (int)2);
        return String.format("TransportContext(%s, %s, %s)", new Object[]{string2, priority, string3});
    }

    public TransportContext withPriority(Priority priority) {
        return TransportContext.builder().setBackendName(this.getBackendName()).setPriority(priority).setExtras(this.getExtras()).build();
    }

    public static abstract class Builder {
        public abstract TransportContext build();

        public abstract Builder setBackendName(String var1);

        public abstract Builder setExtras(byte[] var1);

        public abstract Builder setPriority(Priority var1);
    }
}

