/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.datatransport.runtime.dagger.internal;

import com.google.android.datatransport.runtime.dagger.internal.AbstractMapFactory;
import com.google.android.datatransport.runtime.dagger.internal.DaggerCollections;
import com.google.android.datatransport.runtime.dagger.internal.InstanceFactory;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.inject.Provider;

public final class MapFactory<K, V>
extends AbstractMapFactory<K, V, V> {
    private static final Provider<Map<Object, Object>> EMPTY = InstanceFactory.create(Collections.emptyMap());

    private MapFactory(Map<K, Provider<V>> map) {
        super(map);
    }

    public static <K, V> Builder<K, V> builder(int n) {
        return new Builder(n);
    }

    public static <K, V> Provider<Map<K, V>> emptyMapProvider() {
        return EMPTY;
    }

    @Override
    public Map<K, V> get() {
        LinkedHashMap linkedHashMap = DaggerCollections.newLinkedHashMapWithExpectedSize(this.contributingMap().size());
        for (Map.Entry entry : this.contributingMap().entrySet()) {
            linkedHashMap.put(entry.getKey(), entry.getValue().get());
        }
        return Collections.unmodifiableMap(linkedHashMap);
    }

    public static final class Builder<K, V>
    extends AbstractMapFactory.Builder<K, V, V> {
        private Builder(int n) {
            super(n);
        }

        public MapFactory<K, V> build() {
            return new MapFactory(this.map);
        }

        public Builder<K, V> put(K k, Provider<V> provider) {
            super.put(k, provider);
            return this;
        }

        public Builder<K, V> putAll(Provider<Map<K, V>> provider) {
            super.putAll(provider);
            return this;
        }
    }
}

