/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.datatransport.runtime.scheduling.jobscheduling;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.util.Base64;
import com.google.android.datatransport.runtime.TransportContext;
import com.google.android.datatransport.runtime.logging.Logging;
import com.google.android.datatransport.runtime.scheduling.jobscheduling.AlarmManagerSchedulerBroadcastReceiver;
import com.google.android.datatransport.runtime.scheduling.jobscheduling.SchedulerConfig;
import com.google.android.datatransport.runtime.scheduling.jobscheduling.WorkScheduler;
import com.google.android.datatransport.runtime.scheduling.persistence.EventStore;
import com.google.android.datatransport.runtime.time.Clock;
import com.google.android.datatransport.runtime.util.PriorityMapping;

public class AlarmManagerScheduler
implements WorkScheduler {
    static final String ATTEMPT_NUMBER = "attemptNumber";
    static final String BACKEND_NAME = "backendName";
    static final String EVENT_PRIORITY = "priority";
    static final String EXTRAS = "extras";
    private static final String LOG_TAG = "AlarmManagerScheduler";
    private AlarmManager alarmManager;
    private final Clock clock;
    private final SchedulerConfig config;
    private final Context context;
    private final EventStore eventStore;

    AlarmManagerScheduler(Context context, EventStore eventStore, AlarmManager alarmManager, Clock clock, SchedulerConfig schedulerConfig) {
        this.context = context;
        this.eventStore = eventStore;
        this.alarmManager = alarmManager;
        this.clock = clock;
        this.config = schedulerConfig;
    }

    public AlarmManagerScheduler(Context context, EventStore eventStore, Clock clock, SchedulerConfig schedulerConfig) {
        this(context, eventStore, (AlarmManager)context.getSystemService("alarm"), clock, schedulerConfig);
    }

    boolean isJobServiceOn(Intent intent) {
        Context context = this.context;
        boolean bl = false;
        if (PendingIntent.getBroadcast((Context)context, (int)0, (Intent)intent, (int)0x20000000) != null) {
            bl = true;
        }
        return bl;
    }

    @Override
    public void schedule(TransportContext transportContext, int n) {
        this.schedule(transportContext, n, false);
    }

    @Override
    public void schedule(TransportContext transportContext, int n, boolean bl) {
        Uri.Builder builder = new Uri.Builder();
        builder.appendQueryParameter(BACKEND_NAME, transportContext.getBackendName());
        builder.appendQueryParameter(EVENT_PRIORITY, String.valueOf(PriorityMapping.toInt(transportContext.getPriority())));
        if (transportContext.getExtras() != null) {
            builder.appendQueryParameter(EXTRAS, Base64.encodeToString((byte[])transportContext.getExtras(), (int)0));
        }
        Intent intent = new Intent(this.context, AlarmManagerSchedulerBroadcastReceiver.class);
        intent.setData(builder.build());
        intent.putExtra(ATTEMPT_NUMBER, n);
        if (!bl && this.isJobServiceOn(intent)) {
            Logging.d(LOG_TAG, "Upload for context %s is already scheduled. Returning...", (Object)transportContext);
            return;
        }
        long l = this.eventStore.getNextCallTime(transportContext);
        long l2 = this.config.getScheduleDelay(transportContext.getPriority(), l, n);
        Logging.d(LOG_TAG, "Scheduling upload for context %s in %dms(Backend next call timestamp %d). Attempt %d", transportContext, l2, l, n);
        transportContext = PendingIntent.getBroadcast((Context)this.context, (int)0, (Intent)intent, (int)0);
        this.alarmManager.set(3, this.clock.getTime() + l2, (PendingIntent)transportContext);
    }
}

