/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.datatransport.runtime.scheduling.jobscheduling;

import android.app.job.JobInfo;
import android.app.job.JobScheduler;
import android.content.ComponentName;
import android.content.Context;
import android.os.PersistableBundle;
import android.util.Base64;
import com.google.android.datatransport.runtime.TransportContext;
import com.google.android.datatransport.runtime.logging.Logging;
import com.google.android.datatransport.runtime.scheduling.jobscheduling.JobInfoSchedulerService;
import com.google.android.datatransport.runtime.scheduling.jobscheduling.SchedulerConfig;
import com.google.android.datatransport.runtime.scheduling.jobscheduling.WorkScheduler;
import com.google.android.datatransport.runtime.scheduling.persistence.EventStore;
import com.google.android.datatransport.runtime.util.PriorityMapping;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.zip.Adler32;

public class JobInfoScheduler
implements WorkScheduler {
    static final String ATTEMPT_NUMBER = "attemptNumber";
    static final String BACKEND_NAME = "backendName";
    static final String EVENT_PRIORITY = "priority";
    static final String EXTRAS = "extras";
    private static final String LOG_TAG = "JobInfoScheduler";
    private final SchedulerConfig config;
    private final Context context;
    private final EventStore eventStore;

    public JobInfoScheduler(Context context, EventStore eventStore, SchedulerConfig schedulerConfig) {
        this.context = context;
        this.eventStore = eventStore;
        this.config = schedulerConfig;
    }

    private boolean isJobServiceOn(JobScheduler jobScheduler, int n, int n2) {
        boolean bl;
        block2: {
            int n3;
            boolean bl2;
            Iterator iterator2 = jobScheduler.getAllPendingJobs().iterator();
            do {
                boolean bl3 = iterator2.hasNext();
                bl = bl2 = false;
                if (!bl3) break block2;
                jobScheduler = (JobInfo)iterator2.next();
                n3 = jobScheduler.getExtras().getInt(ATTEMPT_NUMBER);
            } while (jobScheduler.getId() != n);
            bl = bl2;
            if (n3 >= n2) {
                bl = true;
            }
        }
        return bl;
    }

    int getJobId(TransportContext transportContext) {
        Adler32 adler32 = new Adler32();
        adler32.update(this.context.getPackageName().getBytes(Charset.forName("UTF-8")));
        adler32.update(transportContext.getBackendName().getBytes(Charset.forName("UTF-8")));
        adler32.update(ByteBuffer.allocate(4).putInt(PriorityMapping.toInt(transportContext.getPriority())).array());
        if (transportContext.getExtras() != null) {
            adler32.update(transportContext.getExtras());
        }
        return (int)adler32.getValue();
    }

    @Override
    public void schedule(TransportContext transportContext, int n) {
        this.schedule(transportContext, n, false);
    }

    @Override
    public void schedule(TransportContext transportContext, int n, boolean bl) {
        ComponentName componentName = new ComponentName(this.context, JobInfoSchedulerService.class);
        JobScheduler jobScheduler = (JobScheduler)this.context.getSystemService("jobscheduler");
        int n2 = this.getJobId(transportContext);
        if (!bl && this.isJobServiceOn(jobScheduler, n2, n)) {
            Logging.d(LOG_TAG, "Upload for context %s is already scheduled. Returning...", (Object)transportContext);
            return;
        }
        long l = this.eventStore.getNextCallTime(transportContext);
        componentName = this.config.configureJob(new JobInfo.Builder(n2, componentName), transportContext.getPriority(), l, n);
        PersistableBundle persistableBundle = new PersistableBundle();
        persistableBundle.putInt(ATTEMPT_NUMBER, n);
        persistableBundle.putString(BACKEND_NAME, transportContext.getBackendName());
        persistableBundle.putInt(EVENT_PRIORITY, PriorityMapping.toInt(transportContext.getPriority()));
        if (transportContext.getExtras() != null) {
            persistableBundle.putString(EXTRAS, Base64.encodeToString((byte[])transportContext.getExtras(), (int)0));
        }
        componentName.setExtras(persistableBundle);
        Logging.d(LOG_TAG, "Scheduling upload for context %s with jobId=%d in %dms(Backend next call timestamp %d). Attempt %d", transportContext, n2, this.config.getScheduleDelay(transportContext.getPriority(), l, n), l, n);
        jobScheduler.schedule(componentName.build());
    }
}

