/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.datatransport.runtime.scheduling.jobscheduling;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import com.google.android.datatransport.Encoding;
import com.google.android.datatransport.runtime.EncodedPayload;
import com.google.android.datatransport.runtime.EventInternal;
import com.google.android.datatransport.runtime.TransportContext;
import com.google.android.datatransport.runtime.backends.BackendRegistry;
import com.google.android.datatransport.runtime.backends.BackendRequest;
import com.google.android.datatransport.runtime.backends.BackendResponse;
import com.google.android.datatransport.runtime.backends.TransportBackend;
import com.google.android.datatransport.runtime.firebase.transport.ClientMetrics;
import com.google.android.datatransport.runtime.firebase.transport.LogEventDropped;
import com.google.android.datatransport.runtime.logging.Logging;
import com.google.android.datatransport.runtime.scheduling.jobscheduling.Uploader$$ExternalSyntheticLambda0;
import com.google.android.datatransport.runtime.scheduling.jobscheduling.Uploader$$ExternalSyntheticLambda1;
import com.google.android.datatransport.runtime.scheduling.jobscheduling.Uploader$$ExternalSyntheticLambda10;
import com.google.android.datatransport.runtime.scheduling.jobscheduling.Uploader$$ExternalSyntheticLambda2;
import com.google.android.datatransport.runtime.scheduling.jobscheduling.Uploader$$ExternalSyntheticLambda3;
import com.google.android.datatransport.runtime.scheduling.jobscheduling.Uploader$$ExternalSyntheticLambda4;
import com.google.android.datatransport.runtime.scheduling.jobscheduling.Uploader$$ExternalSyntheticLambda5;
import com.google.android.datatransport.runtime.scheduling.jobscheduling.Uploader$$ExternalSyntheticLambda6;
import com.google.android.datatransport.runtime.scheduling.jobscheduling.Uploader$$ExternalSyntheticLambda7;
import com.google.android.datatransport.runtime.scheduling.jobscheduling.Uploader$$ExternalSyntheticLambda8;
import com.google.android.datatransport.runtime.scheduling.jobscheduling.Uploader$$ExternalSyntheticLambda9;
import com.google.android.datatransport.runtime.scheduling.jobscheduling.WorkScheduler;
import com.google.android.datatransport.runtime.scheduling.persistence.ClientHealthMetricsStore;
import com.google.android.datatransport.runtime.scheduling.persistence.EventStore;
import com.google.android.datatransport.runtime.scheduling.persistence.PersistedEvent;
import com.google.android.datatransport.runtime.synchronization.SynchronizationException;
import com.google.android.datatransport.runtime.synchronization.SynchronizationGuard;
import com.google.android.datatransport.runtime.time.Clock;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import javax.inject.Inject;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Uploader {
    private static final String CLIENT_HEALTH_METRICS_LOG_SOURCE = "GDT_CLIENT_METRICS";
    private static final String LOG_TAG = "Uploader";
    private final BackendRegistry backendRegistry;
    private final ClientHealthMetricsStore clientHealthMetricsStore;
    private final Clock clock;
    private final Context context;
    private final EventStore eventStore;
    private final Executor executor;
    private final SynchronizationGuard guard;
    private final Clock uptimeClock;
    private final WorkScheduler workScheduler;

    @Inject
    public Uploader(Context context, BackendRegistry backendRegistry, EventStore eventStore, WorkScheduler workScheduler, Executor executor, SynchronizationGuard synchronizationGuard, Clock clock, Clock clock2, ClientHealthMetricsStore clientHealthMetricsStore) {
        this.context = context;
        this.backendRegistry = backendRegistry;
        this.eventStore = eventStore;
        this.workScheduler = workScheduler;
        this.executor = executor;
        this.guard = synchronizationGuard;
        this.clock = clock;
        this.uptimeClock = clock2;
        this.clientHealthMetricsStore = clientHealthMetricsStore;
    }

    public EventInternal createMetricsEvent(TransportBackend transportBackend) {
        Object object = this.guard;
        ClientHealthMetricsStore clientHealthMetricsStore = this.clientHealthMetricsStore;
        Objects.requireNonNull(clientHealthMetricsStore);
        object = (ClientMetrics)object.runCriticalSection(new Uploader$$ExternalSyntheticLambda9(clientHealthMetricsStore));
        return transportBackend.decorate(EventInternal.builder().setEventMillis(this.clock.getTime()).setUptimeMillis(this.uptimeClock.getTime()).setTransportName(CLIENT_HEALTH_METRICS_LOG_SOURCE).setEncodedPayload(new EncodedPayload(Encoding.of("proto"), ((ClientMetrics)object).toByteArray())).build());
    }

    boolean isNetworkAvailable() {
        NetworkInfo networkInfo = ((ConnectivityManager)this.context.getSystemService("connectivity")).getActiveNetworkInfo();
        boolean bl = networkInfo != null && networkInfo.isConnected();
        return bl;
    }

    public /* synthetic */ Boolean lambda$logAndUpdateState$2$com-google-android-datatransport-runtime-scheduling-jobscheduling-Uploader(TransportContext transportContext) {
        return this.eventStore.hasPendingEventsFor(transportContext);
    }

    public /* synthetic */ Iterable lambda$logAndUpdateState$3$com-google-android-datatransport-runtime-scheduling-jobscheduling-Uploader(TransportContext transportContext) {
        return this.eventStore.loadBatch(transportContext);
    }

    public /* synthetic */ Object lambda$logAndUpdateState$4$com-google-android-datatransport-runtime-scheduling-jobscheduling-Uploader(Iterable iterable, TransportContext transportContext, long l) {
        this.eventStore.recordFailure(iterable);
        this.eventStore.recordNextCallTime(transportContext, this.clock.getTime() + l);
        return null;
    }

    public /* synthetic */ Object lambda$logAndUpdateState$5$com-google-android-datatransport-runtime-scheduling-jobscheduling-Uploader(Iterable iterable) {
        this.eventStore.recordSuccess(iterable);
        return null;
    }

    public /* synthetic */ Object lambda$logAndUpdateState$6$com-google-android-datatransport-runtime-scheduling-jobscheduling-Uploader() {
        this.clientHealthMetricsStore.resetClientMetrics();
        return null;
    }

    public /* synthetic */ Object lambda$logAndUpdateState$7$com-google-android-datatransport-runtime-scheduling-jobscheduling-Uploader(Map object2) {
        for (Map.Entry entry : object2.entrySet()) {
            this.clientHealthMetricsStore.recordLogEventDropped(((Integer)entry.getValue()).intValue(), LogEventDropped.Reason.INVALID_PAYLOD, (String)entry.getKey());
        }
        return null;
    }

    public /* synthetic */ Object lambda$logAndUpdateState$8$com-google-android-datatransport-runtime-scheduling-jobscheduling-Uploader(TransportContext transportContext, long l) {
        this.eventStore.recordNextCallTime(transportContext, this.clock.getTime() + l);
        return null;
    }

    public /* synthetic */ Object lambda$upload$0$com-google-android-datatransport-runtime-scheduling-jobscheduling-Uploader(TransportContext transportContext, int n) {
        this.workScheduler.schedule(transportContext, n + 1);
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public /* synthetic */ void lambda$upload$1$com-google-android-datatransport-runtime-scheduling-jobscheduling-Uploader(TransportContext transportContext, int n, Runnable runnable) {
        Throwable throwable2;
        block6: {
            block5: {
                try {
                    try {
                        SynchronizationGuard synchronizationGuard = this.guard;
                        Object object = this.eventStore;
                        Objects.requireNonNull(object);
                        SynchronizationGuard.CriticalSection criticalSection = new Uploader$$ExternalSyntheticLambda10((EventStore)object);
                        synchronizationGuard.runCriticalSection(criticalSection);
                        if (!this.isNetworkAvailable()) {
                            object = this.guard;
                            criticalSection = new Uploader$$ExternalSyntheticLambda4(this, transportContext, n);
                            object.runCriticalSection(criticalSection);
                            break block5;
                        }
                        this.logAndUpdateState(transportContext, n);
                    }
                    catch (SynchronizationException synchronizationException) {
                        this.workScheduler.schedule(transportContext, n + 1);
                    }
                }
                catch (Throwable throwable2) {
                    break block6;
                }
            }
            runnable.run();
            return;
        }
        runnable.run();
        throw throwable2;
    }

    BackendResponse logAndUpdateState(TransportContext transportContext, int n) {
        TransportBackend transportBackend = this.backendRegistry.get(transportContext.getBackendName());
        long l = 0L;
        Object object = BackendResponse.ok(0L);
        while (((Boolean)this.guard.runCriticalSection(new Uploader$$ExternalSyntheticLambda2(this, transportContext))).booleanValue()) {
            Object object2;
            Object object3 = (Iterable)this.guard.runCriticalSection(new Uploader$$ExternalSyntheticLambda3(this, transportContext));
            if (!object3.iterator().hasNext()) {
                return object;
            }
            if (transportBackend == null) {
                Logging.d(LOG_TAG, "Unknown backend for %s, deleting event batch for it...", (Object)transportContext);
                object2 = BackendResponse.fatalError();
            } else {
                object = new ArrayList();
                object2 = object3.iterator();
                while (object2.hasNext()) {
                    object.add(((PersistedEvent)object2.next()).getEvent());
                }
                if (transportContext.shouldUploadClientHealthMetrics()) {
                    object.add(this.createMetricsEvent(transportBackend));
                }
                object2 = transportBackend.send(BackendRequest.builder().setEvents((Iterable<EventInternal>)object).setExtras(transportContext.getExtras()).build());
            }
            if (((BackendResponse)object2).getStatus() == BackendResponse.Status.TRANSIENT_ERROR) {
                this.guard.runCriticalSection(new Uploader$$ExternalSyntheticLambda7(this, (Iterable)object3, transportContext, l));
                this.workScheduler.schedule(transportContext, n + 1, true);
                return object2;
            }
            this.guard.runCriticalSection(new Uploader$$ExternalSyntheticLambda6(this, (Iterable)object3));
            if (((BackendResponse)object2).getStatus() == BackendResponse.Status.OK) {
                long l2;
                l = l2 = Math.max(l, ((BackendResponse)object2).getNextRequestWaitMillis());
                object = object2;
                if (!transportContext.shouldUploadClientHealthMetrics()) continue;
                this.guard.runCriticalSection(new Uploader$$ExternalSyntheticLambda0(this));
                l = l2;
                object = object2;
                continue;
            }
            object = object2;
            if (((BackendResponse)object2).getStatus() != BackendResponse.Status.INVALID_PAYLOAD) continue;
            object = new HashMap();
            Iterator iterator2 = object3.iterator();
            while (iterator2.hasNext()) {
                object3 = ((PersistedEvent)iterator2.next()).getEvent().getTransportName();
                if (!object.containsKey(object3)) {
                    object.put(object3, 1);
                    continue;
                }
                object.put(object3, (Integer)object.get(object3) + 1);
            }
            this.guard.runCriticalSection(new Uploader$$ExternalSyntheticLambda8(this, (Map)object));
            object = object2;
        }
        this.guard.runCriticalSection(new Uploader$$ExternalSyntheticLambda5(this, transportContext, l));
        return object;
    }

    public void upload(TransportContext transportContext, int n, Runnable runnable) {
        this.executor.execute(new Uploader$$ExternalSyntheticLambda1(this, transportContext, n, runnable));
    }
}

