/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.util.Log;
import com.google.android.gms.common.GooglePlayServicesUtilLight;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.zzj;
import com.google.android.gms.common.zzk;
import com.google.android.gms.common.zzm;
import com.google.android.gms.common.zzn;
import com.google.android.gms.common.zzx;
import com.google.errorprone.annotations.CheckReturnValue;
import com.google.errorprone.annotations.RestrictedInheritance;
import java.util.Set;
import javax.annotation.Nullable;

@CheckReturnValue
@RestrictedInheritance(allowedOnPath=".*java.*/com/google/android/gms/common/testing/.*", explanation="Sub classing of GMS Core's APIs are restricted to testing fakes.", link="go/gmscore-restrictedinheritance")
public class GoogleSignatureVerifier {
    @Nullable
    private static GoogleSignatureVerifier zza;
    @Nullable
    private static volatile Set zzb;
    private final Context zzc;
    private volatile String zzd;

    public GoogleSignatureVerifier(Context context) {
        this.zzc = context.getApplicationContext();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static GoogleSignatureVerifier getInstance(Context context) {
        Preconditions.checkNotNull(context);
        synchronized (GoogleSignatureVerifier.class) {
            if (zza == null) {
                GoogleSignatureVerifier googleSignatureVerifier;
                zzn.zze(context);
                zza = googleSignatureVerifier = new GoogleSignatureVerifier(context);
            }
            return zza;
        }
    }

    @Nullable
    static final zzj zza(PackageInfo object, zzj ... zzjArray) {
        if (object.signatures == null) {
            return null;
        }
        if (object.signatures.length != 1) {
            Log.w((String)"GoogleSignatureVerifier", (String)"Package has more than one signature.");
            return null;
        }
        object = object.signatures;
        object = new zzk(object[0].toByteArray());
        for (int i = 0; i < zzjArray.length; ++i) {
            if (!zzjArray[i].equals(object)) continue;
            return zzjArray[i];
        }
        return null;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public static final boolean zzb(PackageInfo object, boolean bl) {
        boolean bl2;
        block7: {
            ApplicationInfo applicationInfo;
            block8: {
                void var1_4;
                bl2 = var1_4;
                if (var1_4 == false) break block7;
                bl2 = var1_4;
                if (object == null) break block7;
                if ("com.android.vending".equals(object.packageName)) break block8;
                bl2 = var1_4;
                if (!"com.google.android.gms".equals(object.packageName)) break block7;
            }
            bl2 = (applicationInfo = object.applicationInfo) != null && (applicationInfo.flags & 0x81) != 0;
        }
        if (object != null && object.signatures != null) {
            void var0_3;
            if (bl2) {
                zzj zzj2 = GoogleSignatureVerifier.zza(object, zzm.zza);
            } else {
                zzj zzj3 = GoogleSignatureVerifier.zza(object, new zzj[]{zzm.zza[0]});
            }
            if (var0_3 != null) {
                return true;
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final zzx zzc(String string2, boolean bl, boolean bl2) {
        zzx zzx2;
        if (string2 == null) {
            return zzx.zzc("null pkg");
        }
        if (string2.equals(this.zzd)) {
            return zzx.zzb();
        }
        if (zzn.zzg()) {
            zzx2 = zzn.zzb(string2, GooglePlayServicesUtilLight.honorsDebugCertificates(this.zzc), false, false);
        } else {
            PackageInfo packageInfo;
            try {
                packageInfo = this.zzc.getPackageManager().getPackageInfo(string2, 64);
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                return zzx.zzd("no pkg ".concat(string2), nameNotFoundException);
            }
            bl = GooglePlayServicesUtilLight.honorsDebugCertificates(this.zzc);
            if (packageInfo == null) {
                zzx2 = zzx.zzc("null pkg");
            } else if (packageInfo.signatures != null && packageInfo.signatures.length == 1) {
                zzk zzk2 = new zzk(packageInfo.signatures[0].toByteArray());
                String string3 = packageInfo.packageName;
                zzx2 = zzn.zza(string3, zzk2, bl, false);
                if (zzx2.zza && packageInfo.applicationInfo != null && (packageInfo.applicationInfo.flags & 2) != 0 && zzn.zza((String)string3, (zzj)zzk2, (boolean)false, (boolean)true).zza) {
                    zzx2 = zzx.zzc("debuggable release cert app rejected");
                }
            } else {
                zzx2 = zzx.zzc("single cert required");
            }
        }
        if (zzx2.zza) {
            this.zzd = string2;
        }
        return zzx2;
    }

    public boolean isGooglePublicSignedPackage(PackageInfo packageInfo) {
        if (packageInfo == null) {
            return false;
        }
        if (GoogleSignatureVerifier.zzb(packageInfo, false)) {
            return true;
        }
        if (GoogleSignatureVerifier.zzb(packageInfo, true)) {
            if (GooglePlayServicesUtilLight.honorsDebugCertificates(this.zzc)) {
                return true;
            }
            Log.w((String)"GoogleSignatureVerifier", (String)"Test-keys aren't accepted on this build.");
        }
        return false;
    }

    public boolean isPackageGoogleSigned(String object) {
        object = this.zzc((String)object, false, false);
        ((zzx)object).zze();
        return ((zzx)object).zza;
    }

    public boolean isUidGoogleSigned(int n) {
        zzx zzx2;
        block4: {
            int n2;
            String[] stringArray = this.zzc.getPackageManager().getPackagesForUid(n);
            if (stringArray != null && (n2 = stringArray.length) != 0) {
                zzx2 = null;
                for (n = 0; n < n2; ++n) {
                    zzx2 = this.zzc(stringArray[n], false, false);
                    if (!zzx2.zza) {
                        continue;
                    }
                    break block4;
                }
                Preconditions.checkNotNull(zzx2);
            } else {
                zzx2 = zzx.zzc("no pkgs");
            }
        }
        zzx2.zze();
        return zzx2.zza;
    }
}

