/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.util;

import android.content.Context;
import android.content.res.Resources;
import android.os.Build;
import com.google.android.gms.common.GooglePlayServicesUtilLight;
import com.google.android.gms.common.util.PlatformVersion;

public final class DeviceProperties {
    private static Boolean zza;
    private static Boolean zzb;
    private static Boolean zzc;
    private static Boolean zzd;
    private static Boolean zze;
    private static Boolean zzf;
    private static Boolean zzg;
    private static Boolean zzh;
    private static Boolean zzi;
    private static Boolean zzj;
    private static Boolean zzk;
    private static Boolean zzl;

    private DeviceProperties() {
    }

    public static boolean isAuto(Context context) {
        context = context.getPackageManager();
        if (zzi == null) {
            boolean bl;
            boolean bl2 = PlatformVersion.isAtLeastO();
            boolean bl3 = bl = false;
            if (bl2) {
                bl3 = bl;
                if (context.hasSystemFeature("android.hardware.type.automotive")) {
                    bl3 = true;
                }
            }
            zzi = bl3;
        }
        return zzi;
    }

    public static boolean isBstar(Context context) {
        if (zzl == null) {
            boolean bl;
            boolean bl2 = PlatformVersion.isAtLeastR();
            boolean bl3 = bl = false;
            if (bl2) {
                bl3 = bl;
                if (context.getPackageManager().hasSystemFeature("com.google.android.play.feature.HPE_EXPERIENCE")) {
                    bl3 = true;
                }
            }
            zzl = bl3;
        }
        return zzl;
    }

    public static boolean isLatchsky(Context context) {
        if (zzf == null) {
            boolean bl;
            context = context.getPackageManager();
            boolean bl2 = context.hasSystemFeature("com.google.android.feature.services_updater");
            boolean bl3 = bl = false;
            if (bl2) {
                bl3 = bl;
                if (context.hasSystemFeature("cn.google.services")) {
                    bl3 = true;
                }
            }
            zzf = bl3;
        }
        return zzf;
    }

    public static boolean isPhone(Context context) {
        if (zza == null) {
            boolean bl;
            boolean bl2 = DeviceProperties.isTablet(context);
            boolean bl3 = bl = false;
            if (!bl2) {
                bl3 = bl;
                if (!DeviceProperties.isWearable(context)) {
                    bl3 = bl;
                    if (!DeviceProperties.zzb(context)) {
                        if (zzh == null) {
                            zzh = context.getPackageManager().hasSystemFeature("org.chromium.arc");
                        }
                        bl3 = bl;
                        if (!zzh.booleanValue()) {
                            bl3 = bl;
                            if (!DeviceProperties.isAuto(context)) {
                                bl3 = bl;
                                if (!DeviceProperties.isTv(context)) {
                                    if (zzk == null) {
                                        zzk = context.getPackageManager().hasSystemFeature("com.google.android.feature.AMATI_EXPERIENCE");
                                    }
                                    bl3 = bl;
                                    if (!zzk.booleanValue()) {
                                        bl3 = bl;
                                        if (!DeviceProperties.isBstar(context)) {
                                            bl3 = true;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            zza = bl3;
        }
        return zza;
    }

    public static boolean isSevenInchTablet(Context context) {
        return DeviceProperties.zzc(context.getResources());
    }

    public static boolean isSidewinder(Context context) {
        return DeviceProperties.zza(context);
    }

    public static boolean isTablet(Context context) {
        return DeviceProperties.isTablet(context.getResources());
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean isTablet(Resources resources) {
        boolean bl = false;
        if (resources == null) {
            return false;
        }
        if (zzb == null) {
            if ((resources.getConfiguration().screenLayout & 0xF) > 3 || DeviceProperties.zzc(resources)) {
                bl = true;
            }
            zzb = bl;
        }
        return zzb;
    }

    public static boolean isTv(Context context) {
        context = context.getPackageManager();
        if (zzj == null) {
            boolean bl;
            boolean bl2 = context.hasSystemFeature("com.google.android.tv");
            boolean bl3 = bl = true;
            if (!bl2) {
                bl3 = bl;
                if (!context.hasSystemFeature("android.hardware.type.television")) {
                    bl3 = context.hasSystemFeature("android.software.leanback") ? bl : false;
                }
            }
            zzj = bl3;
        }
        return zzj;
    }

    public static boolean isUserBuild() {
        int n = GooglePlayServicesUtilLight.GOOGLE_PLAY_SERVICES_VERSION_CODE;
        return "user".equals(Build.TYPE);
    }

    public static boolean isWearable(Context context) {
        context = context.getPackageManager();
        if (zzd == null) {
            boolean bl;
            boolean bl2 = PlatformVersion.isAtLeastKitKatWatch();
            boolean bl3 = bl = false;
            if (bl2) {
                bl3 = bl;
                if (context.hasSystemFeature("android.hardware.type.watch")) {
                    bl3 = true;
                }
            }
            zzd = bl3;
        }
        return zzd;
    }

    public static boolean isWearableWithoutPlayStore(Context context) {
        return DeviceProperties.isWearable(context) && !PlatformVersion.isAtLeastN() || DeviceProperties.zza(context) && (!PlatformVersion.isAtLeastO() || PlatformVersion.isAtLeastR());
    }

    public static boolean zza(Context context) {
        if (zze == null) {
            boolean bl;
            boolean bl2 = PlatformVersion.isAtLeastLollipop();
            boolean bl3 = bl = false;
            if (bl2) {
                bl3 = bl;
                if (context.getPackageManager().hasSystemFeature("cn.google")) {
                    bl3 = true;
                }
            }
            zze = bl3;
        }
        return zze;
    }

    public static boolean zzb(Context context) {
        if (zzg == null) {
            boolean bl;
            boolean bl2 = context.getPackageManager().hasSystemFeature("android.hardware.type.iot");
            boolean bl3 = bl = true;
            if (!bl2) {
                bl3 = context.getPackageManager().hasSystemFeature("android.hardware.type.embedded") ? bl : false;
            }
            zzg = bl3;
        }
        return zzg;
    }

    public static boolean zzc(Resources resources) {
        boolean bl = false;
        if (resources == null) {
            return false;
        }
        if (zzc == null) {
            resources = resources.getConfiguration();
            boolean bl2 = bl;
            if ((resources.screenLayout & 0xF) <= 3) {
                bl2 = bl;
                if (resources.smallestScreenWidthDp >= 600) {
                    bl2 = true;
                }
            }
            zzc = bl2;
        }
        return zzc;
    }
}

