/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.util;

import android.text.TextUtils;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.zzc;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class JsonUtils {
    private static final Pattern zza = Pattern.compile("\\\\.");
    private static final Pattern zzb = Pattern.compile("[\\\\\"/\b\f\n\r\t]");

    private JsonUtils() {
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean areJsonValuesEquivalent(Object object, Object object2) {
        if (object == null && object2 == null) {
            return true;
        }
        if (object == null || object2 == null) return false;
        if (object instanceof JSONObject && object2 instanceof JSONObject) {
            object = (JSONObject)object;
            JSONObject jSONObject = (JSONObject)object2;
            if (object.length() != jSONObject.length()) {
                return false;
            }
            object2 = object.keys();
            while (object2.hasNext()) {
                String string2 = (String)object2.next();
                if (!jSONObject.has(string2)) {
                    return false;
                }
                Preconditions.checkNotNull(string2);
                boolean bl = JsonUtils.areJsonValuesEquivalent(object.get(string2), jSONObject.get(string2));
                if (bl) continue;
                return false;
            }
            return true;
        }
        if (!(object instanceof JSONArray) || !(object2 instanceof JSONArray)) return object.equals(object2);
        object = (JSONArray)object;
        object2 = (JSONArray)object2;
        if (object.length() != object2.length()) return false;
        for (int i = 0; i < object.length(); ++i) {
            block12: {
                boolean bl = JsonUtils.areJsonValuesEquivalent(object.get(i), object2.get(i));
                if (!bl) break block12;
                continue;
            }
            return false;
        }
        return true;
        catch (JSONException jSONException) {
            return false;
        }
        catch (JSONException jSONException) {
            return false;
        }
    }

    public static String escapeString(String string2) {
        String string3 = string2;
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            Matcher matcher = zzb.matcher(string2);
            string3 = null;
            block5: while (matcher.find()) {
                char c;
                CharSequence charSequence = string3;
                if (string3 == null) {
                    charSequence = new StringBuffer();
                }
                if ((c = matcher.group().charAt(0)) != '\f') {
                    if (c != '\r') {
                        if (c != '\"') {
                            if (c != '/') {
                                if (c != '\\') {
                                    switch (c) {
                                        default: {
                                            string3 = charSequence;
                                            continue block5;
                                        }
                                        case '\n': {
                                            matcher.appendReplacement((StringBuffer)charSequence, "\\\\n");
                                            string3 = charSequence;
                                            continue block5;
                                        }
                                        case '\t': {
                                            matcher.appendReplacement((StringBuffer)charSequence, "\\\\t");
                                            string3 = charSequence;
                                            continue block5;
                                        }
                                        case '\b': 
                                    }
                                    matcher.appendReplacement((StringBuffer)charSequence, "\\\\b");
                                    string3 = charSequence;
                                    continue;
                                }
                                matcher.appendReplacement((StringBuffer)charSequence, "\\\\\\\\");
                                string3 = charSequence;
                                continue;
                            }
                            matcher.appendReplacement((StringBuffer)charSequence, "\\\\/");
                            string3 = charSequence;
                            continue;
                        }
                        matcher.appendReplacement((StringBuffer)charSequence, "\\\\\\\"");
                        string3 = charSequence;
                        continue;
                    }
                    matcher.appendReplacement((StringBuffer)charSequence, "\\\\r");
                    string3 = charSequence;
                    continue;
                }
                matcher.appendReplacement((StringBuffer)charSequence, "\\\\f");
                string3 = charSequence;
            }
            if (string3 == null) {
                return string2;
            }
            matcher.appendTail((StringBuffer)((Object)string3));
            string3 = ((StringBuffer)((Object)string3)).toString();
        }
        return string3;
    }

    public static String unescapeString(String string2) {
        CharSequence charSequence = string2;
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            String string3 = zzc.zza(string2);
            Matcher matcher = zza.matcher(string3);
            string2 = null;
            while (matcher.find()) {
                char c;
                charSequence = string2;
                if (string2 == null) {
                    charSequence = new StringBuffer();
                }
                if ((c = matcher.group().charAt(1)) != '\"') {
                    if (c != '/') {
                        if (c != '\\') {
                            if (c != 'b') {
                                if (c != 'f') {
                                    if (c != 'n') {
                                        if (c != 'r') {
                                            if (c == 't') {
                                                matcher.appendReplacement((StringBuffer)charSequence, "\t");
                                                string2 = charSequence;
                                                continue;
                                            }
                                            throw new IllegalStateException("Found an escaped character that should never be.");
                                        }
                                        matcher.appendReplacement((StringBuffer)charSequence, "\r");
                                        string2 = charSequence;
                                        continue;
                                    }
                                    matcher.appendReplacement((StringBuffer)charSequence, "\n");
                                    string2 = charSequence;
                                    continue;
                                }
                                matcher.appendReplacement((StringBuffer)charSequence, "\f");
                                string2 = charSequence;
                                continue;
                            }
                            matcher.appendReplacement((StringBuffer)charSequence, "\b");
                            string2 = charSequence;
                            continue;
                        }
                        matcher.appendReplacement((StringBuffer)charSequence, "\\\\");
                        string2 = charSequence;
                        continue;
                    }
                    matcher.appendReplacement((StringBuffer)charSequence, "/");
                    string2 = charSequence;
                    continue;
                }
                matcher.appendReplacement((StringBuffer)charSequence, "\"");
                string2 = charSequence;
            }
            if (string2 == null) {
                return string3;
            }
            matcher.appendTail((StringBuffer)((Object)string2));
            charSequence = ((StringBuffer)((Object)string2)).toString();
        }
        return charSequence;
    }
}

