/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.RemoteException;
import android.text.TextUtils;
import androidx.collection.ArrayMap;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.internal.measurement.zzcb;
import com.google.android.gms.internal.measurement.zzcf;
import com.google.android.gms.internal.measurement.zzci;
import com.google.android.gms.internal.measurement.zzck;
import com.google.android.gms.internal.measurement.zzcl;
import com.google.android.gms.measurement.internal.zzau;
import com.google.android.gms.measurement.internal.zzaw;
import com.google.android.gms.measurement.internal.zzgk;
import com.google.android.gms.measurement.internal.zzhk;
import com.google.android.gms.measurement.internal.zzhl;
import com.google.android.gms.measurement.internal.zzhp;
import com.google.android.gms.measurement.internal.zzhq;
import com.google.android.gms.measurement.internal.zzht;
import com.google.android.gms.measurement.internal.zzi;
import com.google.android.gms.measurement.internal.zzil;
import com.google.android.gms.measurement.internal.zzio;
import com.google.android.gms.measurement.internal.zzip;
import com.google.android.gms.measurement.internal.zziv;
import com.google.android.gms.measurement.internal.zzj;
import com.google.android.gms.measurement.internal.zzk;
import com.google.android.gms.measurement.internal.zzl;
import com.google.android.gms.measurement.internal.zzlt;
import com.google.android.gms.measurement.internal.zzm;
import com.google.android.gms.measurement.internal.zzn;
import com.google.android.gms.measurement.internal.zzo;
import com.google.android.gms.measurement.internal.zzp;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;

public class AppMeasurementDynamiteService
extends zzcb {
    zzgk zza = null;
    private final Map zzb = new ArrayMap();

    @EnsuresNonNull(value={"scion"})
    private final void zzb() {
        if (this.zza != null) {
            return;
        }
        throw new IllegalStateException("Attempting to perform action before initialize.");
    }

    private final void zzc(zzcf zzcf2, String string2) {
        this.zzb();
        this.zza.zzv().zzV(zzcf2, string2);
    }

    @Override
    public void beginAdUnitExposure(String string2, long l) throws RemoteException {
        this.zzb();
        this.zza.zzd().zzd(string2, l);
    }

    @Override
    public void clearConditionalUserProperty(String string2, String string3, Bundle bundle) throws RemoteException {
        this.zzb();
        this.zza.zzq().zzA(string2, string3, bundle);
    }

    @Override
    public void clearMeasurementEnabled(long l) throws RemoteException {
        this.zzb();
        this.zza.zzq().zzW(null);
    }

    @Override
    public void endAdUnitExposure(String string2, long l) throws RemoteException {
        this.zzb();
        this.zza.zzd().zze(string2, l);
    }

    @Override
    public void generateEventId(zzcf zzcf2) throws RemoteException {
        this.zzb();
        long l = this.zza.zzv().zzq();
        this.zzb();
        this.zza.zzv().zzU(zzcf2, l);
    }

    @Override
    public void getAppInstanceId(zzcf zzcf2) throws RemoteException {
        this.zzb();
        this.zza.zzaz().zzp(new zzi(this, zzcf2));
    }

    @Override
    public void getCachedAppInstanceId(zzcf zzcf2) throws RemoteException {
        this.zzb();
        this.zzc(zzcf2, this.zza.zzq().zzo());
    }

    @Override
    public void getConditionalUserProperties(String string2, String string3, zzcf zzcf2) throws RemoteException {
        this.zzb();
        this.zza.zzaz().zzp(new zzm(this, zzcf2, string2, string3));
    }

    @Override
    public void getCurrentScreenClass(zzcf zzcf2) throws RemoteException {
        this.zzb();
        this.zzc(zzcf2, this.zza.zzq().zzp());
    }

    @Override
    public void getCurrentScreenName(zzcf zzcf2) throws RemoteException {
        this.zzb();
        this.zzc(zzcf2, this.zza.zzq().zzq());
    }

    @Override
    public void getGmpAppId(zzcf zzcf2) throws RemoteException {
        String string2;
        this.zzb();
        zzip zzip2 = this.zza.zzq();
        if (zzip2.zzs.zzw() != null) {
            string2 = zzip2.zzs.zzw();
        } else {
            try {
                string2 = zziv.zzc(zzip2.zzs.zzau(), "google_app_id", zzip2.zzs.zzz());
            }
            catch (IllegalStateException illegalStateException) {
                zzip2.zzs.zzay().zzd().zzb("getGoogleAppId failed with exception", illegalStateException);
                string2 = null;
            }
        }
        this.zzc(zzcf2, string2);
    }

    @Override
    public void getMaxUserProperties(String string2, zzcf zzcf2) throws RemoteException {
        this.zzb();
        this.zza.zzq().zzh(string2);
        this.zzb();
        this.zza.zzv().zzT(zzcf2, 25);
    }

    @Override
    public void getTestFlag(zzcf zzcf2, int n) throws RemoteException {
        this.zzb();
        if (n != 0) {
            if (n != 1) {
                if (n != 2) {
                    if (n != 3) {
                        if (n != 4) {
                            return;
                        }
                        this.zza.zzv().zzP(zzcf2, this.zza.zzq().zzi());
                        return;
                    }
                    this.zza.zzv().zzT(zzcf2, this.zza.zzq().zzl());
                    return;
                }
                zzlt zzlt2 = this.zza.zzv();
                double d = this.zza.zzq().zzj();
                Bundle bundle = new Bundle();
                bundle.putDouble("r", d);
                try {
                    zzcf2.zzd(bundle);
                    return;
                }
                catch (RemoteException remoteException) {
                    zzlt2.zzs.zzay().zzk().zzb("Error returning double value to wrapper", (Object)remoteException);
                    return;
                }
            }
            this.zza.zzv().zzU(zzcf2, this.zza.zzq().zzm());
            return;
        }
        this.zza.zzv().zzV(zzcf2, this.zza.zzq().zzr());
    }

    @Override
    public void getUserProperties(String string2, String string3, boolean bl, zzcf zzcf2) throws RemoteException {
        this.zzb();
        this.zza.zzaz().zzp(new zzk(this, zzcf2, string2, string3, bl));
    }

    @Override
    public void initForTests(Map map) throws RemoteException {
        this.zzb();
    }

    @Override
    public void initialize(IObjectWrapper iObjectWrapper, zzcl zzcl2, long l) throws RemoteException {
        zzgk zzgk2 = this.zza;
        if (zzgk2 == null) {
            this.zza = zzgk.zzp(Preconditions.checkNotNull((Context)ObjectWrapper.unwrap(iObjectWrapper)), zzcl2, l);
            return;
        }
        zzgk2.zzay().zzk().zza("Attempting to initialize multiple times");
    }

    @Override
    public void isDataCollectionEnabled(zzcf zzcf2) throws RemoteException {
        this.zzb();
        this.zza.zzaz().zzp(new zzn(this, zzcf2));
    }

    @Override
    public void logEvent(String string2, String string3, Bundle bundle, boolean bl, boolean bl2, long l) throws RemoteException {
        this.zzb();
        this.zza.zzq().zzF(string2, string3, bundle, bl, bl2, l);
    }

    @Override
    public void logEventAndBundle(String string2, String object, Bundle bundle, zzcf zzcf2, long l) throws RemoteException {
        this.zzb();
        Preconditions.checkNotEmpty((String)object);
        Bundle bundle2 = bundle != null ? new Bundle(bundle) : new Bundle();
        bundle2.putString("_o", "app");
        object = new zzaw((String)object, new zzau(bundle), "app", l);
        this.zza.zzaz().zzp(new zzj(this, zzcf2, (zzaw)object, string2));
    }

    @Override
    public void logHealthData(int n, String string2, IObjectWrapper iObjectWrapper, IObjectWrapper iObjectWrapper2, IObjectWrapper iObjectWrapper3) throws RemoteException {
        this.zzb();
        Object var6_6 = null;
        iObjectWrapper = iObjectWrapper == null ? null : ObjectWrapper.unwrap(iObjectWrapper);
        iObjectWrapper2 = iObjectWrapper2 == null ? null : ObjectWrapper.unwrap(iObjectWrapper2);
        iObjectWrapper3 = iObjectWrapper3 == null ? var6_6 : ObjectWrapper.unwrap(iObjectWrapper3);
        this.zza.zzay().zzt(n, true, false, string2, iObjectWrapper, iObjectWrapper2, iObjectWrapper3);
    }

    @Override
    public void onActivityCreated(IObjectWrapper iObjectWrapper, Bundle bundle, long l) throws RemoteException {
        this.zzb();
        zzio zzio2 = this.zza.zzq().zza;
        if (zzio2 != null) {
            this.zza.zzq().zzB();
            zzio2.onActivityCreated((Activity)ObjectWrapper.unwrap(iObjectWrapper), bundle);
        }
    }

    @Override
    public void onActivityDestroyed(IObjectWrapper iObjectWrapper, long l) throws RemoteException {
        this.zzb();
        zzio zzio2 = this.zza.zzq().zza;
        if (zzio2 != null) {
            this.zza.zzq().zzB();
            zzio2.onActivityDestroyed((Activity)ObjectWrapper.unwrap(iObjectWrapper));
        }
    }

    @Override
    public void onActivityPaused(IObjectWrapper iObjectWrapper, long l) throws RemoteException {
        this.zzb();
        zzio zzio2 = this.zza.zzq().zza;
        if (zzio2 != null) {
            this.zza.zzq().zzB();
            zzio2.onActivityPaused((Activity)ObjectWrapper.unwrap(iObjectWrapper));
        }
    }

    @Override
    public void onActivityResumed(IObjectWrapper iObjectWrapper, long l) throws RemoteException {
        this.zzb();
        zzio zzio2 = this.zza.zzq().zza;
        if (zzio2 != null) {
            this.zza.zzq().zzB();
            zzio2.onActivityResumed((Activity)ObjectWrapper.unwrap(iObjectWrapper));
        }
    }

    @Override
    public void onActivitySaveInstanceState(IObjectWrapper iObjectWrapper, zzcf zzcf2, long l) throws RemoteException {
        this.zzb();
        zzio zzio2 = this.zza.zzq().zza;
        Bundle bundle = new Bundle();
        if (zzio2 != null) {
            this.zza.zzq().zzB();
            zzio2.onActivitySaveInstanceState((Activity)ObjectWrapper.unwrap(iObjectWrapper), bundle);
        }
        try {
            zzcf2.zzd(bundle);
            return;
        }
        catch (RemoteException remoteException) {
            this.zza.zzay().zzk().zzb("Error returning bundle value to wrapper", (Object)remoteException);
            return;
        }
    }

    @Override
    public void onActivityStarted(IObjectWrapper iObjectWrapper, long l) throws RemoteException {
        this.zzb();
        if (this.zza.zzq().zza != null) {
            this.zza.zzq().zzB();
            iObjectWrapper = (Activity)ObjectWrapper.unwrap(iObjectWrapper);
        }
    }

    @Override
    public void onActivityStopped(IObjectWrapper iObjectWrapper, long l) throws RemoteException {
        this.zzb();
        if (this.zza.zzq().zza != null) {
            this.zza.zzq().zzB();
            iObjectWrapper = (Activity)ObjectWrapper.unwrap(iObjectWrapper);
        }
    }

    @Override
    public void performAction(Bundle bundle, zzcf zzcf2, long l) throws RemoteException {
        this.zzb();
        zzcf2.zzd(null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void registerOnMeasurementEventListener(zzci zzci2) throws RemoteException {
        zzhl zzhl2;
        this.zzb();
        Map map = this.zzb;
        synchronized (map) {
            zzhl zzhl3;
            zzhl2 = zzhl3 = (zzhl)this.zzb.get(zzci2.zzd());
            if (zzhl3 == null) {
                zzhl2 = new zzp(this, zzci2);
                this.zzb.put(zzci2.zzd(), zzhl2);
            }
        }
        this.zza.zzq().zzK(zzhl2);
    }

    @Override
    public void resetAnalyticsData(long l) throws RemoteException {
        this.zzb();
        this.zza.zzq().zzL(l);
    }

    @Override
    public void setConditionalUserProperty(Bundle bundle, long l) throws RemoteException {
        this.zzb();
        if (bundle == null) {
            this.zza.zzay().zzd().zza("Conditional user property must not be null");
            return;
        }
        this.zza.zzq().zzR(bundle, l);
    }

    @Override
    public void setConsent(Bundle bundle, long l) throws RemoteException {
        this.zzb();
        this.zza.zzq().zzU(bundle, l);
    }

    @Override
    public void setConsentThirdParty(Bundle bundle, long l) throws RemoteException {
        this.zzb();
        this.zza.zzq().zzS(bundle, -20, l);
    }

    @Override
    public void setCurrentScreen(IObjectWrapper iObjectWrapper, String string2, String string3, long l) throws RemoteException {
        this.zzb();
        this.zza.zzs().zzw((Activity)ObjectWrapper.unwrap(iObjectWrapper), string2, string3);
    }

    @Override
    public void setDataCollectionEnabled(boolean bl) throws RemoteException {
        this.zzb();
        zzip zzip2 = this.zza.zzq();
        zzip2.zza();
        zzgk zzgk2 = zzip2.zzs;
        zzip2.zzs.zzaz().zzp(new zzil(zzip2, bl));
    }

    @Override
    public void setDefaultEventParameters(Bundle object) {
        this.zzb();
        zzip zzip2 = this.zza.zzq();
        object = object == null ? null : new Bundle(object);
        zzip2.zzs.zzaz().zzp(new zzhp(zzip2, (Bundle)object));
    }

    @Override
    public void setEventInterceptor(zzci object) throws RemoteException {
        this.zzb();
        object = new zzo(this, (zzci)object);
        if (this.zza.zzaz().zzs()) {
            this.zza.zzq().zzV((zzhk)object);
            return;
        }
        this.zza.zzaz().zzp(new zzl(this, (zzo)object));
    }

    @Override
    public void setInstanceIdProvider(zzck zzck2) throws RemoteException {
        this.zzb();
    }

    @Override
    public void setMeasurementEnabled(boolean bl, long l) throws RemoteException {
        this.zzb();
        this.zza.zzq().zzW(bl);
    }

    @Override
    public void setMinimumSessionDuration(long l) throws RemoteException {
        this.zzb();
    }

    @Override
    public void setSessionTimeoutDuration(long l) throws RemoteException {
        this.zzb();
        zzip zzip2 = this.zza.zzq();
        zzgk zzgk2 = zzip2.zzs;
        zzip2.zzs.zzaz().zzp(new zzht(zzip2, l));
    }

    @Override
    public void setUserId(String string2, long l) throws RemoteException {
        this.zzb();
        zzip zzip2 = this.zza.zzq();
        if (string2 != null && TextUtils.isEmpty((CharSequence)string2)) {
            zzip2.zzs.zzay().zzk().zza("User ID must be non-empty or null");
            return;
        }
        zzip2.zzs.zzaz().zzp(new zzhq(zzip2, string2));
        zzip2.zzZ(null, "_id", string2, true, l);
    }

    @Override
    public void setUserProperty(String string2, String string3, IObjectWrapper iObjectWrapper, boolean bl, long l) throws RemoteException {
        this.zzb();
        iObjectWrapper = ObjectWrapper.unwrap(iObjectWrapper);
        this.zza.zzq().zzZ(string2, string3, iObjectWrapper, bl, l);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void unregisterOnMeasurementEventListener(zzci zzci2) throws RemoteException {
        zzhl zzhl2;
        this.zzb();
        Object object = this.zzb;
        synchronized (object) {
            zzhl2 = (zzhl)this.zzb.remove(zzci2.zzd());
        }
        object = zzhl2;
        if (zzhl2 == null) {
            object = new zzp(this, zzci2);
        }
        this.zza.zzq().zzab((zzhl)object);
    }
}

