/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.SharedPreferences;
import android.util.Pair;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.measurement.internal.zzai;
import com.google.android.gms.measurement.internal.zzen;
import com.google.android.gms.measurement.internal.zzfj;
import com.google.android.gms.measurement.internal.zzfk;
import com.google.android.gms.measurement.internal.zzfl;
import com.google.android.gms.measurement.internal.zzfn;
import com.google.android.gms.measurement.internal.zzfo;
import com.google.android.gms.measurement.internal.zzgk;
import com.google.android.gms.measurement.internal.zzhe;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;

final class zzfp
extends zzhe {
    static final Pair zza = new Pair((Object)"", (Object)0L);
    public zzfn zzb;
    public final zzfl zzc;
    public final zzfl zzd;
    public final zzfo zze;
    public final zzfl zzf = new zzfl(this, "session_timeout", 1800000L);
    public final zzfj zzg = new zzfj(this, "start_new_session", true);
    public final zzfo zzh;
    public final zzfj zzi;
    public final zzfl zzj = new zzfl(this, "last_pause_time", 0L);
    public boolean zzk;
    public final zzfj zzl;
    public final zzfj zzm;
    public final zzfl zzn;
    public final zzfo zzo;
    public final zzfo zzp;
    public final zzfl zzq;
    public final zzfk zzr;
    private SharedPreferences zzt;
    private String zzu;
    private boolean zzv;
    private long zzw;

    zzfp(zzgk zzgk2) {
        super(zzgk2);
        this.zzh = new zzfo(this, "non_personalized_ads", null);
        this.zzi = new zzfj(this, "allow_remote_dynamite", false);
        this.zzc = new zzfl(this, "first_open_time", 0L);
        this.zzd = new zzfl(this, "app_install_time", 0L);
        this.zze = new zzfo(this, "app_instance_id", null);
        this.zzl = new zzfj(this, "app_backgrounded", false);
        this.zzm = new zzfj(this, "deep_link_retrieval_complete", false);
        this.zzn = new zzfl(this, "deep_link_retrieval_attempts", 0L);
        this.zzo = new zzfo(this, "firebase_feature_rollouts", null);
        this.zzp = new zzfo(this, "deferred_attribution_cache", null);
        this.zzq = new zzfl(this, "deferred_attribution_cache_timestamp", 0L);
        this.zzr = new zzfk(this, "default_event_parameters", null);
    }

    protected final SharedPreferences zza() {
        this.zzg();
        this.zzu();
        Preconditions.checkNotNull(this.zzt);
        return this.zzt;
    }

    @Override
    @EnsuresNonNull.List(value={@EnsuresNonNull(value={"this.preferences"}), @EnsuresNonNull(value={"this.monitoringSample"})})
    protected final void zzaA() {
        boolean bl;
        SharedPreferences sharedPreferences;
        this.zzt = sharedPreferences = this.zzs.zzau().getSharedPreferences("com.google.android.gms.measurement.prefs", 0);
        this.zzk = bl = sharedPreferences.getBoolean("has_been_opened", false);
        if (!bl) {
            sharedPreferences = this.zzt.edit();
            sharedPreferences.putBoolean("has_been_opened", true);
            sharedPreferences.apply();
        }
        this.zzs.zzf();
        this.zzb = new zzfn(this, "health_monitor", Math.max(0L, (Long)zzen.zzb.zza(null)), null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final Pair zzb(String string2) {
        this.zzg();
        long l = this.zzs.zzav().elapsedRealtime();
        Object object = this.zzu;
        if (object != null && l < this.zzw) {
            return new Pair(object, (Object)this.zzv);
        }
        this.zzw = l + this.zzs.zzf().zzi(string2, zzen.zza);
        AdvertisingIdClient.setShouldSkipGmsCoreVersionCheck(true);
        try {
            object = AdvertisingIdClient.getAdvertisingIdInfo(this.zzs.zzau());
            this.zzu = "";
            string2 = ((AdvertisingIdClient.Info)object).getId();
            if (string2 != null) {
                this.zzu = string2;
            }
            this.zzv = ((AdvertisingIdClient.Info)object).isLimitAdTrackingEnabled();
        }
        catch (Exception exception) {
            this.zzs.zzay().zzc().zzb("Unable to get advertising id", exception);
            this.zzu = "";
        }
        AdvertisingIdClient.setShouldSkipGmsCoreVersionCheck(false);
        return new Pair((Object)this.zzu, (Object)this.zzv);
    }

    final zzai zzc() {
        this.zzg();
        return zzai.zzb(this.zza().getString("consent_settings", "G1"));
    }

    final Boolean zzd() {
        this.zzg();
        if (this.zza().contains("measurement_enabled")) {
            return this.zza().getBoolean("measurement_enabled", true);
        }
        return null;
    }

    @Override
    protected final boolean zzf() {
        return true;
    }

    final void zzh(Boolean bl) {
        this.zzg();
        SharedPreferences.Editor editor = this.zza().edit();
        if (bl != null) {
            editor.putBoolean("measurement_enabled", bl.booleanValue());
        } else {
            editor.remove("measurement_enabled");
        }
        editor.apply();
    }

    final void zzi(boolean bl) {
        this.zzg();
        this.zzs.zzay().zzj().zzb("App measurement setting deferred collection", bl);
        SharedPreferences.Editor editor = this.zza().edit();
        editor.putBoolean("deferred_analytics_collection", bl);
        editor.apply();
    }

    final boolean zzj() {
        SharedPreferences sharedPreferences = this.zzt;
        if (sharedPreferences == null) {
            return false;
        }
        return sharedPreferences.contains("deferred_analytics_collection");
    }

    final boolean zzk(long l) {
        return l - this.zzf.zza() > this.zzj.zza();
    }

    final boolean zzl(int n) {
        return zzai.zzj(n, this.zza().getInt("consent_source", 100));
    }
}

