/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.measurement.internal.zzey;
import com.google.android.gms.measurement.internal.zzge;
import com.google.android.gms.measurement.internal.zzgf;
import com.google.android.gms.measurement.internal.zzgg;
import com.google.android.gms.measurement.internal.zzgk;
import com.google.android.gms.measurement.internal.zzhe;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public final class zzgh
extends zzhe {
    private static final AtomicLong zza = new AtomicLong(Long.MIN_VALUE);
    private zzgg zzb;
    private zzgg zzc;
    private final PriorityBlockingQueue zzd;
    private final BlockingQueue zze;
    private final Thread.UncaughtExceptionHandler zzf;
    private final Thread.UncaughtExceptionHandler zzg;
    private final Object zzh = new Object();
    private final Semaphore zzi = new Semaphore(2);
    private volatile boolean zzj;

    zzgh(zzgk zzgk2) {
        super(zzgk2);
        this.zzd = new PriorityBlockingQueue();
        this.zze = new LinkedBlockingQueue();
        this.zzf = new zzge(this, "Thread death: Uncaught exception on worker thread");
        this.zzg = new zzge(this, "Thread death: Uncaught exception on network thread");
    }

    static /* bridge */ /* synthetic */ zzgg zza(zzgh zzgh2) {
        return zzgh2.zzc;
    }

    static /* bridge */ /* synthetic */ zzgg zzb(zzgh zzgh2) {
        return zzgh2.zzb;
    }

    static /* bridge */ /* synthetic */ Object zzc(zzgh zzgh2) {
        return zzgh2.zzh;
    }

    static /* bridge */ /* synthetic */ Semaphore zzj(zzgh zzgh2) {
        return zzgh2.zzi;
    }

    static /* bridge */ /* synthetic */ AtomicLong zzk() {
        return zza;
    }

    static /* bridge */ /* synthetic */ void zzl(zzgh zzgh2, zzgg zzgg2) {
        zzgh2.zzc = null;
    }

    static /* bridge */ /* synthetic */ void zzm(zzgh zzgh2, zzgg zzgg2) {
        zzgh2.zzb = null;
    }

    static /* bridge */ /* synthetic */ boolean zzr(zzgh zzgh2) {
        boolean bl = zzgh2.zzj;
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void zzt(zzgf runnable) {
        Object object = this.zzh;
        synchronized (object) {
            this.zzd.add(runnable);
            runnable = this.zzb;
            if (runnable == null) {
                runnable = new zzgg(this, "Measurement Worker", this.zzd);
                this.zzb = runnable;
                ((Thread)runnable).setUncaughtExceptionHandler(this.zzf);
                this.zzb.start();
            } else {
                ((zzgg)runnable).zza();
            }
            return;
        }
    }

    @Override
    public final void zzax() {
        if (Thread.currentThread() == this.zzc) {
            return;
        }
        throw new IllegalStateException("Call expected from network thread");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final Object zzd(AtomicReference atomicReference, long l, String string2, Runnable runnable) {
        synchronized (atomicReference) {
            this.zzs.zzaz().zzp(runnable);
            try {
                atomicReference.wait(l);
                // MONITOREXIT @DISABLED, blocks:[1, 3] lbl5 : MonitorExitStatement: MONITOREXIT : var1_1 /* !! */ 
                atomicReference = atomicReference.get();
                if (atomicReference == null) {
                    this.zzs.zzay().zzk().zza("Timed out waiting for ".concat(string2));
                }
                return atomicReference;
            }
            catch (InterruptedException interruptedException) {
                zzey zzey2 = this.zzs.zzay().zzk();
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Interrupted waiting for ");
                stringBuilder.append(string2);
                zzey2.zza(stringBuilder.toString());
                return null;
            }
        }
    }

    @Override
    protected final boolean zzf() {
        return false;
    }

    @Override
    public final void zzg() {
        if (Thread.currentThread() == this.zzb) {
            return;
        }
        throw new IllegalStateException("Call expected from worker thread");
    }

    public final Future zzh(Callable object) throws IllegalStateException {
        this.zzu();
        Preconditions.checkNotNull(object);
        object = new zzgf(this, (Callable)object, false, "Task exception on worker thread");
        if (Thread.currentThread() == this.zzb) {
            if (!this.zzd.isEmpty()) {
                this.zzs.zzay().zzk().zza("Callable skipped the worker queue.");
            }
            ((FutureTask)object).run();
        } else {
            this.zzt((zzgf)object);
        }
        return object;
    }

    public final Future zzi(Callable object) throws IllegalStateException {
        this.zzu();
        Preconditions.checkNotNull(object);
        object = new zzgf(this, (Callable)object, true, "Task exception on worker thread");
        if (Thread.currentThread() == this.zzb) {
            ((FutureTask)object).run();
        } else {
            this.zzt((zzgf)object);
        }
        return object;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zzo(Runnable object) throws IllegalStateException {
        this.zzu();
        Preconditions.checkNotNull(object);
        Runnable runnable = new zzgf(this, (Runnable)object, false, "Task exception on network thread");
        object = this.zzh;
        synchronized (object) {
            this.zze.add(runnable);
            runnable = this.zzc;
            if (runnable == null) {
                runnable = new zzgg(this, "Measurement Network", this.zze);
                this.zzc = runnable;
                ((Thread)runnable).setUncaughtExceptionHandler(this.zzg);
                this.zzc.start();
            } else {
                ((zzgg)runnable).zza();
            }
            return;
        }
    }

    public final void zzp(Runnable runnable) throws IllegalStateException {
        this.zzu();
        Preconditions.checkNotNull(runnable);
        this.zzt(new zzgf(this, runnable, false, "Task exception on worker thread"));
    }

    public final void zzq(Runnable runnable) throws IllegalStateException {
        this.zzu();
        Preconditions.checkNotNull(runnable);
        this.zzt(new zzgf(this, runnable, true, "Task exception on worker thread"));
    }

    public final boolean zzs() {
        return Thread.currentThread() == this.zzb;
    }
}

