/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.app.Application;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextUtils;
import androidx.collection.ArrayMap;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.CollectionUtils;
import com.google.android.gms.common.util.Strings;
import com.google.android.gms.internal.measurement.zzoc;
import com.google.android.gms.internal.measurement.zzof;
import com.google.android.gms.internal.measurement.zzoo;
import com.google.android.gms.internal.measurement.zzpp;
import com.google.android.gms.internal.measurement.zzps;
import com.google.android.gms.measurement.internal.zzab;
import com.google.android.gms.measurement.internal.zzag;
import com.google.android.gms.measurement.internal.zzah;
import com.google.android.gms.measurement.internal.zzai;
import com.google.android.gms.measurement.internal.zzau;
import com.google.android.gms.measurement.internal.zzaw;
import com.google.android.gms.measurement.internal.zzen;
import com.google.android.gms.measurement.internal.zzf;
import com.google.android.gms.measurement.internal.zzfo;
import com.google.android.gms.measurement.internal.zzfp;
import com.google.android.gms.measurement.internal.zzgk;
import com.google.android.gms.measurement.internal.zzhd;
import com.google.android.gms.measurement.internal.zzhg;
import com.google.android.gms.measurement.internal.zzhh;
import com.google.android.gms.measurement.internal.zzhj;
import com.google.android.gms.measurement.internal.zzhk;
import com.google.android.gms.measurement.internal.zzhl;
import com.google.android.gms.measurement.internal.zzho;
import com.google.android.gms.measurement.internal.zzhr;
import com.google.android.gms.measurement.internal.zzhs;
import com.google.android.gms.measurement.internal.zzhu;
import com.google.android.gms.measurement.internal.zzhv;
import com.google.android.gms.measurement.internal.zzhw;
import com.google.android.gms.measurement.internal.zzhx;
import com.google.android.gms.measurement.internal.zzhy;
import com.google.android.gms.measurement.internal.zzhz;
import com.google.android.gms.measurement.internal.zzia;
import com.google.android.gms.measurement.internal.zzib;
import com.google.android.gms.measurement.internal.zzic;
import com.google.android.gms.measurement.internal.zzid;
import com.google.android.gms.measurement.internal.zzie;
import com.google.android.gms.measurement.internal.zzif;
import com.google.android.gms.measurement.internal.zzig;
import com.google.android.gms.measurement.internal.zzih;
import com.google.android.gms.measurement.internal.zzii;
import com.google.android.gms.measurement.internal.zzij;
import com.google.android.gms.measurement.internal.zzik;
import com.google.android.gms.measurement.internal.zzio;
import com.google.android.gms.measurement.internal.zziw;
import com.google.android.gms.measurement.internal.zzkt;
import com.google.android.gms.measurement.internal.zzku;
import com.google.android.gms.measurement.internal.zzlo;
import com.google.android.gms.measurement.internal.zzlr;
import com.google.android.gms.measurement.internal.zzls;
import com.google.android.gms.measurement.internal.zzlt;
import com.google.android.gms.measurement.internal.zzs;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public final class zzip
extends zzf {
    protected zzio zza;
    final zzs zzb;
    protected boolean zzc = true;
    private zzhk zzd;
    private final Set zze = new CopyOnWriteArraySet();
    private boolean zzf;
    private final AtomicReference zzg;
    private final Object zzh = new Object();
    private zzai zzi;
    private int zzj = 100;
    private final AtomicLong zzk;
    private long zzl = -1L;
    private int zzm = 100;
    private final zzls zzn = new zzid(this);

    protected zzip(zzgk zzgk2) {
        super(zzgk2);
        this.zzg = new AtomicReference();
        this.zzi = new zzai(null, null);
        this.zzk = new AtomicLong(0L);
        this.zzb = new zzs(zzgk2);
    }

    private final void zzac(Bundle bundle, long l) {
        if (TextUtils.isEmpty((CharSequence)this.zzs.zzh().zzm())) {
            this.zzS(bundle, 0, l);
            return;
        }
        this.zzs.zzay().zzl().zza("Using developer consent only; google app id found");
    }

    private final void zzad(Boolean bl, boolean bl2) {
        ((zzhd)this).zzg();
        this.zza();
        this.zzs.zzay().zzc().zzb("Setting app measurement enabled (FE)", bl);
        this.zzs.zzm().zzh(bl);
        if (bl2) {
            zzfp zzfp2 = this.zzs.zzm();
            zzgk zzgk2 = zzfp2.zzs;
            zzfp2.zzg();
            zzgk2 = zzfp2.zza().edit();
            if (bl != null) {
                zzgk2.putBoolean("measurement_enabled_from_api", bl);
            } else {
                zzgk2.remove("measurement_enabled_from_api");
            }
            zzgk2.apply();
        }
        if (!this.zzs.zzK() && (bl == null || bl.booleanValue())) {
            return;
        }
        this.zzae();
    }

    private final void zzae() {
        ((zzhd)this).zzg();
        String string2 = this.zzs.zzm().zzh.zza();
        if (string2 != null) {
            if ("unset".equals(string2)) {
                this.zzaa("app", "_npa", null, this.zzs.zzav().currentTimeMillis());
            } else {
                long l = true != "true".equals(string2) ? 0L : 1L;
                this.zzaa("app", "_npa", l, this.zzs.zzav().currentTimeMillis());
            }
        }
        if (this.zzs.zzJ() && this.zzc) {
            this.zzs.zzay().zzc().zza("Recording app launch after enabling measurement for the first time (FE)");
            this.zzz();
            zzoo.zzc();
            if (this.zzs.zzf().zzs(null, zzen.zzae)) {
                this.zzs.zzu().zza.zza();
            }
            this.zzs.zzaz().zzp(new zzhs(this));
            return;
        }
        this.zzs.zzay().zzc().zza("Updating Scion state (FE)");
        this.zzs.zzt().zzI();
    }

    static /* bridge */ /* synthetic */ void zzv(zzip zzip2, zzai zzai2, zzai zzai3) {
        int n;
        block2: {
            zzah zzah2 = zzah.zzb;
            zzah zzah3 = zzah.zza;
            for (n = 0; n < 2; ++n) {
                zzah zzah4 = (new zzah[]{zzah2, zzah3})[n];
                if (zzai3.zzi(zzah4) || !zzai2.zzi(zzah4)) continue;
                n = 1;
                break block2;
            }
            n = 0;
        }
        boolean bl = zzai2.zzl(zzai3, zzah.zzb, zzah.zza);
        if (n == 0 && !bl) {
            return;
        }
        zzip2.zzs.zzh().zzo();
    }

    static /* synthetic */ void zzw(zzip zzip2, zzai zzai2, int n, long l, boolean bl, boolean bl2) {
        ((zzhd)zzip2).zzg();
        zzip2.zza();
        if (l <= zzip2.zzl && zzai.zzj(zzip2.zzm, n)) {
            zzip2.zzs.zzay().zzi().zzb("Dropped out-of-date consent setting, proposed settings", zzai2);
            return;
        }
        zzfp zzfp2 = zzip2.zzs.zzm();
        zzgk zzgk2 = zzfp2.zzs;
        zzfp2.zzg();
        if (zzfp2.zzl(n)) {
            zzgk2 = zzfp2.zza().edit();
            zzgk2.putString("consent_settings", zzai2.zzh());
            zzgk2.putInt("consent_source", n);
            zzgk2.apply();
            zzip2.zzl = l;
            zzip2.zzm = n;
            zzip2.zzs.zzt().zzF(bl);
            if (bl2) {
                zzip2.zzs.zzt().zzu(new AtomicReference());
            }
            return;
        }
        zzip2.zzs.zzay().zzi().zzb("Lower precedence consent source ignored, proposed source", n);
    }

    static /* bridge */ /* synthetic */ void zzx(zzip zzip2, Boolean bl, boolean bl2) {
        zzip2.zzad(bl, true);
    }

    static /* bridge */ /* synthetic */ void zzy(zzip zzip2) {
        zzip2.zzae();
    }

    public final void zzA(String string2, String string3, Bundle bundle) {
        long l = this.zzs.zzav().currentTimeMillis();
        Preconditions.checkNotEmpty(string2);
        Bundle bundle2 = new Bundle();
        bundle2.putString("name", string2);
        bundle2.putLong("creation_timestamp", l);
        if (string3 != null) {
            bundle2.putString("expired_event_name", string3);
            bundle2.putBundle("expired_event_params", bundle);
        }
        this.zzs.zzaz().zzp(new zzhz(this, bundle2));
    }

    public final void zzB() {
        if (this.zzs.zzau().getApplicationContext() instanceof Application && this.zza != null) {
            ((Application)this.zzs.zzau().getApplicationContext()).unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.zza);
        }
    }

    final /* synthetic */ void zzC(Bundle bundle, long l) {
        this.zzac(bundle, l);
    }

    final /* synthetic */ void zzD(Bundle object) {
        Iterator iterator2;
        if (object == null) {
            this.zzs.zzm().zzr.zzb(new Bundle());
            return;
        }
        Bundle bundle = this.zzs.zzm().zzr.zza();
        for (String string2 : object.keySet()) {
            iterator2 = object.get(string2);
            if (!(iterator2 == null || iterator2 instanceof String || iterator2 instanceof Long || iterator2 instanceof Double)) {
                if (this.zzs.zzv().zzaf(iterator2)) {
                    this.zzs.zzv().zzN(this.zzn, null, 27, null, null, 0);
                }
                this.zzs.zzay().zzl().zzc("Invalid default event parameter type. Name, value", string2, iterator2);
                continue;
            }
            if (zzlt.zzah(string2)) {
                this.zzs.zzay().zzl().zzb("Invalid default event parameter name. Name", string2);
                continue;
            }
            if (iterator2 == null) {
                bundle.remove(string2);
                continue;
            }
            zzlt zzlt2 = this.zzs.zzv();
            this.zzs.zzf();
            if (!zzlt2.zzaa("param", string2, 100, iterator2)) continue;
            this.zzs.zzv().zzO(bundle, string2, iterator2);
        }
        this.zzs.zzv();
        int n = this.zzs.zzf().zzc();
        if (bundle.size() > n) {
            iterator2 = new TreeSet(bundle.keySet()).iterator();
            int n2 = 0;
            while (iterator2.hasNext()) {
                int n3;
                object = (String)iterator2.next();
                n2 = n3 = n2 + 1;
                if (n3 <= n) continue;
                bundle.remove((String)object);
                n2 = n3;
            }
            this.zzs.zzv().zzN(this.zzn, null, 26, null, null, 0);
            this.zzs.zzay().zzl().zza("Too many default event parameters set. Discarding beyond event parameter limit");
        }
        this.zzs.zzm().zzr.zzb(bundle);
        this.zzs.zzt().zzH(bundle);
    }

    public final void zzE(String string2, String string3, Bundle bundle) {
        this.zzF(string2, string3, bundle, true, true, this.zzs.zzav().currentTimeMillis());
    }

    public final void zzF(String string2, String string3, Bundle bundle, boolean bl, boolean bl2, long l) {
        if (string2 == null) {
            string2 = "app";
        }
        if (bundle == null) {
            bundle = new Bundle();
        }
        if (!(string3 == "screen_view" || string3 != null && string3.equals("screen_view"))) {
            boolean bl3 = !bl2 || this.zzd == null || zzlt.zzah(string3);
            this.zzN(string2, string3, l, bundle, bl2, bl3, bl, null);
            return;
        }
        this.zzs.zzs().zzx(bundle, l);
    }

    public final void zzG(String string2, String string3, Bundle bundle, String string4) {
        zzgk.zzO();
        this.zzN("auto", string3, this.zzs.zzav().currentTimeMillis(), bundle, false, true, true, string4);
    }

    final void zzH(String string2, String string3, Bundle bundle) {
        ((zzhd)this).zzg();
        this.zzI(string2, string3, this.zzs.zzav().currentTimeMillis(), bundle);
    }

    final void zzI(String string2, String string3, long l, Bundle bundle) {
        ((zzhd)this).zzg();
        boolean bl = this.zzd == null || zzlt.zzah(string3);
        this.zzJ(string2, string3, l, bundle, true, bl, true, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final void zzJ(String object, String string2, long l, Bundle bundleArray, boolean bl, boolean bl2, boolean bl3, String string3) {
        int n;
        Preconditions.checkNotEmpty((String)object);
        Preconditions.checkNotNull(bundleArray);
        ((zzhd)this).zzg();
        this.zza();
        if (!this.zzs.zzJ()) {
            this.zzs.zzay().zzc().zza("Event not sent since app measurement is disabled");
            return;
        }
        Object object2 = this.zzs.zzh().zzn();
        if (object2 != null && !object2.contains(string2)) {
            this.zzs.zzay().zzc().zzc("Dropping non-safelisted event. event name, origin", string2, object);
            return;
        }
        boolean bl4 = this.zzf;
        int n3 = 0;
        int n2 = 0;
        if (!bl4) {
            this.zzf = true;
            bl4 = this.zzs.zzN();
            object2 = !bl4 ? Class.forName("com.google.android.gms.tagmanager.TagManagerService", true, this.zzs.zzau().getClassLoader()) : Class.forName("com.google.android.gms.tagmanager.TagManagerService");
            try {
                ((Class)object2).getDeclaredMethod("initialize", Context.class).invoke(null, this.zzs.zzau());
            }
            catch (Exception exception) {
                try {
                    this.zzs.zzay().zzk().zzb("Failed to invoke Tag Manager's initialize() method", exception);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    this.zzs.zzay().zzi().zza("Tag Manager is not found and thus will not be used");
                }
            }
        }
        if ("_cmp".equals(string2) && bundleArray.containsKey("gclid")) {
            this.zzs.zzaw();
            this.zzaa("auto", "_lgclid", bundleArray.getString("gclid"), this.zzs.zzav().currentTimeMillis());
        }
        this.zzs.zzaw();
        if (bl && zzlt.zzal(string2)) {
            this.zzs.zzv().zzL((Bundle)bundleArray, this.zzs.zzm().zzr.zza());
        }
        if (!bl3) {
            this.zzs.zzaw();
            if (!"_iap".equals(string2)) {
                object2 = this.zzs.zzv();
                bl4 = ((zzlt)object2).zzac("event", string2);
                n = 2;
                if (bl4) {
                    if (!((zzlt)object2).zzZ("event", zzhh.zza, zzhh.zzb, string2)) {
                        n = 13;
                    } else {
                        ((zzhd)object2).zzs.zzf();
                        if (((zzlt)object2).zzY("event", 40, string2)) {
                            n = 0;
                        }
                    }
                }
                if (n != 0) {
                    this.zzs.zzay().zze().zzb("Invalid public event name. Event will not be logged (FE)", this.zzs.zzj().zzd(string2));
                    object = this.zzs.zzv();
                    this.zzs.zzf();
                    object = ((zzlt)object).zzD(string2, 40, true);
                    n3 = n2;
                    if (string2 != null) {
                        n3 = string2.length();
                    }
                    this.zzs.zzv().zzN(this.zzn, null, n, "_ev", (String)object, n3);
                    return;
                }
            }
        }
        zzpp.zzc();
        if (this.zzs.zzf().zzs(null, zzen.zzat)) {
            this.zzs.zzaw();
            object2 = this.zzs.zzs().zzj(false);
            if (object2 != null && !bundleArray.containsKey("_sc")) {
                ((zziw)object2).zzd = true;
            }
            bl4 = bl && !bl3;
            zzlt.zzK((zziw)object2, (Bundle)bundleArray, bl4);
        } else {
            this.zzs.zzaw();
            object2 = this.zzs.zzs().zzj(false);
            if (object2 != null && !bundleArray.containsKey("_sc")) {
                ((zziw)object2).zzd = true;
            }
            bl4 = bl && !bl3;
            zzlt.zzK((zziw)object2, (Bundle)bundleArray, bl4);
        }
        bl4 = "am".equals(object);
        boolean bl5 = zzlt.zzah(string2);
        if (bl && this.zzd != null && !bl5) {
            if (!bl4) {
                this.zzs.zzay().zzc().zzc("Passing event to registered event handler (FE)", this.zzs.zzj().zzd(string2), this.zzs.zzj().zzb((Bundle)bundleArray));
                Preconditions.checkNotNull(this.zzd);
                this.zzd.interceptEvent((String)object, string2, (Bundle)bundleArray, l);
                return;
            }
            bl = true;
        } else {
            bl = bl4;
        }
        if (this.zzs.zzM()) {
            Object object3;
            n2 = this.zzs.zzv().zzh(string2);
            if (n2 != 0) {
                this.zzs.zzay().zze().zzb("Invalid event name. Event will not be logged (FE)", this.zzs.zzj().zzd(string2));
                object = this.zzs.zzv();
                this.zzs.zzf();
                object = ((zzlt)object).zzD(string2, 40, true);
                n = n3;
                if (string2 != null) {
                    n = string2.length();
                }
                this.zzs.zzv().zzN(this.zzn, string3, n2, "_ev", (String)object, n);
                return;
            }
            object2 = CollectionUtils.listOf("_o", "_sn", "_sc", "_si");
            Parcelable[] parcelableArray = this.zzs.zzv().zzy(string3, string2, (Bundle)bundleArray, (List)object2, bl3);
            Preconditions.checkNotNull(parcelableArray);
            this.zzs.zzaw();
            if (this.zzs.zzs().zzj(false) != null && "_ae".equals(string2)) {
                bundleArray = this.zzs.zzu().zzb;
                long l2 = bundleArray.zzc.zzs.zzav().elapsedRealtime();
                long l3 = l2 - bundleArray.zzb;
                bundleArray.zzb = l2;
                if (l3 > 0L) {
                    this.zzs.zzv().zzI((Bundle)parcelableArray, l3);
                }
            }
            zzoc.zzc();
            if (this.zzs.zzf().zzs(null, zzen.zzad)) {
                if (!"auto".equals(object) && "_ssr".equals(string2)) {
                    object3 = this.zzs.zzv();
                    object2 = parcelableArray.getString("_ffr");
                    if (Strings.isEmptyOrWhitespace((String)object2)) {
                        bundleArray = null;
                    } else {
                        bundleArray = object2;
                        if (object2 != null) {
                            bundleArray = ((String)object2).trim();
                        }
                    }
                    if (zzlr.zza(bundleArray, ((zzhd)object3).zzs.zzm().zzo.zza())) {
                        ((zzhd)object3).zzs.zzay().zzc().zza("Not logging duplicate session_start_with_rollout event");
                        return;
                    }
                    ((zzhd)object3).zzs.zzm().zzo.zzb((String)bundleArray);
                } else if ("_ae".equals(string2) && !TextUtils.isEmpty((CharSequence)(bundleArray = this.zzs.zzv().zzs.zzm().zzo.zza()))) {
                    parcelableArray.putString("_ffr", (String)bundleArray);
                }
            }
            object3 = new ArrayList<Parcelable[]>();
            object3.add(parcelableArray);
            if (this.zzs.zzm().zzj.zza() > 0L && this.zzs.zzm().zzk(l) && this.zzs.zzm().zzl.zzb()) {
                this.zzs.zzay().zzj().zza("Current session is expired, remove the session number, ID, and engagement time");
                this.zzaa("auto", "_sid", null, this.zzs.zzav().currentTimeMillis());
                this.zzaa("auto", "_sno", null, this.zzs.zzav().currentTimeMillis());
                this.zzaa("auto", "_se", null, this.zzs.zzav().currentTimeMillis());
            }
            if (parcelableArray.getLong("extend_session", 0L) == 1L) {
                this.zzs.zzay().zzj().zza("EXTEND_SESSION param attached: initiate a new session or extend the current active session");
                this.zzs.zzu().zza.zzb(l, true);
            }
            object2 = new ArrayList(parcelableArray.keySet());
            Collections.sort(object2);
            n3 = object2.size();
            for (n = 0; n < n3; ++n) {
                String string4 = (String)object2.get(n);
                if (string4 == null) continue;
                this.zzs.zzv();
                Object object4 = parcelableArray.get(string4);
                if (object4 instanceof Bundle) {
                    bundleArray = new Bundle[]{(Bundle)object4};
                } else if (object4 instanceof Parcelable[]) {
                    bundleArray = (Parcelable[])object4;
                    bundleArray = (Bundle[])Arrays.copyOf(bundleArray, bundleArray.length, Bundle[].class);
                } else if (object4 instanceof ArrayList) {
                    bundleArray = (ArrayList)object4;
                    bundleArray = bundleArray.toArray(new Bundle[bundleArray.size()]);
                } else {
                    bundleArray = null;
                }
                if (bundleArray == null) continue;
                parcelableArray.putParcelableArray(string4, (Parcelable[])bundleArray);
            }
            for (n = 0; n < object3.size(); ++n) {
                parcelableArray = (Bundle)object3.get(n);
                object2 = n != 0 ? "_ep" : string2;
                parcelableArray.putString("_o", (String)object);
                bundleArray = parcelableArray;
                if (bl2) {
                    bundleArray = this.zzs.zzv().zzt((Bundle)parcelableArray);
                }
                object2 = new zzaw((String)object2, new zzau((Bundle)bundleArray), (String)object, l);
                this.zzs.zzt().zzA((zzaw)object2, string3);
                if (bl) continue;
                object2 = this.zze.iterator();
                while (object2.hasNext()) {
                    ((zzhl)object2.next()).onEvent((String)object, string2, new Bundle((Bundle)bundleArray), l);
                }
            }
            this.zzs.zzaw();
            if (this.zzs.zzs().zzj(false) != null && "_ae".equals(string2)) {
                object = this.zzs.zzu();
                l = this.zzs.zzav().elapsedRealtime();
                ((zzku)object).zzb.zzd(true, true, l);
            }
        }
    }

    public final void zzK(zzhl zzhl2) {
        this.zza();
        Preconditions.checkNotNull(zzhl2);
        if (!this.zze.add(zzhl2)) {
            this.zzs.zzay().zzk().zza("OnEventListener already registered");
        }
    }

    public final void zzL(long l) {
        this.zzg.set(null);
        this.zzs.zzaz().zzp(new zzhx(this, l));
    }

    final void zzM(long l, boolean bl) {
        ((zzhd)this).zzg();
        this.zza();
        this.zzs.zzay().zzc().zza("Resetting analytics data (FE)");
        zzhd zzhd2 = this.zzs.zzu();
        zzhd2.zzg();
        zzkt zzkt2 = ((zzku)zzhd2).zza;
        ((zzku)zzhd2).zzb.zza();
        zzps.zzc();
        if (this.zzs.zzf().zzs(null, zzen.zzaI)) {
            this.zzs.zzh().zzo();
        }
        boolean bl2 = this.zzs.zzJ();
        zzhd2 = this.zzs.zzm();
        ((zzfp)zzhd2).zzc.zzb(l);
        if (!TextUtils.isEmpty((CharSequence)zzhd2.zzs.zzm().zzo.zza())) {
            ((zzfp)zzhd2).zzo.zzb(null);
        }
        zzoo.zzc();
        if (zzhd2.zzs.zzf().zzs(null, zzen.zzae)) {
            ((zzfp)zzhd2).zzj.zzb(0L);
        }
        if (!zzhd2.zzs.zzf().zzv()) {
            ((zzfp)zzhd2).zzi(bl2 ^ true);
        }
        ((zzfp)zzhd2).zzp.zzb(null);
        ((zzfp)zzhd2).zzq.zzb(0L);
        ((zzfp)zzhd2).zzr.zzb(null);
        if (bl) {
            this.zzs.zzt().zzC();
        }
        zzoo.zzc();
        if (this.zzs.zzf().zzs(null, zzen.zzae)) {
            this.zzs.zzu().zza.zza();
        }
        this.zzc = bl2 ^ true;
    }

    protected final void zzN(String string2, String string3, long l, Bundle bundle, boolean bl, boolean bl2, boolean bl3, String string4) {
        bundle = new Bundle(bundle);
        for (String string5 : bundle.keySet()) {
            int n;
            Object object = bundle.get(string5);
            if (object instanceof Bundle) {
                bundle.putBundle(string5, new Bundle((Bundle)object));
                continue;
            }
            boolean bl4 = object instanceof Parcelable[];
            int n2 = 0;
            if (bl4) {
                object = (Parcelable[])object;
                for (n = 0; n < ((Parcelable[])object).length; ++n) {
                    string5 = object[n];
                    if (!(string5 instanceof Bundle)) continue;
                    object[n] = new Bundle((Bundle)string5);
                }
                continue;
            }
            if (!(object instanceof List)) continue;
            object = (List)object;
            for (n = n2; n < object.size(); ++n) {
                string5 = object.get(n);
                if (!(string5 instanceof Bundle)) continue;
                object.set(n, new Bundle((Bundle)string5));
            }
        }
        this.zzs.zzaz().zzp(new zzhu(this, string2, string3, l, bundle, bl, bl2, bl3, string4));
    }

    final void zzO(String string2, String string3, long l, Object object) {
        this.zzs.zzaz().zzp(new zzhv(this, string2, string3, object, l));
    }

    final void zzP(String string2) {
        this.zzg.set(string2);
    }

    public final void zzQ(Bundle bundle) {
        this.zzR(bundle, this.zzs.zzav().currentTimeMillis());
    }

    public final void zzR(Bundle bundle, long l) {
        Preconditions.checkNotNull(bundle);
        bundle = new Bundle(bundle);
        if (!TextUtils.isEmpty((CharSequence)bundle.getString("app_id"))) {
            this.zzs.zzay().zzk().zza("Package name should be null when calling setConditionalUserProperty");
        }
        bundle.remove("app_id");
        Preconditions.checkNotNull(bundle);
        zzhg.zza(bundle, "app_id", String.class, null);
        zzhg.zza(bundle, "origin", String.class, null);
        zzhg.zza(bundle, "name", String.class, null);
        zzhg.zza(bundle, "value", Object.class, null);
        zzhg.zza(bundle, "trigger_event_name", String.class, null);
        Object object = 0L;
        zzhg.zza(bundle, "trigger_timeout", Long.class, object);
        zzhg.zza(bundle, "timed_out_event_name", String.class, null);
        zzhg.zza(bundle, "timed_out_event_params", Bundle.class, null);
        zzhg.zza(bundle, "triggered_event_name", String.class, null);
        zzhg.zza(bundle, "triggered_event_params", Bundle.class, null);
        zzhg.zza(bundle, "time_to_live", Long.class, object);
        zzhg.zza(bundle, "expired_event_name", String.class, null);
        zzhg.zza(bundle, "expired_event_params", Bundle.class, null);
        Preconditions.checkNotEmpty(bundle.getString("name"));
        Preconditions.checkNotEmpty(bundle.getString("origin"));
        Preconditions.checkNotNull(bundle.get("value"));
        bundle.putLong("creation_timestamp", l);
        String string2 = bundle.getString("name");
        object = bundle.get("value");
        if (this.zzs.zzv().zzl(string2) == 0) {
            if (this.zzs.zzv().zzd(string2, object) == 0) {
                Object object2 = this.zzs.zzv().zzB(string2, object);
                if (object2 == null) {
                    this.zzs.zzay().zzd().zzc("Unable to normalize conditional user property value", this.zzs.zzj().zzf(string2), object);
                    return;
                }
                zzhg.zzb(bundle, object2);
                l = bundle.getLong("trigger_timeout");
                if (!TextUtils.isEmpty((CharSequence)bundle.getString("trigger_event_name"))) {
                    this.zzs.zzf();
                    if (l > 15552000000L || l < 1L) {
                        this.zzs.zzay().zzd().zzc("Invalid conditional user property timeout", this.zzs.zzj().zzf(string2), l);
                        return;
                    }
                }
                l = bundle.getLong("time_to_live");
                this.zzs.zzf();
                if (l <= 15552000000L && l >= 1L) {
                    this.zzs.zzaz().zzp(new zzhy(this, bundle));
                    return;
                }
                this.zzs.zzay().zzd().zzc("Invalid conditional user property time to live", this.zzs.zzj().zzf(string2), l);
                return;
            }
            this.zzs.zzay().zzd().zzc("Invalid conditional user property value", this.zzs.zzj().zzf(string2), object);
            return;
        }
        this.zzs.zzay().zzd().zzb("Invalid conditional user property name", this.zzs.zzj().zzf(string2));
    }

    public final void zzS(Bundle bundle, int n, long l) {
        this.zza();
        String string2 = zzai.zzg(bundle);
        if (string2 != null) {
            this.zzs.zzay().zzl().zzb("Ignoring invalid consent setting", string2);
            this.zzs.zzay().zzl().zza("Valid consent values are 'granted', 'denied'");
        }
        this.zzT(zzai.zza(bundle), n, l);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public final void zzT(zzai object, int n, long l) {
        Object object2 = object;
        this.zza();
        if (n != -10 && ((zzai)object).zze() == null && ((zzai)object).zzf() == null) {
            this.zzs.zzay().zzl().zza("Discarding empty consent settings");
            return;
        }
        object = this.zzh;
        // MONITORENTER : object
        zzai zzai2 = this.zzi;
        boolean bl = zzai.zzj(n, this.zzj);
        boolean bl2 = true;
        boolean bl3 = false;
        boolean bl4 = false;
        if (bl) {
            bl3 = ((zzai)object2).zzk(this.zzi);
            bl = bl4;
            if (((zzai)object2).zzi(zzah.zzb)) {
                bl = bl4;
                if (!this.zzi.zzi(zzah.zzb)) {
                    bl = true;
                }
            }
            this.zzi = object2 = ((zzai)object2).zzd(this.zzi);
            this.zzj = n;
        } else {
            bl2 = false;
            bl = false;
        }
        // MONITOREXIT : object
        if (!bl2) {
            this.zzs.zzay().zzi().zzb("Ignoring lower-priority consent settings, proposed settings", object2);
            return;
        }
        long l2 = this.zzk.getAndIncrement();
        if (bl3) {
            this.zzg.set(null);
            this.zzs.zzaz().zzq(new zzij(this, (zzai)object2, l, n, l2, bl, zzai2));
            return;
        }
        object = new zzik(this, (zzai)object2, n, l2, bl, zzai2);
        if (n != 30 && n != -10) {
            this.zzs.zzaz().zzp((Runnable)object);
            return;
        }
        this.zzs.zzaz().zzq((Runnable)object);
    }

    public final void zzU(Bundle bundle, long l) {
        zzof.zzc();
        if (this.zzs.zzf().zzs(null, zzen.zzal)) {
            this.zzs.zzaz().zzq(new zzho(this, bundle, l));
            return;
        }
        this.zzac(bundle, l);
    }

    public final void zzV(zzhk zzhk2) {
        zzhk zzhk3;
        ((zzhd)this).zzg();
        this.zza();
        if (zzhk2 != null && zzhk2 != (zzhk3 = this.zzd)) {
            boolean bl = zzhk3 == null;
            Preconditions.checkState(bl, "EventInterceptor already set.");
        }
        this.zzd = zzhk2;
    }

    public final void zzW(Boolean bl) {
        this.zza();
        this.zzs.zzaz().zzp(new zzii(this, bl));
    }

    final void zzX(zzai object) {
        ((zzhd)this).zzg();
        boolean bl = ((zzai)object).zzi(zzah.zzb) && ((zzai)object).zzi(zzah.zza) || this.zzs.zzt().zzM();
        if (bl != this.zzs.zzK()) {
            this.zzs.zzG(bl);
            object = this.zzs.zzm();
            zzgk zzgk2 = ((zzhd)object).zzs;
            ((zzhd)object).zzg();
            object = ((zzfp)object).zza().contains("measurement_enabled_from_api") ? Boolean.valueOf(((zzfp)object).zza().getBoolean("measurement_enabled_from_api", true)) : null;
            if (!bl || object == null || ((Boolean)object).booleanValue()) {
                this.zzad(bl, false);
            }
        }
    }

    public final void zzY(String string2, String string3, Object object, boolean bl) {
        this.zzZ("auto", "_ldl", object, true, this.zzs.zzav().currentTimeMillis());
    }

    /*
     * Unable to fully structure code
     */
    public final void zzZ(String var1_1, String var2_2, Object var3_3, boolean var4_4, long var5_5) {
        if (var1_1 == null) {
            var1_1 = "app";
        }
        if (var4_4) {
            var7_6 = this.zzs.zzv().zzl(var2_2);
        } else {
            var8_7 = this.zzs.zzv();
            if (!var8_7.zzac("user property", var2_2)) {
                while (true) {
                    var7_6 = 6;
                    break;
                }
            } else if (!var8_7.zzZ("user property", zzhj.zza, null, var2_2)) {
                var7_6 = 15;
            } else {
                var8_7.zzs.zzf();
                if (!var8_7.zzY("user property", 24, var2_2)) ** continue;
                var7_6 = 0;
            }
        }
        if (var7_6 != 0) {
            var1_1 = this.zzs.zzv();
            this.zzs.zzf();
            var1_1 = var1_1.zzD(var2_2, 24, true);
            var9_8 = var2_2 != null ? var2_2.length() : 0;
            this.zzs.zzv().zzN(this.zzn, null, var7_6, "_ev", (String)var1_1, var9_8);
            return;
        }
        if (var3_3 != null) {
            var9_9 = this.zzs.zzv().zzd(var2_2, var3_3);
            if (var9_9 != 0) {
                var1_1 = this.zzs.zzv();
                this.zzs.zzf();
                var1_1 = var1_1.zzD(var2_2, 24, true);
                var7_6 = !(var3_3 instanceof String) && !(var3_3 instanceof CharSequence) ? 0 : var3_3.toString().length();
                this.zzs.zzv().zzN(this.zzn, null, var9_9, "_ev", (String)var1_1, var7_6);
                return;
            }
            var3_3 = this.zzs.zzv().zzB(var2_2, var3_3);
            if (var3_3 != null) {
                this.zzO((String)var1_1, var2_2, var5_5, var3_3);
            }
            return;
        }
        this.zzO((String)var1_1, var2_2, var5_5, null);
    }

    final void zzaa(String object, String string2, Object object2, long l) {
        block6: {
            block8: {
                block7: {
                    Object object3;
                    Preconditions.checkNotEmpty((String)object);
                    Preconditions.checkNotEmpty(string2);
                    ((zzhd)this).zzg();
                    this.zza();
                    if (!"allow_personalized_ads".equals(string2)) break block6;
                    if (!(object2 instanceof String) || TextUtils.isEmpty((CharSequence)(object3 = (String)object2))) break block7;
                    object2 = ((String)object3).toLowerCase(Locale.ENGLISH);
                    string2 = "false";
                    long l2 = true != "false".equals(object2) ? 0L : 1L;
                    object2 = l2;
                    object3 = this.zzs.zzm().zzh;
                    if ((Long)object2 == 1L) {
                        string2 = "true";
                    }
                    ((zzfo)object3).zzb(string2);
                    break block8;
                }
                if (object2 != null) break block6;
                this.zzs.zzm().zzh.zzb("unset");
            }
            string2 = "_npa";
        }
        if (!this.zzs.zzJ()) {
            this.zzs.zzay().zzj().zza("User property not set since app measurement is disabled");
            return;
        }
        if (!this.zzs.zzM()) {
            return;
        }
        object = new zzlo(string2, l, object2, (String)object);
        this.zzs.zzt().zzK((zzlo)object);
    }

    public final void zzab(zzhl zzhl2) {
        this.zza();
        Preconditions.checkNotNull(zzhl2);
        if (!this.zze.remove(zzhl2)) {
            this.zzs.zzay().zzk().zza("OnEventListener had not been registered");
        }
    }

    @Override
    protected final boolean zzf() {
        return false;
    }

    public final int zzh(String string2) {
        Preconditions.checkNotEmpty(string2);
        this.zzs.zzf();
        return 25;
    }

    public final Boolean zzi() {
        AtomicReference atomicReference = new AtomicReference();
        return (Boolean)this.zzs.zzaz().zzd(atomicReference, 15000L, "boolean test flag value", new zzib(this, atomicReference));
    }

    public final Double zzj() {
        AtomicReference atomicReference = new AtomicReference();
        return (Double)this.zzs.zzaz().zzd(atomicReference, 15000L, "double test flag value", new zzih(this, atomicReference));
    }

    public final Integer zzl() {
        AtomicReference atomicReference = new AtomicReference();
        return (Integer)this.zzs.zzaz().zzd(atomicReference, 15000L, "int test flag value", new zzig(this, atomicReference));
    }

    public final Long zzm() {
        AtomicReference atomicReference = new AtomicReference();
        return (Long)this.zzs.zzaz().zzd(atomicReference, 15000L, "long test flag value", new zzif(this, atomicReference));
    }

    public final String zzo() {
        return (String)this.zzg.get();
    }

    public final String zzp() {
        zziw zziw2 = this.zzs.zzs().zzi();
        if (zziw2 != null) {
            return zziw2.zzb;
        }
        return null;
    }

    public final String zzq() {
        zziw zziw2 = this.zzs.zzs().zzi();
        if (zziw2 != null) {
            return zziw2.zza;
        }
        return null;
    }

    public final String zzr() {
        AtomicReference atomicReference = new AtomicReference();
        return (String)this.zzs.zzaz().zzd(atomicReference, 15000L, "String test flag value", new zzie(this, atomicReference));
    }

    public final ArrayList zzs(String arrayList, String string2) {
        if (this.zzs.zzaz().zzs()) {
            this.zzs.zzay().zzd().zza("Cannot get conditional user properties from analytics worker thread");
            arrayList = new ArrayList(0);
        } else {
            this.zzs.zzaw();
            if (zzab.zza()) {
                this.zzs.zzay().zzd().zza("Cannot get conditional user properties from main thread");
                arrayList = new ArrayList(0);
            } else {
                AtomicReference atomicReference = new AtomicReference();
                this.zzs.zzaz().zzd(atomicReference, 5000L, "get conditional user properties", new zzia(this, atomicReference, null, (String)((Object)arrayList), string2));
                arrayList = (List)atomicReference.get();
                if (arrayList == null) {
                    this.zzs.zzay().zzd().zzb("Timed out waiting for get conditional user properties", null);
                    arrayList = new ArrayList();
                } else {
                    arrayList = zzlt.zzH(arrayList);
                }
            }
        }
        return arrayList;
    }

    public final List zzt(boolean bl) {
        this.zza();
        this.zzs.zzay().zzj().zza("Getting user properties (FE)");
        if (!this.zzs.zzaz().zzs()) {
            this.zzs.zzaw();
            if (zzab.zza()) {
                this.zzs.zzay().zzd().zza("Cannot get all user properties from main thread");
                return Collections.emptyList();
            }
            Object object = new AtomicReference();
            this.zzs.zzaz().zzd((AtomicReference)object, 5000L, "get user properties", new zzhw(this, (AtomicReference)object, bl));
            object = (List)((AtomicReference)object).get();
            if (object == null) {
                this.zzs.zzay().zzd().zzb("Timed out waiting for get user properties, includeInternal", bl);
                return Collections.emptyList();
            }
            return object;
        }
        this.zzs.zzay().zzd().zza("Cannot get all user properties from analytics worker thread");
        return Collections.emptyList();
    }

    public final Map zzu(String object, String object2, boolean bl) {
        if (this.zzs.zzaz().zzs()) {
            this.zzs.zzay().zzd().zza("Cannot get user properties from analytics worker thread");
            object = Collections.emptyMap();
        } else {
            this.zzs.zzaw();
            if (zzab.zza()) {
                this.zzs.zzay().zzd().zza("Cannot get user properties from main thread");
                object = Collections.emptyMap();
            } else {
                Object object3 = new AtomicReference();
                this.zzs.zzaz().zzd((AtomicReference)object3, 5000L, "get user properties", new zzic(this, (AtomicReference)object3, null, (String)object, (String)object2, bl));
                object2 = (List)((AtomicReference)object3).get();
                if (object2 == null) {
                    this.zzs.zzay().zzd().zzb("Timed out waiting for handle get user properties, includeInternal", bl);
                    object = Collections.emptyMap();
                } else {
                    object = new ArrayMap(object2.size());
                    object3 = object2.iterator();
                    while (object3.hasNext()) {
                        zzlo zzlo2 = (zzlo)object3.next();
                        object2 = zzlo2.zza();
                        if (object2 == null) continue;
                        object.put(zzlo2.zzb, object2);
                    }
                }
            }
        }
        return object;
    }

    public final void zzz() {
        ((zzhd)this).zzg();
        this.zza();
        if (this.zzs.zzM()) {
            Object object;
            if (this.zzs.zzf().zzs(null, zzen.zzY)) {
                object = this.zzs.zzf();
                ((zzhd)object).zzs.zzaw();
                object = ((zzag)object).zzk("google_analytics_deferred_deep_link_enabled");
                if (object != null && ((Boolean)object).booleanValue()) {
                    this.zzs.zzay().zzc().zza("Deferred Deep Link feature enabled.");
                    this.zzs.zzaz().zzp(new zzhr(this));
                }
            }
            this.zzs.zzt().zzq();
            this.zzc = false;
            zzfp zzfp2 = this.zzs.zzm();
            zzfp2.zzg();
            object = zzfp2.zza().getString("previous_os_version", null);
            zzfp2.zzs.zzg().zzu();
            String string2 = Build.VERSION.RELEASE;
            if (!TextUtils.isEmpty((CharSequence)string2) && !string2.equals(object)) {
                zzfp2 = zzfp2.zza().edit();
                zzfp2.putString("previous_os_version", string2);
                zzfp2.apply();
            }
            if (!TextUtils.isEmpty((CharSequence)object)) {
                this.zzs.zzg().zzu();
                if (!((String)object).equals(Build.VERSION.RELEASE)) {
                    string2 = new Bundle();
                    string2.putString("_po", (String)object);
                    this.zzH("auto", "_ou", (Bundle)string2);
                }
            }
        }
    }
}

