/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.stats;

import android.content.Context;
import android.os.PowerManager;
import android.os.WorkSource;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.Clock;
import com.google.android.gms.common.util.DefaultClock;
import com.google.android.gms.common.util.Strings;
import com.google.android.gms.common.util.WorkSourceUtil;
import com.google.android.gms.internal.stats.zzh;
import com.google.android.gms.internal.stats.zzi;
import com.google.android.gms.stats.zza;
import com.google.android.gms.stats.zzb;
import com.google.android.gms.stats.zzc;
import com.google.android.gms.stats.zzd;
import com.google.android.gms.stats.zze;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class WakeLock {
    private static final long zzb = TimeUnit.DAYS.toMillis(366L);
    private static volatile ScheduledExecutorService zzc = null;
    private static final Object zzd = new Object();
    private static volatile zzd zze = new zzb();
    com.google.android.gms.internal.stats.zzb zza;
    private final Object zzf;
    private final PowerManager.WakeLock zzg;
    private int zzh;
    private Future<?> zzi;
    private long zzj;
    private final Set<zze> zzk;
    private boolean zzl;
    private int zzm;
    private Clock zzn;
    private WorkSource zzo;
    private final String zzp;
    private final String zzq;
    private final Context zzr;
    private final Map<String, zzc> zzs;
    private AtomicInteger zzt;
    private final ScheduledExecutorService zzu;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public WakeLock(Context object, int n, String object2) {
        Object object3;
        String string2 = object.getPackageName();
        this.zzf = new Object();
        this.zzh = 0;
        this.zzk = new HashSet<zze>();
        this.zzl = true;
        this.zzn = DefaultClock.getInstance();
        this.zzs = new HashMap<String, zzc>();
        this.zzt = new AtomicInteger(0);
        Preconditions.checkNotNull(object, "WakeLock: context must not be null");
        Preconditions.checkNotEmpty((String)object2, "WakeLock: wakeLockName must not be empty");
        this.zzr = object.getApplicationContext();
        this.zzq = object2;
        this.zza = null;
        if (!"com.google.android.gms".equals(object.getPackageName())) {
            object3 = String.valueOf(object2);
            object3 = ((String)object3).length() != 0 ? "*gcore*:".concat((String)object3) : new String("*gcore*:");
            this.zzp = object3;
        } else {
            this.zzp = object2;
        }
        object3 = (PowerManager)object.getSystemService("power");
        if (object3 == null) {
            object = new StringBuilder(29);
            ((StringBuilder)object).append("expected a non-null reference", 0, 29);
            throw new zzi(((StringBuilder)object).toString());
        }
        object3 = object3.newWakeLock(n, (String)object2);
        this.zzg = object3;
        if (WorkSourceUtil.hasWorkSourcePermission((Context)object)) {
            object2 = string2;
            if (Strings.isEmptyOrWhitespace(string2)) {
                object2 = object.getPackageName();
            }
            object = WorkSourceUtil.fromPackage((Context)object, (String)object2);
            this.zzo = object;
            if (object != null) {
                WakeLock.zze((PowerManager.WakeLock)object3, (WorkSource)object);
            }
        }
        object = object2 = zzc;
        if (object2 == null) {
            object3 = zzd;
            synchronized (object3) {
                object = object2 = zzc;
                if (object2 == null) {
                    com.google.android.gms.internal.stats.zzh.zza();
                    zzc = object = Executors.unconfigurableScheduledExecutorService(Executors.newScheduledThreadPool(1));
                }
            }
        }
        this.zzu = object;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static /* synthetic */ void zza(WakeLock wakeLock) {
        Object object = wakeLock.zzf;
        synchronized (object) {
            if (!wakeLock.isHeld()) {
                return;
            }
            Log.e((String)"WakeLock", (String)String.valueOf(wakeLock.zzp).concat(" ** IS FORCE-RELEASED ON TIMEOUT **"));
            wakeLock.zzc();
            if (!wakeLock.isHeld()) {
                return;
            }
            wakeLock.zzh = 1;
            wakeLock.zzd(0);
            return;
        }
    }

    private final String zzb(String string2) {
        if (this.zzl) {
            TextUtils.isEmpty(null);
        }
        return null;
    }

    private final void zzc() {
        if (this.zzk.isEmpty()) {
            return;
        }
        Object object = new ArrayList<zze>(this.zzk);
        this.zzk.clear();
        if (object.size() <= 0) {
            return;
        }
        object = (zze)object.get(0);
        throw null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private final void zzd(int n) {
        Throwable throwable22;
        Object object = this.zzf;
        // MONITORENTER : object
        if (!this.isHeld()) {
            // MONITOREXIT : object
            return;
        }
        if (this.zzl) {
            this.zzh = n = this.zzh - 1;
            if (n > 0) {
                // MONITOREXIT : object
                return;
            }
        } else {
            this.zzh = 0;
        }
        this.zzc();
        Object object2 = this.zzs.values().iterator();
        while (object2.hasNext()) {
            object2.next().zza = 0;
        }
        this.zzs.clear();
        object2 = this.zzi;
        if (object2 != null) {
            object2.cancel(false);
            this.zzi = null;
            this.zzj = 0L;
        }
        this.zzm = 0;
        boolean bl = this.zzg.isHeld();
        if (bl) {
            this.zzg.release();
            if (this.zza == null) return;
            this.zza = null;
            return;
        } else {
            Log.e((String)"WakeLock", (String)String.valueOf(this.zzp).concat(" should be held!"));
        }
        return;
        {
            catch (Throwable throwable22) {
            }
            catch (RuntimeException runtimeException) {}
            {
                if (!runtimeException.getClass().equals(RuntimeException.class)) throw runtimeException;
                Log.e((String)"WakeLock", (String)String.valueOf(this.zzp).concat(" failed to release!"), (Throwable)runtimeException);
                if (this.zza == null) return;
                this.zza = null;
                return;
            }
        }
        if (this.zza == null) throw throwable22;
        this.zza = null;
        throw throwable22;
    }

    /*
     * WARNING - void declaration
     */
    private static void zze(PowerManager.WakeLock wakeLock, WorkSource workSource) {
        void var0_3;
        try {
            wakeLock.setWorkSource(workSource);
            return;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Log.wtf((String)"WakeLock", (String)var0_3.toString());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void acquire(long l) {
        long l2;
        this.zzt.incrementAndGet();
        long l3 = zzb;
        long l4 = Long.MAX_VALUE;
        l3 = l2 = Math.max(Math.min(Long.MAX_VALUE, l3), 1L);
        if (l > 0L) {
            l3 = Math.min(l, l2);
        }
        Object object = this.zzf;
        synchronized (object) {
            Object object2;
            if (!this.isHeld()) {
                this.zza = com.google.android.gms.internal.stats.zzb.zza(false, null);
                this.zzg.acquire();
                this.zzn.elapsedRealtime();
            }
            ++this.zzh;
            ++this.zzm;
            this.zzb(null);
            Future future = object2 = this.zzs.get(null);
            if (object2 == null) {
                future = new zzc(null);
                this.zzs.put(null, (zzc)((Object)future));
            }
            ++((zzc)((Object)future)).zza;
            l2 = this.zzn.elapsedRealtime();
            l = l4;
            if (Long.MAX_VALUE - l2 > l3) {
                l = l2 + l3;
            }
            if (l > this.zzj) {
                this.zzj = l;
                future = this.zzi;
                if (future != null) {
                    future.cancel(false);
                }
                object2 = this.zzu;
                future = new zza(this);
                this.zzi = object2.schedule((Runnable)((Object)future), l3, TimeUnit.MILLISECONDS);
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isHeld() {
        Object object = this.zzf;
        synchronized (object) {
            if (this.zzh <= 0) return false;
            return true;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void release() {
        if (this.zzt.decrementAndGet() < 0) {
            Log.e((String)"WakeLock", (String)String.valueOf(this.zzp).concat(" release without a matched acquire!"));
        }
        Object object = this.zzf;
        synchronized (object) {
            block6: {
                block5: {
                    this.zzb(null);
                    if (!this.zzs.containsKey(null)) break block5;
                    zzc zzc2 = this.zzs.get(null);
                    if (zzc2 != null) {
                        int n;
                        zzc2.zza = n = zzc2.zza - 1;
                        if (n == 0) {
                            this.zzs.remove(null);
                        }
                    }
                    break block6;
                }
                Log.w((String)"WakeLock", (String)String.valueOf(this.zzp).concat(" counter does not exist"));
            }
            this.zzd(0);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setReferenceCounted(boolean bl) {
        Object object = this.zzf;
        synchronized (object) {
            this.zzl = bl;
            return;
        }
    }
}

