/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.appbar;

import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.Region;
import android.graphics.Typeface;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.FrameLayout;
import androidx.appcompat.R;
import androidx.appcompat.widget.Toolbar;
import androidx.core.content.ContextCompat;
import androidx.core.graphics.drawable.DrawableCompat;
import androidx.core.math.MathUtils;
import androidx.core.util.ObjectsCompat;
import androidx.core.view.OnApplyWindowInsetsListener;
import androidx.core.view.ViewCompat;
import androidx.core.view.WindowInsetsCompat;
import com.google.android.material.R;
import com.google.android.material.animation.AnimationUtils;
import com.google.android.material.appbar.AppBarLayout;
import com.google.android.material.appbar.ViewOffsetHelper;
import com.google.android.material.elevation.ElevationOverlayProvider;
import com.google.android.material.internal.CollapsingTextHelper;
import com.google.android.material.internal.DescendantOffsetUtils;
import com.google.android.material.internal.ThemeEnforcement;
import com.google.android.material.resources.MaterialResources;
import com.google.android.material.theme.overlay.MaterialThemeOverlay;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class CollapsingToolbarLayout
extends FrameLayout {
    private static final int DEFAULT_SCRIM_ANIMATION_DURATION = 600;
    private static final int DEF_STYLE_RES = R.style.Widget_Design_CollapsingToolbar;
    public static final int TITLE_COLLAPSE_MODE_FADE = 1;
    public static final int TITLE_COLLAPSE_MODE_SCALE = 0;
    final CollapsingTextHelper collapsingTextHelper;
    private boolean collapsingTitleEnabled;
    private Drawable contentScrim;
    int currentOffset;
    private boolean drawCollapsingTitle;
    private View dummyView;
    final ElevationOverlayProvider elevationOverlayProvider;
    private int expandedMarginBottom;
    private int expandedMarginEnd;
    private int expandedMarginStart;
    private int expandedMarginTop;
    private int extraMultilineHeight;
    private boolean extraMultilineHeightEnabled;
    private boolean forceApplySystemWindowInsetTop;
    WindowInsetsCompat lastInsets;
    private AppBarLayout.OnOffsetChangedListener onOffsetChangedListener;
    private boolean refreshToolbar;
    private int scrimAlpha;
    private long scrimAnimationDuration;
    private ValueAnimator scrimAnimator;
    private int scrimVisibleHeightTrigger;
    private boolean scrimsAreShown;
    Drawable statusBarScrim;
    private int titleCollapseMode;
    private final Rect tmpRect;
    private ViewGroup toolbar;
    private View toolbarDirectChild;
    private int toolbarId;
    private int topInsetApplied;

    public CollapsingToolbarLayout(Context context) {
        this(context, null);
    }

    public CollapsingToolbarLayout(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, R.attr.collapsingToolbarLayoutStyle);
    }

    public CollapsingToolbarLayout(Context object, AttributeSet attributeSet, int n) {
        int n2 = DEF_STYLE_RES;
        super(MaterialThemeOverlay.wrap((Context)object, attributeSet, n, n2), attributeSet, n);
        this.refreshToolbar = true;
        this.tmpRect = new Rect();
        this.scrimVisibleHeightTrigger = -1;
        this.topInsetApplied = 0;
        this.extraMultilineHeight = 0;
        Context context = this.getContext();
        object = new CollapsingTextHelper((View)this);
        this.collapsingTextHelper = object;
        ((CollapsingTextHelper)object).setTextSizeInterpolator(AnimationUtils.DECELERATE_INTERPOLATOR);
        ((CollapsingTextHelper)object).setRtlTextDirectionHeuristicsEnabled(false);
        this.elevationOverlayProvider = new ElevationOverlayProvider(context);
        attributeSet = ThemeEnforcement.obtainStyledAttributes(context, attributeSet, R.styleable.CollapsingToolbarLayout, n, n2, new int[0]);
        ((CollapsingTextHelper)object).setExpandedTextGravity(attributeSet.getInt(R.styleable.CollapsingToolbarLayout_expandedTitleGravity, 8388691));
        ((CollapsingTextHelper)object).setCollapsedTextGravity(attributeSet.getInt(R.styleable.CollapsingToolbarLayout_collapsedTitleGravity, 8388627));
        this.expandedMarginBottom = n = attributeSet.getDimensionPixelSize(R.styleable.CollapsingToolbarLayout_expandedTitleMargin, 0);
        this.expandedMarginEnd = n;
        this.expandedMarginTop = n;
        this.expandedMarginStart = n;
        if (attributeSet.hasValue(R.styleable.CollapsingToolbarLayout_expandedTitleMarginStart)) {
            this.expandedMarginStart = attributeSet.getDimensionPixelSize(R.styleable.CollapsingToolbarLayout_expandedTitleMarginStart, 0);
        }
        if (attributeSet.hasValue(R.styleable.CollapsingToolbarLayout_expandedTitleMarginEnd)) {
            this.expandedMarginEnd = attributeSet.getDimensionPixelSize(R.styleable.CollapsingToolbarLayout_expandedTitleMarginEnd, 0);
        }
        if (attributeSet.hasValue(R.styleable.CollapsingToolbarLayout_expandedTitleMarginTop)) {
            this.expandedMarginTop = attributeSet.getDimensionPixelSize(R.styleable.CollapsingToolbarLayout_expandedTitleMarginTop, 0);
        }
        if (attributeSet.hasValue(R.styleable.CollapsingToolbarLayout_expandedTitleMarginBottom)) {
            this.expandedMarginBottom = attributeSet.getDimensionPixelSize(R.styleable.CollapsingToolbarLayout_expandedTitleMarginBottom, 0);
        }
        this.collapsingTitleEnabled = attributeSet.getBoolean(R.styleable.CollapsingToolbarLayout_titleEnabled, true);
        this.setTitle(attributeSet.getText(R.styleable.CollapsingToolbarLayout_title));
        ((CollapsingTextHelper)object).setExpandedTextAppearance(R.style.TextAppearance_Design_CollapsingToolbar_Expanded);
        ((CollapsingTextHelper)object).setCollapsedTextAppearance(R.style.TextAppearance_AppCompat_Widget_ActionBar_Title);
        if (attributeSet.hasValue(R.styleable.CollapsingToolbarLayout_expandedTitleTextAppearance)) {
            ((CollapsingTextHelper)object).setExpandedTextAppearance(attributeSet.getResourceId(R.styleable.CollapsingToolbarLayout_expandedTitleTextAppearance, 0));
        }
        if (attributeSet.hasValue(R.styleable.CollapsingToolbarLayout_collapsedTitleTextAppearance)) {
            ((CollapsingTextHelper)object).setCollapsedTextAppearance(attributeSet.getResourceId(R.styleable.CollapsingToolbarLayout_collapsedTitleTextAppearance, 0));
        }
        if (attributeSet.hasValue(R.styleable.CollapsingToolbarLayout_expandedTitleTextColor)) {
            ((CollapsingTextHelper)object).setExpandedTextColor(MaterialResources.getColorStateList(context, (TypedArray)attributeSet, R.styleable.CollapsingToolbarLayout_expandedTitleTextColor));
        }
        if (attributeSet.hasValue(R.styleable.CollapsingToolbarLayout_collapsedTitleTextColor)) {
            ((CollapsingTextHelper)object).setCollapsedTextColor(MaterialResources.getColorStateList(context, (TypedArray)attributeSet, R.styleable.CollapsingToolbarLayout_collapsedTitleTextColor));
        }
        this.scrimVisibleHeightTrigger = attributeSet.getDimensionPixelSize(R.styleable.CollapsingToolbarLayout_scrimVisibleHeightTrigger, -1);
        if (attributeSet.hasValue(R.styleable.CollapsingToolbarLayout_maxLines)) {
            ((CollapsingTextHelper)object).setMaxLines(attributeSet.getInt(R.styleable.CollapsingToolbarLayout_maxLines, 1));
        }
        if (attributeSet.hasValue(R.styleable.CollapsingToolbarLayout_titlePositionInterpolator)) {
            ((CollapsingTextHelper)object).setPositionInterpolator((TimeInterpolator)android.view.animation.AnimationUtils.loadInterpolator((Context)context, (int)attributeSet.getResourceId(R.styleable.CollapsingToolbarLayout_titlePositionInterpolator, 0)));
        }
        this.scrimAnimationDuration = attributeSet.getInt(R.styleable.CollapsingToolbarLayout_scrimAnimationDuration, 600);
        this.setContentScrim(attributeSet.getDrawable(R.styleable.CollapsingToolbarLayout_contentScrim));
        this.setStatusBarScrim(attributeSet.getDrawable(R.styleable.CollapsingToolbarLayout_statusBarScrim));
        this.setTitleCollapseMode(attributeSet.getInt(R.styleable.CollapsingToolbarLayout_titleCollapseMode, 0));
        this.toolbarId = attributeSet.getResourceId(R.styleable.CollapsingToolbarLayout_toolbarId, -1);
        this.forceApplySystemWindowInsetTop = attributeSet.getBoolean(R.styleable.CollapsingToolbarLayout_forceApplySystemWindowInsetTop, false);
        this.extraMultilineHeightEnabled = attributeSet.getBoolean(R.styleable.CollapsingToolbarLayout_extraMultilineHeightEnabled, false);
        attributeSet.recycle();
        this.setWillNotDraw(false);
        ViewCompat.setOnApplyWindowInsetsListener((View)this, (OnApplyWindowInsetsListener)new OnApplyWindowInsetsListener(){

            public WindowInsetsCompat onApplyWindowInsets(View view, WindowInsetsCompat windowInsetsCompat) {
                return CollapsingToolbarLayout.this.onWindowInsetChanged(windowInsetsCompat);
            }
        });
    }

    private void animateScrim(int n) {
        this.ensureToolbar();
        ValueAnimator valueAnimator = this.scrimAnimator;
        if (valueAnimator == null) {
            ValueAnimator valueAnimator2;
            this.scrimAnimator = valueAnimator2 = new ValueAnimator();
            valueAnimator = n > this.scrimAlpha ? AnimationUtils.FAST_OUT_LINEAR_IN_INTERPOLATOR : AnimationUtils.LINEAR_OUT_SLOW_IN_INTERPOLATOR;
            valueAnimator2.setInterpolator((TimeInterpolator)valueAnimator);
            this.scrimAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator valueAnimator) {
                    CollapsingToolbarLayout.this.setScrimAlpha((Integer)valueAnimator.getAnimatedValue());
                }
            });
        } else if (valueAnimator.isRunning()) {
            this.scrimAnimator.cancel();
        }
        this.scrimAnimator.setDuration(this.scrimAnimationDuration);
        this.scrimAnimator.setIntValues(new int[]{this.scrimAlpha, n});
        this.scrimAnimator.start();
    }

    private void disableLiftOnScrollIfNeeded(AppBarLayout appBarLayout) {
        if (this.isTitleCollapseFadeMode()) {
            appBarLayout.setLiftOnScroll(false);
        }
    }

    private void ensureToolbar() {
        ViewGroup viewGroup;
        if (!this.refreshToolbar) {
            return;
        }
        Object var1_1 = null;
        this.toolbar = null;
        this.toolbarDirectChild = null;
        int n = this.toolbarId;
        if (n != -1) {
            this.toolbar = viewGroup = (ViewGroup)this.findViewById(n);
            if (viewGroup != null) {
                this.toolbarDirectChild = this.findDirectChild((View)viewGroup);
            }
        }
        if (this.toolbar == null) {
            int n2 = this.getChildCount();
            n = 0;
            while (true) {
                viewGroup = var1_1;
                if (n >= n2 || CollapsingToolbarLayout.isToolbar((View)(viewGroup = this.getChildAt(n)))) break;
                ++n;
            }
            this.toolbar = viewGroup;
        }
        this.updateDummyView();
        this.refreshToolbar = false;
    }

    private View findDirectChild(View view) {
        ViewParent viewParent = view.getParent();
        View view2 = view;
        for (view = viewParent; view != this && view != null; view = view.getParent()) {
            if (!(view instanceof View)) continue;
            view2 = view;
        }
        return view2;
    }

    private static int getHeightWithMargins(View view) {
        ViewGroup.LayoutParams layoutParams = view.getLayoutParams();
        if (layoutParams instanceof ViewGroup.MarginLayoutParams) {
            layoutParams = (ViewGroup.MarginLayoutParams)layoutParams;
            return view.getMeasuredHeight() + layoutParams.topMargin + layoutParams.bottomMargin;
        }
        return view.getMeasuredHeight();
    }

    private static CharSequence getToolbarTitle(View view) {
        if (view instanceof Toolbar) {
            return ((Toolbar)view).getTitle();
        }
        if (Build.VERSION.SDK_INT >= 21 && view instanceof android.widget.Toolbar) {
            return ((android.widget.Toolbar)view).getTitle();
        }
        return null;
    }

    static ViewOffsetHelper getViewOffsetHelper(View view) {
        ViewOffsetHelper viewOffsetHelper;
        ViewOffsetHelper viewOffsetHelper2 = viewOffsetHelper = (ViewOffsetHelper)view.getTag(R.id.view_offset_helper);
        if (viewOffsetHelper == null) {
            viewOffsetHelper2 = new ViewOffsetHelper(view);
            view.setTag(R.id.view_offset_helper, (Object)viewOffsetHelper2);
        }
        return viewOffsetHelper2;
    }

    private boolean isTitleCollapseFadeMode() {
        int n = this.titleCollapseMode;
        boolean bl = true;
        if (n != 1) {
            bl = false;
        }
        return bl;
    }

    private static boolean isToolbar(View view) {
        boolean bl = view instanceof Toolbar || Build.VERSION.SDK_INT >= 21 && view instanceof android.widget.Toolbar;
        return bl;
    }

    private boolean isToolbarChild(View view) {
        View view2 = this.toolbarDirectChild;
        boolean bl = true;
        if (!(view2 != null && view2 != this ? view == view2 : view == this.toolbar)) {
            bl = false;
        }
        return bl;
    }

    private void updateCollapsedBounds(boolean bl) {
        int n;
        int n2;
        int n3;
        Object object = this.toolbarDirectChild;
        if (object == null) {
            object = this.toolbar;
        }
        int n4 = this.getMaxOffsetForPinChild((View)object);
        DescendantOffsetUtils.getDescendantRect((ViewGroup)this, this.dummyView, this.tmpRect);
        object = this.toolbar;
        boolean bl2 = object instanceof Toolbar;
        int n5 = 0;
        if (bl2) {
            object = (Toolbar)object;
            n5 = object.getTitleMarginStart();
            n3 = object.getTitleMarginEnd();
            n2 = object.getTitleMarginTop();
            n = object.getTitleMarginBottom();
        } else if (Build.VERSION.SDK_INT >= 24 && (object = this.toolbar) instanceof android.widget.Toolbar) {
            object = (android.widget.Toolbar)object;
            n5 = object.getTitleMarginStart();
            n3 = object.getTitleMarginEnd();
            n2 = object.getTitleMarginTop();
            n = object.getTitleMarginBottom();
        } else {
            n = 0;
            n3 = 0;
            n2 = 0;
        }
        object = this.collapsingTextHelper;
        int n6 = this.tmpRect.left;
        int n7 = bl ? n3 : n5;
        int n8 = this.tmpRect.top;
        int n9 = this.tmpRect.right;
        if (bl) {
            n3 = n5;
        }
        ((CollapsingTextHelper)object).setCollapsedBounds(n6 + n7, n8 + n4 + n2, n9 - n3, this.tmpRect.bottom + n4 - n);
    }

    private void updateContentDescriptionFromTitle() {
        this.setContentDescription(this.getTitle());
    }

    private void updateContentScrimBounds(Drawable drawable2, int n, int n2) {
        this.updateContentScrimBounds(drawable2, (View)this.toolbar, n, n2);
    }

    private void updateContentScrimBounds(Drawable drawable2, View view, int n, int n2) {
        int n3 = n2;
        if (this.isTitleCollapseFadeMode()) {
            n3 = n2;
            if (view != null) {
                n3 = n2;
                if (this.collapsingTitleEnabled) {
                    n3 = view.getBottom();
                }
            }
        }
        drawable2.setBounds(0, 0, n, n3);
    }

    private void updateDummyView() {
        View view;
        if (!this.collapsingTitleEnabled && (view = this.dummyView) != null && (view = view.getParent()) instanceof ViewGroup) {
            ((ViewGroup)view).removeView(this.dummyView);
        }
        if (this.collapsingTitleEnabled && this.toolbar != null) {
            if (this.dummyView == null) {
                this.dummyView = new View(this.getContext());
            }
            if (this.dummyView.getParent() == null) {
                this.toolbar.addView(this.dummyView, -1, -1);
            }
        }
    }

    private void updateTextBounds(int n, int n2, int n3, int n4, boolean bl) {
        Object object;
        if (this.collapsingTitleEnabled && (object = this.dummyView) != null) {
            boolean bl2 = ViewCompat.isAttachedToWindow((View)object);
            boolean bl3 = false;
            bl2 = bl2 && this.dummyView.getVisibility() == 0;
            this.drawCollapsingTitle = bl2;
            if (bl2 || bl) {
                bl2 = bl3;
                if (ViewCompat.getLayoutDirection((View)this) == 1) {
                    bl2 = true;
                }
                this.updateCollapsedBounds(bl2);
                object = this.collapsingTextHelper;
                int n5 = bl2 ? this.expandedMarginEnd : this.expandedMarginStart;
                int n6 = this.tmpRect.top;
                int n7 = this.expandedMarginTop;
                int n8 = bl2 ? this.expandedMarginStart : this.expandedMarginEnd;
                ((CollapsingTextHelper)object).setExpandedBounds(n5, n6 + n7, n3 - n - n8, n4 - n2 - this.expandedMarginBottom);
                this.collapsingTextHelper.recalculate(bl);
            }
        }
    }

    private void updateTitleFromToolbarIfNeeded() {
        if (this.toolbar != null && this.collapsingTitleEnabled && TextUtils.isEmpty((CharSequence)this.collapsingTextHelper.getText())) {
            this.setTitle(CollapsingToolbarLayout.getToolbarTitle((View)this.toolbar));
        }
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return layoutParams instanceof LayoutParams;
    }

    public void draw(Canvas canvas) {
        int n;
        Drawable drawable2;
        super.draw(canvas);
        this.ensureToolbar();
        if (this.toolbar == null && (drawable2 = this.contentScrim) != null && this.scrimAlpha > 0) {
            drawable2.mutate().setAlpha(this.scrimAlpha);
            this.contentScrim.draw(canvas);
        }
        if (this.collapsingTitleEnabled && this.drawCollapsingTitle) {
            if (this.toolbar != null && this.contentScrim != null && this.scrimAlpha > 0 && this.isTitleCollapseFadeMode() && this.collapsingTextHelper.getExpansionFraction() < this.collapsingTextHelper.getFadeModeThresholdFraction()) {
                n = canvas.save();
                canvas.clipRect(this.contentScrim.getBounds(), Region.Op.DIFFERENCE);
                this.collapsingTextHelper.draw(canvas);
                canvas.restoreToCount(n);
            } else {
                this.collapsingTextHelper.draw(canvas);
            }
        }
        if (this.statusBarScrim != null && this.scrimAlpha > 0 && (n = (drawable2 = this.lastInsets) != null ? drawable2.getSystemWindowInsetTop() : 0) > 0) {
            this.statusBarScrim.setBounds(0, -this.currentOffset, this.getWidth(), n - this.currentOffset);
            this.statusBarScrim.mutate().setAlpha(this.scrimAlpha);
            this.statusBarScrim.draw(canvas);
        }
    }

    protected boolean drawChild(Canvas canvas, View view, long l) {
        boolean bl;
        Drawable drawable2 = this.contentScrim;
        boolean bl2 = true;
        if (drawable2 != null && this.scrimAlpha > 0 && this.isToolbarChild(view)) {
            this.updateContentScrimBounds(this.contentScrim, view, this.getWidth(), this.getHeight());
            this.contentScrim.mutate().setAlpha(this.scrimAlpha);
            this.contentScrim.draw(canvas);
            bl = true;
        } else {
            bl = false;
        }
        boolean bl3 = bl2;
        if (!super.drawChild(canvas, view, l)) {
            bl3 = bl ? bl2 : false;
        }
        return bl3;
    }

    protected void drawableStateChanged() {
        boolean bl;
        super.drawableStateChanged();
        int[] nArray = this.getDrawableState();
        Object object = this.statusBarScrim;
        boolean bl2 = bl = false;
        if (object != null) {
            bl2 = bl;
            if (object.isStateful()) {
                bl2 = false | object.setState(nArray);
            }
        }
        object = this.contentScrim;
        bl = bl2;
        if (object != null) {
            bl = bl2;
            if (object.isStateful()) {
                bl = bl2 | object.setState(nArray);
            }
        }
        object = this.collapsingTextHelper;
        bl2 = bl;
        if (object != null) {
            bl2 = bl | ((CollapsingTextHelper)object).setState(nArray);
        }
        if (bl2) {
            this.invalidate();
        }
    }

    protected LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams(-1, -1);
    }

    public FrameLayout.LayoutParams generateLayoutParams(AttributeSet attributeSet) {
        return new LayoutParams(this.getContext(), attributeSet);
    }

    protected FrameLayout.LayoutParams generateLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return new LayoutParams(layoutParams);
    }

    public int getCollapsedTitleGravity() {
        return this.collapsingTextHelper.getCollapsedTextGravity();
    }

    public Typeface getCollapsedTitleTypeface() {
        return this.collapsingTextHelper.getCollapsedTypeface();
    }

    public Drawable getContentScrim() {
        return this.contentScrim;
    }

    public int getExpandedTitleGravity() {
        return this.collapsingTextHelper.getExpandedTextGravity();
    }

    public int getExpandedTitleMarginBottom() {
        return this.expandedMarginBottom;
    }

    public int getExpandedTitleMarginEnd() {
        return this.expandedMarginEnd;
    }

    public int getExpandedTitleMarginStart() {
        return this.expandedMarginStart;
    }

    public int getExpandedTitleMarginTop() {
        return this.expandedMarginTop;
    }

    public Typeface getExpandedTitleTypeface() {
        return this.collapsingTextHelper.getExpandedTypeface();
    }

    public int getHyphenationFrequency() {
        return this.collapsingTextHelper.getHyphenationFrequency();
    }

    public int getLineCount() {
        return this.collapsingTextHelper.getLineCount();
    }

    public float getLineSpacingAdd() {
        return this.collapsingTextHelper.getLineSpacingAdd();
    }

    public float getLineSpacingMultiplier() {
        return this.collapsingTextHelper.getLineSpacingMultiplier();
    }

    public int getMaxLines() {
        return this.collapsingTextHelper.getMaxLines();
    }

    final int getMaxOffsetForPinChild(View view) {
        ViewOffsetHelper viewOffsetHelper = CollapsingToolbarLayout.getViewOffsetHelper(view);
        LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
        return this.getHeight() - viewOffsetHelper.getLayoutTop() - view.getHeight() - layoutParams.bottomMargin;
    }

    int getScrimAlpha() {
        return this.scrimAlpha;
    }

    public long getScrimAnimationDuration() {
        return this.scrimAnimationDuration;
    }

    public int getScrimVisibleHeightTrigger() {
        int n = this.scrimVisibleHeightTrigger;
        if (n >= 0) {
            return n + this.topInsetApplied + this.extraMultilineHeight;
        }
        WindowInsetsCompat windowInsetsCompat = this.lastInsets;
        n = windowInsetsCompat != null ? windowInsetsCompat.getSystemWindowInsetTop() : 0;
        int n2 = ViewCompat.getMinimumHeight((View)this);
        if (n2 > 0) {
            return Math.min(n2 * 2 + n, this.getHeight());
        }
        return this.getHeight() / 3;
    }

    public Drawable getStatusBarScrim() {
        return this.statusBarScrim;
    }

    public CharSequence getTitle() {
        CharSequence charSequence = this.collapsingTitleEnabled ? this.collapsingTextHelper.getText() : null;
        return charSequence;
    }

    public int getTitleCollapseMode() {
        return this.titleCollapseMode;
    }

    public TimeInterpolator getTitlePositionInterpolator() {
        return this.collapsingTextHelper.getPositionInterpolator();
    }

    public boolean isExtraMultilineHeightEnabled() {
        return this.extraMultilineHeightEnabled;
    }

    public boolean isForceApplySystemWindowInsetTop() {
        return this.forceApplySystemWindowInsetTop;
    }

    public boolean isRtlTextDirectionHeuristicsEnabled() {
        return this.collapsingTextHelper.isRtlTextDirectionHeuristicsEnabled();
    }

    public boolean isTitleEnabled() {
        return this.collapsingTitleEnabled;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        Object object = this.getParent();
        if (object instanceof AppBarLayout) {
            object = (AppBarLayout)((Object)object);
            this.disableLiftOnScrollIfNeeded((AppBarLayout)((Object)object));
            ViewCompat.setFitsSystemWindows((View)this, (boolean)ViewCompat.getFitsSystemWindows((View)object));
            if (this.onOffsetChangedListener == null) {
                this.onOffsetChangedListener = new OffsetUpdateListener();
            }
            ((AppBarLayout)((Object)object)).addOnOffsetChangedListener(this.onOffsetChangedListener);
            ViewCompat.requestApplyInsets((View)this);
        }
    }

    protected void onDetachedFromWindow() {
        ViewParent viewParent = this.getParent();
        AppBarLayout.OnOffsetChangedListener onOffsetChangedListener = this.onOffsetChangedListener;
        if (onOffsetChangedListener != null && viewParent instanceof AppBarLayout) {
            ((AppBarLayout)viewParent).removeOnOffsetChangedListener(onOffsetChangedListener);
        }
        super.onDetachedFromWindow();
    }

    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        super.onLayout(bl, n, n2, n3, n4);
        WindowInsetsCompat windowInsetsCompat = this.lastInsets;
        int n7 = 0;
        if (windowInsetsCompat != null) {
            int n8 = windowInsetsCompat.getSystemWindowInsetTop();
            n6 = this.getChildCount();
            for (n5 = 0; n5 < n6; ++n5) {
                windowInsetsCompat = this.getChildAt(n5);
                if (ViewCompat.getFitsSystemWindows((View)windowInsetsCompat) || windowInsetsCompat.getTop() >= n8) continue;
                ViewCompat.offsetTopAndBottom((View)windowInsetsCompat, (int)n8);
            }
        }
        n6 = this.getChildCount();
        for (n5 = 0; n5 < n6; ++n5) {
            CollapsingToolbarLayout.getViewOffsetHelper(this.getChildAt(n5)).onViewLayout();
        }
        this.updateTextBounds(n, n2, n3, n4, false);
        this.updateTitleFromToolbarIfNeeded();
        this.updateScrimVisibility();
        n2 = this.getChildCount();
        for (n = n7; n < n2; ++n) {
            CollapsingToolbarLayout.getViewOffsetHelper(this.getChildAt(n)).applyOffsets();
        }
    }

    protected void onMeasure(int n, int n2) {
        this.ensureToolbar();
        super.onMeasure(n, n2);
        int n3 = View.MeasureSpec.getMode((int)n2);
        WindowInsetsCompat windowInsetsCompat = this.lastInsets;
        n2 = windowInsetsCompat != null ? windowInsetsCompat.getSystemWindowInsetTop() : 0;
        if ((n3 == 0 || this.forceApplySystemWindowInsetTop) && n2 > 0) {
            this.topInsetApplied = n2;
            super.onMeasure(n, View.MeasureSpec.makeMeasureSpec((int)(this.getMeasuredHeight() + n2), (int)0x40000000));
        }
        if (this.extraMultilineHeightEnabled && this.collapsingTextHelper.getMaxLines() > 1) {
            this.updateTitleFromToolbarIfNeeded();
            this.updateTextBounds(0, 0, this.getMeasuredWidth(), this.getMeasuredHeight(), true);
            n2 = this.collapsingTextHelper.getExpandedLineCount();
            if (n2 > 1) {
                this.extraMultilineHeight = Math.round(this.collapsingTextHelper.getExpandedTextFullHeight()) * (n2 - 1);
                super.onMeasure(n, View.MeasureSpec.makeMeasureSpec((int)(this.getMeasuredHeight() + this.extraMultilineHeight), (int)0x40000000));
            }
        }
        if ((windowInsetsCompat = this.toolbar) != null) {
            View view = this.toolbarDirectChild;
            if (view != null && view != this) {
                this.setMinimumHeight(CollapsingToolbarLayout.getHeightWithMargins(view));
            } else {
                this.setMinimumHeight(CollapsingToolbarLayout.getHeightWithMargins((View)windowInsetsCompat));
            }
        }
    }

    protected void onSizeChanged(int n, int n2, int n3, int n4) {
        super.onSizeChanged(n, n2, n3, n4);
        Drawable drawable2 = this.contentScrim;
        if (drawable2 != null) {
            this.updateContentScrimBounds(drawable2, n, n2);
        }
    }

    WindowInsetsCompat onWindowInsetChanged(WindowInsetsCompat windowInsetsCompat) {
        Object object = ViewCompat.getFitsSystemWindows((View)this) ? windowInsetsCompat : null;
        if (!ObjectsCompat.equals((Object)this.lastInsets, (Object)object)) {
            this.lastInsets = object;
            this.requestLayout();
        }
        return windowInsetsCompat.consumeSystemWindowInsets();
    }

    public void setCollapsedTitleGravity(int n) {
        this.collapsingTextHelper.setCollapsedTextGravity(n);
    }

    public void setCollapsedTitleTextAppearance(int n) {
        this.collapsingTextHelper.setCollapsedTextAppearance(n);
    }

    public void setCollapsedTitleTextColor(int n) {
        this.setCollapsedTitleTextColor(ColorStateList.valueOf((int)n));
    }

    public void setCollapsedTitleTextColor(ColorStateList colorStateList) {
        this.collapsingTextHelper.setCollapsedTextColor(colorStateList);
    }

    public void setCollapsedTitleTypeface(Typeface typeface) {
        this.collapsingTextHelper.setCollapsedTypeface(typeface);
    }

    public void setContentScrim(Drawable drawable2) {
        Drawable drawable3 = this.contentScrim;
        if (drawable3 != drawable2) {
            Drawable drawable4 = null;
            if (drawable3 != null) {
                drawable3.setCallback(null);
            }
            if (drawable2 != null) {
                drawable4 = drawable2.mutate();
            }
            this.contentScrim = drawable4;
            if (drawable4 != null) {
                this.updateContentScrimBounds(drawable4, this.getWidth(), this.getHeight());
                this.contentScrim.setCallback((Drawable.Callback)this);
                this.contentScrim.setAlpha(this.scrimAlpha);
            }
            ViewCompat.postInvalidateOnAnimation((View)this);
        }
    }

    public void setContentScrimColor(int n) {
        this.setContentScrim((Drawable)new ColorDrawable(n));
    }

    public void setContentScrimResource(int n) {
        this.setContentScrim(ContextCompat.getDrawable((Context)this.getContext(), (int)n));
    }

    public void setExpandedTitleColor(int n) {
        this.setExpandedTitleTextColor(ColorStateList.valueOf((int)n));
    }

    public void setExpandedTitleGravity(int n) {
        this.collapsingTextHelper.setExpandedTextGravity(n);
    }

    public void setExpandedTitleMargin(int n, int n2, int n3, int n4) {
        this.expandedMarginStart = n;
        this.expandedMarginTop = n2;
        this.expandedMarginEnd = n3;
        this.expandedMarginBottom = n4;
        this.requestLayout();
    }

    public void setExpandedTitleMarginBottom(int n) {
        this.expandedMarginBottom = n;
        this.requestLayout();
    }

    public void setExpandedTitleMarginEnd(int n) {
        this.expandedMarginEnd = n;
        this.requestLayout();
    }

    public void setExpandedTitleMarginStart(int n) {
        this.expandedMarginStart = n;
        this.requestLayout();
    }

    public void setExpandedTitleMarginTop(int n) {
        this.expandedMarginTop = n;
        this.requestLayout();
    }

    public void setExpandedTitleTextAppearance(int n) {
        this.collapsingTextHelper.setExpandedTextAppearance(n);
    }

    public void setExpandedTitleTextColor(ColorStateList colorStateList) {
        this.collapsingTextHelper.setExpandedTextColor(colorStateList);
    }

    public void setExpandedTitleTypeface(Typeface typeface) {
        this.collapsingTextHelper.setExpandedTypeface(typeface);
    }

    public void setExtraMultilineHeightEnabled(boolean bl) {
        this.extraMultilineHeightEnabled = bl;
    }

    public void setForceApplySystemWindowInsetTop(boolean bl) {
        this.forceApplySystemWindowInsetTop = bl;
    }

    public void setHyphenationFrequency(int n) {
        this.collapsingTextHelper.setHyphenationFrequency(n);
    }

    public void setLineSpacingAdd(float f) {
        this.collapsingTextHelper.setLineSpacingAdd(f);
    }

    public void setLineSpacingMultiplier(float f) {
        this.collapsingTextHelper.setLineSpacingMultiplier(f);
    }

    public void setMaxLines(int n) {
        this.collapsingTextHelper.setMaxLines(n);
    }

    public void setRtlTextDirectionHeuristicsEnabled(boolean bl) {
        this.collapsingTextHelper.setRtlTextDirectionHeuristicsEnabled(bl);
    }

    void setScrimAlpha(int n) {
        if (n != this.scrimAlpha) {
            ViewGroup viewGroup;
            if (this.contentScrim != null && (viewGroup = this.toolbar) != null) {
                ViewCompat.postInvalidateOnAnimation((View)viewGroup);
            }
            this.scrimAlpha = n;
            ViewCompat.postInvalidateOnAnimation((View)this);
        }
    }

    public void setScrimAnimationDuration(long l) {
        this.scrimAnimationDuration = l;
    }

    public void setScrimVisibleHeightTrigger(int n) {
        if (this.scrimVisibleHeightTrigger != n) {
            this.scrimVisibleHeightTrigger = n;
            this.updateScrimVisibility();
        }
    }

    public void setScrimsShown(boolean bl) {
        boolean bl2 = ViewCompat.isLaidOut((View)this) && !this.isInEditMode();
        this.setScrimsShown(bl, bl2);
    }

    public void setScrimsShown(boolean bl, boolean bl2) {
        if (this.scrimsAreShown != bl) {
            int n = 255;
            if (bl2) {
                if (!bl) {
                    n = 0;
                }
                this.animateScrim(n);
            } else {
                if (!bl) {
                    n = 0;
                }
                this.setScrimAlpha(n);
            }
            this.scrimsAreShown = bl;
        }
    }

    public void setStatusBarScrim(Drawable drawable2) {
        Drawable drawable3 = this.statusBarScrim;
        if (drawable3 != drawable2) {
            Drawable drawable4 = null;
            if (drawable3 != null) {
                drawable3.setCallback(null);
            }
            if (drawable2 != null) {
                drawable4 = drawable2.mutate();
            }
            this.statusBarScrim = drawable4;
            if (drawable4 != null) {
                if (drawable4.isStateful()) {
                    this.statusBarScrim.setState(this.getDrawableState());
                }
                DrawableCompat.setLayoutDirection((Drawable)this.statusBarScrim, (int)ViewCompat.getLayoutDirection((View)this));
                drawable2 = this.statusBarScrim;
                boolean bl = this.getVisibility() == 0;
                drawable2.setVisible(bl, false);
                this.statusBarScrim.setCallback((Drawable.Callback)this);
                this.statusBarScrim.setAlpha(this.scrimAlpha);
            }
            ViewCompat.postInvalidateOnAnimation((View)this);
        }
    }

    public void setStatusBarScrimColor(int n) {
        this.setStatusBarScrim((Drawable)new ColorDrawable(n));
    }

    public void setStatusBarScrimResource(int n) {
        this.setStatusBarScrim(ContextCompat.getDrawable((Context)this.getContext(), (int)n));
    }

    public void setTitle(CharSequence charSequence) {
        this.collapsingTextHelper.setText(charSequence);
        this.updateContentDescriptionFromTitle();
    }

    public void setTitleCollapseMode(int n) {
        this.titleCollapseMode = n;
        boolean bl = this.isTitleCollapseFadeMode();
        this.collapsingTextHelper.setFadeModeEnabled(bl);
        ViewParent viewParent = this.getParent();
        if (viewParent instanceof AppBarLayout) {
            this.disableLiftOnScrollIfNeeded((AppBarLayout)viewParent);
        }
        if (bl && this.contentScrim == null) {
            float f = this.getResources().getDimension(R.dimen.design_appbar_elevation);
            this.setContentScrimColor(this.elevationOverlayProvider.compositeOverlayWithThemeSurfaceColorIfNeeded(f));
        }
    }

    public void setTitleEnabled(boolean bl) {
        if (bl != this.collapsingTitleEnabled) {
            this.collapsingTitleEnabled = bl;
            this.updateContentDescriptionFromTitle();
            this.updateDummyView();
            this.requestLayout();
        }
    }

    public void setTitlePositionInterpolator(TimeInterpolator timeInterpolator) {
        this.collapsingTextHelper.setPositionInterpolator(timeInterpolator);
    }

    public void setVisibility(int n) {
        super.setVisibility(n);
        boolean bl = n == 0;
        Drawable drawable2 = this.statusBarScrim;
        if (drawable2 != null && drawable2.isVisible() != bl) {
            this.statusBarScrim.setVisible(bl, false);
        }
        if ((drawable2 = this.contentScrim) != null && drawable2.isVisible() != bl) {
            this.contentScrim.setVisible(bl, false);
        }
    }

    final void updateScrimVisibility() {
        if (this.contentScrim != null || this.statusBarScrim != null) {
            boolean bl = this.getHeight() + this.currentOffset < this.getScrimVisibleHeightTrigger();
            this.setScrimsShown(bl);
        }
    }

    protected boolean verifyDrawable(Drawable drawable2) {
        boolean bl = super.verifyDrawable(drawable2) || drawable2 == this.contentScrim || drawable2 == this.statusBarScrim;
        return bl;
    }

    public static class LayoutParams
    extends FrameLayout.LayoutParams {
        public static final int COLLAPSE_MODE_OFF = 0;
        public static final int COLLAPSE_MODE_PARALLAX = 2;
        public static final int COLLAPSE_MODE_PIN = 1;
        private static final float DEFAULT_PARALLAX_MULTIPLIER = 0.5f;
        int collapseMode = 0;
        float parallaxMult = 0.5f;

        public LayoutParams(int n, int n2) {
            super(n, n2);
        }

        public LayoutParams(int n, int n2, int n3) {
            super(n, n2, n3);
        }

        public LayoutParams(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
            context = context.obtainStyledAttributes(attributeSet, R.styleable.CollapsingToolbarLayout_Layout);
            this.collapseMode = context.getInt(R.styleable.CollapsingToolbarLayout_Layout_layout_collapseMode, 0);
            this.setParallaxMultiplier(context.getFloat(R.styleable.CollapsingToolbarLayout_Layout_layout_collapseParallaxMultiplier, 0.5f));
            context.recycle();
        }

        public LayoutParams(ViewGroup.LayoutParams layoutParams) {
            super(layoutParams);
        }

        public LayoutParams(ViewGroup.MarginLayoutParams marginLayoutParams) {
            super(marginLayoutParams);
        }

        public LayoutParams(FrameLayout.LayoutParams layoutParams) {
            super(layoutParams);
        }

        public int getCollapseMode() {
            return this.collapseMode;
        }

        public float getParallaxMultiplier() {
            return this.parallaxMult;
        }

        public void setCollapseMode(int n) {
            this.collapseMode = n;
        }

        public void setParallaxMultiplier(float f) {
            this.parallaxMult = f;
        }
    }

    private class OffsetUpdateListener
    implements AppBarLayout.OnOffsetChangedListener {
        OffsetUpdateListener() {
        }

        @Override
        public void onOffsetChanged(AppBarLayout object, int n) {
            int n2;
            CollapsingToolbarLayout.this.currentOffset = n;
            int n3 = CollapsingToolbarLayout.this.lastInsets != null ? CollapsingToolbarLayout.this.lastInsets.getSystemWindowInsetTop() : 0;
            int n4 = CollapsingToolbarLayout.this.getChildCount();
            for (n2 = 0; n2 < n4; ++n2) {
                View view = CollapsingToolbarLayout.this.getChildAt(n2);
                LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
                object = CollapsingToolbarLayout.getViewOffsetHelper(view);
                int n5 = layoutParams.collapseMode;
                if (n5 != 1) {
                    if (n5 != 2) continue;
                    ((ViewOffsetHelper)object).setTopAndBottomOffset(Math.round((float)(-n) * layoutParams.parallaxMult));
                    continue;
                }
                ((ViewOffsetHelper)object).setTopAndBottomOffset(MathUtils.clamp((int)(-n), (int)0, (int)CollapsingToolbarLayout.this.getMaxOffsetForPinChild(view)));
            }
            CollapsingToolbarLayout.this.updateScrimVisibility();
            if (CollapsingToolbarLayout.this.statusBarScrim != null && n3 > 0) {
                ViewCompat.postInvalidateOnAnimation((View)CollapsingToolbarLayout.this);
            }
            n2 = CollapsingToolbarLayout.this.getHeight();
            n3 = n2 - ViewCompat.getMinimumHeight((View)CollapsingToolbarLayout.this) - n3;
            n4 = CollapsingToolbarLayout.this.getScrimVisibleHeightTrigger();
            object = CollapsingToolbarLayout.this.collapsingTextHelper;
            float f = n2 - n4;
            float f2 = n3;
            ((CollapsingTextHelper)object).setFadeModeStartFraction(Math.min(1.0f, f / f2));
            CollapsingToolbarLayout.this.collapsingTextHelper.setCurrentOffsetY(CollapsingToolbarLayout.this.currentOffset + n3);
            CollapsingToolbarLayout.this.collapsingTextHelper.setExpansionFraction((float)Math.abs(n) / f2);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface TitleCollapseMode {
    }
}

