/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.appbar;

import android.content.Context;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.View;
import androidx.coordinatorlayout.widget.CoordinatorLayout;
import androidx.core.math.MathUtils;
import androidx.core.view.GravityCompat;
import androidx.core.view.ViewCompat;
import androidx.core.view.WindowInsetsCompat;
import com.google.android.material.appbar.ViewOffsetBehavior;
import java.util.List;

abstract class HeaderScrollingViewBehavior
extends ViewOffsetBehavior<View> {
    private int overlayTop;
    final Rect tempRect1 = new Rect();
    final Rect tempRect2 = new Rect();
    private int verticalLayoutGap = 0;

    public HeaderScrollingViewBehavior() {
    }

    public HeaderScrollingViewBehavior(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
    }

    private static int resolveGravity(int n) {
        int n2 = n;
        if (n == 0) {
            n2 = 0x800033;
        }
        return n2;
    }

    abstract View findFirstDependency(List<View> var1);

    final int getOverlapPixelsForOffset(View view) {
        int n = this.overlayTop;
        int n2 = 0;
        if (n != 0) {
            float f = this.getOverlapRatioForOffset(view);
            n2 = this.overlayTop;
            n2 = MathUtils.clamp((int)((int)(f * (float)n2)), (int)0, (int)n2);
        }
        return n2;
    }

    float getOverlapRatioForOffset(View view) {
        return 1.0f;
    }

    public final int getOverlayTop() {
        return this.overlayTop;
    }

    int getScrollRange(View view) {
        return view.getMeasuredHeight();
    }

    final int getVerticalLayoutGap() {
        return this.verticalLayoutGap;
    }

    @Override
    protected void layoutChild(CoordinatorLayout coordinatorLayout, View view, int n) {
        View view2 = this.findFirstDependency(coordinatorLayout.getDependencies(view));
        if (view2 != null) {
            CoordinatorLayout.LayoutParams layoutParams = (CoordinatorLayout.LayoutParams)view.getLayoutParams();
            Rect rect = this.tempRect1;
            rect.set(coordinatorLayout.getPaddingLeft() + layoutParams.leftMargin, view2.getBottom() + layoutParams.topMargin, coordinatorLayout.getWidth() - coordinatorLayout.getPaddingRight() - layoutParams.rightMargin, coordinatorLayout.getHeight() + view2.getBottom() - coordinatorLayout.getPaddingBottom() - layoutParams.bottomMargin);
            WindowInsetsCompat windowInsetsCompat = coordinatorLayout.getLastWindowInsets();
            if (windowInsetsCompat != null && ViewCompat.getFitsSystemWindows((View)coordinatorLayout) && !ViewCompat.getFitsSystemWindows((View)view)) {
                rect.left += windowInsetsCompat.getSystemWindowInsetLeft();
                rect.right -= windowInsetsCompat.getSystemWindowInsetRight();
            }
            coordinatorLayout = this.tempRect2;
            GravityCompat.apply((int)HeaderScrollingViewBehavior.resolveGravity(layoutParams.gravity), (int)view.getMeasuredWidth(), (int)view.getMeasuredHeight(), (Rect)rect, (Rect)coordinatorLayout, (int)n);
            n = this.getOverlapPixelsForOffset(view2);
            view.layout(coordinatorLayout.left, coordinatorLayout.top - n, coordinatorLayout.right, coordinatorLayout.bottom - n);
            this.verticalLayoutGap = coordinatorLayout.top - view2.getBottom();
        } else {
            super.layoutChild(coordinatorLayout, view, n);
            this.verticalLayoutGap = 0;
        }
    }

    public boolean onMeasureChild(CoordinatorLayout coordinatorLayout, View view, int n, int n2, int n3, int n4) {
        View view2;
        int n5 = view.getLayoutParams().height;
        if ((n5 == -1 || n5 == -2) && (view2 = this.findFirstDependency(coordinatorLayout.getDependencies(view))) != null) {
            int n6 = View.MeasureSpec.getSize((int)n3);
            if (n6 > 0) {
                n3 = n6;
                if (ViewCompat.getFitsSystemWindows((View)view2)) {
                    WindowInsetsCompat windowInsetsCompat = coordinatorLayout.getLastWindowInsets();
                    n3 = n6;
                    if (windowInsetsCompat != null) {
                        n3 = n6 + (windowInsetsCompat.getSystemWindowInsetTop() + windowInsetsCompat.getSystemWindowInsetBottom());
                    }
                }
            } else {
                n3 = coordinatorLayout.getHeight();
            }
            n3 += this.getScrollRange(view2);
            n6 = view2.getMeasuredHeight();
            if (this.shouldHeaderOverlapScrollingChild()) {
                view.setTranslationY((float)(-n6));
            } else {
                n3 -= n6;
            }
            n6 = n5 == -1 ? 0x40000000 : Integer.MIN_VALUE;
            coordinatorLayout.onMeasureChild(view, n, n2, View.MeasureSpec.makeMeasureSpec((int)n3, (int)n6), n4);
            return true;
        }
        return false;
    }

    public final void setOverlayTop(int n) {
        this.overlayTop = n;
    }

    protected boolean shouldHeaderOverlapScrollingChild() {
        return false;
    }
}

