/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.appbar;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.util.Pair;
import android.view.View;
import android.widget.TextView;
import androidx.appcompat.widget.Toolbar;
import androidx.core.graphics.drawable.DrawableCompat;
import androidx.core.view.ViewCompat;
import com.google.android.material.R;
import com.google.android.material.internal.ThemeEnforcement;
import com.google.android.material.internal.ToolbarUtils;
import com.google.android.material.shape.MaterialShapeDrawable;
import com.google.android.material.shape.MaterialShapeUtils;
import com.google.android.material.theme.overlay.MaterialThemeOverlay;

public class MaterialToolbar
extends Toolbar {
    private static final int DEF_STYLE_RES = R.style.Widget_MaterialComponents_Toolbar;
    private Integer navigationIconTint;
    private boolean subtitleCentered;
    private boolean titleCentered;

    public MaterialToolbar(Context context) {
        this(context, null);
    }

    public MaterialToolbar(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, R.attr.toolbarStyle);
    }

    public MaterialToolbar(Context context, AttributeSet attributeSet, int n) {
        int n2 = DEF_STYLE_RES;
        super(MaterialThemeOverlay.wrap(context, attributeSet, n, n2), attributeSet, n);
        context = this.getContext();
        attributeSet = ThemeEnforcement.obtainStyledAttributes(context, attributeSet, R.styleable.MaterialToolbar, n, n2, new int[0]);
        if (attributeSet.hasValue(R.styleable.MaterialToolbar_navigationIconTint)) {
            this.setNavigationIconTint(attributeSet.getColor(R.styleable.MaterialToolbar_navigationIconTint, -1));
        }
        this.titleCentered = attributeSet.getBoolean(R.styleable.MaterialToolbar_titleCentered, false);
        this.subtitleCentered = attributeSet.getBoolean(R.styleable.MaterialToolbar_subtitleCentered, false);
        attributeSet.recycle();
        this.initBackground(context);
    }

    private Pair<Integer, Integer> calculateTitleBoundLimits(TextView textView, TextView textView2) {
        int n = this.getMeasuredWidth();
        int n2 = n / 2;
        int n3 = this.getPaddingLeft();
        int n4 = n - this.getPaddingRight();
        for (int i = 0; i < this.getChildCount(); ++i) {
            View view = this.getChildAt(i);
            int n5 = n4;
            int n6 = n3;
            if (view.getVisibility() != 8) {
                n5 = n4;
                n6 = n3;
                if (view != textView) {
                    n5 = n4;
                    n6 = n3;
                    if (view != textView2) {
                        n = n3;
                        if (view.getRight() < n2) {
                            n = n3;
                            if (view.getRight() > n3) {
                                n = view.getRight();
                            }
                        }
                        n5 = n4;
                        n6 = n;
                        if (view.getLeft() > n2) {
                            n5 = n4;
                            n6 = n;
                            if (view.getLeft() < n4) {
                                n5 = view.getLeft();
                                n6 = n;
                            }
                        }
                    }
                }
            }
            n4 = n5;
            n3 = n6;
        }
        return new Pair((Object)n3, (Object)n4);
    }

    private void initBackground(Context context) {
        Drawable drawable2 = this.getBackground();
        if (drawable2 != null && !(drawable2 instanceof ColorDrawable)) {
            return;
        }
        MaterialShapeDrawable materialShapeDrawable = new MaterialShapeDrawable();
        int n = drawable2 != null ? ((ColorDrawable)drawable2).getColor() : 0;
        materialShapeDrawable.setFillColor(ColorStateList.valueOf((int)n));
        materialShapeDrawable.initializeElevationOverlay(context);
        materialShapeDrawable.setElevation(ViewCompat.getElevation((View)this));
        ViewCompat.setBackground((View)this, (Drawable)materialShapeDrawable);
    }

    private void layoutTitleCenteredHorizontally(View view, Pair<Integer, Integer> pair) {
        int n = this.getMeasuredWidth();
        int n2 = view.getMeasuredWidth();
        int n3 = n / 2 - n2 / 2;
        int n4 = n2 + n3;
        int n5 = Math.max(Math.max((Integer)pair.first - n3, 0), Math.max(n4 - (Integer)pair.second, 0));
        n = n3;
        n2 = n4;
        if (n5 > 0) {
            n = n3 + n5;
            n2 = n4 - n5;
            view.measure(View.MeasureSpec.makeMeasureSpec((int)(n2 - n), (int)0x40000000), view.getMeasuredHeightAndState());
        }
        view.layout(n, view.getTop(), n2, view.getBottom());
    }

    private void maybeCenterTitleViews() {
        if (!this.titleCentered && !this.subtitleCentered) {
            return;
        }
        TextView textView = ToolbarUtils.getTitleTextView(this);
        TextView textView2 = ToolbarUtils.getSubtitleTextView(this);
        if (textView == null && textView2 == null) {
            return;
        }
        Pair<Integer, Integer> pair = this.calculateTitleBoundLimits(textView, textView2);
        if (this.titleCentered && textView != null) {
            this.layoutTitleCenteredHorizontally((View)textView, pair);
        }
        if (this.subtitleCentered && textView2 != null) {
            this.layoutTitleCenteredHorizontally((View)textView2, pair);
        }
    }

    private Drawable maybeTintNavigationIcon(Drawable drawable2) {
        Drawable drawable3 = drawable2;
        if (drawable2 != null) {
            drawable3 = drawable2;
            if (this.navigationIconTint != null) {
                drawable3 = DrawableCompat.wrap((Drawable)drawable2.mutate());
                DrawableCompat.setTint((Drawable)drawable3, (int)this.navigationIconTint);
            }
        }
        return drawable3;
    }

    public Integer getNavigationIconTint() {
        return this.navigationIconTint;
    }

    public boolean isSubtitleCentered() {
        return this.subtitleCentered;
    }

    public boolean isTitleCentered() {
        return this.titleCentered;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        MaterialShapeUtils.setParentAbsoluteElevation((View)this);
    }

    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        super.onLayout(bl, n, n2, n3, n4);
        this.maybeCenterTitleViews();
    }

    public void setElevation(float f) {
        super.setElevation(f);
        MaterialShapeUtils.setElevation((View)this, f);
    }

    public void setNavigationIcon(Drawable drawable2) {
        super.setNavigationIcon(this.maybeTintNavigationIcon(drawable2));
    }

    public void setNavigationIconTint(int n) {
        this.navigationIconTint = n;
        Drawable drawable2 = this.getNavigationIcon();
        if (drawable2 != null) {
            this.setNavigationIcon(drawable2);
        }
    }

    public void setSubtitleCentered(boolean bl) {
        if (this.subtitleCentered != bl) {
            this.subtitleCentered = bl;
            this.requestLayout();
        }
    }

    public void setTitleCentered(boolean bl) {
        if (this.titleCentered != bl) {
            this.titleCentered = bl;
            this.requestLayout();
        }
    }
}

