/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.behavior;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewPropertyAnimator;
import androidx.coordinatorlayout.widget.CoordinatorLayout;
import com.google.android.material.animation.AnimationUtils;

public class HideBottomViewOnScrollBehavior<V extends View>
extends CoordinatorLayout.Behavior<V> {
    protected static final int ENTER_ANIMATION_DURATION = 225;
    protected static final int EXIT_ANIMATION_DURATION = 175;
    private static final int STATE_SCROLLED_DOWN = 1;
    private static final int STATE_SCROLLED_UP = 2;
    private int additionalHiddenOffsetY = 0;
    private ViewPropertyAnimator currentAnimator;
    private int currentState = 2;
    private int height = 0;

    public HideBottomViewOnScrollBehavior() {
    }

    public HideBottomViewOnScrollBehavior(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
    }

    static /* synthetic */ ViewPropertyAnimator access$002(HideBottomViewOnScrollBehavior hideBottomViewOnScrollBehavior, ViewPropertyAnimator viewPropertyAnimator) {
        hideBottomViewOnScrollBehavior.currentAnimator = viewPropertyAnimator;
        return viewPropertyAnimator;
    }

    private void animateChildTo(V v, int n, long l, TimeInterpolator timeInterpolator) {
        this.currentAnimator = v.animate().translationY((float)n).setInterpolator(timeInterpolator).setDuration(l).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animator2) {
                HideBottomViewOnScrollBehavior.access$002(HideBottomViewOnScrollBehavior.this, null);
            }
        });
    }

    public boolean isScrolledDown() {
        int n = this.currentState;
        boolean bl = true;
        if (n != 1) {
            bl = false;
        }
        return bl;
    }

    public boolean isScrolledUp() {
        boolean bl = this.currentState == 2;
        return bl;
    }

    public boolean onLayoutChild(CoordinatorLayout coordinatorLayout, V v, int n) {
        ViewGroup.MarginLayoutParams marginLayoutParams = (ViewGroup.MarginLayoutParams)v.getLayoutParams();
        this.height = v.getMeasuredHeight() + marginLayoutParams.bottomMargin;
        return super.onLayoutChild(coordinatorLayout, v, n);
    }

    public void onNestedScroll(CoordinatorLayout coordinatorLayout, V v, View view, int n, int n2, int n3, int n4, int n5, int[] nArray) {
        if (n2 > 0) {
            this.slideDown(v);
        } else if (n2 < 0) {
            this.slideUp(v);
        }
    }

    public boolean onStartNestedScroll(CoordinatorLayout coordinatorLayout, V v, View view, View view2, int n, int n2) {
        boolean bl = n == 2;
        return bl;
    }

    public void setAdditionalHiddenOffsetY(V v, int n) {
        this.additionalHiddenOffsetY = n;
        if (this.currentState == 1) {
            v.setTranslationY((float)(this.height + n));
        }
    }

    public void slideDown(V v) {
        this.slideDown(v, true);
    }

    public void slideDown(V v, boolean bl) {
        if (this.isScrolledDown()) {
            return;
        }
        ViewPropertyAnimator viewPropertyAnimator = this.currentAnimator;
        if (viewPropertyAnimator != null) {
            viewPropertyAnimator.cancel();
            v.clearAnimation();
        }
        this.currentState = 1;
        int n = this.height + this.additionalHiddenOffsetY;
        if (bl) {
            this.animateChildTo(v, n, 175L, AnimationUtils.FAST_OUT_LINEAR_IN_INTERPOLATOR);
        } else {
            v.setTranslationY((float)n);
        }
    }

    public void slideUp(V v) {
        this.slideUp(v, true);
    }

    public void slideUp(V v, boolean bl) {
        if (this.isScrolledUp()) {
            return;
        }
        ViewPropertyAnimator viewPropertyAnimator = this.currentAnimator;
        if (viewPropertyAnimator != null) {
            viewPropertyAnimator.cancel();
            v.clearAnimation();
        }
        this.currentState = 2;
        if (bl) {
            this.animateChildTo(v, 0, 225L, AnimationUtils.LINEAR_OUT_SLOW_IN_INTERPOLATOR);
        } else {
            v.setTranslationY(0.0f);
        }
    }
}

