/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.behavior;

import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import androidx.coordinatorlayout.widget.CoordinatorLayout;
import androidx.core.view.ViewCompat;
import androidx.core.view.accessibility.AccessibilityNodeInfoCompat;
import androidx.core.view.accessibility.AccessibilityViewCommand;
import androidx.customview.widget.ViewDragHelper;

public class SwipeDismissBehavior<V extends View>
extends CoordinatorLayout.Behavior<V> {
    private static final float DEFAULT_ALPHA_END_DISTANCE = 0.5f;
    private static final float DEFAULT_ALPHA_START_DISTANCE = 0.0f;
    private static final float DEFAULT_DRAG_DISMISS_THRESHOLD = 0.5f;
    public static final int STATE_DRAGGING = 1;
    public static final int STATE_IDLE = 0;
    public static final int STATE_SETTLING = 2;
    public static final int SWIPE_DIRECTION_ANY = 2;
    public static final int SWIPE_DIRECTION_END_TO_START = 1;
    public static final int SWIPE_DIRECTION_START_TO_END = 0;
    float alphaEndSwipeDistance = 0.5f;
    float alphaStartSwipeDistance = 0.0f;
    private final ViewDragHelper.Callback dragCallback = new ViewDragHelper.Callback(){
        private static final int INVALID_POINTER_ID = -1;
        private int activePointerId = -1;
        private int originalCapturedViewLeft;

        private boolean shouldDismiss(View view, float f) {
            float f2;
            boolean bl;
            boolean bl2;
            block7: {
                block8: {
                    block10: {
                        boolean bl3;
                        block9: {
                            bl3 = false;
                            bl2 = false;
                            bl = false;
                            float f3 = f - 0.0f;
                            f2 = f3 == 0.0f ? 0 : (f3 > 0.0f ? 1 : -1);
                            if (f2 == false) break block7;
                            boolean bl4 = ViewCompat.getLayoutDirection((View)view) == 1;
                            if (SwipeDismissBehavior.this.swipeDirection == 2) {
                                return true;
                            }
                            if (SwipeDismissBehavior.this.swipeDirection == 0) {
                                if (bl4 ? f < 0.0f : f2 > 0) {
                                    bl = true;
                                }
                                return bl;
                            }
                            bl = bl3;
                            if (SwipeDismissBehavior.this.swipeDirection != 1) break block8;
                            if (!bl4) break block9;
                            bl = bl3;
                            if (f2 <= 0) break block8;
                            break block10;
                        }
                        bl = bl3;
                        if (!(f < 0.0f)) break block8;
                    }
                    bl = true;
                }
                return bl;
            }
            int n = view.getLeft();
            f2 = this.originalCapturedViewLeft;
            int n2 = Math.round((float)view.getWidth() * SwipeDismissBehavior.this.dragDismissThreshold);
            bl = bl2;
            if (Math.abs(n - f2) >= n2) {
                bl = true;
            }
            return bl;
        }

        /*
         * Enabled aggressive block sorting
         */
        public int clampViewPositionHorizontal(View view, int n, int n2) {
            int n3;
            n2 = ViewCompat.getLayoutDirection((View)view) == 1 ? 1 : 0;
            if (SwipeDismissBehavior.this.swipeDirection == 0) {
                if (n2 != 0) {
                    n3 = this.originalCapturedViewLeft - view.getWidth();
                    n2 = this.originalCapturedViewLeft;
                    return SwipeDismissBehavior.clamp(n3, n, n2);
                }
                n3 = this.originalCapturedViewLeft;
                n2 = view.getWidth();
                return SwipeDismissBehavior.clamp(n3, n, n2 += n3);
            } else {
                if (SwipeDismissBehavior.this.swipeDirection != 1) {
                    n3 = this.originalCapturedViewLeft - view.getWidth();
                    n2 = this.originalCapturedViewLeft;
                    n2 = view.getWidth() + n2;
                    return SwipeDismissBehavior.clamp(n3, n, n2);
                }
                if (n2 == 0) {
                    n3 = this.originalCapturedViewLeft - view.getWidth();
                    n2 = this.originalCapturedViewLeft;
                    return SwipeDismissBehavior.clamp(n3, n, n2);
                }
                n3 = this.originalCapturedViewLeft;
                n2 = view.getWidth();
            }
            return SwipeDismissBehavior.clamp(n3, n, n2 += n3);
        }

        public int clampViewPositionVertical(View view, int n, int n2) {
            return view.getTop();
        }

        public int getViewHorizontalDragRange(View view) {
            return view.getWidth();
        }

        public void onViewCaptured(View view, int n) {
            this.activePointerId = n;
            this.originalCapturedViewLeft = view.getLeft();
            if ((view = view.getParent()) != null) {
                view.requestDisallowInterceptTouchEvent(true);
            }
        }

        public void onViewDragStateChanged(int n) {
            if (SwipeDismissBehavior.this.listener != null) {
                SwipeDismissBehavior.this.listener.onDragStateChanged(n);
            }
        }

        public void onViewPositionChanged(View view, int n, int n2, int n3, int n4) {
            float f = (float)this.originalCapturedViewLeft + (float)view.getWidth() * SwipeDismissBehavior.this.alphaStartSwipeDistance;
            float f2 = (float)this.originalCapturedViewLeft + (float)view.getWidth() * SwipeDismissBehavior.this.alphaEndSwipeDistance;
            float f3 = n;
            if (f3 <= f) {
                view.setAlpha(1.0f);
            } else if (f3 >= f2) {
                view.setAlpha(0.0f);
            } else {
                view.setAlpha(SwipeDismissBehavior.clamp(0.0f, 1.0f - SwipeDismissBehavior.fraction(f, f2, f3), 1.0f));
            }
        }

        public void onViewReleased(View view, float f, float f2) {
            boolean bl;
            int n;
            this.activePointerId = -1;
            int n2 = view.getWidth();
            if (this.shouldDismiss(view, f)) {
                int n3 = view.getLeft();
                n = n3 < (n = this.originalCapturedViewLeft) ? (n -= n2) : (n += n2);
                bl = true;
            } else {
                n = this.originalCapturedViewLeft;
                bl = false;
            }
            if (SwipeDismissBehavior.this.viewDragHelper.settleCapturedViewAt(n, view.getTop())) {
                ViewCompat.postOnAnimation((View)view, (Runnable)new SettleRunnable(view, bl));
            } else if (bl && SwipeDismissBehavior.this.listener != null) {
                SwipeDismissBehavior.this.listener.onDismiss(view);
            }
        }

        public boolean tryCaptureView(View view, int n) {
            int n2 = this.activePointerId;
            boolean bl = (n2 == -1 || n2 == n) && SwipeDismissBehavior.this.canSwipeDismissView(view);
            return bl;
        }
    };
    float dragDismissThreshold = 0.5f;
    private boolean interceptingEvents;
    OnDismissListener listener;
    private float sensitivity = 0.0f;
    private boolean sensitivitySet;
    int swipeDirection = 2;
    ViewDragHelper viewDragHelper;

    static float clamp(float f, float f2, float f3) {
        return Math.min(Math.max(f, f2), f3);
    }

    static int clamp(int n, int n2, int n3) {
        return Math.min(Math.max(n, n2), n3);
    }

    private void ensureViewDragHelper(ViewGroup viewGroup) {
        if (this.viewDragHelper == null) {
            viewGroup = this.sensitivitySet ? ViewDragHelper.create((ViewGroup)viewGroup, (float)this.sensitivity, (ViewDragHelper.Callback)this.dragCallback) : ViewDragHelper.create((ViewGroup)viewGroup, (ViewDragHelper.Callback)this.dragCallback);
            this.viewDragHelper = viewGroup;
        }
    }

    static float fraction(float f, float f2, float f3) {
        return (f3 - f) / (f2 - f);
    }

    private void updateAccessibilityActions(View view) {
        ViewCompat.removeAccessibilityAction((View)view, (int)0x100000);
        if (this.canSwipeDismissView(view)) {
            ViewCompat.replaceAccessibilityAction((View)view, (AccessibilityNodeInfoCompat.AccessibilityActionCompat)AccessibilityNodeInfoCompat.AccessibilityActionCompat.ACTION_DISMISS, null, (AccessibilityViewCommand)new AccessibilityViewCommand(){

                public boolean perform(View view, AccessibilityViewCommand.CommandArguments commandArguments) {
                    block5: {
                        int n;
                        int n2;
                        int n3;
                        block7: {
                            block6: {
                                boolean bl = SwipeDismissBehavior.this.canSwipeDismissView(view);
                                n3 = 0;
                                if (!bl) break block5;
                                n2 = ViewCompat.getLayoutDirection((View)view) == 1 ? 1 : 0;
                                if (SwipeDismissBehavior.this.swipeDirection == 0 && n2 != 0) break block6;
                                n = n3;
                                if (SwipeDismissBehavior.this.swipeDirection != 1) break block7;
                                n = n3;
                                if (n2 != 0) break block7;
                            }
                            n = 1;
                        }
                        n2 = n3 = view.getWidth();
                        if (n != 0) {
                            n2 = -n3;
                        }
                        ViewCompat.offsetLeftAndRight((View)view, (int)n2);
                        view.setAlpha(0.0f);
                        if (SwipeDismissBehavior.this.listener != null) {
                            SwipeDismissBehavior.this.listener.onDismiss(view);
                        }
                        return true;
                    }
                    return false;
                }
            });
        }
    }

    public boolean canSwipeDismissView(View view) {
        return true;
    }

    public int getDragState() {
        ViewDragHelper viewDragHelper = this.viewDragHelper;
        int n = viewDragHelper != null ? viewDragHelper.getViewDragState() : 0;
        return n;
    }

    public OnDismissListener getListener() {
        return this.listener;
    }

    public boolean onInterceptTouchEvent(CoordinatorLayout coordinatorLayout, V v, MotionEvent motionEvent) {
        boolean bl = this.interceptingEvents;
        int n = motionEvent.getActionMasked();
        if (n != 0) {
            if (n == 1 || n == 3) {
                this.interceptingEvents = false;
            }
        } else {
            this.interceptingEvents = bl = coordinatorLayout.isPointInChildBounds(v, (int)motionEvent.getX(), (int)motionEvent.getY());
        }
        if (bl) {
            this.ensureViewDragHelper((ViewGroup)coordinatorLayout);
            return this.viewDragHelper.shouldInterceptTouchEvent(motionEvent);
        }
        return false;
    }

    public boolean onLayoutChild(CoordinatorLayout coordinatorLayout, V v, int n) {
        boolean bl = super.onLayoutChild(coordinatorLayout, v, n);
        if (ViewCompat.getImportantForAccessibility(v) == 0) {
            ViewCompat.setImportantForAccessibility(v, (int)1);
            this.updateAccessibilityActions((View)v);
        }
        return bl;
    }

    public boolean onTouchEvent(CoordinatorLayout coordinatorLayout, V v, MotionEvent motionEvent) {
        coordinatorLayout = this.viewDragHelper;
        if (coordinatorLayout != null) {
            coordinatorLayout.processTouchEvent(motionEvent);
            return true;
        }
        return false;
    }

    public void setDragDismissDistance(float f) {
        this.dragDismissThreshold = SwipeDismissBehavior.clamp(0.0f, f, 1.0f);
    }

    public void setEndAlphaSwipeDistance(float f) {
        this.alphaEndSwipeDistance = SwipeDismissBehavior.clamp(0.0f, f, 1.0f);
    }

    public void setListener(OnDismissListener onDismissListener) {
        this.listener = onDismissListener;
    }

    public void setSensitivity(float f) {
        this.sensitivity = f;
        this.sensitivitySet = true;
    }

    public void setStartAlphaSwipeDistance(float f) {
        this.alphaStartSwipeDistance = SwipeDismissBehavior.clamp(0.0f, f, 1.0f);
    }

    public void setSwipeDirection(int n) {
        this.swipeDirection = n;
    }

    public static interface OnDismissListener {
        public void onDismiss(View var1);

        public void onDragStateChanged(int var1);
    }

    private class SettleRunnable
    implements Runnable {
        private final boolean dismiss;
        private final View view;

        SettleRunnable(View view, boolean bl) {
            this.view = view;
            this.dismiss = bl;
        }

        @Override
        public void run() {
            if (SwipeDismissBehavior.this.viewDragHelper != null && SwipeDismissBehavior.this.viewDragHelper.continueSettling(true)) {
                ViewCompat.postOnAnimation((View)this.view, (Runnable)this);
            } else if (this.dismiss && SwipeDismissBehavior.this.listener != null) {
                SwipeDismissBehavior.this.listener.onDismiss(this.view);
            }
        }
    }
}

