/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.bottomnavigation;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.appcompat.view.menu.MenuBuilder;
import androidx.core.view.ViewCompat;
import com.google.android.material.R;
import com.google.android.material.bottomnavigation.BottomNavigationItemView;
import com.google.android.material.navigation.NavigationBarItemView;
import com.google.android.material.navigation.NavigationBarMenuView;

public class BottomNavigationMenuView
extends NavigationBarMenuView {
    private final int activeItemMaxWidth;
    private final int activeItemMinWidth;
    private final int inactiveItemMaxWidth;
    private final int inactiveItemMinWidth;
    private boolean itemHorizontalTranslationEnabled;
    private int[] tempChildWidths;

    public BottomNavigationMenuView(Context context) {
        super(context);
        context = new FrameLayout.LayoutParams(-2, -2);
        context.gravity = 17;
        this.setLayoutParams((ViewGroup.LayoutParams)context);
        context = this.getResources();
        this.inactiveItemMaxWidth = context.getDimensionPixelSize(R.dimen.design_bottom_navigation_item_max_width);
        this.inactiveItemMinWidth = context.getDimensionPixelSize(R.dimen.design_bottom_navigation_item_min_width);
        this.activeItemMaxWidth = context.getDimensionPixelSize(R.dimen.design_bottom_navigation_active_item_max_width);
        this.activeItemMinWidth = context.getDimensionPixelSize(R.dimen.design_bottom_navigation_active_item_min_width);
        this.tempChildWidths = new int[5];
    }

    @Override
    protected NavigationBarItemView createNavigationBarItemView(Context context) {
        return new BottomNavigationItemView(context);
    }

    public boolean isItemHorizontalTranslationEnabled() {
        return this.itemHorizontalTranslationEnabled;
    }

    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        int n5 = this.getChildCount();
        int n6 = n4 - n2;
        n4 = 0;
        for (n2 = 0; n2 < n5; ++n2) {
            View view = this.getChildAt(n2);
            if (view.getVisibility() == 8) continue;
            if (ViewCompat.getLayoutDirection((View)this) == 1) {
                int n7 = n3 - n - n4;
                view.layout(n7 - view.getMeasuredWidth(), 0, n7, n6);
            } else {
                view.layout(n4, 0, view.getMeasuredWidth() + n4, n6);
            }
            n4 += view.getMeasuredWidth();
        }
    }

    protected void onMeasure(int n, int n2) {
        int n3;
        int n4;
        Object object = this.getMenu();
        int n5 = View.MeasureSpec.getSize((int)n);
        int n6 = object.getVisibleItems().size();
        int n7 = this.getChildCount();
        int n8 = View.MeasureSpec.getSize((int)n2);
        int n9 = View.MeasureSpec.makeMeasureSpec((int)n8, (int)0x40000000);
        if (this.isShifting(this.getLabelVisibilityMode(), n6) && this.isItemHorizontalTranslationEnabled()) {
            object = this.getChildAt(this.getSelectedItemPosition());
            n = n4 = this.activeItemMinWidth;
            if (object.getVisibility() != 8) {
                object.measure(View.MeasureSpec.makeMeasureSpec((int)this.activeItemMaxWidth, (int)Integer.MIN_VALUE), n9);
                n = Math.max(n4, object.getMeasuredWidth());
            }
            n4 = object.getVisibility() != 8 ? 1 : 0;
            n4 = n6 - n4;
            n3 = Math.min(n5 - this.inactiveItemMinWidth * n4, Math.min(n, this.activeItemMaxWidth));
            n6 = n5 - n3;
            n = n4 == 0 ? 1 : n4;
            n5 = Math.min(n6 / n, this.inactiveItemMaxWidth);
            n = n6 - n4 * n5;
            for (n4 = 0; n4 < n7; ++n4) {
                if (this.getChildAt(n4).getVisibility() != 8) {
                    object = this.tempChildWidths;
                    n6 = n4 == this.getSelectedItemPosition() ? n3 : n5;
                    object[n4] = (MenuBuilder)n6;
                    n6 = n;
                    if (n > 0) {
                        object = this.tempChildWidths;
                        object[n4] = object[n4] + true;
                        n6 = n - 1;
                    }
                } else {
                    this.tempChildWidths[n4] = 0;
                    n6 = n;
                }
                n = n6;
            }
        } else {
            n = n6 == 0 ? 1 : n6;
            n3 = Math.min(n5 / n, this.activeItemMaxWidth);
            n6 = n5 - n6 * n3;
            for (n = 0; n < n7; ++n) {
                if (this.getChildAt(n).getVisibility() != 8) {
                    object = this.tempChildWidths;
                    object[n] = (MenuBuilder)n3;
                    n4 = n6;
                    if (n6 > 0) {
                        object[n] = object[n] + true;
                        n4 = n6 - 1;
                    }
                } else {
                    this.tempChildWidths[n] = 0;
                    n4 = n6;
                }
                n6 = n4;
            }
        }
        n4 = 0;
        for (n = 0; n < n7; ++n) {
            object = this.getChildAt(n);
            if (object.getVisibility() == 8) continue;
            object.measure(View.MeasureSpec.makeMeasureSpec((int)this.tempChildWidths[n], (int)0x40000000), n9);
            object.getLayoutParams().width = object.getMeasuredWidth();
            n4 += object.getMeasuredWidth();
        }
        this.setMeasuredDimension(View.resolveSizeAndState((int)n4, (int)View.MeasureSpec.makeMeasureSpec((int)n4, (int)0x40000000), (int)0), View.resolveSizeAndState((int)n8, (int)n2, (int)0));
    }

    public void setItemHorizontalTranslationEnabled(boolean bl) {
        this.itemHorizontalTranslationEnabled = bl;
    }
}

