/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.button;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextPaint;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.Button;
import android.widget.Checkable;
import android.widget.CompoundButton;
import android.widget.TextView;
import androidx.appcompat.content.res.AppCompatResources;
import androidx.appcompat.widget.AppCompatButton;
import androidx.core.graphics.drawable.DrawableCompat;
import androidx.core.view.ViewCompat;
import androidx.core.widget.TextViewCompat;
import androidx.customview.view.AbsSavedState;
import com.google.android.material.R;
import com.google.android.material.button.MaterialButtonHelper;
import com.google.android.material.internal.ThemeEnforcement;
import com.google.android.material.internal.ViewUtils;
import com.google.android.material.resources.MaterialResources;
import com.google.android.material.shape.MaterialShapeUtils;
import com.google.android.material.shape.ShapeAppearanceModel;
import com.google.android.material.shape.Shapeable;
import com.google.android.material.theme.overlay.MaterialThemeOverlay;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Iterator;
import java.util.LinkedHashSet;

public class MaterialButton
extends AppCompatButton
implements Checkable,
Shapeable {
    private static final int[] CHECKABLE_STATE_SET = new int[]{16842911};
    private static final int[] CHECKED_STATE_SET = new int[]{0x10100A0};
    private static final int DEF_STYLE_RES = R.style.Widget_MaterialComponents_Button;
    public static final int ICON_GRAVITY_END = 3;
    public static final int ICON_GRAVITY_START = 1;
    public static final int ICON_GRAVITY_TEXT_END = 4;
    public static final int ICON_GRAVITY_TEXT_START = 2;
    public static final int ICON_GRAVITY_TEXT_TOP = 32;
    public static final int ICON_GRAVITY_TOP = 16;
    private static final String LOG_TAG = "MaterialButton";
    private boolean broadcasting;
    private boolean checked;
    private Drawable icon;
    private int iconGravity;
    private int iconLeft;
    private int iconPadding;
    private int iconSize;
    private ColorStateList iconTint;
    private PorterDuff.Mode iconTintMode;
    private int iconTop;
    private final MaterialButtonHelper materialButtonHelper;
    private final LinkedHashSet<OnCheckedChangeListener> onCheckedChangeListeners;
    private OnPressedChangeListener onPressedChangeListenerInternal;

    public MaterialButton(Context context) {
        this(context, null);
    }

    public MaterialButton(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, R.attr.materialButtonStyle);
    }

    public MaterialButton(Context context, AttributeSet object, int n) {
        int n2 = DEF_STYLE_RES;
        super(MaterialThemeOverlay.wrap(context, (AttributeSet)object, n, n2), (AttributeSet)object, n);
        this.onCheckedChangeListeners = new LinkedHashSet();
        boolean bl = false;
        this.checked = false;
        this.broadcasting = false;
        Context context2 = this.getContext();
        context = ThemeEnforcement.obtainStyledAttributes(context2, (AttributeSet)object, R.styleable.MaterialButton, n, n2, new int[0]);
        this.iconPadding = context.getDimensionPixelSize(R.styleable.MaterialButton_iconPadding, 0);
        this.iconTintMode = ViewUtils.parseTintMode(context.getInt(R.styleable.MaterialButton_iconTintMode, -1), PorterDuff.Mode.SRC_IN);
        this.iconTint = MaterialResources.getColorStateList(this.getContext(), (TypedArray)context, R.styleable.MaterialButton_iconTint);
        this.icon = MaterialResources.getDrawable(this.getContext(), (TypedArray)context, R.styleable.MaterialButton_icon);
        this.iconGravity = context.getInteger(R.styleable.MaterialButton_iconGravity, 1);
        this.iconSize = context.getDimensionPixelSize(R.styleable.MaterialButton_iconSize, 0);
        object = new MaterialButtonHelper(this, ShapeAppearanceModel.builder(context2, (AttributeSet)object, n, n2).build());
        this.materialButtonHelper = object;
        ((MaterialButtonHelper)object).loadFromAttributes((TypedArray)context);
        context.recycle();
        this.setCompoundDrawablePadding(this.iconPadding);
        if (this.icon != null) {
            bl = true;
        }
        this.updateIcon(bl);
    }

    private String getA11yClassName() {
        Class clazz = this.isCheckable() ? CompoundButton.class : Button.class;
        return clazz.getName();
    }

    private int getTextHeight() {
        String string2;
        TextPaint textPaint = this.getPaint();
        String string3 = string2 = this.getText().toString();
        if (this.getTransformationMethod() != null) {
            string3 = this.getTransformationMethod().getTransformation((CharSequence)string2, (View)this).toString();
        }
        string2 = new Rect();
        textPaint.getTextBounds(string3, 0, string3.length(), (Rect)string2);
        return Math.min(string2.height(), this.getLayout().getHeight());
    }

    private int getTextWidth() {
        String string2;
        TextPaint textPaint = this.getPaint();
        String string3 = string2 = this.getText().toString();
        if (this.getTransformationMethod() != null) {
            string3 = this.getTransformationMethod().getTransformation((CharSequence)string2, (View)this).toString();
        }
        return Math.min((int)textPaint.measureText(string3), this.getLayout().getEllipsizedWidth());
    }

    private boolean isIconEnd() {
        int n = this.iconGravity;
        boolean bl = n == 3 || n == 4;
        return bl;
    }

    private boolean isIconStart() {
        boolean bl;
        int n = this.iconGravity;
        boolean bl2 = bl = true;
        if (n != 1) {
            bl2 = n == 2 ? bl : false;
        }
        return bl2;
    }

    private boolean isIconTop() {
        int n = this.iconGravity;
        boolean bl = n == 16 || n == 32;
        return bl;
    }

    private boolean isLayoutRTL() {
        int n = ViewCompat.getLayoutDirection((View)this);
        boolean bl = true;
        if (n != 1) {
            bl = false;
        }
        return bl;
    }

    private boolean isUsingOriginalBackground() {
        MaterialButtonHelper materialButtonHelper = this.materialButtonHelper;
        boolean bl = materialButtonHelper != null && !materialButtonHelper.isBackgroundOverwritten();
        return bl;
    }

    private void resetIconDrawable() {
        if (this.isIconStart()) {
            TextViewCompat.setCompoundDrawablesRelative((TextView)this, (Drawable)this.icon, null, null, null);
        } else if (this.isIconEnd()) {
            TextViewCompat.setCompoundDrawablesRelative((TextView)this, null, null, (Drawable)this.icon, null);
        } else if (this.isIconTop()) {
            TextViewCompat.setCompoundDrawablesRelative((TextView)this, null, (Drawable)this.icon, null, null);
        }
    }

    private void updateIcon(boolean bl) {
        int n;
        block10: {
            Drawable drawable2;
            int n2;
            block11: {
                Drawable drawable3;
                block9: {
                    Drawable drawable4 = this.icon;
                    n2 = 1;
                    if (drawable4 != null) {
                        this.icon = drawable4 = DrawableCompat.wrap((Drawable)drawable4).mutate();
                        DrawableCompat.setTintList((Drawable)drawable4, (ColorStateList)this.iconTint);
                        drawable4 = this.iconTintMode;
                        if (drawable4 != null) {
                            DrawableCompat.setTintMode((Drawable)this.icon, (PorterDuff.Mode)drawable4);
                        }
                        if ((n = this.iconSize) == 0) {
                            n = this.icon.getIntrinsicWidth();
                        }
                        int n3 = this.iconSize;
                        if (n3 == 0) {
                            n3 = this.icon.getIntrinsicHeight();
                        }
                        drawable4 = this.icon;
                        int n4 = this.iconLeft;
                        int n5 = this.iconTop;
                        drawable4.setBounds(n4, n5, n + n4, n3 + n5);
                        this.icon.setVisible(true, bl);
                    }
                    if (bl) {
                        this.resetIconDrawable();
                        return;
                    }
                    drawable3 = TextViewCompat.getCompoundDrawablesRelative((TextView)this);
                    drawable4 = drawable3[0];
                    drawable2 = drawable3[1];
                    drawable3 = drawable3[2];
                    if (!this.isIconStart()) break block9;
                    n = n2;
                    if (drawable4 != this.icon) break block10;
                }
                if (!this.isIconEnd()) break block11;
                n = n2;
                if (drawable3 != this.icon) break block10;
            }
            n = this.isIconTop() && drawable2 != this.icon ? n2 : 0;
        }
        if (n != 0) {
            this.resetIconDrawable();
        }
    }

    private void updateIconPosition(int n, int n2) {
        block12: {
            block15: {
                block14: {
                    int n3;
                    block13: {
                        if (this.icon == null || this.getLayout() == null) break block12;
                        if (this.isIconStart() || this.isIconEnd()) break block13;
                        if (this.isIconTop()) {
                            int n4;
                            this.iconLeft = 0;
                            if (this.iconGravity == 16) {
                                this.iconTop = 0;
                                this.updateIcon(false);
                                return;
                            }
                            n = n4 = this.iconSize;
                            if (n4 == 0) {
                                n = this.icon.getIntrinsicHeight();
                            }
                            if (this.iconTop != (n = (n2 - this.getTextHeight() - this.getPaddingTop() - n - this.iconPadding - this.getPaddingBottom()) / 2)) {
                                this.iconTop = n;
                                this.updateIcon(false);
                            }
                        }
                        break block14;
                    }
                    this.iconTop = 0;
                    n2 = this.iconGravity;
                    boolean bl = true;
                    if (n2 == 1 || n2 == 3) break block15;
                    n2 = n3 = this.iconSize;
                    if (n3 == 0) {
                        n2 = this.icon.getIntrinsicWidth();
                    }
                    n2 = (n - this.getTextWidth() - ViewCompat.getPaddingEnd((View)this) - n2 - this.iconPadding - ViewCompat.getPaddingStart((View)this)) / 2;
                    boolean bl2 = this.isLayoutRTL();
                    if (this.iconGravity != 4) {
                        bl = false;
                    }
                    n = n2;
                    if (bl2 != bl) {
                        n = -n2;
                    }
                    if (this.iconLeft != n) {
                        this.iconLeft = n;
                        this.updateIcon(false);
                    }
                }
                return;
            }
            this.iconLeft = 0;
            this.updateIcon(false);
        }
    }

    public void addOnCheckedChangeListener(OnCheckedChangeListener onCheckedChangeListener) {
        this.onCheckedChangeListeners.add(onCheckedChangeListener);
    }

    public void clearOnCheckedChangeListeners() {
        this.onCheckedChangeListeners.clear();
    }

    public ColorStateList getBackgroundTintList() {
        return this.getSupportBackgroundTintList();
    }

    public PorterDuff.Mode getBackgroundTintMode() {
        return this.getSupportBackgroundTintMode();
    }

    public int getCornerRadius() {
        int n = this.isUsingOriginalBackground() ? this.materialButtonHelper.getCornerRadius() : 0;
        return n;
    }

    public Drawable getIcon() {
        return this.icon;
    }

    public int getIconGravity() {
        return this.iconGravity;
    }

    public int getIconPadding() {
        return this.iconPadding;
    }

    public int getIconSize() {
        return this.iconSize;
    }

    public ColorStateList getIconTint() {
        return this.iconTint;
    }

    public PorterDuff.Mode getIconTintMode() {
        return this.iconTintMode;
    }

    public int getInsetBottom() {
        return this.materialButtonHelper.getInsetBottom();
    }

    public int getInsetTop() {
        return this.materialButtonHelper.getInsetTop();
    }

    public ColorStateList getRippleColor() {
        ColorStateList colorStateList = this.isUsingOriginalBackground() ? this.materialButtonHelper.getRippleColor() : null;
        return colorStateList;
    }

    @Override
    public ShapeAppearanceModel getShapeAppearanceModel() {
        if (this.isUsingOriginalBackground()) {
            return this.materialButtonHelper.getShapeAppearanceModel();
        }
        throw new IllegalStateException("Attempted to get ShapeAppearanceModel from a MaterialButton which has an overwritten background.");
    }

    public ColorStateList getStrokeColor() {
        ColorStateList colorStateList = this.isUsingOriginalBackground() ? this.materialButtonHelper.getStrokeColor() : null;
        return colorStateList;
    }

    public int getStrokeWidth() {
        int n = this.isUsingOriginalBackground() ? this.materialButtonHelper.getStrokeWidth() : 0;
        return n;
    }

    public ColorStateList getSupportBackgroundTintList() {
        if (this.isUsingOriginalBackground()) {
            return this.materialButtonHelper.getSupportBackgroundTintList();
        }
        return super.getSupportBackgroundTintList();
    }

    public PorterDuff.Mode getSupportBackgroundTintMode() {
        if (this.isUsingOriginalBackground()) {
            return this.materialButtonHelper.getSupportBackgroundTintMode();
        }
        return super.getSupportBackgroundTintMode();
    }

    public boolean isCheckable() {
        MaterialButtonHelper materialButtonHelper = this.materialButtonHelper;
        boolean bl = materialButtonHelper != null && materialButtonHelper.isCheckable();
        return bl;
    }

    public boolean isChecked() {
        return this.checked;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.isUsingOriginalBackground()) {
            MaterialShapeUtils.setParentAbsoluteElevation((View)this, this.materialButtonHelper.getMaterialShapeDrawable());
        }
    }

    protected int[] onCreateDrawableState(int n) {
        int[] nArray = super.onCreateDrawableState(n + 2);
        if (this.isCheckable()) {
            MaterialButton.mergeDrawableStates((int[])nArray, (int[])CHECKABLE_STATE_SET);
        }
        if (this.isChecked()) {
            MaterialButton.mergeDrawableStates((int[])nArray, (int[])CHECKED_STATE_SET);
        }
        return nArray;
    }

    public void onInitializeAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        super.onInitializeAccessibilityEvent(accessibilityEvent);
        accessibilityEvent.setClassName((CharSequence)this.getA11yClassName());
        accessibilityEvent.setChecked(this.isChecked());
    }

    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo accessibilityNodeInfo) {
        super.onInitializeAccessibilityNodeInfo(accessibilityNodeInfo);
        accessibilityNodeInfo.setClassName((CharSequence)this.getA11yClassName());
        accessibilityNodeInfo.setCheckable(this.isCheckable());
        accessibilityNodeInfo.setChecked(this.isChecked());
        accessibilityNodeInfo.setClickable(this.isClickable());
    }

    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        MaterialButtonHelper materialButtonHelper;
        super.onLayout(bl, n, n2, n3, n4);
        if (Build.VERSION.SDK_INT == 21 && (materialButtonHelper = this.materialButtonHelper) != null) {
            materialButtonHelper.updateMaskBounds(n4 - n2, n3 - n);
        }
    }

    public void onRestoreInstanceState(Parcelable object) {
        if (!(object instanceof SavedState)) {
            super.onRestoreInstanceState(object);
            return;
        }
        object = (SavedState)((Object)object);
        super.onRestoreInstanceState(object.getSuperState());
        this.setChecked(object.checked);
    }

    public Parcelable onSaveInstanceState() {
        SavedState savedState = new SavedState(super.onSaveInstanceState());
        savedState.checked = this.checked;
        return savedState;
    }

    protected void onSizeChanged(int n, int n2, int n3, int n4) {
        super.onSizeChanged(n, n2, n3, n4);
        this.updateIconPosition(n, n2);
    }

    protected void onTextChanged(CharSequence charSequence, int n, int n2, int n3) {
        super.onTextChanged(charSequence, n, n2, n3);
        this.updateIconPosition(this.getMeasuredWidth(), this.getMeasuredHeight());
    }

    public boolean performClick() {
        this.toggle();
        return super.performClick();
    }

    public void refreshDrawableState() {
        int[] nArray;
        super.refreshDrawableState();
        if (this.icon != null && this.icon.setState(nArray = this.getDrawableState())) {
            this.invalidate();
        }
    }

    public void removeOnCheckedChangeListener(OnCheckedChangeListener onCheckedChangeListener) {
        this.onCheckedChangeListeners.remove(onCheckedChangeListener);
    }

    public void setBackground(Drawable drawable2) {
        this.setBackgroundDrawable(drawable2);
    }

    public void setBackgroundColor(int n) {
        if (this.isUsingOriginalBackground()) {
            this.materialButtonHelper.setBackgroundColor(n);
        } else {
            super.setBackgroundColor(n);
        }
    }

    public void setBackgroundDrawable(Drawable drawable2) {
        if (this.isUsingOriginalBackground()) {
            if (drawable2 != this.getBackground()) {
                Log.w((String)LOG_TAG, (String)"MaterialButton manages its own background to control elevation, shape, color and states. Consider using backgroundTint, shapeAppearance and other attributes where available. A custom background will ignore these attributes and you should consider handling interaction states such as pressed, focused and disabled");
                this.materialButtonHelper.setBackgroundOverwritten();
                super.setBackgroundDrawable(drawable2);
            } else {
                this.getBackground().setState(drawable2.getState());
            }
        } else {
            super.setBackgroundDrawable(drawable2);
        }
    }

    public void setBackgroundResource(int n) {
        Drawable drawable2 = n != 0 ? AppCompatResources.getDrawable((Context)this.getContext(), (int)n) : null;
        this.setBackgroundDrawable(drawable2);
    }

    public void setBackgroundTintList(ColorStateList colorStateList) {
        this.setSupportBackgroundTintList(colorStateList);
    }

    public void setBackgroundTintMode(PorterDuff.Mode mode) {
        this.setSupportBackgroundTintMode(mode);
    }

    public void setCheckable(boolean bl) {
        if (this.isUsingOriginalBackground()) {
            this.materialButtonHelper.setCheckable(bl);
        }
    }

    public void setChecked(boolean bl) {
        if (this.isCheckable() && this.isEnabled() && this.checked != bl) {
            this.checked = bl;
            this.refreshDrawableState();
            if (this.broadcasting) {
                return;
            }
            this.broadcasting = true;
            Iterator iterator2 = this.onCheckedChangeListeners.iterator();
            while (iterator2.hasNext()) {
                ((OnCheckedChangeListener)iterator2.next()).onCheckedChanged(this, this.checked);
            }
            this.broadcasting = false;
        }
    }

    public void setCornerRadius(int n) {
        if (this.isUsingOriginalBackground()) {
            this.materialButtonHelper.setCornerRadius(n);
        }
    }

    public void setCornerRadiusResource(int n) {
        if (this.isUsingOriginalBackground()) {
            this.setCornerRadius(this.getResources().getDimensionPixelSize(n));
        }
    }

    public void setElevation(float f) {
        super.setElevation(f);
        if (this.isUsingOriginalBackground()) {
            this.materialButtonHelper.getMaterialShapeDrawable().setElevation(f);
        }
    }

    public void setIcon(Drawable drawable2) {
        if (this.icon != drawable2) {
            this.icon = drawable2;
            this.updateIcon(true);
            this.updateIconPosition(this.getMeasuredWidth(), this.getMeasuredHeight());
        }
    }

    public void setIconGravity(int n) {
        if (this.iconGravity != n) {
            this.iconGravity = n;
            this.updateIconPosition(this.getMeasuredWidth(), this.getMeasuredHeight());
        }
    }

    public void setIconPadding(int n) {
        if (this.iconPadding != n) {
            this.iconPadding = n;
            this.setCompoundDrawablePadding(n);
        }
    }

    public void setIconResource(int n) {
        Drawable drawable2 = n != 0 ? AppCompatResources.getDrawable((Context)this.getContext(), (int)n) : null;
        this.setIcon(drawable2);
    }

    public void setIconSize(int n) {
        if (n >= 0) {
            if (this.iconSize != n) {
                this.iconSize = n;
                this.updateIcon(true);
            }
            return;
        }
        throw new IllegalArgumentException("iconSize cannot be less than 0");
    }

    public void setIconTint(ColorStateList colorStateList) {
        if (this.iconTint != colorStateList) {
            this.iconTint = colorStateList;
            this.updateIcon(false);
        }
    }

    public void setIconTintMode(PorterDuff.Mode mode) {
        if (this.iconTintMode != mode) {
            this.iconTintMode = mode;
            this.updateIcon(false);
        }
    }

    public void setIconTintResource(int n) {
        this.setIconTint(AppCompatResources.getColorStateList((Context)this.getContext(), (int)n));
    }

    public void setInsetBottom(int n) {
        this.materialButtonHelper.setInsetBottom(n);
    }

    public void setInsetTop(int n) {
        this.materialButtonHelper.setInsetTop(n);
    }

    void setInternalBackground(Drawable drawable2) {
        super.setBackgroundDrawable(drawable2);
    }

    void setOnPressedChangeListenerInternal(OnPressedChangeListener onPressedChangeListener) {
        this.onPressedChangeListenerInternal = onPressedChangeListener;
    }

    public void setPressed(boolean bl) {
        OnPressedChangeListener onPressedChangeListener = this.onPressedChangeListenerInternal;
        if (onPressedChangeListener != null) {
            onPressedChangeListener.onPressedChanged(this, bl);
        }
        super.setPressed(bl);
    }

    public void setRippleColor(ColorStateList colorStateList) {
        if (this.isUsingOriginalBackground()) {
            this.materialButtonHelper.setRippleColor(colorStateList);
        }
    }

    public void setRippleColorResource(int n) {
        if (this.isUsingOriginalBackground()) {
            this.setRippleColor(AppCompatResources.getColorStateList((Context)this.getContext(), (int)n));
        }
    }

    @Override
    public void setShapeAppearanceModel(ShapeAppearanceModel shapeAppearanceModel) {
        if (this.isUsingOriginalBackground()) {
            this.materialButtonHelper.setShapeAppearanceModel(shapeAppearanceModel);
            return;
        }
        throw new IllegalStateException("Attempted to set ShapeAppearanceModel on a MaterialButton which has an overwritten background.");
    }

    void setShouldDrawSurfaceColorStroke(boolean bl) {
        if (this.isUsingOriginalBackground()) {
            this.materialButtonHelper.setShouldDrawSurfaceColorStroke(bl);
        }
    }

    public void setStrokeColor(ColorStateList colorStateList) {
        if (this.isUsingOriginalBackground()) {
            this.materialButtonHelper.setStrokeColor(colorStateList);
        }
    }

    public void setStrokeColorResource(int n) {
        if (this.isUsingOriginalBackground()) {
            this.setStrokeColor(AppCompatResources.getColorStateList((Context)this.getContext(), (int)n));
        }
    }

    public void setStrokeWidth(int n) {
        if (this.isUsingOriginalBackground()) {
            this.materialButtonHelper.setStrokeWidth(n);
        }
    }

    public void setStrokeWidthResource(int n) {
        if (this.isUsingOriginalBackground()) {
            this.setStrokeWidth(this.getResources().getDimensionPixelSize(n));
        }
    }

    public void setSupportBackgroundTintList(ColorStateList colorStateList) {
        if (this.isUsingOriginalBackground()) {
            this.materialButtonHelper.setSupportBackgroundTintList(colorStateList);
        } else {
            super.setSupportBackgroundTintList(colorStateList);
        }
    }

    public void setSupportBackgroundTintMode(PorterDuff.Mode mode) {
        if (this.isUsingOriginalBackground()) {
            this.materialButtonHelper.setSupportBackgroundTintMode(mode);
        } else {
            super.setSupportBackgroundTintMode(mode);
        }
    }

    public void toggle() {
        this.setChecked(this.checked ^ true);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface IconGravity {
    }

    public static interface OnCheckedChangeListener {
        public void onCheckedChanged(MaterialButton var1, boolean var2);
    }

    static interface OnPressedChangeListener {
        public void onPressedChanged(MaterialButton var1, boolean var2);
    }

    static class SavedState
    extends AbsSavedState {
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.ClassLoaderCreator<SavedState>(){

            public SavedState createFromParcel(Parcel parcel) {
                return new SavedState(parcel, null);
            }

            public SavedState createFromParcel(Parcel parcel, ClassLoader classLoader) {
                return new SavedState(parcel, classLoader);
            }

            public SavedState[] newArray(int n) {
                return new SavedState[n];
            }
        };
        boolean checked;

        public SavedState(Parcel parcel, ClassLoader classLoader) {
            super(parcel, classLoader);
            if (classLoader == null) {
                ((Object)((Object)this)).getClass().getClassLoader();
            }
            this.readFromParcel(parcel);
        }

        public SavedState(Parcelable parcelable) {
            super(parcelable);
        }

        private void readFromParcel(Parcel parcel) {
            int n = parcel.readInt();
            boolean bl = true;
            if (n != 1) {
                bl = false;
            }
            this.checked = bl;
        }

        public void writeToParcel(Parcel parcel, int n) {
            super.writeToParcel(parcel, n);
            parcel.writeInt(this.checked ? 1 : 0);
        }
    }
}

