/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.button;

import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.InsetDrawable;
import android.graphics.drawable.LayerDrawable;
import android.graphics.drawable.RippleDrawable;
import android.os.Build;
import android.view.View;
import androidx.core.graphics.drawable.DrawableCompat;
import androidx.core.view.ViewCompat;
import com.google.android.material.R;
import com.google.android.material.button.MaterialButton;
import com.google.android.material.color.MaterialColors;
import com.google.android.material.internal.ViewUtils;
import com.google.android.material.resources.MaterialResources;
import com.google.android.material.ripple.RippleDrawableCompat;
import com.google.android.material.ripple.RippleUtils;
import com.google.android.material.shape.MaterialShapeDrawable;
import com.google.android.material.shape.ShapeAppearanceModel;
import com.google.android.material.shape.Shapeable;

class MaterialButtonHelper {
    private static final boolean IS_LOLLIPOP;
    private static final boolean IS_MIN_LOLLIPOP;
    private boolean backgroundOverwritten = false;
    private ColorStateList backgroundTint;
    private PorterDuff.Mode backgroundTintMode;
    private boolean checkable;
    private int cornerRadius;
    private boolean cornerRadiusSet = false;
    private int elevation;
    private int insetBottom;
    private int insetLeft;
    private int insetRight;
    private int insetTop;
    private Drawable maskDrawable;
    private final MaterialButton materialButton;
    private ColorStateList rippleColor;
    private LayerDrawable rippleDrawable;
    private ShapeAppearanceModel shapeAppearanceModel;
    private boolean shouldDrawSurfaceColorStroke = false;
    private ColorStateList strokeColor;
    private int strokeWidth;

    static {
        int n = Build.VERSION.SDK_INT;
        boolean bl = true;
        boolean bl2 = n >= 21;
        IS_MIN_LOLLIPOP = bl2;
        bl2 = Build.VERSION.SDK_INT >= 21 && Build.VERSION.SDK_INT <= 22 ? bl : false;
        IS_LOLLIPOP = bl2;
    }

    MaterialButtonHelper(MaterialButton materialButton, ShapeAppearanceModel shapeAppearanceModel) {
        this.materialButton = materialButton;
        this.shapeAppearanceModel = shapeAppearanceModel;
    }

    private Drawable createBackground() {
        MaterialShapeDrawable materialShapeDrawable = new MaterialShapeDrawable(this.shapeAppearanceModel);
        materialShapeDrawable.initializeElevationOverlay(this.materialButton.getContext());
        DrawableCompat.setTintList((Drawable)materialShapeDrawable, (ColorStateList)this.backgroundTint);
        Object object = this.backgroundTintMode;
        if (object != null) {
            DrawableCompat.setTintMode((Drawable)materialShapeDrawable, (PorterDuff.Mode)object);
        }
        materialShapeDrawable.setStroke((float)this.strokeWidth, this.strokeColor);
        object = new MaterialShapeDrawable(this.shapeAppearanceModel);
        ((MaterialShapeDrawable)object).setTint(0);
        float f = this.strokeWidth;
        int n = this.shouldDrawSurfaceColorStroke ? MaterialColors.getColor((View)this.materialButton, R.attr.colorSurface) : 0;
        ((MaterialShapeDrawable)object).setStroke(f, n);
        if (IS_MIN_LOLLIPOP) {
            MaterialShapeDrawable materialShapeDrawable2 = new MaterialShapeDrawable(this.shapeAppearanceModel);
            this.maskDrawable = materialShapeDrawable2;
            DrawableCompat.setTint((Drawable)materialShapeDrawable2, (int)-1);
            materialShapeDrawable = new RippleDrawable(RippleUtils.sanitizeRippleDrawableColor(this.rippleColor), (Drawable)this.wrapDrawableWithInset((Drawable)new LayerDrawable(new Drawable[]{object, materialShapeDrawable})), this.maskDrawable);
            this.rippleDrawable = materialShapeDrawable;
            return materialShapeDrawable;
        }
        RippleDrawableCompat rippleDrawableCompat = new RippleDrawableCompat(this.shapeAppearanceModel);
        this.maskDrawable = rippleDrawableCompat;
        DrawableCompat.setTintList((Drawable)rippleDrawableCompat, (ColorStateList)RippleUtils.sanitizeRippleDrawableColor(this.rippleColor));
        materialShapeDrawable = new LayerDrawable(new Drawable[]{object, materialShapeDrawable, this.maskDrawable});
        this.rippleDrawable = materialShapeDrawable;
        return this.wrapDrawableWithInset(materialShapeDrawable);
    }

    private MaterialShapeDrawable getMaterialShapeDrawable(boolean bl) {
        LayerDrawable layerDrawable = this.rippleDrawable;
        if (layerDrawable != null && layerDrawable.getNumberOfLayers() > 0) {
            if (IS_MIN_LOLLIPOP) {
                return (MaterialShapeDrawable)((LayerDrawable)((InsetDrawable)this.rippleDrawable.getDrawable(0)).getDrawable()).getDrawable(bl ^ 1);
            }
            return (MaterialShapeDrawable)this.rippleDrawable.getDrawable(bl ^ 1);
        }
        return null;
    }

    private MaterialShapeDrawable getSurfaceColorStrokeDrawable() {
        return this.getMaterialShapeDrawable(true);
    }

    private void setVerticalInsets(int n, int n2) {
        int n3 = ViewCompat.getPaddingStart((View)this.materialButton);
        int n4 = this.materialButton.getPaddingTop();
        int n5 = ViewCompat.getPaddingEnd((View)this.materialButton);
        int n6 = this.materialButton.getPaddingBottom();
        int n7 = this.insetTop;
        int n8 = this.insetBottom;
        this.insetBottom = n2;
        this.insetTop = n;
        if (!this.backgroundOverwritten) {
            this.updateBackground();
        }
        ViewCompat.setPaddingRelative((View)this.materialButton, (int)n3, (int)(n4 + n - n7), (int)n5, (int)(n6 + n2 - n8));
    }

    private void updateBackground() {
        this.materialButton.setInternalBackground(this.createBackground());
        MaterialShapeDrawable materialShapeDrawable = this.getMaterialShapeDrawable();
        if (materialShapeDrawable != null) {
            materialShapeDrawable.setElevation(this.elevation);
        }
    }

    private void updateButtonShape(ShapeAppearanceModel shapeAppearanceModel) {
        if (IS_LOLLIPOP && !this.backgroundOverwritten) {
            int n = ViewCompat.getPaddingStart((View)this.materialButton);
            int n2 = this.materialButton.getPaddingTop();
            int n3 = ViewCompat.getPaddingEnd((View)this.materialButton);
            int n4 = this.materialButton.getPaddingBottom();
            this.updateBackground();
            ViewCompat.setPaddingRelative((View)this.materialButton, (int)n, (int)n2, (int)n3, (int)n4);
        } else {
            if (this.getMaterialShapeDrawable() != null) {
                this.getMaterialShapeDrawable().setShapeAppearanceModel(shapeAppearanceModel);
            }
            if (this.getSurfaceColorStrokeDrawable() != null) {
                this.getSurfaceColorStrokeDrawable().setShapeAppearanceModel(shapeAppearanceModel);
            }
            if (this.getMaskDrawable() != null) {
                this.getMaskDrawable().setShapeAppearanceModel(shapeAppearanceModel);
            }
        }
    }

    private void updateStroke() {
        MaterialShapeDrawable materialShapeDrawable = this.getMaterialShapeDrawable();
        MaterialShapeDrawable materialShapeDrawable2 = this.getSurfaceColorStrokeDrawable();
        if (materialShapeDrawable != null) {
            materialShapeDrawable.setStroke((float)this.strokeWidth, this.strokeColor);
            if (materialShapeDrawable2 != null) {
                float f = this.strokeWidth;
                int n = this.shouldDrawSurfaceColorStroke ? MaterialColors.getColor((View)this.materialButton, R.attr.colorSurface) : 0;
                materialShapeDrawable2.setStroke(f, n);
            }
        }
    }

    private InsetDrawable wrapDrawableWithInset(Drawable drawable2) {
        return new InsetDrawable(drawable2, this.insetLeft, this.insetTop, this.insetRight, this.insetBottom);
    }

    int getCornerRadius() {
        return this.cornerRadius;
    }

    public int getInsetBottom() {
        return this.insetBottom;
    }

    public int getInsetTop() {
        return this.insetTop;
    }

    public Shapeable getMaskDrawable() {
        LayerDrawable layerDrawable = this.rippleDrawable;
        if (layerDrawable != null && layerDrawable.getNumberOfLayers() > 1) {
            if (this.rippleDrawable.getNumberOfLayers() > 2) {
                return (Shapeable)this.rippleDrawable.getDrawable(2);
            }
            return (Shapeable)this.rippleDrawable.getDrawable(1);
        }
        return null;
    }

    MaterialShapeDrawable getMaterialShapeDrawable() {
        return this.getMaterialShapeDrawable(false);
    }

    ColorStateList getRippleColor() {
        return this.rippleColor;
    }

    ShapeAppearanceModel getShapeAppearanceModel() {
        return this.shapeAppearanceModel;
    }

    ColorStateList getStrokeColor() {
        return this.strokeColor;
    }

    int getStrokeWidth() {
        return this.strokeWidth;
    }

    ColorStateList getSupportBackgroundTintList() {
        return this.backgroundTint;
    }

    PorterDuff.Mode getSupportBackgroundTintMode() {
        return this.backgroundTintMode;
    }

    boolean isBackgroundOverwritten() {
        return this.backgroundOverwritten;
    }

    boolean isCheckable() {
        return this.checkable;
    }

    void loadFromAttributes(TypedArray typedArray) {
        int n;
        this.insetLeft = typedArray.getDimensionPixelOffset(R.styleable.MaterialButton_android_insetLeft, 0);
        this.insetRight = typedArray.getDimensionPixelOffset(R.styleable.MaterialButton_android_insetRight, 0);
        this.insetTop = typedArray.getDimensionPixelOffset(R.styleable.MaterialButton_android_insetTop, 0);
        this.insetBottom = typedArray.getDimensionPixelOffset(R.styleable.MaterialButton_android_insetBottom, 0);
        if (typedArray.hasValue(R.styleable.MaterialButton_cornerRadius)) {
            this.cornerRadius = n = typedArray.getDimensionPixelSize(R.styleable.MaterialButton_cornerRadius, -1);
            this.setShapeAppearanceModel(this.shapeAppearanceModel.withCornerSize(n));
            this.cornerRadiusSet = true;
        }
        this.strokeWidth = typedArray.getDimensionPixelSize(R.styleable.MaterialButton_strokeWidth, 0);
        this.backgroundTintMode = ViewUtils.parseTintMode(typedArray.getInt(R.styleable.MaterialButton_backgroundTintMode, -1), PorterDuff.Mode.SRC_IN);
        this.backgroundTint = MaterialResources.getColorStateList(this.materialButton.getContext(), typedArray, R.styleable.MaterialButton_backgroundTint);
        this.strokeColor = MaterialResources.getColorStateList(this.materialButton.getContext(), typedArray, R.styleable.MaterialButton_strokeColor);
        this.rippleColor = MaterialResources.getColorStateList(this.materialButton.getContext(), typedArray, R.styleable.MaterialButton_rippleColor);
        this.checkable = typedArray.getBoolean(R.styleable.MaterialButton_android_checkable, false);
        this.elevation = typedArray.getDimensionPixelSize(R.styleable.MaterialButton_elevation, 0);
        int n2 = ViewCompat.getPaddingStart((View)this.materialButton);
        int n3 = this.materialButton.getPaddingTop();
        n = ViewCompat.getPaddingEnd((View)this.materialButton);
        int n4 = this.materialButton.getPaddingBottom();
        if (typedArray.hasValue(R.styleable.MaterialButton_android_background)) {
            this.setBackgroundOverwritten();
        } else {
            this.updateBackground();
        }
        ViewCompat.setPaddingRelative((View)this.materialButton, (int)(n2 + this.insetLeft), (int)(n3 + this.insetTop), (int)(n + this.insetRight), (int)(n4 + this.insetBottom));
    }

    void setBackgroundColor(int n) {
        if (this.getMaterialShapeDrawable() != null) {
            this.getMaterialShapeDrawable().setTint(n);
        }
    }

    void setBackgroundOverwritten() {
        this.backgroundOverwritten = true;
        this.materialButton.setSupportBackgroundTintList(this.backgroundTint);
        this.materialButton.setSupportBackgroundTintMode(this.backgroundTintMode);
    }

    void setCheckable(boolean bl) {
        this.checkable = bl;
    }

    void setCornerRadius(int n) {
        if (!this.cornerRadiusSet || this.cornerRadius != n) {
            this.cornerRadius = n;
            this.cornerRadiusSet = true;
            this.setShapeAppearanceModel(this.shapeAppearanceModel.withCornerSize(n));
        }
    }

    public void setInsetBottom(int n) {
        this.setVerticalInsets(this.insetTop, n);
    }

    public void setInsetTop(int n) {
        this.setVerticalInsets(n, this.insetBottom);
    }

    void setRippleColor(ColorStateList colorStateList) {
        if (this.rippleColor != colorStateList) {
            this.rippleColor = colorStateList;
            boolean bl = IS_MIN_LOLLIPOP;
            if (bl && this.materialButton.getBackground() instanceof RippleDrawable) {
                ((RippleDrawable)this.materialButton.getBackground()).setColor(RippleUtils.sanitizeRippleDrawableColor(colorStateList));
            } else if (!bl && this.materialButton.getBackground() instanceof RippleDrawableCompat) {
                ((RippleDrawableCompat)this.materialButton.getBackground()).setTintList(RippleUtils.sanitizeRippleDrawableColor(colorStateList));
            }
        }
    }

    void setShapeAppearanceModel(ShapeAppearanceModel shapeAppearanceModel) {
        this.shapeAppearanceModel = shapeAppearanceModel;
        this.updateButtonShape(shapeAppearanceModel);
    }

    void setShouldDrawSurfaceColorStroke(boolean bl) {
        this.shouldDrawSurfaceColorStroke = bl;
        this.updateStroke();
    }

    void setStrokeColor(ColorStateList colorStateList) {
        if (this.strokeColor != colorStateList) {
            this.strokeColor = colorStateList;
            this.updateStroke();
        }
    }

    void setStrokeWidth(int n) {
        if (this.strokeWidth != n) {
            this.strokeWidth = n;
            this.updateStroke();
        }
    }

    void setSupportBackgroundTintList(ColorStateList colorStateList) {
        if (this.backgroundTint != colorStateList) {
            this.backgroundTint = colorStateList;
            if (this.getMaterialShapeDrawable() != null) {
                DrawableCompat.setTintList((Drawable)this.getMaterialShapeDrawable(), (ColorStateList)this.backgroundTint);
            }
        }
    }

    void setSupportBackgroundTintMode(PorterDuff.Mode mode) {
        if (this.backgroundTintMode != mode) {
            this.backgroundTintMode = mode;
            if (this.getMaterialShapeDrawable() != null && this.backgroundTintMode != null) {
                DrawableCompat.setTintMode((Drawable)this.getMaterialShapeDrawable(), (PorterDuff.Mode)this.backgroundTintMode);
            }
        }
    }

    void updateMaskBounds(int n, int n2) {
        Drawable drawable2 = this.maskDrawable;
        if (drawable2 != null) {
            drawable2.setBounds(this.insetLeft, this.insetTop, n2 - this.insetRight, n - this.insetBottom);
        }
    }
}

