/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.button;

import android.content.Context;
import android.graphics.Canvas;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.LinearLayout;
import androidx.core.view.AccessibilityDelegateCompat;
import androidx.core.view.MarginLayoutParamsCompat;
import androidx.core.view.ViewCompat;
import androidx.core.view.accessibility.AccessibilityNodeInfoCompat;
import com.google.android.material.R;
import com.google.android.material.button.MaterialButton;
import com.google.android.material.internal.ThemeEnforcement;
import com.google.android.material.internal.ViewUtils;
import com.google.android.material.shape.AbsoluteCornerSize;
import com.google.android.material.shape.CornerSize;
import com.google.android.material.shape.ShapeAppearanceModel;
import com.google.android.material.theme.overlay.MaterialThemeOverlay;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.TreeMap;

public class MaterialButtonToggleGroup
extends LinearLayout {
    private static final int DEF_STYLE_RES = R.style.Widget_MaterialComponents_MaterialButtonToggleGroup;
    private static final String LOG_TAG = "MaterialButtonToggleGroup";
    private int checkedId;
    private final CheckedStateTracker checkedStateTracker;
    private Integer[] childOrder;
    private final Comparator<MaterialButton> childOrderComparator;
    private final LinkedHashSet<OnButtonCheckedListener> onButtonCheckedListeners;
    private final List<CornerData> originalCornerData;
    private final PressedStateTracker pressedStateTracker;
    private boolean selectionRequired;
    private boolean singleSelection;
    private boolean skipCheckedStateTracker;

    public MaterialButtonToggleGroup(Context context) {
        this(context, null);
    }

    public MaterialButtonToggleGroup(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, R.attr.materialButtonToggleGroupStyle);
    }

    public MaterialButtonToggleGroup(Context context, AttributeSet attributeSet, int n) {
        int n2 = DEF_STYLE_RES;
        super(MaterialThemeOverlay.wrap(context, attributeSet, n, n2), attributeSet, n);
        this.originalCornerData = new ArrayList<CornerData>();
        this.checkedStateTracker = new CheckedStateTracker();
        this.pressedStateTracker = new PressedStateTracker();
        this.onButtonCheckedListeners = new LinkedHashSet();
        this.childOrderComparator = new Comparator<MaterialButton>(){

            @Override
            public int compare(MaterialButton materialButton, MaterialButton materialButton2) {
                int n = Boolean.valueOf(materialButton.isChecked()).compareTo(materialButton2.isChecked());
                if (n != 0) {
                    return n;
                }
                n = Boolean.valueOf(materialButton.isPressed()).compareTo(materialButton2.isPressed());
                if (n != 0) {
                    return n;
                }
                return Integer.valueOf(MaterialButtonToggleGroup.this.indexOfChild((View)materialButton)).compareTo(MaterialButtonToggleGroup.this.indexOfChild((View)materialButton2));
            }
        };
        this.skipCheckedStateTracker = false;
        context = ThemeEnforcement.obtainStyledAttributes(this.getContext(), attributeSet, R.styleable.MaterialButtonToggleGroup, n, n2, new int[0]);
        this.setSingleSelection(context.getBoolean(R.styleable.MaterialButtonToggleGroup_singleSelection, false));
        this.checkedId = context.getResourceId(R.styleable.MaterialButtonToggleGroup_checkedButton, -1);
        this.selectionRequired = context.getBoolean(R.styleable.MaterialButtonToggleGroup_selectionRequired, false);
        this.setChildrenDrawingOrderEnabled(true);
        context.recycle();
        ViewCompat.setImportantForAccessibility((View)this, (int)1);
    }

    static /* synthetic */ int access$502(MaterialButtonToggleGroup materialButtonToggleGroup, int n) {
        materialButtonToggleGroup.checkedId = n;
        return n;
    }

    private void adjustChildMarginsAndUpdateLayout() {
        int n = this.getFirstVisibleChildIndex();
        if (n == -1) {
            return;
        }
        for (int i = n + 1; i < this.getChildCount(); ++i) {
            MaterialButton materialButton = this.getChildButton(i);
            MaterialButton materialButton2 = this.getChildButton(i - 1);
            int n2 = Math.min(materialButton.getStrokeWidth(), materialButton2.getStrokeWidth());
            materialButton2 = this.buildLayoutParams((View)materialButton);
            if (this.getOrientation() == 0) {
                MarginLayoutParamsCompat.setMarginEnd((ViewGroup.MarginLayoutParams)materialButton2, (int)0);
                MarginLayoutParamsCompat.setMarginStart((ViewGroup.MarginLayoutParams)materialButton2, (int)(-n2));
                ((LinearLayout.LayoutParams)materialButton2).topMargin = 0;
            } else {
                ((LinearLayout.LayoutParams)materialButton2).bottomMargin = 0;
                ((LinearLayout.LayoutParams)materialButton2).topMargin = -n2;
                MarginLayoutParamsCompat.setMarginStart((ViewGroup.MarginLayoutParams)materialButton2, (int)0);
            }
            materialButton.setLayoutParams((ViewGroup.LayoutParams)materialButton2);
        }
        this.resetChildMargins(n);
    }

    private LinearLayout.LayoutParams buildLayoutParams(View view) {
        if ((view = view.getLayoutParams()) instanceof LinearLayout.LayoutParams) {
            return (LinearLayout.LayoutParams)view;
        }
        return new LinearLayout.LayoutParams(view.width, view.height);
    }

    private void checkForced(int n, boolean bl) {
        MaterialButton materialButton = (MaterialButton)this.findViewById(n);
        if (materialButton != null) {
            materialButton.setChecked(bl);
        }
    }

    private void dispatchOnButtonChecked(int n, boolean bl) {
        Iterator iterator2 = this.onButtonCheckedListeners.iterator();
        while (iterator2.hasNext()) {
            ((OnButtonCheckedListener)iterator2.next()).onButtonChecked(this, n, bl);
        }
    }

    private MaterialButton getChildButton(int n) {
        return (MaterialButton)this.getChildAt(n);
    }

    private int getFirstVisibleChildIndex() {
        int n = this.getChildCount();
        for (int i = 0; i < n; ++i) {
            if (!this.isChildVisible(i)) continue;
            return i;
        }
        return -1;
    }

    private int getIndexWithinVisibleButtons(View view) {
        if (!(view instanceof MaterialButton)) {
            return -1;
        }
        int n = 0;
        for (int i = 0; i < this.getChildCount(); ++i) {
            if (this.getChildAt(i) == view) {
                return n;
            }
            int n2 = n;
            if (this.getChildAt(i) instanceof MaterialButton) {
                n2 = n;
                if (this.isChildVisible(i)) {
                    n2 = n + 1;
                }
            }
            n = n2;
        }
        return -1;
    }

    private int getLastVisibleChildIndex() {
        for (int i = this.getChildCount() - 1; i >= 0; --i) {
            if (!this.isChildVisible(i)) continue;
            return i;
        }
        return -1;
    }

    private CornerData getNewCornerData(int n, int n2, int n3) {
        CornerData cornerData = this.originalCornerData.get(n);
        if (n2 == n3) {
            return cornerData;
        }
        boolean bl = this.getOrientation() == 0;
        if (n == n2) {
            cornerData = bl ? CornerData.start(cornerData, (View)this) : CornerData.top(cornerData);
            return cornerData;
        }
        if (n == n3) {
            cornerData = bl ? CornerData.end(cornerData, (View)this) : CornerData.bottom(cornerData);
            return cornerData;
        }
        return null;
    }

    private int getVisibleButtonCount() {
        int n = 0;
        for (int i = 0; i < this.getChildCount(); ++i) {
            int n2 = n;
            if (this.getChildAt(i) instanceof MaterialButton) {
                n2 = n;
                if (this.isChildVisible(i)) {
                    n2 = n + 1;
                }
            }
            n = n2;
        }
        return n;
    }

    private boolean isChildVisible(int n) {
        boolean bl = this.getChildAt(n).getVisibility() != 8;
        return bl;
    }

    private void resetChildMargins(int n) {
        if (this.getChildCount() != 0 && n != -1) {
            LinearLayout.LayoutParams layoutParams = (LinearLayout.LayoutParams)this.getChildButton(n).getLayoutParams();
            if (this.getOrientation() == 1) {
                layoutParams.topMargin = 0;
                layoutParams.bottomMargin = 0;
                return;
            }
            MarginLayoutParamsCompat.setMarginEnd((ViewGroup.MarginLayoutParams)layoutParams, (int)0);
            MarginLayoutParamsCompat.setMarginStart((ViewGroup.MarginLayoutParams)layoutParams, (int)0);
            layoutParams.leftMargin = 0;
            layoutParams.rightMargin = 0;
        }
    }

    private void setCheckedId(int n) {
        this.checkedId = n;
        this.dispatchOnButtonChecked(n, true);
    }

    private void setCheckedStateForView(int n, boolean bl) {
        View view = this.findViewById(n);
        if (view instanceof MaterialButton) {
            this.skipCheckedStateTracker = true;
            ((MaterialButton)view).setChecked(bl);
            this.skipCheckedStateTracker = false;
        }
    }

    private void setGeneratedIdIfNeeded(MaterialButton materialButton) {
        if (materialButton.getId() == -1) {
            materialButton.setId(ViewCompat.generateViewId());
        }
    }

    private void setupButtonChild(MaterialButton materialButton) {
        materialButton.setMaxLines(1);
        materialButton.setEllipsize(TextUtils.TruncateAt.END);
        materialButton.setCheckable(true);
        materialButton.addOnCheckedChangeListener(this.checkedStateTracker);
        materialButton.setOnPressedChangeListenerInternal(this.pressedStateTracker);
        materialButton.setShouldDrawSurfaceColorStroke(true);
    }

    private static void updateBuilderWithCornerData(ShapeAppearanceModel.Builder builder, CornerData cornerData) {
        if (cornerData == null) {
            builder.setAllCornerSizes(0.0f);
            return;
        }
        builder.setTopLeftCornerSize(cornerData.topLeft).setBottomLeftCornerSize(cornerData.bottomLeft).setTopRightCornerSize(cornerData.topRight).setBottomRightCornerSize(cornerData.bottomRight);
    }

    private boolean updateCheckedStates(int n, boolean bl) {
        Object object = this.getCheckedButtonIds();
        if (this.selectionRequired && object.isEmpty()) {
            this.setCheckedStateForView(n, true);
            this.checkedId = n;
            return false;
        }
        if (bl && this.singleSelection) {
            object.remove((Object)n);
            object = object.iterator();
            while (object.hasNext()) {
                n = (Integer)object.next();
                this.setCheckedStateForView(n, false);
                this.dispatchOnButtonChecked(n, false);
            }
        }
        return true;
    }

    private void updateChildOrder() {
        TreeMap<MaterialButton, Integer> treeMap = new TreeMap<MaterialButton, Integer>(this.childOrderComparator);
        int n = this.getChildCount();
        for (int i = 0; i < n; ++i) {
            treeMap.put(this.getChildButton(i), i);
        }
        this.childOrder = treeMap.values().toArray(new Integer[0]);
    }

    public void addOnButtonCheckedListener(OnButtonCheckedListener onButtonCheckedListener) {
        this.onButtonCheckedListeners.add(onButtonCheckedListener);
    }

    public void addView(View object, int n, ViewGroup.LayoutParams object2) {
        if (!(object instanceof MaterialButton)) {
            Log.e((String)LOG_TAG, (String)"Child views must be of type MaterialButton.");
            return;
        }
        super.addView((View)object, n, (ViewGroup.LayoutParams)object2);
        object = (MaterialButton)object;
        this.setGeneratedIdIfNeeded((MaterialButton)object);
        this.setupButtonChild((MaterialButton)object);
        if (((MaterialButton)object).isChecked()) {
            this.updateCheckedStates(object.getId(), true);
            this.setCheckedId(object.getId());
        }
        object2 = ((MaterialButton)object).getShapeAppearanceModel();
        this.originalCornerData.add(new CornerData(((ShapeAppearanceModel)object2).getTopLeftCornerSize(), ((ShapeAppearanceModel)object2).getBottomLeftCornerSize(), ((ShapeAppearanceModel)object2).getTopRightCornerSize(), ((ShapeAppearanceModel)object2).getBottomRightCornerSize()));
        ViewCompat.setAccessibilityDelegate((View)object, (AccessibilityDelegateCompat)new AccessibilityDelegateCompat(){

            public void onInitializeAccessibilityNodeInfo(View view, AccessibilityNodeInfoCompat accessibilityNodeInfoCompat) {
                super.onInitializeAccessibilityNodeInfo(view, accessibilityNodeInfoCompat);
                accessibilityNodeInfoCompat.setCollectionItemInfo((Object)AccessibilityNodeInfoCompat.CollectionItemInfoCompat.obtain((int)0, (int)1, (int)MaterialButtonToggleGroup.this.getIndexWithinVisibleButtons(view), (int)1, (boolean)false, (boolean)((MaterialButton)view).isChecked()));
            }
        });
    }

    public void check(int n) {
        if (n == this.checkedId) {
            return;
        }
        this.checkForced(n, true);
    }

    public void clearChecked() {
        this.skipCheckedStateTracker = true;
        for (int i = 0; i < this.getChildCount(); ++i) {
            MaterialButton materialButton = this.getChildButton(i);
            materialButton.setChecked(false);
            this.dispatchOnButtonChecked(materialButton.getId(), false);
        }
        this.skipCheckedStateTracker = false;
        this.setCheckedId(-1);
    }

    public void clearOnButtonCheckedListeners() {
        this.onButtonCheckedListeners.clear();
    }

    protected void dispatchDraw(Canvas canvas) {
        this.updateChildOrder();
        super.dispatchDraw(canvas);
    }

    public CharSequence getAccessibilityClassName() {
        return MaterialButtonToggleGroup.class.getName();
    }

    public int getCheckedButtonId() {
        int n = this.singleSelection ? this.checkedId : -1;
        return n;
    }

    public List<Integer> getCheckedButtonIds() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < this.getChildCount(); ++i) {
            MaterialButton materialButton = this.getChildButton(i);
            if (!materialButton.isChecked()) continue;
            arrayList.add(materialButton.getId());
        }
        return arrayList;
    }

    protected int getChildDrawingOrder(int n, int n2) {
        Integer[] integerArray = this.childOrder;
        if (integerArray != null && n2 < integerArray.length) {
            return integerArray[n2];
        }
        Log.w((String)LOG_TAG, (String)"Child order wasn't updated");
        return n2;
    }

    public boolean isSelectionRequired() {
        return this.selectionRequired;
    }

    public boolean isSingleSelection() {
        return this.singleSelection;
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        int n = this.checkedId;
        if (n != -1) {
            this.checkForced(n, true);
        }
    }

    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo accessibilityNodeInfo) {
        super.onInitializeAccessibilityNodeInfo(accessibilityNodeInfo);
        accessibilityNodeInfo = AccessibilityNodeInfoCompat.wrap((AccessibilityNodeInfo)accessibilityNodeInfo);
        int n = this.getVisibleButtonCount();
        int n2 = this.isSingleSelection() ? 1 : 2;
        accessibilityNodeInfo.setCollectionInfo((Object)AccessibilityNodeInfoCompat.CollectionInfoCompat.obtain((int)1, (int)n, (boolean)false, (int)n2));
    }

    protected void onMeasure(int n, int n2) {
        this.updateChildShapes();
        this.adjustChildMarginsAndUpdateLayout();
        super.onMeasure(n, n2);
    }

    public void onViewRemoved(View view) {
        int n;
        super.onViewRemoved(view);
        if (view instanceof MaterialButton) {
            MaterialButton materialButton = (MaterialButton)view;
            materialButton.removeOnCheckedChangeListener(this.checkedStateTracker);
            materialButton.setOnPressedChangeListenerInternal(null);
        }
        if ((n = this.indexOfChild(view)) >= 0) {
            this.originalCornerData.remove(n);
        }
        this.updateChildShapes();
        this.adjustChildMarginsAndUpdateLayout();
    }

    public void removeOnButtonCheckedListener(OnButtonCheckedListener onButtonCheckedListener) {
        this.onButtonCheckedListeners.remove(onButtonCheckedListener);
    }

    public void setSelectionRequired(boolean bl) {
        this.selectionRequired = bl;
    }

    public void setSingleSelection(int n) {
        this.setSingleSelection(this.getResources().getBoolean(n));
    }

    public void setSingleSelection(boolean bl) {
        if (this.singleSelection != bl) {
            this.singleSelection = bl;
            this.clearChecked();
        }
    }

    public void uncheck(int n) {
        this.checkForced(n, false);
    }

    void updateChildShapes() {
        int n = this.getChildCount();
        int n2 = this.getFirstVisibleChildIndex();
        int n3 = this.getLastVisibleChildIndex();
        for (int i = 0; i < n; ++i) {
            MaterialButton materialButton = this.getChildButton(i);
            if (materialButton.getVisibility() == 8) continue;
            ShapeAppearanceModel.Builder builder = materialButton.getShapeAppearanceModel().toBuilder();
            MaterialButtonToggleGroup.updateBuilderWithCornerData(builder, this.getNewCornerData(i, n2, n3));
            materialButton.setShapeAppearanceModel(builder.build());
        }
    }

    private class CheckedStateTracker
    implements MaterialButton.OnCheckedChangeListener {
        private CheckedStateTracker() {
        }

        @Override
        public void onCheckedChanged(MaterialButton materialButton, boolean bl) {
            if (MaterialButtonToggleGroup.this.skipCheckedStateTracker) {
                return;
            }
            if (MaterialButtonToggleGroup.this.singleSelection) {
                MaterialButtonToggleGroup materialButtonToggleGroup = MaterialButtonToggleGroup.this;
                int n = bl ? materialButton.getId() : -1;
                MaterialButtonToggleGroup.access$502(materialButtonToggleGroup, n);
            }
            if (MaterialButtonToggleGroup.this.updateCheckedStates(materialButton.getId(), bl)) {
                MaterialButtonToggleGroup.this.dispatchOnButtonChecked(materialButton.getId(), materialButton.isChecked());
            }
            MaterialButtonToggleGroup.this.invalidate();
        }
    }

    private static class CornerData {
        private static final CornerSize noCorner = new AbsoluteCornerSize(0.0f);
        CornerSize bottomLeft;
        CornerSize bottomRight;
        CornerSize topLeft;
        CornerSize topRight;

        CornerData(CornerSize cornerSize, CornerSize cornerSize2, CornerSize cornerSize3, CornerSize cornerSize4) {
            this.topLeft = cornerSize;
            this.topRight = cornerSize3;
            this.bottomRight = cornerSize4;
            this.bottomLeft = cornerSize2;
        }

        public static CornerData bottom(CornerData cornerData) {
            CornerSize cornerSize = noCorner;
            return new CornerData(cornerSize, cornerData.bottomLeft, cornerSize, cornerData.bottomRight);
        }

        public static CornerData end(CornerData cornerData, View view) {
            cornerData = ViewUtils.isLayoutRtl(view) ? CornerData.left(cornerData) : CornerData.right(cornerData);
            return cornerData;
        }

        public static CornerData left(CornerData object) {
            CornerSize cornerSize = ((CornerData)object).topLeft;
            object = ((CornerData)object).bottomLeft;
            CornerSize cornerSize2 = noCorner;
            return new CornerData(cornerSize, (CornerSize)object, cornerSize2, cornerSize2);
        }

        public static CornerData right(CornerData cornerData) {
            CornerSize cornerSize = noCorner;
            return new CornerData(cornerSize, cornerSize, cornerData.topRight, cornerData.bottomRight);
        }

        public static CornerData start(CornerData cornerData, View view) {
            cornerData = ViewUtils.isLayoutRtl(view) ? CornerData.right(cornerData) : CornerData.left(cornerData);
            return cornerData;
        }

        public static CornerData top(CornerData cornerData) {
            CornerSize cornerSize = cornerData.topLeft;
            CornerSize cornerSize2 = noCorner;
            return new CornerData(cornerSize, cornerSize2, cornerData.topRight, cornerSize2);
        }
    }

    public static interface OnButtonCheckedListener {
        public void onButtonChecked(MaterialButtonToggleGroup var1, int var2, boolean var3);
    }

    private class PressedStateTracker
    implements MaterialButton.OnPressedChangeListener {
        private PressedStateTracker() {
        }

        @Override
        public void onPressedChanged(MaterialButton materialButton, boolean bl) {
            MaterialButtonToggleGroup.this.invalidate();
        }
    }
}

