/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.chip;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.CompoundButton;
import androidx.core.view.ViewCompat;
import androidx.core.view.accessibility.AccessibilityNodeInfoCompat;
import com.google.android.material.R;
import com.google.android.material.chip.Chip;
import com.google.android.material.internal.FlowLayout;
import com.google.android.material.internal.ThemeEnforcement;
import com.google.android.material.theme.overlay.MaterialThemeOverlay;
import java.util.ArrayList;
import java.util.List;

public class ChipGroup
extends FlowLayout {
    private static final int DEF_STYLE_RES = R.style.Widget_MaterialComponents_ChipGroup;
    private int checkedId;
    private final CheckedStateTracker checkedStateTracker;
    private int chipSpacingHorizontal;
    private int chipSpacingVertical;
    private OnCheckedChangeListener onCheckedChangeListener;
    private PassThroughHierarchyChangeListener passThroughListener;
    private boolean protectFromCheckedChange;
    private boolean selectionRequired;
    private boolean singleSelection;

    public ChipGroup(Context context) {
        this(context, null);
    }

    public ChipGroup(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, R.attr.chipGroupStyle);
    }

    public ChipGroup(Context context, AttributeSet attributeSet, int n) {
        int n2 = DEF_STYLE_RES;
        super(MaterialThemeOverlay.wrap(context, attributeSet, n, n2), attributeSet, n);
        this.checkedStateTracker = new CheckedStateTracker();
        this.passThroughListener = new PassThroughHierarchyChangeListener();
        this.checkedId = -1;
        this.protectFromCheckedChange = false;
        context = ThemeEnforcement.obtainStyledAttributes(this.getContext(), attributeSet, R.styleable.ChipGroup, n, n2, new int[0]);
        n = context.getDimensionPixelOffset(R.styleable.ChipGroup_chipSpacing, 0);
        this.setChipSpacingHorizontal(context.getDimensionPixelOffset(R.styleable.ChipGroup_chipSpacingHorizontal, n));
        this.setChipSpacingVertical(context.getDimensionPixelOffset(R.styleable.ChipGroup_chipSpacingVertical, n));
        this.setSingleLine(context.getBoolean(R.styleable.ChipGroup_singleLine, false));
        this.setSingleSelection(context.getBoolean(R.styleable.ChipGroup_singleSelection, false));
        this.setSelectionRequired(context.getBoolean(R.styleable.ChipGroup_selectionRequired, false));
        n = context.getResourceId(R.styleable.ChipGroup_checkedChip, -1);
        if (n != -1) {
            this.checkedId = n;
        }
        context.recycle();
        super.setOnHierarchyChangeListener((ViewGroup.OnHierarchyChangeListener)this.passThroughListener);
        ViewCompat.setImportantForAccessibility((View)this, (int)1);
    }

    private int getChipCount() {
        int n = 0;
        for (int i = 0; i < this.getChildCount(); ++i) {
            int n2 = n;
            if (this.getChildAt(i) instanceof Chip) {
                n2 = n + 1;
            }
            n = n2;
        }
        return n;
    }

    private void setCheckedId(int n) {
        this.setCheckedId(n, true);
    }

    private void setCheckedId(int n, boolean bl) {
        this.checkedId = n;
        OnCheckedChangeListener onCheckedChangeListener = this.onCheckedChangeListener;
        if (onCheckedChangeListener != null && this.singleSelection && bl) {
            onCheckedChangeListener.onCheckedChanged(this, n);
        }
    }

    private void setCheckedStateForView(int n, boolean bl) {
        View view = this.findViewById(n);
        if (view instanceof Chip) {
            this.protectFromCheckedChange = true;
            ((Chip)view).setChecked(bl);
            this.protectFromCheckedChange = false;
        }
    }

    public void addView(View view, int n, ViewGroup.LayoutParams layoutParams) {
        Chip chip;
        if (view instanceof Chip && (chip = (Chip)view).isChecked()) {
            int n2 = this.checkedId;
            if (n2 != -1 && this.singleSelection) {
                this.setCheckedStateForView(n2, false);
            }
            this.setCheckedId(chip.getId());
        }
        super.addView(view, n, layoutParams);
    }

    public void check(int n) {
        int n2 = this.checkedId;
        if (n == n2) {
            return;
        }
        if (n2 != -1 && this.singleSelection) {
            this.setCheckedStateForView(n2, false);
        }
        if (n != -1) {
            this.setCheckedStateForView(n, true);
        }
        this.setCheckedId(n);
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams layoutParams) {
        boolean bl = super.checkLayoutParams(layoutParams) && layoutParams instanceof LayoutParams;
        return bl;
    }

    public void clearCheck() {
        this.protectFromCheckedChange = true;
        for (int i = 0; i < this.getChildCount(); ++i) {
            View view = this.getChildAt(i);
            if (!(view instanceof Chip)) continue;
            ((Chip)view).setChecked(false);
        }
        this.protectFromCheckedChange = false;
        this.setCheckedId(-1);
    }

    protected ViewGroup.LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams(-2, -2);
    }

    public ViewGroup.LayoutParams generateLayoutParams(AttributeSet attributeSet) {
        return new LayoutParams(this.getContext(), attributeSet);
    }

    protected ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return new LayoutParams(layoutParams);
    }

    public int getCheckedChipId() {
        int n = this.singleSelection ? this.checkedId : -1;
        return n;
    }

    public List<Integer> getCheckedChipIds() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < this.getChildCount(); ++i) {
            View view = this.getChildAt(i);
            if (!(view instanceof Chip) || !((Chip)view).isChecked()) continue;
            arrayList.add(view.getId());
            if (!this.singleSelection) continue;
            return arrayList;
        }
        return arrayList;
    }

    public int getChipSpacingHorizontal() {
        return this.chipSpacingHorizontal;
    }

    public int getChipSpacingVertical() {
        return this.chipSpacingVertical;
    }

    int getIndexOfChip(View view) {
        if (!(view instanceof Chip)) {
            return -1;
        }
        int n = 0;
        for (int i = 0; i < this.getChildCount(); ++i) {
            int n2 = n;
            if (this.getChildAt(i) instanceof Chip) {
                if ((Chip)this.getChildAt(i) == view) {
                    return n;
                }
                n2 = n + 1;
            }
            n = n2;
        }
        return -1;
    }

    public boolean isSelectionRequired() {
        return this.selectionRequired;
    }

    @Override
    public boolean isSingleLine() {
        return super.isSingleLine();
    }

    public boolean isSingleSelection() {
        return this.singleSelection;
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        int n = this.checkedId;
        if (n != -1) {
            this.setCheckedStateForView(n, true);
            this.setCheckedId(this.checkedId);
        }
    }

    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo accessibilityNodeInfo) {
        super.onInitializeAccessibilityNodeInfo(accessibilityNodeInfo);
        accessibilityNodeInfo = AccessibilityNodeInfoCompat.wrap((AccessibilityNodeInfo)accessibilityNodeInfo);
        int n = this.isSingleLine() ? this.getChipCount() : -1;
        int n2 = this.getRowCount();
        int n3 = this.isSingleSelection() ? 1 : 2;
        accessibilityNodeInfo.setCollectionInfo((Object)AccessibilityNodeInfoCompat.CollectionInfoCompat.obtain((int)n2, (int)n, (boolean)false, (int)n3));
    }

    public void setChipSpacing(int n) {
        this.setChipSpacingHorizontal(n);
        this.setChipSpacingVertical(n);
    }

    public void setChipSpacingHorizontal(int n) {
        if (this.chipSpacingHorizontal != n) {
            this.chipSpacingHorizontal = n;
            this.setItemSpacing(n);
            this.requestLayout();
        }
    }

    public void setChipSpacingHorizontalResource(int n) {
        this.setChipSpacingHorizontal(this.getResources().getDimensionPixelOffset(n));
    }

    public void setChipSpacingResource(int n) {
        this.setChipSpacing(this.getResources().getDimensionPixelOffset(n));
    }

    public void setChipSpacingVertical(int n) {
        if (this.chipSpacingVertical != n) {
            this.chipSpacingVertical = n;
            this.setLineSpacing(n);
            this.requestLayout();
        }
    }

    public void setChipSpacingVerticalResource(int n) {
        this.setChipSpacingVertical(this.getResources().getDimensionPixelOffset(n));
    }

    @Deprecated
    public void setDividerDrawableHorizontal(Drawable drawable2) {
        throw new UnsupportedOperationException("Changing divider drawables have no effect. ChipGroup do not use divider drawables as spacing.");
    }

    @Deprecated
    public void setDividerDrawableVertical(Drawable drawable2) {
        throw new UnsupportedOperationException("Changing divider drawables have no effect. ChipGroup do not use divider drawables as spacing.");
    }

    @Deprecated
    public void setFlexWrap(int n) {
        throw new UnsupportedOperationException("Changing flex wrap not allowed. ChipGroup exposes a singleLine attribute instead.");
    }

    public void setOnCheckedChangeListener(OnCheckedChangeListener onCheckedChangeListener) {
        this.onCheckedChangeListener = onCheckedChangeListener;
    }

    public void setOnHierarchyChangeListener(ViewGroup.OnHierarchyChangeListener onHierarchyChangeListener) {
        PassThroughHierarchyChangeListener.access$202(this.passThroughListener, onHierarchyChangeListener);
    }

    public void setSelectionRequired(boolean bl) {
        this.selectionRequired = bl;
    }

    @Deprecated
    public void setShowDividerHorizontal(int n) {
        throw new UnsupportedOperationException("Changing divider modes has no effect. ChipGroup do not use divider drawables as spacing.");
    }

    @Deprecated
    public void setShowDividerVertical(int n) {
        throw new UnsupportedOperationException("Changing divider modes has no effect. ChipGroup do not use divider drawables as spacing.");
    }

    public void setSingleLine(int n) {
        this.setSingleLine(this.getResources().getBoolean(n));
    }

    @Override
    public void setSingleLine(boolean bl) {
        super.setSingleLine(bl);
    }

    public void setSingleSelection(int n) {
        this.setSingleSelection(this.getResources().getBoolean(n));
    }

    public void setSingleSelection(boolean bl) {
        if (this.singleSelection != bl) {
            this.singleSelection = bl;
            this.clearCheck();
        }
    }

    private class CheckedStateTracker
    implements CompoundButton.OnCheckedChangeListener {
        private CheckedStateTracker() {
        }

        public void onCheckedChanged(CompoundButton object, boolean bl) {
            if (ChipGroup.this.protectFromCheckedChange) {
                return;
            }
            if (ChipGroup.this.getCheckedChipIds().isEmpty() && ChipGroup.this.selectionRequired) {
                ChipGroup.this.setCheckedStateForView(object.getId(), true);
                ChipGroup.this.setCheckedId(object.getId(), false);
                return;
            }
            int n = object.getId();
            if (bl) {
                if (ChipGroup.this.checkedId != -1 && ChipGroup.this.checkedId != n && ChipGroup.this.singleSelection) {
                    object = ChipGroup.this;
                    ((ChipGroup)((Object)object)).setCheckedStateForView(((ChipGroup)((Object)object)).checkedId, false);
                }
                ChipGroup.this.setCheckedId(n);
            } else if (ChipGroup.this.checkedId == n) {
                ChipGroup.this.setCheckedId(-1);
            }
        }
    }

    public static class LayoutParams
    extends ViewGroup.MarginLayoutParams {
        public LayoutParams(int n, int n2) {
            super(n, n2);
        }

        public LayoutParams(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
        }

        public LayoutParams(ViewGroup.LayoutParams layoutParams) {
            super(layoutParams);
        }

        public LayoutParams(ViewGroup.MarginLayoutParams marginLayoutParams) {
            super(marginLayoutParams);
        }
    }

    public static interface OnCheckedChangeListener {
        public void onCheckedChanged(ChipGroup var1, int var2);
    }

    private class PassThroughHierarchyChangeListener
    implements ViewGroup.OnHierarchyChangeListener {
        private ViewGroup.OnHierarchyChangeListener onHierarchyChangeListener;

        private PassThroughHierarchyChangeListener() {
        }

        static /* synthetic */ ViewGroup.OnHierarchyChangeListener access$202(PassThroughHierarchyChangeListener passThroughHierarchyChangeListener, ViewGroup.OnHierarchyChangeListener onHierarchyChangeListener) {
            passThroughHierarchyChangeListener.onHierarchyChangeListener = onHierarchyChangeListener;
            return onHierarchyChangeListener;
        }

        public void onChildViewAdded(View view, View view2) {
            Object object;
            if (view == ChipGroup.this && view2 instanceof Chip) {
                if (view2.getId() == -1) {
                    view2.setId(ViewCompat.generateViewId());
                }
                if ((object = (Chip)view2).isChecked()) {
                    ((ChipGroup)view).check(object.getId());
                }
                ((Chip)object).setOnCheckedChangeListenerInternal(ChipGroup.this.checkedStateTracker);
            }
            if ((object = this.onHierarchyChangeListener) != null) {
                object.onChildViewAdded(view, view2);
            }
        }

        public void onChildViewRemoved(View view, View view2) {
            ViewGroup.OnHierarchyChangeListener onHierarchyChangeListener;
            if (view == ChipGroup.this && view2 instanceof Chip) {
                ((Chip)view2).setOnCheckedChangeListenerInternal(null);
            }
            if ((onHierarchyChangeListener = this.onHierarchyChangeListener) != null) {
                onHierarchyChangeListener.onChildViewRemoved(view, view2);
            }
        }
    }
}

