/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.color;

import com.google.android.material.color.Cam16;
import com.google.android.material.color.ColorUtils;
import com.google.android.material.color.Hct;
import com.google.android.material.color.MathUtils;

final class Blend {
    private static final float HARMONIZE_MAX_DEGREES = 15.0f;
    private static final float HARMONIZE_PERCENTAGE = 0.5f;

    private Blend() {
    }

    public static int blendCam16Ucs(int n, int n2, float f) {
        Cam16 cam16 = Cam16.fromInt(n);
        Cam16 cam162 = Cam16.fromInt(n2);
        float f2 = cam16.getJStar();
        float f3 = cam16.getAStar();
        float f4 = cam16.getBStar();
        return Cam16.fromUcs(f2 + (cam162.getJStar() - f2) * f, f3 + (cam162.getAStar() - f3) * f, f4 + (cam162.getBStar() - f4) * f).getInt();
    }

    public static int blendHctHue(int n, int n2, float f) {
        Cam16 cam16 = Cam16.fromInt(Blend.blendCam16Ucs(n, n2, f));
        Cam16 cam162 = Cam16.fromInt(n);
        return Hct.from(cam16.getHue(), cam162.getChroma(), ColorUtils.lstarFromInt(n)).toInt();
    }

    public static int harmonize(int n, int n2) {
        Hct hct = Hct.fromInt(n);
        Hct hct2 = Hct.fromInt(n2);
        float f = Math.min(MathUtils.differenceDegrees(hct.getHue(), hct2.getHue()) * 0.5f, 15.0f);
        return Hct.from(MathUtils.sanitizeDegrees(hct.getHue() + f * Blend.rotationDirection(hct.getHue(), hct2.getHue())), hct.getChroma(), hct.getTone()).toInt();
    }

    private static float rotationDirection(float f, float f2) {
        float f3 = f2 - f;
        float f4 = f3 + 360.0f;
        f2 = f3 - 360.0f;
        float f5 = Math.abs(f3);
        float f6 = Math.abs(f4);
        float f7 = Math.abs(f2);
        f = 1.0f;
        if (f5 <= f6 && f5 <= f7) {
            if (!((double)f3 >= 0.0)) {
                f = -1.0f;
            }
            return f;
        }
        if (f6 <= f5 && f6 <= f7) {
            if (!((double)f4 >= 0.0)) {
                f = -1.0f;
            }
            return f;
        }
        if (!((double)f2 >= 0.0)) {
            f = -1.0f;
        }
        return f;
    }
}

