/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.color;

import com.google.android.material.color.ColorUtils;
import com.google.android.material.color.ViewingConditions;

final class Cam16 {
    static final float[][] CAM16RGB_TO_XYZ;
    static final float[][] XYZ_TO_CAM16RGB;
    private final float astar;
    private final float bstar;
    private final float chroma;
    private final float hue;
    private final float j;
    private final float jstar;
    private final float m;
    private final float q;
    private final float s;

    static {
        XYZ_TO_CAM16RGB = new float[][]{{0.401288f, 0.650173f, -0.051461f}, {-0.250268f, 1.204414f, 0.045854f}, {-0.002079f, 0.048952f, 0.953127f}};
        CAM16RGB_TO_XYZ = new float[][]{{1.8620678f, -1.0112547f, 0.14918678f}, {0.38752654f, 0.62144744f, -0.00897398f}, {-0.0158415f, -0.03412294f, 1.0499644f}};
    }

    private Cam16(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        this.hue = f;
        this.chroma = f2;
        this.j = f3;
        this.q = f4;
        this.m = f5;
        this.s = f6;
        this.jstar = f7;
        this.astar = f8;
        this.bstar = f9;
    }

    public static Cam16 fromInt(int n) {
        return Cam16.fromIntInViewingConditions(n, ViewingConditions.DEFAULT);
    }

    static Cam16 fromIntInViewingConditions(int n, ViewingConditions viewingConditions) {
        float f = ColorUtils.linearized((float)((0xFF0000 & n) >> 16) / 255.0f) * 100.0f;
        float f2 = ColorUtils.linearized((float)((0xFF00 & n) >> 8) / 255.0f) * 100.0f;
        float f3 = ColorUtils.linearized((float)(n & 0xFF) / 255.0f) * 100.0f;
        float f4 = 0.41233894f * f + 0.35762063f * f2 + 0.18051042f * f3;
        float f5 = 0.2126f * f + 0.7152f * f2 + 0.0722f * f3;
        float f6 = f * 0.01932141f + f2 * 0.11916382f + f3 * 0.9503448f;
        float[][] fArray = XYZ_TO_CAM16RGB;
        float f7 = fArray[0][0];
        f3 = fArray[0][1];
        float f8 = fArray[0][2];
        float f9 = fArray[1][0];
        float f10 = fArray[1][1];
        float f11 = fArray[1][2];
        float f12 = fArray[2][0];
        f = fArray[2][1];
        f2 = fArray[2][2];
        f3 = viewingConditions.getRgbD()[0] * (f7 * f4 + f3 * f5 + f8 * f6);
        f10 = viewingConditions.getRgbD()[1] * (f9 * f4 + f10 * f5 + f11 * f6);
        f4 = viewingConditions.getRgbD()[2] * (f4 * f12 + f5 * f + f6 * f2);
        f5 = (float)Math.pow((double)(viewingConditions.getFl() * Math.abs(f3)) / 100.0, 0.42);
        f2 = (float)Math.pow((double)(viewingConditions.getFl() * Math.abs(f10)) / 100.0, 0.42);
        f = (float)Math.pow((double)(viewingConditions.getFl() * Math.abs(f4)) / 100.0, 0.42);
        f5 = Math.signum(f3) * 400.0f * f5 / (f5 + 27.13f);
        f3 = Math.signum(f10) * 400.0f * f2 / (f2 + 27.13f);
        f2 = Math.signum(f4) * 400.0f * f / (f + 27.13f);
        double d = f5;
        double d2 = f3;
        double d3 = f2;
        f4 = (float)(d * 11.0 + d2 * -12.0 + d3) / 11.0f;
        f = (float)((double)(f5 + f3) - d3 * 2.0) / 9.0f;
        f6 = f3 * 20.0f;
        f3 = (f5 * 20.0f + f6 + 21.0f * f2) / 20.0f;
        f2 = (f5 * 40.0f + f6 + f2) / 20.0f;
        d2 = f;
        d3 = f4;
        if ((f4 = (float)Math.atan2(d2, d3) * 180.0f / (float)Math.PI) < 0.0f) {
            f5 = f4 + 360.0f;
        } else {
            f5 = f4;
            if (f4 >= 360.0f) {
                f5 = f4 - 360.0f;
            }
        }
        f = (float)Math.PI * f5 / 180.0f;
        f11 = (float)Math.pow(f2 * viewingConditions.getNbb() / viewingConditions.getAw(), viewingConditions.getC() * viewingConditions.getZ()) * 100.0f;
        f12 = 4.0f / viewingConditions.getC();
        f6 = (float)Math.sqrt(f11 / 100.0f);
        f2 = viewingConditions.getAw();
        f10 = viewingConditions.getFlRoot();
        f4 = (double)f5 < 20.14 ? 360.0f + f5 : f5;
        f4 = (float)(Math.cos(Math.toRadians(f4) + 2.0) + 3.8) * 0.25f * 3846.1538f * viewingConditions.getNc() * viewingConditions.getNcb() * (float)Math.hypot(d3, d2) / (f3 + 0.305f);
        f9 = (float)Math.pow(1.64 - Math.pow(0.29, viewingConditions.getN()), 0.73) * (float)Math.pow(f4, 0.9);
        f3 = f9 * (float)Math.sqrt((double)f11 / 100.0);
        f4 = f3 * viewingConditions.getFlRoot();
        f9 = (float)Math.sqrt(f9 * viewingConditions.getC() / (viewingConditions.getAw() + 4.0f));
        f8 = 1.7f * f11 / (0.007f * f11 + 1.0f);
        f7 = (float)Math.log1p(0.0228f * f4) * 43.85965f;
        d3 = f;
        return new Cam16(f5, f3, f11, f12 * f6 * (f2 + 4.0f) * f10, f4, f9 * 50.0f, f8, f7 * (float)Math.cos(d3), f7 * (float)Math.sin(d3));
    }

    static Cam16 fromJch(float f, float f2, float f3) {
        return Cam16.fromJchInViewingConditions(f, f2, f3, ViewingConditions.DEFAULT);
    }

    private static Cam16 fromJchInViewingConditions(float f, float f2, float f3, ViewingConditions viewingConditions) {
        float f4 = 4.0f / viewingConditions.getC();
        double d = (double)f / 100.0;
        float f5 = (float)Math.sqrt(d);
        float f6 = viewingConditions.getAw();
        float f7 = viewingConditions.getFlRoot();
        float f8 = f2 * viewingConditions.getFlRoot();
        float f9 = (float)Math.sqrt(f2 / (float)Math.sqrt(d) * viewingConditions.getC() / (viewingConditions.getAw() + 4.0f));
        float f10 = (float)Math.PI * f3 / 180.0f;
        float f11 = 1.7f * f / (0.007f * f + 1.0f);
        float f12 = (float)Math.log1p((double)f8 * 0.0228) * 43.85965f;
        d = f10;
        return new Cam16(f3, f2, f, f4 * f5 * (f6 + 4.0f) * f7, f8, f9 * 50.0f, f11, f12 * (float)Math.cos(d), f12 * (float)Math.sin(d));
    }

    public static Cam16 fromUcs(float f, float f2, float f3) {
        return Cam16.fromUcsInViewingConditions(f, f2, f3, ViewingConditions.DEFAULT);
    }

    public static Cam16 fromUcsInViewingConditions(float f, float f2, float f3, ViewingConditions viewingConditions) {
        double d = f2;
        double d2 = f3;
        double d3 = Math.expm1(Math.hypot(d, d2) * (double)0.0228f) / (double)0.0228f / (double)viewingConditions.getFlRoot();
        d = d2 = Math.atan2(d2, d) * 57.29577951308232;
        if (d2 < 0.0) {
            d = d2 + 360.0;
        }
        return Cam16.fromJchInViewingConditions(f / (1.0f - (f - 100.0f) * 0.007f), (float)d3, (float)d, viewingConditions);
    }

    float distance(Cam16 cam16) {
        float f = this.getJStar() - cam16.getJStar();
        float f2 = this.getAStar() - cam16.getAStar();
        float f3 = this.getBStar() - cam16.getBStar();
        return (float)(Math.pow(Math.sqrt(f * f + f2 * f2 + f3 * f3), 0.63) * 1.41);
    }

    public float getAStar() {
        return this.astar;
    }

    public float getBStar() {
        return this.bstar;
    }

    public float getChroma() {
        return this.chroma;
    }

    public float getHue() {
        return this.hue;
    }

    public int getInt() {
        return this.viewed(ViewingConditions.DEFAULT);
    }

    public float getJ() {
        return this.j;
    }

    public float getJStar() {
        return this.jstar;
    }

    public float getM() {
        return this.m;
    }

    public float getQ() {
        return this.q;
    }

    public float getS() {
        return this.s;
    }

    int viewed(ViewingConditions object) {
        float f = (double)this.getChroma() != 0.0 && (double)this.getJ() != 0.0 ? this.getChroma() / (float)Math.sqrt((double)this.getJ() / 100.0) : 0.0f;
        float f2 = (float)Math.pow((double)f / Math.pow(1.64 - Math.pow(0.29, ((ViewingConditions)object).getN()), 0.73), 1.1111111111111112);
        double d = this.getHue() * (float)Math.PI / 180.0f;
        float f3 = (float)(Math.cos(2.0 + d) + 3.8);
        f = ((ViewingConditions)object).getAw();
        float f4 = (float)Math.pow((double)this.getJ() / 100.0, 1.0 / (double)((ViewingConditions)object).getC() / (double)((ViewingConditions)object).getZ());
        float f5 = ((ViewingConditions)object).getNc();
        float f6 = ((ViewingConditions)object).getNcb();
        f = f * f4 / ((ViewingConditions)object).getNbb();
        f4 = (float)Math.sin(d);
        float f7 = (float)Math.cos(d);
        f2 = (0.305f + f) * 23.0f * f2 / (f3 * 0.25f * 3846.1538f * f5 * f6 * 23.0f + 11.0f * f2 * f7 + f2 * 108.0f * f4);
        f3 = f7 * f2;
        f4 = f2 * f4;
        f6 = f * 460.0f;
        f = (451.0f * f3 + f6 + 288.0f * f4) / 1403.0f;
        f2 = (f6 - 891.0f * f3 - 261.0f * f4) / 1403.0f;
        f5 = (f6 - f3 * 220.0f - f4 * 6300.0f) / 1403.0f;
        f4 = (float)Math.max(0.0, (double)Math.abs(f) * 27.13 / (400.0 - (double)Math.abs(f)));
        f = Math.signum(f);
        f3 = 100.0f / ((ViewingConditions)object).getFl();
        f4 = (float)Math.pow(f4, 2.380952380952381);
        f7 = (float)Math.max(0.0, (double)Math.abs(f2) * 27.13 / (400.0 - (double)Math.abs(f2)));
        f2 = Math.signum(f2);
        f6 = 100.0f / ((ViewingConditions)object).getFl();
        f7 = (float)Math.pow(f7, 2.380952380952381);
        float f8 = (float)Math.max(0.0, (double)Math.abs(f5) * 27.13 / (400.0 - (double)Math.abs(f5)));
        float f9 = Math.signum(f5);
        f5 = 100.0f / ((ViewingConditions)object).getFl();
        f8 = (float)Math.pow(f8, 2.380952380952381);
        f = f * f3 * f4 / ((ViewingConditions)object).getRgbD()[0];
        f3 = f2 * f6 * f7 / ((ViewingConditions)object).getRgbD()[1];
        f2 = f9 * f5 * f8 / ((ViewingConditions)object).getRgbD()[2];
        object = CAM16RGB_TO_XYZ;
        return ColorUtils.intFromXyzComponents((float)(object[0][0] * f + object[0][1] * f3 + object[0][2] * f2), (float)(object[1][0] * f + object[1][1] * f3 + object[1][2] * f2), f * object[2][0] + f3 * object[2][1] + f2 * object[2][2]);
    }
}

