/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.color;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.view.ContextThemeWrapper;
import com.google.android.material.R;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class DynamicColors {
    private static final Precondition ALWAYS_ALLOW;
    private static final DeviceSupportCondition DEFAULT_DEVICE_SUPPORT_CONDITION;
    private static final Map<String, DeviceSupportCondition> DYNAMIC_COLOR_SUPPORTED_BRANDS;
    private static final Map<String, DeviceSupportCondition> DYNAMIC_COLOR_SUPPORTED_MANUFACTURERS;
    private static final int[] DYNAMIC_COLOR_THEME_OVERLAY_ATTRIBUTE;
    private static final DeviceSupportCondition SAMSUNG_DEVICE_SUPPORT_CONDITION;
    private static final int USE_DEFAULT_THEME_OVERLAY = 0;

    static {
        DeviceSupportCondition deviceSupportCondition;
        DYNAMIC_COLOR_THEME_OVERLAY_ATTRIBUTE = new int[]{R.attr.dynamicColorThemeOverlay};
        DEFAULT_DEVICE_SUPPORT_CONDITION = deviceSupportCondition = new DeviceSupportCondition(){

            @Override
            public boolean isSupported() {
                return true;
            }
        };
        Object object = new DeviceSupportCondition(){
            private Long version;

            @Override
            public boolean isSupported() {
                Object object = this.version;
                boolean bl = false;
                if (object == null) {
                    try {
                        object = Build.class.getDeclaredMethod("getLong", String.class);
                        ((Method)object).setAccessible(true);
                        this.version = (long)((Long)((Method)object).invoke(null, "ro.build.version.oneui"));
                    }
                    catch (Exception exception) {
                        this.version = -1L;
                    }
                }
                if (this.version >= 40100L) {
                    bl = true;
                }
                return bl;
            }
        };
        SAMSUNG_DEVICE_SUPPORT_CONDITION = object;
        HashMap<String, DeviceSupportCondition> hashMap = new HashMap<String, DeviceSupportCondition>();
        hashMap.put("oppo", deviceSupportCondition);
        hashMap.put("realme", deviceSupportCondition);
        hashMap.put("oneplus", deviceSupportCondition);
        hashMap.put("vivo", deviceSupportCondition);
        hashMap.put("xiaomi", deviceSupportCondition);
        hashMap.put("motorola", deviceSupportCondition);
        hashMap.put("itel", deviceSupportCondition);
        hashMap.put("tecno mobile limited", deviceSupportCondition);
        hashMap.put("infinix mobility limited", deviceSupportCondition);
        hashMap.put("hmd global", deviceSupportCondition);
        hashMap.put("sharp", deviceSupportCondition);
        hashMap.put("sony", deviceSupportCondition);
        hashMap.put("tcl", deviceSupportCondition);
        hashMap.put("lenovo", deviceSupportCondition);
        hashMap.put("lge", deviceSupportCondition);
        hashMap.put("google", deviceSupportCondition);
        hashMap.put("robolectric", deviceSupportCondition);
        hashMap.put("samsung", (DeviceSupportCondition)object);
        DYNAMIC_COLOR_SUPPORTED_MANUFACTURERS = Collections.unmodifiableMap(hashMap);
        object = new HashMap();
        object.put("asus", deviceSupportCondition);
        object.put("jio", deviceSupportCondition);
        DYNAMIC_COLOR_SUPPORTED_BRANDS = Collections.unmodifiableMap(object);
        ALWAYS_ALLOW = new Precondition(){

            @Override
            public boolean shouldApplyDynamicColors(Activity activity, int n) {
                return true;
            }
        };
    }

    private DynamicColors() {
    }

    public static void applyIfAvailable(Activity activity) {
        DynamicColors.applyIfAvailable(activity, 0);
    }

    public static void applyIfAvailable(Activity activity, int n) {
        DynamicColors.applyIfAvailable(activity, n, ALWAYS_ALLOW);
    }

    private static void applyIfAvailable(Activity activity, int n, Precondition precondition) {
        if (!DynamicColors.isDynamicColorAvailable()) {
            return;
        }
        int n2 = n;
        if (n == 0) {
            n2 = DynamicColors.getDefaultThemeOverlay((Context)activity);
        }
        if (n2 != 0 && precondition.shouldApplyDynamicColors(activity, n2)) {
            activity.setTheme(n2);
        }
    }

    public static void applyIfAvailable(Activity activity, Precondition precondition) {
        DynamicColors.applyIfAvailable(activity, 0, precondition);
    }

    public static void applyToActivitiesIfAvailable(Application application) {
        DynamicColors.applyToActivitiesIfAvailable(application, 0);
    }

    public static void applyToActivitiesIfAvailable(Application application, int n) {
        DynamicColors.applyToActivitiesIfAvailable(application, n, ALWAYS_ALLOW);
    }

    public static void applyToActivitiesIfAvailable(Application application, int n, Precondition precondition) {
        application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)new DynamicColorsActivityLifecycleCallbacks(n, precondition));
    }

    public static void applyToActivitiesIfAvailable(Application application, Precondition precondition) {
        DynamicColors.applyToActivitiesIfAvailable(application, 0, precondition);
    }

    private static int getDefaultThemeOverlay(Context context) {
        context = context.obtainStyledAttributes(DYNAMIC_COLOR_THEME_OVERLAY_ATTRIBUTE);
        int n = context.getResourceId(0, 0);
        context.recycle();
        return n;
    }

    public static boolean isDynamicColorAvailable() {
        DeviceSupportCondition deviceSupportCondition;
        int n = Build.VERSION.SDK_INT;
        boolean bl = false;
        if (n < 31) {
            return false;
        }
        DeviceSupportCondition deviceSupportCondition2 = deviceSupportCondition = DYNAMIC_COLOR_SUPPORTED_MANUFACTURERS.get(Build.MANUFACTURER.toLowerCase());
        if (deviceSupportCondition == null) {
            deviceSupportCondition2 = DYNAMIC_COLOR_SUPPORTED_BRANDS.get(Build.BRAND.toLowerCase());
        }
        boolean bl2 = bl;
        if (deviceSupportCondition2 != null) {
            bl2 = bl;
            if (deviceSupportCondition2.isSupported()) {
                bl2 = true;
            }
        }
        return bl2;
    }

    public static Context wrapContextIfAvailable(Context context) {
        return DynamicColors.wrapContextIfAvailable(context, 0);
    }

    public static Context wrapContextIfAvailable(Context context, int n) {
        if (!DynamicColors.isDynamicColorAvailable()) {
            return context;
        }
        int n2 = n;
        if (n == 0) {
            n2 = DynamicColors.getDefaultThemeOverlay(context);
        }
        if (n2 != 0) {
            context = new ContextThemeWrapper(context, n2);
        }
        return context;
    }

    private static interface DeviceSupportCondition {
        public boolean isSupported();
    }

    private static class DynamicColorsActivityLifecycleCallbacks
    implements Application.ActivityLifecycleCallbacks {
        private final int dynamicColorThemeOverlay;
        private final Precondition precondition;

        DynamicColorsActivityLifecycleCallbacks(int n, Precondition precondition) {
            this.dynamicColorThemeOverlay = n;
            this.precondition = precondition;
        }

        public void onActivityCreated(Activity activity, Bundle bundle) {
        }

        public void onActivityDestroyed(Activity activity) {
        }

        public void onActivityPaused(Activity activity) {
        }

        public void onActivityPreCreated(Activity activity, Bundle bundle) {
            DynamicColors.applyIfAvailable(activity, this.dynamicColorThemeOverlay, this.precondition);
        }

        public void onActivityResumed(Activity activity) {
        }

        public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
        }

        public void onActivityStarted(Activity activity) {
        }

        public void onActivityStopped(Activity activity) {
        }
    }

    public static interface Precondition {
        public boolean shouldApplyDynamicColors(Activity var1, int var2);
    }
}

